<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}
   
   
if(session::usr_conectado($_REQUEST['USER_ID'])){

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('COMPRAS_FORNECEDOR.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'COMPRAS FORNECEDOR';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE COMPRAS POR FORNECEDOR',$formatot);
	$worksheet1->write(3,0,config_pad('sistema_licenca'));
	$worksheet1->write(4,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
      
	$filtro = '';

	$empresa = $_REQUEST['empresa'];
	$fornecedor = $_REQUEST['fornecedor'];
	$produto = $_REQUEST['produto'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];
	$agrupado = $_REQUEST['agrupado'];

	$lista_geral = array();

	$consulta = 'SELECT nf.Nr_Nota, nf.Empresa, nf.NrDoc, nf.Serie, nf.Modelo, nf.DH_EntSai as DH_Emissao, nf.Nat_Op_CFOP, nf.Nat_Op_Descricao, '.
                  ' nf.Total_NF, nf.Vendedor, nf.Vendedor_Nome, nf.Destinatario, '.
                  ' nfi.Id_Produto, nfi.Codigo_Produto, nfi.Prod_Descricao, '.
                  ' nfi.Quantidade_Estoque, nfi.Unidade_Estoque, nfi.Valor_Unitario, '.
                  ' nfi.Valor_Total, nfi.Seq_Item '.
                  ' FROM nota_fiscal nf '.
                  ' INNER JOIN nota_fiscal_item nfi ON'.
                  ' nf.Dominio = nfi.Dominio AND '.
                  ' nf.Empresa = nfi.Empresa AND '.
                  ' nf.Nr_Nota = nfi.Nr_Nota '.
                  ' WHERE nf.Dominio = "'.$_SESSION['Dominio'].'"'.
                  ' AND nf.TipoES="0" '.
                  ' AND nf.Situacao="F" '.
                  ' AND nf.Nat_Op_Gera_Contas = "P" '.
                  ' AND nfi.Id_Produto > 0 ';
	if($empresa!=''){
		$consulta.= ' AND nf.Empresa = "'.$empresa.'" ';

		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' AND Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	if(($data_ini!='')||($data_fim!='')){
        $filtro.= ' Data:';
        if($data_ini!=''){
            $consulta.= ' AND nf.DH_EntSai >= "'.datad($data_ini).'" ';
            $filtro.= ' De: "'.$data_ini.'"';
        }

        if($data_fim!=''){
            $consulta.= ' AND nf.DH_EntSai <= "'.datad($data_fim).' 23:59:59" ';
            $filtro.= ' At: "'.$data_fim.'"';
        }
    }

    if($fornecedor!=''){
        $consulta.= ' AND nf.Destinatario = "'.$fornecedor.'" ';

        $cons_pessoa = 'SELECT Nome_Razao, Pessoa FROM pessoa '.
                        ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                        ' AND Pessoa = "'.$fornecedor.'"';
        $res_pessoa = consulta_sql($cons_pessoa);
        $reg_pessoa = consulta_ler_linha($res_pessoa);
        consulta_limpa($res_pessoa);
        $filtro.= ' Fornecedor: "'.$reg_pessoa[0].'"';
    }

    if($produto!=''){
        $consulta.= ' AND nfi.Id_Produto = "'.$produto.'" ';

        $con_produt = 'SELECT Descricao_Curta FROM produto '.
                       ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
                       ' AND Id_Produto="'.$produto.'"';
        $res_produt = consulta_sql($con_produt);
        $reg_produt = consulta_ler_linha($res_produt);
        consulta_limpa($res_produt);
        $filtro.= ' Produto: "'.$produto.' - '.$reg_produt[0].'"';
	}

	$filtro_depart = '';
	$depart = '';
	$con_filtro = '';
	$filtro_dep = '';

	$lista_depart = explode(';',$_REQUEST['depart']);
	foreach($lista_depart as $key => $valor){
		if($valor!=''){
			if($con_filtro != ''){
				$con_filtro.= 'OR';
			}
			$con_filtro.= ' (Codigo_Depart = "'.$valor.'") ';
			$depart[$valor] = '1';
			if($filtro_depart==''){
				$filtro_depart = ' Departamentos:';
			}else{
				$filtro_depart.= ',';
			}

			$cons_filt_depart = 'SELECT Codigo_Depart, Descricao '.
								' FROM produto_departamento '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Codigo_Depart <> 0 '.
								' AND Codigo_Depart = "'.$valor.'" '.
								' AND Situacao <> "E" '.
								' ORDER BY Descricao ';
			$res_filt_depart = consulta_sql($cons_filt_depart);
			$reg_filt_depart = consulta_ler_linha($res_filt_depart);
			$filtro_depart.= ' "'.$reg_filt_depart[1].'"';
		}
	}

	if($con_filtro != ''){
		$con_filtro = ' AND ('.$con_filtro.')';
		if($filtro != ''){
			$filtro.= ' /'.$filtro_depart;
		}
	}

	$consulta.= ' GROUP BY nf.Empresa, nf.Nr_Nota ';
	$consulta.= ' ORDER BY nf.NrDoc, nf.DH_Emissao, nf.Destinatario ';

	$worksheet1->write(7,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatotb =& $workbook->add_format();
	$formatotb->set_align('left');
	$formatotb->set_border(0);
	$formatotb->set_bold(1);
	$formatotb->set_size(10);

	$formatot0 =& $workbook->add_format();
	$formatot0->set_align('left');
	$formatot0->set_border(0);
	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	$formatotr =& $workbook->add_format();
	$formatotr->set_border(1);
	$formatotr->set_bold(1);
	$formatotr->set_align('right');

	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_size(10);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotqtd3 =& $workbook->add_format();
	$formatotqtd3->set_border(1);
	$formatotqtd3->set_align('right');
	$formatotqtd3->set_num_format('#,##0.000_);(#,##0.000)');


	$formatotbqtd3 =& $workbook->add_format();
	$formatotbqtd3->set_border(1);
	$formatotbqtd3->set_bold(1);
	$formatotbqtd3->set_align('right');
	$formatotbqtd3->set_num_format('#,##0.000_);(#,##0.000)');


	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	$formatotqtdb =& $workbook->add_format();
	$formatotqtdb->set_border(1);
	$formatotqtdb->set_align('right');
	$formatotqtdb->set_size(10);
	$formatotqtdb->set_bold(1);
	$formatotqtdb->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');


	// Format for the headings
	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	// Format for the headings
	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	set_time_limit(60);
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	for($i=0;$i<$nrows;$i++){
		$registro = consulta_ler_objeto($resultado);

		$ok_linha = true;

		if(0&&$ok_linha){
			if($depart != ''){
				$con_prod = 'SELECT Codigo_Depart FROM produto '.
						   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' AND Id_Produto="'.$registro->Id_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$reg_prod = consulta_ler_objeto($res_prod);
				consulta_limpa($res_prod);

				$ok_linha = (isset($depart[$reg_prod->Codigo_Depart]));
			}
		}
	 

		if($ok_linha){
			$chave = $registro->Destinatario;

			if(!isset($lista_geral[$chave])){
				$cons_forn = 'SELECT Nome_Razao FROM pessoa '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$registro->Destinatario.'"';
				$res_forn = consulta_sql($cons_forn);
				$reg_forn = consulta_ler_linha($res_forn);
				consulta_limpa($res_forn);

				$lista_geral[$chave]['Fornecedor'] = $registro->Destinatario;
				$lista_geral[$chave]['Fornecedor_Desc'] = $registro->Destinatario.' - '.$reg_forn[0];
				$lista_geral[$chave]['Total_Fornec'] = 0;
				$lista_geral[$chave]['Notas'] = array();
			}
		
			$con_cfop = 'SELECT Descricao FROM cfop '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND CFOP = "'.$registro->Nat_Op_CFOP.'"';
			$res_cfop = consulta_sql($con_cfop);
			$reg_cfop = consulta_ler_linha($res_cfop);
			consulta_limpa($res_cfop);

			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['NrDoc'] = $registro->NrDoc;
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['Serie'] = $registro->Serie;
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['Modelo'] = $registro->Modelo;
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['DH_Emissao'] = $registro->DH_Emissao;
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['Nat_Op_CFOP'] = $registro->Nat_Op_CFOP;
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['Nat_Op_Descricao'] = $reg_cfop[0];
			$lista_geral[$chave]['Notas'][$registro->Nr_Nota]['Total_NF'] = $registro->Total_NF;

			$lista_geral[$chave]['Total_Fornec']+= $registro->Total_NF;
		}
	}

	if(!empty($lista_geral)){
		$k=0;
		$linha_ini = 11;
		$worksheet1->set_column($k,$k,16);
		$worksheet1->write_string($linha_ini,$k,'NrDoc',$formatott);
		$k++;

		$worksheet1->set_column($k,$k,16);
		$worksheet1->write_string($linha_ini,$k,'Dt. Entrada',$formatott);
		$k++;

		$worksheet1->set_column($k,$k,14);
		$worksheet1->write_string($linha_ini,$k,'Nat. Op',$formatott);
		$k++;

		$worksheet1->set_column($k,$k,42);
		$worksheet1->write_string($linha_ini,$k,'Desc. Nat. Op.',$formatott);
		$k++;

		$worksheet1->set_column($k,$k,20);
		$worksheet1->write_string($linha_ini,$k,'Vl. Total',$formatott);
		$k++;
		$k=0;
		$total_geral = 0;
		foreach($lista_geral as $registro){
			$k=0;
			$linha_ini++;
			$linha_ini++;
			//$worksheet1->write_string($linha_ini,$k,'Fornecedor: '.$registro['Fornecedor_Desc'],$formatotl);
			$worksheet1->write_string($linha_ini,$k,'Fornecedor: '.$registro['Fornecedor_Desc'],$formatotb);
			$linha_ini++;
			$linha_ini++;
			foreach($registro['Notas'] as $nota){
				$k=0;
				//$linha_ini++;
				$rowarr[$k] = $nota['NrDoc'].'/'.$nota['Serie'].'-'.$nota['Modelo'];
				$worksheet1->write_string($linha_ini,$k,$rowarr[$k],$formatotl);
				$k++;


				$rowarr[$k] = dataf($nota['DH_Emissao']);
				$worksheet1->write_string($linha_ini,$k,$rowarr[$k],$formatotl);
				$k++;

				$rowarr[$k] = $nota['Nat_Op_CFOP'];
				$worksheet1->write_string($linha_ini,$k,$rowarr[$k],$formatotl);
				$k++;

				$rowarr[$k] = $nota['Nat_Op_Descricao'];
				$worksheet1->write_string($linha_ini,$k,$rowarr[$k],$formatotl);
				$k++;

				$rowarr[$k] = to_money($nota['Total_NF'], false);
				$worksheet1->write_string($linha_ini,$k,$rowarr[$k],$formatotpreco);
				$k++;

				$total_geral+= $nota['Total_NF'];
				$linha_ini++;
			}
			$k=0;
			$k++;$k++;$k++;
			$worksheet1->write_string($linha_ini,$k,'Total do Fornecedor:',$formatotr);
			$k++;
			$worksheet1->write_string($linha_ini,$k,to_money($registro['Total_Fornec'], false),$formatotbpreco);
		}
		$linha_ini++;
		$linha_ini++;
		$k=0;
		$k++;$k++;$k++;
		$worksheet1->write_string($linha_ini,$k,'Total Geral:',$formatotr);
		$k++;
		$worksheet1->write_string($linha_ini,$k,str_replace('"','',to_money($total_geral)),$formatotbpreco);

	}else{
		$worksheet1->write_string($linha_ini,$k,'No existem registros para este filtro!',$formatotl);
	}

	consulta_limpa($resultado);
	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
    $insert = 'insert into relatorio_tmp ( '.
              ' Dominio, '.
              ' Usuario, '.
              ' Descricao ) values ('.
              '"'.$_SESSION['Dominio'].'", '.
              '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
              '"")';
    consulta_sql($insert);
	$workbook->close();
}
?>
