<?
	
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	HeaderingExcel('REL_CC_FATURAS_RESUMO.xls');
   
if(session::usr_conectado($_REQUEST['USER_ID'])){

    $workbook = new Workbook("-");

	// Format for the headings
	$fmt_branco =& $workbook->add_format();
	$fmt_branco->set_size(10);

	$fmt_brancob =& $workbook->add_format();
	$fmt_brancob->set_size(10);
	$fmt_brancob->set_bold(1);

	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_align('vcenter');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatottl =& $workbook->add_format();
	$formatottl->set_align('left');
	$formatottl->set_pattern();
	$formatottl->set_fg_color(40);
	$formatottl->set_bold(1);
	$formatottl->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');
	$formatotl->set_size(10);
	$formatotl->font='Tahoma';

	$formatotl_filtro =& $workbook->add_format();
	$formatotl_filtro->set_align('left');
	$formatotl_filtro->set_size(10);
	$formatotl_filtro->font='Tahoma';


	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('right');
	$fmt_qtd->set_num_format('#,##0_);-#,##0_)'); //('#,##0.000_);(#,##0.000)')

	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_border(1);
	$fmt_txt_c->set_align('center');

	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_align('left');

	$fmt_txt_r =& $workbook->add_format();
	$fmt_txt_r->set_border(1);
	$fmt_txt_r->set_align('right');
	$fmt_txt_r->set_bold(1);

	$fmt_valorb =& $workbook->add_format();
	$fmt_valorb->set_border(1);
	//$fmt_valorb->set_bold(1);
	$fmt_valorb->set_align('right');

	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	// $fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');


	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$titulo_sheet = 'Relatrio CC Faturas Resumo';
	$filtro = '';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);


	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,$titulo_sheet,$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
	//$filtro = '';
	//$worksheet1->write(8,0,"Filtro: ".$filtro);


	$coluna =  0;
	$linha_ini = 11;
	//Imprime Cabealho
	$worksheet1->set_column($coluna,$coluna,85);
	$worksheet1->write_string($linha_ini,$coluna,'Conta',$formatott);
	$coluna++;

	$worksheet1->set_column($coluna,$coluna,15);
	$worksheet1->write_string($linha_ini,$coluna,'Crdito',$formatott);
	$coluna++;

	$worksheet1->set_column($coluna,$coluna,15);
	$worksheet1->write_string($linha_ini,$coluna,'Dbito',$formatott);
	$coluna++;

	$worksheet1->set_column($coluna,$coluna,15);
	$worksheet1->write_string($linha_ini,$coluna,'Saldo',$formatott);
	$coluna++;

	$coluna=0;
	$linha_ini++;



	$dt_tipo = $_REQUEST['tipo_data'];
	$tipo_data_ini = $_REQUEST['tipo_data_ini'];
	$tipo_data_fim = $_REQUEST['tipo_data_fim'];
	$empresa = $_REQUEST['empresa'];
	$tipo = $_REQUEST['tipo_conta'];
	$grupo = $_REQUEST['grupo_conta'];
	$conta = $_REQUEST['conta_contabil'];
	$cliente = $_REQUEST['cliente_fornecedor'];
	$situacao = $_REQUEST['situacao'];

	$filtro = '';

    
    $consulta = 'SELECT cp.Nr_Contas, cp.Empresa, '.
                ' cp.TipoPR, cp.Situacao, cp.Valor_Pago, cp.Valor Valor, cc.Valor ValorCC, IFNULL(cp.Conta_Contabil, "") Conta_ContabilCP, IFNULL(cc.Conta_Contabil, "") Conta_ContabilCC, '.
                ' IFNULL((CASE WHEN cc.Conta_Contabil IS NULL OR TRIM(cc.Conta_Contabil) = "" THEN cp.Conta_Contabil ELSE cc.Conta_Contabil END), "") Conta_Contabil, '.
                ' cp.Valor_Liquido, cp.Situacao '.
                ' FROM contas_pr cp '.
                ' LEFT JOIN contas_pr_conta_contabil cc ON '.
                ' cp.Dominio = cc.Dominio '.
                ' AND cp.Empresa = cc.Empresa '.
                ' AND cp.Nr_Contas = cc.Nr_Contas '.
                ' AND cp.Seq = cc.Seq ';
    if (($dt_tipo!="V")&&($dt_tipo!="P")){
		$consulta.=' inner join contas_pr cp1 on '.
                  ' cp.Dominio = cp1.Dominio AND '.
                  ' cp.Empresa = cp1.Empresa AND '.
                  ' cp.Nr_Contas = cp1.Nr_Contas AND '.
                  ' cp1.Seq = 1 ';
    }

    $consulta.= ' WHERE cp.Dominio = "'.$_SESSION["Dominio"].'"'.
                ' and cp.Situacao <> "E"';

    $con_empr = 'select Pessoa, Nome_Listas from pessoa '.
                ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                ' and Pessoa = "'.$empresa.'"';
    $res_empr = consulta_sql($con_empr);
    $reg_empr = consulta_ler_linha($res_empr);
    consulta_limpa($res_empr);

    if($empresa==''){
		$consulta.= ' AND cp.Empresa > "0" ';
		$filtro.= ' Filiais: Todas';
    }else if($empresa!=''){
		$consulta.= ' AND cp.Empresa = "'.$empresa.'" ';
		$filtro.= ' Empresa: '.$reg_empr[1];
    }

    if($dt_tipo=="V"){
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
			$filtro.= ' Data de: "Vencimento":';
			if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' AND (cp.DT_Vencto >= "'.datad($tipo_data_ini).'" '.
							' AND cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
			}else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp.DT_Vencto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
			}else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
			}
		}
    }else if($dt_tipo=="P"){
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
			$filtro.= ' Data de: "Pagamento":';
			if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' AND (cp.DT_Pagto >= "'.datad($tipo_data_ini).'" '.
							' AND cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'" ';
			}else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp.DT_Pagto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
			}else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
			}
		}
    }else{
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
			$filtro.= ' Data de: "Emisso":';
			if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' AND (cp1.DH_Criacao >= "'.datad($tipo_data_ini).'" '.
							' AND cp1.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
			}else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp1.DH_Criacao >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
			}else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp1.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
			}
		}
    }

    if($situacao != ''){
        $consulta.= ' AND cp.Situacao = "'.$situacao.'"';
        if($situacao=='A'){
            $filtro.= ' Situao: Aberto(s) ';
        }else if($situacao=='F'){
            $filtro.= ' Situao: Fechado(s) ';
        }else {
            $filtro.= ' Situao: Todo(s) ';
        }
    }

    if($conta!=''){
		$consulta.= ' AND ( '.
				   '   (CASE WHEN cc.Conta_Contabil IS NULL OR TRIM(cc.Conta_Contabil) = "" THEN cp.Conta_Contabil ELSE cc.Conta_Contabil END) = "'.$conta.'" '.
				   ' )';

		$con_conta = 'select Conta_Contabil, Descricao from conta_contabil '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Conta_Contabil = "'.$conta.'"';
		$res_conta = consulta_sql($con_conta);
		$reg_conta = consulta_ler_linha($res_conta);
		consulta_limpa($res_conta);

		$filtro.= ' Conta: '.$reg_conta[1].'';
    }else{
		$filtro.= ' - Todas as Contas';
    }

    if($cliente!=''){
        $consulta.= ' AND cp.Pessoa = "'.$cliente.'"';

        $con_cliente = 'select Pessoa, Nome_Listas from pessoa '.
                       ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                       ' and Pessoa = "'.$cliente.'"';
        $res_cliente = consulta_sql($con_cliente);
        $reg_cliente = consulta_ler_linha($res_cliente);
        consulta_limpa($res_cliente);

        $filtro .= ' Cliente/Fornecedor: '.$reg_cliente[1];
    }
    $consulta.= ' ORDER BY Conta_Contabil';
    
    
    $worksheet1->write(8,0,"Filtro: ".$filtro);

    $resultado = consulta_sql($consulta);
    $nrows = consulta_num_registros($resultado);

    $lista_geral = array();

    for($i=0;$i<$nrows;$i++){
        $registro = consulta_ler_objeto($resultado);

        set_time_limit(60);

        $conta_tipo = '';
        $conta_grupo = '';
        $conta_contabil = $registro->Conta_Contabil;
        
		$indice = 1;

		$valor_base = $registro->Valor;
		if($registro->ValorCC > 0){
            $valor_base = $registro->ValorCC;

            if(($registro->Valor_Liquido > 0) &&
                 ($registro->Valor > 0) &&
                 ($registro->Situacao == 'F')){
                if($registro->Valor_Liquido != $registro->Valor){
					$perc_ref = $registro->Valor_Liquido/$registro->Valor;
					$valor_base = arredonda_numero_menos ($valor_base * $perc_ref * 100) / 100;
				}
			}
		}else{
            if(($registro->Valor_Liquido > 0) &&
                ($registro->Valor > 0) &&
                ($registro->Situacao == 'F')){
                $valor_base = $registro->Valor_Liquido;
            }
		}

        if($registro->Situacao == 'F'){
            if ($registro->Valor_Pago == 0){
                $indice = 0;
            }
        }
          
         $valor_base = ($valor_base * $indice);

        $con_conta = 'SELECT Conta_Tipo, Conta_Grupo FROM conta_contabil '.
                     ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
                     ' AND Conta_Contabil = "'.$conta_contabil.'" '.
                     ' AND Situacao <> "E"';
        $res_conta = consulta_sql($con_conta);
        $nrw_cont = consulta_num_registros($res_conta);
        if($nrw_cont > 0){
			$reg_conta = consulta_ler_objeto($res_conta);

			$conta_grupo = $reg_conta->Conta_Grupo;
			$conta_tipo = $reg_conta->Conta_Tipo;
        }
        consulta_limpa($res_conta);

        if(isset($lista_geral[$conta_tipo][$conta_grupo][$conta_contabil])){
			$lista_campos =  $lista_geral[$conta_tipo][$conta_grupo][$conta_contabil];
        }else{
			$lista_campos['Valor'] = 0;
			$lista_campos['ValorC'] = 0;
			$lista_campos['ValorD'] = 0;
        }

        if($registro->TipoPR=='R'){
			$lista_campos['Valor']+= $valor_base;
			$lista_campos['ValorC']+= $valor_base;
        }else{
			$lista_campos['Valor']-= $valor_base;
			$lista_campos['ValorD']+= $valor_base;
        }
        $lista_geral[$conta_tipo][$conta_grupo][$conta_contabil] = $lista_campos;
    }
    consulta_limpa($resultado);


    if (count($lista_geral)>0){

        $k=0;

        $total_credito_grupo = 0;
        $total_debito_grupo = 0;
        $total_saldo_grupo = 0;

        $total_credito_tipo = 0;
        $total_debito_tipo = 0;
        $total_saldo_tipo = 0;

        $total_credito_geral = 0;
        $total_debito_geral = 0;
        $total_saldo_geral = 0;

        $id_tipo = '';
        $id_grupo = '';

        foreach($lista_geral as $idtipo => $valor){

			$lista_geral2 = $lista_geral[$idtipo];

			$total_credito_tipo = 0;
			$total_debito_tipo = 0;
			$total_saldo_tipo = 0;


			$con_tipo = 'select Codigo_Tipo, Descricao from conta_contabil_tipo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Tipo = "'.$idtipo.'"';
			$res_tipo = consulta_sql($con_tipo);
			$reg_tipo = consulta_ler_linha($res_tipo);
			consulta_limpa($res_tipo);


			foreach($lista_geral2 as $idgrupo => $valor2){
				$lista_geral3 = $lista_geral2[$idgrupo];

				$total_credito_grupo = 0;
				$total_debito_grupo = 0;
				$total_saldo_grupo = 0;

				$con_grupo = 'select Codigo_Grupo, Descricao from conta_contabil_grupo '.
						   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' and Codigo_Tipo = "'.$idtipo.'"'.
						   ' and Codigo_Grupo = "'.$idgrupo.'"';
				$res_grupo = consulta_sql($con_grupo);
				$reg_grupo = consulta_ler_linha($res_grupo);
				consulta_limpa($res_grupo);


				$worksheet1->write($linha_ini,$k,$reg_grupo[0].' - '.$reg_grupo[1], $fmt_txt_l);
				$k++;
				$worksheet1->write($linha_ini,$k,'', $fmt_txt_l);
				$k++;
				$worksheet1->write($linha_ini,$k,'', $fmt_txt_l);
				$k++;
				$worksheet1->write($linha_ini,$k,'', $fmt_txt_l);
				$k++;
				$linha_ini++;
              


				foreach($lista_geral3 as $idconta => $valor3){
					$lista_campos = $lista_geral3[$idconta];

					$k=0;

					$con_conta = 'SELECT Conta_Contabil, Descricao FROM conta_contabil '.
							  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							  ' AND Conta_Contabil = "'.$idconta.'" '.
							  ' AND Situacao <> "E"';
					$res_conta = consulta_sql($con_conta);
					$reg_conta = consulta_ler_linha($res_conta);
					consulta_limpa($res_conta);
					if ($reg_conta[1]!=''){
						$rowarr[$k]  =  $idconta.' - '.$reg_conta[1];
					}else if ($idconta==''){
						$rowarr[$k]  =  'CONTA CONTBIL NO INFORMADA';
					}else{
						$con_conta = 'select Conta_Contabil_C, Nome_Razao from pessoa '.
									 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
									  ' and ((Conta_Contabil_C = "'.$idconta.'")'.
									  ' or (Conta_Contabil_D = "'.$idconta.'"))'.
									  ' and Situacao<>"E"';
						$res_conta = consulta_sql($con_conta);
						$reg_conta = consulta_ler_linha($res_conta);
						consulta_limpa($res_conta);
						$rowarr[$k]  =  $idconta.' - '.$reg_conta[1];
					}
					$worksheet1->write($linha_ini,$k,$rowarr[$k], $fmt_txt_l);
					$k++;

					$cred = '';
					$deb = '';
					$soma_cred = 0;
					$soma_deb = 0;

					if($lista_campos['ValorC']>0){
                        $cred = str_replace('"','',to_money($lista_campos['ValorC']));
                        $soma_cred = $lista_campos['ValorC'];
					}

					if($lista_campos['ValorD']>0){
                        $deb = str_replace('"','',to_money($lista_campos['ValorD']));
                        $soma_deb = $lista_campos['ValorD'];
					}
					//}
					//Credito
					$rowarr[$k]  =  $cred;
					$worksheet1->write($linha_ini,$k,$rowarr[$k], $fmt_valorb);
					$k++;


					//Debito
					$rowarr[$k]  =  $deb;
					$worksheet1->write($linha_ini,$k,$rowarr[$k], $fmt_valorb);
					$k++;

					$worksheet1->write($linha_ini,$k,'', $fmt_valorb);
					$k++;


					$total_credito_grupo+= $soma_cred;
					$total_debito_grupo+= $soma_deb;
					$total_saldo_grupo+= ($soma_cred-$soma_deb);

					$total_credito_tipo+= $soma_cred;
					$total_debito_tipo+= $soma_deb;
					$total_saldo_tipo+= ($soma_cred-$soma_deb);

					$total_credito_geral+= $soma_cred;
					$total_debito_geral+= $soma_deb;
					$total_saldo_geral+= ($soma_cred-$soma_deb);

					$linha_ini++;
				}
				$k=0;
				//total conta
				$worksheet1->write($linha_ini,$k,'Total Crdito / Dbito / Saldo do Grupo:', $fmt_txt_l);
				$k++;

				if($total_credito_grupo==0){
					$total_credito_grupo = '';
				}else{
					$total_credito_grupo = str_replace('"','',to_money($total_credito_grupo));
				}

				if($total_debito_grupo==0){
					$total_debito_grupo = '';
				}else{
					$total_debito_grupo = str_replace('"','',to_money($total_debito_grupo));
				}

				$worksheet1->write($linha_ini,$k,$total_credito_grupo, $fmt_valorb);
				$k++;

				$worksheet1->write($linha_ini,$k,$total_debito_grupo, $fmt_valorb);
				$k++;

				$worksheet1->write($linha_ini,$k,str_replace('"','',to_money($total_saldo_grupo)), $fmt_valorb);
				$k++;
              
              
				$linha_ini++;
			}
			$k=0;
			$worksheet1->write($linha_ini,$k,'Total Crdito / Dbito / Saldo do Tipo:', $fmt_txt_l);
			$k++;

			if($total_credito_tipo==0){
				$total_credito_tipo = '';
			}else{
				$total_credito_tipo = str_replace('"','',to_money($total_credito_tipo));
			}

			if($total_debito_tipo==0){
				$total_debito_tipo = '';
			}else{
				$total_debito_tipo = str_replace('"','',to_money($total_debito_tipo));
			}

			$worksheet1->write($linha_ini,$k, $total_credito_tipo, $fmt_valorb);
			$k++;

			$worksheet1->write($linha_ini,$k, $total_debito_tipo, $fmt_valorb);
			$k++;

			$worksheet1->write($linha_ini,$k,str_replace('"','',to_money($total_saldo_tipo)), $fmt_valorb);
			$k++;
			$linha_ini++;
        }
		$k=0;
        //TOTAL GERAL SALDO
        $worksheet1->write($linha_ini,$k,'Total Crdito / Dbito / Saldo Geral:', $fmt_txt_l);
        $k++;

        $worksheet1->write($linha_ini,$k,str_replace('"','',to_money($total_credito_geral)), $fmt_valorb);
        $k++;

        $worksheet1->write($linha_ini,$k,str_replace('"','',to_money($total_debito_geral)), $fmt_valorb);
        $k++;
        
        $worksheet1->write($linha_ini,$k,str_replace('"','',to_money($total_saldo_geral)), $fmt_valorb);
        $k++;
        $linha_ini++;
    }
   
	$workbook->close();
	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			' Dominio, '.
			' Usuario, '.
			' Descricao ) values ('.
			'"'.$_SESSION['Dominio'].'", '.
			'"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			'"")';
	consulta_sql($insert);
}
?>