<?
    require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
    session::usr_conectado($_REQUEST['USER_ID']);
    require_once('../../includes/write_excel/Worksheet.php');
    require_once('../../includes/write_excel/Workbook.php');

    function HeaderingExcel($filename) {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=$filename" );
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
        header("Pragma: public");
    }


    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');

    // HTTP headers
    HeaderingExcel('CONTAS_PAGAR.xls');

    // Creating a workbook
    $workbook = new Workbook("-");
    // Creating the first worksheet
    $titulo_sheet = 'CONTAS A PAGAR';
    $worksheet1 =& $workbook->add_worksheet($titulo_sheet);

    // Format for the headings
    $formatot =& $workbook->add_format();
    $formatot->set_size(18);

    $formatost =& $workbook->add_format();
    $formatost->set_size(14);

    $worksheet1->write_string(0,0,'RELATRIO DE CONTAS A PAGAR',$formatot);
    $worksheet1->write(3,0,config_pad('sistema_sigla')." - ".config_pad('sistema_licenca'));
    $worksheet1->write(4,0,"Data: ".$hoje." - Hora: ".$hora);
    $worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));


    $empresa = $_REQUEST['empresa'];
    $fornecedor = $_REQUEST['fornecedor'];
    $familia = $_REQUEST['familia'];
    $fam_grupo = $_REQUEST['fam_grupo'];
    $despesa = $_REQUEST['despesa'];
    $tipo_data = $_REQUEST['tipo_data'];
    $tipo_data_ini = $_REQUEST['tipo_data_ini'];
    $tipo_data_fim = $_REQUEST['tipo_data_fim'];
    $valor_ini = $_REQUEST['valor_ini'];
    $valor_fim = $_REQUEST['valor_fim'];
    $nome_parcial = $_REQUEST['nome_parcial'];
    $situacao = $_REQUEST['situacao'];
    $tipo_emissao = $_REQUEST['tipo_emissao'];
    $modelo = $_REQUEST['modelo'];
    $serie = $_REQUEST['serie'];
    $nr_fatura = $_REQUEST['nr_fatura'];
    $nr_pedido = $_REQUEST['nr_pedido'];
    $liberado = $_REQUEST['liberado'];
    $agrupado = $_REQUEST['agrupado'];
    $vendor = $_REQUEST['vendor'];
    $contrato = $_REQUEST['contrato'];
    $ordenacao = $_REQUEST['ordenacao'];
    if (isset($_REQUEST['observ'])){
        $observ = $_REQUEST['observ'];
    }else{
        $observ = 'S';
    }

    if (isset($_REQUEST['frete'])){
        $frete = $_REQUEST['frete'];
    }else{
        $frete = 'S';
    }
    
    $meio_pagto = $_REQUEST['meio_pagto'];
    $forma_pagto_contas = $_REQUEST['forma_pagto_contas'];


    $inner_pessoa = '';
    if(($despesa!='')&&($despesa>0)){
        $inner_pessoa = ' inner join pessoa_fornecedor pes_forn '.
                       ' on cp.Dominio = pes_forn.Dominio '.
                       ' and cp.Pessoa = pes_forn.Pessoa ';
    }

    $filtro = '';

    $consulta = 'select cp.Nr_Doc, cp.Modelo, cp.Serie, cp.Pessoa, cp.Parcela, cp.Nr_Contas, cp.Seq, cp.DT_Vencto, cp.DH_Baixa, '.
                ' cp.Valor, cp.Valor_Desconto, cp.Valor_Acrescimo, cp.Valor_Liquido, cp.Valor_Pago, cp.Contrato, '.
                ' cp.Empresa, cp.Conferido, cp.Liberado, cp.Observacao, cp.Desconto_Pre_Aprovado, '.
                ' cp.Nr_Pedido_Compra, cp.Valor_Pedido_Compra, '.
                ' cp.EGF_Produto, cp.EGF_Qtd, cp.EGF_Data, cp.EGF_Banco, cp.EGF_Taxa, cp.EGF_TaxaTipo, '.
                ' pes.Nome_Razao, pes.CPF_CNPJ, cp.Programado '.
                ' from contas_pr cp '.
                ' inner join pessoa pes '.
                ' on cp.Dominio = pes.Dominio '.
                ' and cp.Pessoa = pes.Pessoa '.
                ''.$inner_pessoa.''.
                ' where cp.Dominio = "'.$_SESSION['Dominio'].'" '.
                ' and cp.TipoPR = "P" ';

    if($empresa>0){
		$consulta.= ' and cp.Empresa = "'.$empresa.'" ';

		$cons_empresa = 'select Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					   ' and Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
    }

    if (isset($_REQUEST['pesquisa'])){
        if($_REQUEST['pesquisa']!=''){
            $_REQUEST['pesquisa'] = str_replace('"',"",$_REQUEST['pesquisa']);
            $consulta.= ' and ( ';


            $data = '';

            if ((strlen($_REQUEST['pesquisa'])==7)&& (is_numeric(substr($_REQUEST['pesquisa'],0,2))) &&
                (substr($_REQUEST['pesquisa'],2,1)=='/') && (is_numeric(substr($_REQUEST['pesquisa'],3,4)))
				){
				$pesq_ini = '01/'.$_REQUEST['pesquisa'];
				$pesq_fim = '31/'.$_REQUEST['pesquisa'];
				$data = datad($dt_ini);

				$con_movto.= ' (cp.DT_Vencto>="'.datad($pesq_ini).'")'.
                            ' and (cp.DT_Vencto<="'.datad($pesq_fim).'")';
            }else if ((strlen($_REQUEST['pesquisa'])==10)&&(strlen(limpa_numero($_REQUEST['pesquisa']))==8)){
				$data = datad($_REQUEST['pesquisa']);
				if (($data[4]=='-')&&
					($data[7]=='-')){
					if (checkdate($data[5].$data[6],
                                $data[8].$data[9],
                                $data[0].$data[1].$data[2].$data[3])){
						$consulta.= ' (cp.DT_Vencto="'.$data.'")'.
                                  ' or (cp.DT_Pagto="'.$data.'")';

					}else{
						$data = '';
					}
				}
            }else if(strlen($_REQUEST['pesquisa'])==11){
				if(is_numeric($_REQUEST['pesquisa'])){
					$cpf.=substr($_REQUEST['pesquisa'],0,3).'.';
					$cpf.=substr($_REQUEST['pesquisa'],3,3).'.';
					$cpf.=substr($_REQUEST['pesquisa'],6,3).'-';
					$cpf.=substr($_REQUEST['pesquisa'],9,2);

					//Busca o codigo atraves do cpf no cadastro pessoa.
					$con_cpf = 'select Pessoa from pessoa '.
							' where Dominio="'.$_SESSION["Dominio"].'" '.
							' and CPF_CNPJ like "'.$cpf.'"';
					$res_cpf = consulta_sql($con_cpf);
					$reg_cpf = consulta_ler_linha($res_cpf);
					consulta_limpa($res_cpf);
					$consulta.= ' ( Pessoa = "'.$reg_cpf[0].'" ) or ';
				}//formata o cpf
            }else if(strlen($_REQUEST['pesquisa'])==14){
				//formata o cnpj
				if(is_numeric($_REQUEST['pesquisa'])){
					$cnpj.=substr($_REQUEST['pesquisa'],0,2).'.';
					$cnpj.=substr($_REQUEST['pesquisa'],2,3).'.';
					$cnpj.=substr($_REQUEST['pesquisa'],5,3).'/';
					$cnpj.=substr($_REQUEST['pesquisa'],8,4).'-';
					$cnpj.=substr($_REQUEST['pesquisa'],12,2);

					//Busca o codigo atraves do cpf no cadastro pessoa.
					$con_cnpj = 'select Pessoa from pessoa '.
							 ' where Dominio="'.$_SESSION["Dominio"].'" '.
							 ' and CPF_CNPJ like "'.$cnpj.'"';
					$res_cnpj = consulta_sql($con_cnpj);
					$reg_cnpj = consulta_ler_linha($res_cnpj);
					consulta_limpa($res_cnpj);
					$consulta.= ' ( Pessoa = "'.$reg_cnpj[0].'" ) or ';
				}
            }

            if ($data==''){
				$consulta.=' (cp.Nr_Doc like "%'.$_REQUEST['pesquisa'].'%")';
				if (is_numeric(str2nr(formata_valor(  $_REQUEST['pesquisa'])))){
					$consulta.= ' or (cp.Valor="'.str2nr(formata_valor($_REQUEST['pesquisa'])).'")'.
							   ' or (cp.Pessoa="'.$_REQUEST['pesquisa'].'") ';
				}else if (strlen($_REQUEST['pesquisa'])>2){
					$con_pessoa = 'select Pessoa from pessoa '.
							  ' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							  ' and ((Nome_Listas like "%'.$_REQUEST['pesquisa'].'%")'.
							  ' or  (Nome_Razao like "%'.$_REQUEST['pesquisa'].'%"))';
					$res_pessoa = consulta_sql($con_pessoa);
					$nrw_pessoa = consulta_num_registros($res_pessoa);
					for($p=0;$p<$nrw_pessoa;$p++){
						$reg_pessoa = consulta_ler_linha($res_pessoa);
						$consulta.= ' or (cp.Pessoa="'.$reg_pessoa[0].'")';
					}
					consulta_limpa($res_pessoa);
				}
            }
            $consulta.= ')';
            $filtro.= ' Nr da Fatura/Pessoa/Valor/Vencimento ou Pagamento Contm "'.$_REQUEST['pesquisa'].'"';
        }    
	}else{
        if($tipo_data=="V"){
			if(($tipo_data_ini!='')||($tipo_data_fim!='')){
				$filtro.= ' Data de: "Vencimento":';
				if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
					$consulta.= ' and (cp.DT_Vencto >= "'.datad($tipo_data_ini).'" '.
							 ' and cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
					$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
				}else if($tipo_data_ini!=''){
					$consulta.= ' and (cp.DT_Vencto >= "'.datad($tipo_data_ini).'") ';
					$filtro.= ' De "'.$tipo_data_ini.'"';
				}else if($tipo_data_fim!=''){
					$consulta.= ' and (cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
					$filtro.= ' At "'.$tipo_data_fim.'"';
				}
			}
        }else if($tipo_data=="P"){
			if(($tipo_data_ini!='')||($tipo_data_fim!='')){
				$filtro.= ' Data de: "Pagamento":';
				if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
					$consulta.= ' and (cp.DT_Pagto >= "'.datad($tipo_data_ini).'" '.
							 ' and cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
					$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
				}else if($tipo_data_ini!=''){
					$consulta.= ' and (cp.DT_Pagto >= "'.datad($tipo_data_ini).'") ';
					$filtro.= ' De "'.$tipo_data_ini.'"';
				}else if($tipo_data_fim!=''){
					$consulta.= ' and (cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
					$filtro.= ' At "'.$tipo_data_fim.'"';
				}
			}
        }else{
			if(($tipo_data_ini!='')||($tipo_data_fim!='')){
				$filtro.= ' Data de: "Emisso":';
				if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
					$consulta.= ' and (cp.DH_Criacao >= "'.datad($tipo_data_ini).'" '.
							 ' and cp.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
					$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
				}else if($tipo_data_ini!=''){
					$consulta.= ' and (cp.DH_Criacao >= "'.datad($tipo_data_ini).'") ';
					$filtro.= ' De "'.$tipo_data_ini.'"';
				}else if($tipo_data_fim!=''){
					$consulta.= ' and (cp.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
					$filtro.= ' At "'.$tipo_data_fim.'"';
				}
			}
        }

        if(($valor_ini!='') || ($valor_fim!='')){
			$filtro.= ' Valor:';
			if($valor_ini!=''){
				$consulta.= ' and cp.Valor >= "'.str2nr(formata_valor($valor_ini)).'" ';
				$filtro.= ' De "'.$valor_ini.'"';
			}
			if($valor_fim!=''){
				$consulta.= ' and cp.Valor <= "'.str2nr(formata_valor($valor_fim)).'" ';
				$filtro.= ' At "'.$valor_fim.'"';
			}
        }

        if($nome_parcial!=''){
			$consulta.= ' and pes.Nome_Razao like "%'.$nome_parcial.'%" ';
			$filtro.= ' Parcial Nome: "'.$nome_parcial.'"';
        }

        if($familia!=''){
			$consulta.= ' and pes.Familia = "'.$familia.'"';
			$cons_familia = 'select Descricao from pessoa_familia '.
						   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' and Cod_Familia = "'.$familia.'"';
			$res_familia = consulta_sql($cons_familia);
			$reg_familia = consulta_ler_linha($res_familia);
			consulta_limpa($res_familia);
			$filtro.= ' Famlia: "'.$reg_familia[0].'"';
		}

		if($fam_grupo!=''){
			$consulta.= ' and pes.Grupo = "'.$fam_grupo.'"';
			$cons_grupo = 'select Descricao from pessoa_grupo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Cod_Grupo = "'.$fam_grupo.'"';
			$res_grupo = consulta_sql($cons_grupo);
			$reg_grupo = consulta_ler_linha($res_grupo);
			consulta_limpa($res_grupo);
			$filtro.= ' Grupo: "'.$reg_grupo[0].'"';
		}

		if(($despesa!='')&&($despesa>0)){
			$consulta.= ' and pes_forn.Codigo_OQue = "'.$despesa.'"';
			$filtro.= ' Despesa: "'.financeiro_centro_custo_nome_ou_codigo_oque($despesa,'D').'"';
		}

		if($meio_pagto!=''){
			$consulta.= ' and cp.Tipo_Docto = "'.$meio_pagto.'" ';
			$filtro.= ' Meio Pagto: "'.busca_dados_combo('tipo_fatura',$meio_pagto).'"';
		}
    }

    if($situacao=='A'){
        $tipo_rel = 'A Pagar';
        $consulta.= ' and cp.Situacao = "A"';
    }else if($situacao=='V'){
        $tipo_rel = 'Vencido';
        $consulta.= ' and (cp.Situacao = "A") and (cp.DT_Vencto<"'.data_atual('date').'")';
    }else if($situacao=='I'){
        $tipo_rel = 'Vincendo';
        $consulta.= ' and (cp.Situacao = "A") and (cp.DT_Vencto>="'.data_atual('date').'")';
    }else if ($situacao=='J'){
        $consulta.= ' and (cp.Situacao="J")'; // Em Cobrana
        $tipo_rel = 'Em Cobrana';
    }else if ($situacao=='CL'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Conferido="S")'.
                    ' and (cp.Liberado="S")';
        $tipo_rel = 'Conferido e Liberado';
    }else if ($situacao=='AC'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Conferido="N")';
        $tipo_rel = 'No Conferido';
    }else if ($situacao=='AL'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Liberado="N")';
        $tipo_rel = 'No Liberado';
    }else if ($situacao=='PR'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Programado<>"N")';
        $tipo_rel = 'Pagto Programado';
    }else if ($situacao=='RMP'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and ( (cp.Programado="G") or (cp.Programado="L") or (cp.Programado="M"))';
        $tipo_rel = 'Pagto Programado - Remessa';
    }else if ($situacao=='RG'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Programado="G")';
        $tipo_rel = 'Pagto Programado - Remessa Gilmara';
    }else if ($situacao=='RM'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Programado="M")';
        $tipo_rel = 'Pagto Programado - Remessa Marilia';
    }else if ($situacao=='RL'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Programado="L")';
        $tipo_rel = 'Pagto Programado - Remessa Luciane';
    }else if ($situacao=='RCRT'){
        $consulta.= ' and (cp.Situacao="A")'.
                    ' and (cp.Programado="C")';
        $tipo_rel = 'Pagto Programado - Carto';
    }else if($situacao=='F'){
        $consulta.= ' and cp.Situacao = "F" ';
        $tipo_rel = 'Pagas';  //Pagas
    }else{
        $consulta.= ' and cp.Situacao <> "C" ';
        $tipo_rel = 'Todas';
    }


    if($tipo_emissao!=''){
        if($tipo_emissao=='P'){
			$filtro.= ' Tipo Emisso: "Prprio (Cereais)"';
			$consulta.= ' and (cp.TipoEmissao = "'.$tipo_emissao.'" or cp.Nr_Boletim_Pesagem <> 0)';
		}else{
			$filtro.= ' Tipo Emisso: "Terceiros (No Cereais)"';
			$consulta.= ' and (cp.TipoEmissao = "'.$tipo_emissao.'" and cp.Nr_Boletim_Pesagem = 0)';
		}
    }

    if (!(isset($_REQUEST['pesquisa']))){
        if($modelo!=''){
			$consulta.= ' and cp.Modelo = "'.$modelo.'" ';
			$filtro.= ' Modelo: "'.$modelo.'"';
        }else{
			if ($frete=='N'){
				$consulta.= ' and cp.Modelo <> "07" '.
						 ' and cp.Modelo <> "08" '.
						 ' and cp.Modelo <> "8B" '.
						 ' and cp.Modelo <> "09" '.
						 ' and cp.Modelo <> "10" '.
						 ' and cp.Modelo <> "11" '.
						 ' and cp.Modelo <> "13" '.
						 ' and cp.Modelo <> "14" '.
						 ' and cp.Modelo <> "15" '.
						 ' and cp.Modelo <> "16" '.
						 ' and cp.Modelo <> "17" '.
						 ' and cp.Modelo <> "20" '.
						 ' and cp.Modelo <> "57" ';
				$filtro.= ' "Sem Frete"';
			}else if($frete=='O'){
				$consulta.= ' and ((cp.Modelo = "07") '.
						  ' or (cp.Modelo = "08") '.
						  ' or (cp.Modelo = "8B") '.
						  ' or (cp.Modelo = "09") '.
						  ' or (cp.Modelo = "10") '.
						  ' or (cp.Modelo = "11") '.
						  ' or (cp.Modelo = "13") '.
						  ' or (cp.Modelo = "14") '.
						  ' or (cp.Modelo = "15") '.
						  ' or (cp.Modelo = "16") '.
						  ' or (cp.Modelo = "17") '.
						  ' or (cp.Modelo = "20") '.
						  ' or (cp.Modelo = "57")) ';
				$filtro.= ' "Somente Frete"';
			}
        }

        if($serie!=''){
            $consulta.= ' and cp.Serie = "'.$serie.'" ';
            $filtro.= ' Srie: "'.$serie.'"';
        }

        if($nr_fatura!=''){
            $consulta.= ' and cp.Nr_Doc = "'.$nr_fatura.'" ';
            $filtro.= ' NrFatura: "'.$nr_fatura.'"';
        }

        if($nr_pedido!=''){
            $consulta.= ' and cp.Nr_Pedido_Compra = "'.$nr_pedido.'" ';
            $filtro.= ' Nr Pedido: '.$nr_pedido;
        }

        if($liberado!=''){
            $consulta.= ' and cp.Liberado = "'.$liberado.'" ';

            if($liberado=='S'){
				$filtro.= ' Liberado: "Sim"';
			}else{
				$filtro.= ' Liberado: "No"';
			}
        }

        if($contrato!=''){
            $consulta.= ' and cp.Contrato = "'.$contrato.'" ';

            if($contrato=='S'){
				$filtro.= ' "Com Contratos"';
			}else{
				$filtro.= ' "Sem Contratos"';
			}
        }

        if($forma_pagto_contas!=''){
			$consulta.= ' and cp.Forma_Pagto_Contas = "'.$forma_pagto_contas.'" ';
			$sql_forma = 'select Descricao from forma_pagto_contas '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Pagto = "'.$forma_pagto_contas.'"';
			$res_forma = consulta_sql($sql_forma);
			$reg_forma = consulta_ler_linha($res_forma);
			consulta_limpa($res_forma);
			$filtro.= ' Forma Pagto: "'.$reg_forma[0].'"';
        }
        
        if($meio_pagto!=''){
			$consulta.= ' and cp.Tipo_Docto = "'.$meio_pagto.'" ';
			$filtro.= ' Meio Pagto: "'.busca_dados_combo('tipo_fatura',$meio_pagto).'"';
        }
    }
    if($ordenacao=='A'){
        $consulta.= ' order by pes.Nome_Razao, cp.Pessoa, cp.DT_Vencto, cp.Empresa, cp.Nr_Doc, cp.Serie, cp.Modelo, cp.Parcela, cp.Seq';
    }else{
        $consulta.= ' order by cp.DT_Vencto, cp.Pessoa, cp.Empresa, cp.Nr_Doc, cp.Serie, cp.Modelo, cp.Parcela, cp.Seq';
    }
    if ((isset($_REQUEST['pesquisa']))){
        $consulta.= ' limit 10000 ';
    }
//    echo $consulta;

    $worksheet1->write(7,0,"Filtro: ".$filtro);
    //$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

    // Format for the headings
    $formatott =& $workbook->add_format();
    $formatott->set_align('center');
    $formatott->set_pattern();
    $formatott->set_fg_color(40);
    $formatott->set_bold(1);
    $formatott->set_border(1);

    // Format for the headings
    $formatotl =& $workbook->add_format();
    $formatotl->set_border(1);
    $formatotl->set_align('left');

    $formatotlb =& $workbook->add_format();
    $formatotlb->set_border(1);
    $formatotlb->set_size(10);
    $formatotlb->set_align('left');
    $formatotlb->set_bold(1);

    $formatotrb =& $workbook->add_format();
    $formatotrb->set_border(1);
    $formatotrb->set_size(10);
    $formatotrb->set_align('right');
    $formatotrb->set_bold(1);

    $formatotcb =& $workbook->add_format();
    $formatotcb->set_border(1);
    $formatotcb->set_size(10);
    $formatotcb->set_align('center');
    $formatotcb->set_bold(1);

    $formatotqtdb =& $workbook->add_format();
    $formatotqtdb->set_border(1);
    $formatotqtdb->set_align('right');
    $formatotqtdb->set_size(10);
    $formatotqtdb->set_bold(1);
    $formatotqtdb->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

    // Format for the headings
    $formatotc =& $workbook->add_format();
    $formatotc->set_border(1);
    $formatotc->set_align('center');

    // Format for the headings
    $formatotqtd =& $workbook->add_format();
    $formatotqtd->set_border(1);
    $formatotqtd->set_align('right');
    $formatotqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

    // Format for the headings
    $formatotpreco =& $workbook->add_format();
    $formatotpreco->set_border(1);
    $formatotpreco->set_align('right');
    $formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

    // Format for the headings
    $formatotbpreco =& $workbook->add_format();
    $formatotbpreco->set_border(1);
    $formatotbpreco->set_align('right');
    $formatotbpreco->set_bold(1);
    $formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');


    $resultado = consulta_sql($consulta);
    $nrows = consulta_num_registros($resultado);

    $worksheet1->write_string(1,0,'Todos os Fornecedores - '.$tipo_rel,$formatost);

    $linha_ini = 9;
    $lista_qtd_egf = array();

    if ($nrows>0){
        $coluna=0;
        $worksheet1->set_column($coluna,$coluna,38);
        $worksheet1->write_string($linha_ini,$coluna,'Fornecedor',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'NrFatura',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,5);
        $worksheet1->write_string($linha_ini,$coluna,'Par',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,5);
        $worksheet1->write_string($linha_ini,$coluna,'Conf.',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,4);
        $worksheet1->write_string($linha_ini,$coluna,'Lib.',$formatott);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,6);
        $worksheet1->write_string($linha_ini,$coluna,'Prog',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'Dt Venc',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,16);
        $worksheet1->write_string($linha_ini,$coluna,'Empresa',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,42);
        $worksheet1->write_string($linha_ini,$coluna,'Observao',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,14);
        $worksheet1->write_string($linha_ini,$coluna,'Desc',$formatott);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,18);
        $worksheet1->write_string($linha_ini,$coluna,'Valor',$formatott);
        $coluna++;


        $linha_ini++;

        $vl_valor = 0;
        $vl_valor_geral = 0;
        $tot_desc = 0;
        $tot_desc_geral = 0;

        $id_data = '';
        $id_fornec = '';

        $vl_com_contratos = 0;
        $vl_sem_contratos = 0;
        $vl_com_contratos_grupo = 0;
        $vl_sem_contratos_grupo = 0;

        $vl_pedido_grupo = 0;
        $vl_saldo_grupo = 0;

        $vl_pedido_geral = 0;
        $vl_saldo_geral = 0;

        $lista_pedidos = '';
        $lista_pedidos_repetidos = '';

        $lista_empresas = lista_empresas();

        for ($i=0;$i<$nrows;$i++){
            $registro = consulta_ler_objeto($resultado);
            set_time_limit(30);

            $cpf_cnpj =  $registro->CPF_CNPJ;


            if($ordenacao=='V'){
				if($id_data!=$registro->DT_Vencto){

					if($id_data!=''){
						$coluna=0;

						$worksheet1->write_string($linha_ini,$coluna,'TOTAL',$formatotlb);
						for($la=0;$la<=4;$la++){
							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
						}

						if($contrato!='N'){
							$coluna++;
							$worksheet1->write_string($linha_ini,$coluna,'S Contratos: '.str_replace('"','',to_money($vl_com_contratos_grupo)),$formatotlb);
							$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
							$coluna++;

							$coluna++;
							$worksheet1->write_string($linha_ini,$coluna,'Sem Contratos: '.str_replace('"','',to_money($vl_sem_contratos_grupo)),$formatotlb);
						}else{
							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
						}
						//$coluna++;
						//$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

						$coluna++;
						$worksheet1->write_number($linha_ini,$coluna,$tot_desc,$formatotbpreco);

						$coluna++;
						$worksheet1->write_number($linha_ini,$coluna,$vl_valor,$formatotbpreco);
						$linha_ini++;

						$vl_valor = 0;
						$tot_desc = 0;

						$vl_com_contratos_grupo = 0;
						$vl_sem_contratos_grupo = 0;

					}

					$id_data = $registro->DT_Vencto;

				}
            }else{
				if($id_fornec!=$registro->Pessoa){
					if($id_fornec!=''){
						$coluna=0;

						$worksheet1->write_string($linha_ini,$coluna,'TOTAL - Pedido: '.str_replace('"','',to_money($vl_pedido_grupo)),$formatotlb);
						/*for($lb=0;$lb<=4;$lb++){
						$coluna++;
						$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
						}*/

						$coluna++;
						$worksheet1->write_string($linha_ini,$coluna,'Saldo Pedido: '.str_replace('"','',to_money($vl_saldo_grupo)),$formatotlb);
						$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
						for($lb=0;$lb<=3;$lb++){
							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
						}

						if($contrato!='N'){
							$coluna++;
							$worksheet1->write_string($linha_ini,$coluna,'S Contratos: '.str_replace('"','',to_money($vl_com_contratos_grupo)),$formatotlb);
							$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
							$coluna++;

							$coluna++;
							$worksheet1->write_string($linha_ini,$coluna,'Sem Contratos: '.str_replace('"','',to_money($vl_sem_contratos_grupo)),$formatotlb);
						}else{
							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

							$coluna++;
							$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
						}

						$coluna++;
						$worksheet1->write_number($linha_ini,$coluna,$tot_desc,$formatotbpreco);

						$coluna++;
						$worksheet1->write_number($linha_ini,$coluna,$vl_valor,$formatotbpreco);
						$linha_ini++;

						$vl_valor = 0;
						$tot_desc = 0;

						$vl_com_contratos_grupo = 0;
						$vl_sem_contratos_grupo = 0;

						$vl_pedido_grupo = 0;
						$vl_saldo_grupo = 0;

						$lista_pedidos = '';
						$lista_pedidos_repetidos = '';

					}

					$id_fornec = $registro->Pessoa;

				}
            }


            $coluna=0;

            $contar_total = true;
            if (isset($listas_contados[$registro->Empresa.'-'.$registro->Nr_Contas])){
				$contar_total = false;
            }else{
				$listas_contados[$registro->Empresa.'-'.$registro->Nr_Contas] = $registro->Seq;
            }

            if($registro->Nome_Razao!=''){
				$desc_pess = $registro->Nome_Razao;
            }else{
				$cons_pess = 'select Nome_Razao from pessoa '.
							' where Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = "'.$registro->Pessoa.'"';
				$res_pess = consulta_sql($cons_pess);
				$reg_pess = consulta_ler_linha($res_pess);
				consulta_limpa($res_pess);

				$desc_pess = $reg_desc[0];
            }
            $worksheet1->write_string($linha_ini,$coluna,$registro->Pessoa.' - '.$desc_pess.' ('.$cpf_cnpj.')',$formatotl);
            $coluna++;


            $worksheet1->write_string($linha_ini,$coluna,$registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo,$formatotc);
            $coluna++;


            $worksheet1->write($linha_ini,$coluna,$registro->Parcela,$formatotc);
            $coluna++;


            if($registro->Conferido=="S"){
				$conf = '*';
            }else{
				$conf = '';
            }
            $worksheet1->write_string($linha_ini,$coluna,$conf,$formatotc);
            $coluna++;


            if($registro->Liberado=="S"){
				$lib = '*';
            }else{
				$lib = '';
            }
            $worksheet1->write_string($linha_ini,$coluna,$lib,$formatotc);
            $coluna++;


            if($registro->Contrato=='S'){
				$contrat = 'C';
				if ($contar_total){
					$vl_com_contratos+=$registro->Valor;
					$vl_com_contratos_grupo+=$registro->Valor;
					//$vl_com_contratos_geral+=$registro->Valor;
				}
            }else{
				$contrat = '';
				if ($contar_total){
					$vl_sem_contratos+=$registro->Valor;
					$vl_sem_contratos_grupo+=$registro->Valor;
					//$vl_sem_contratos_geral+=$registro->Valor;
				}
            }
            $contrat = '';
            if($registro->Programado!='N'){
				$contrat = $registro->Programado;
				if (($contrat=='G')||
					($contrat=='L')||
					($contrat=='M')){
					$contrat = 'R'.$registro->Programado;
				}
            }
            
            
            $worksheet1->write_string($linha_ini,$coluna,$contrat,$formatotc);
            $coluna++;


            if(($registro->DT_Vencto == '') || ($registro->DT_Vencto == '0000-00-00')){
				$dt_venc = ' ';
            }else{
				$dt_venc = dataf($registro->DT_Vencto);
            }
            $worksheet1->write_string($linha_ini,$coluna,$dt_venc,$formatotc);
            $coluna++;


            $worksheet1->write_string($linha_ini,$coluna,nome_empresa($lista_empresas,$registro->Empresa),$formatotc);
            $coluna++;


            $txt_obs = '';
            if($observ=='S'){
				if($registro->Nr_Pedido_Compra!=''){
					$txt_obs.= 'Ped '.$registro->Nr_Pedido_Compra.' ';
				}
				if($registro->Valor_Pedido_Compra>0){
					if($registro->Nr_Pedido_Compra!=''){
						$txt_obs.= 'TOTAL '.str_replace('"','',to_money($registro->Valor_Pedido_Compra));
					}
				}

				if($registro->EGF_Banco!=''){
					$cons_banco = 'select Nome from banco '.
								' where Dominio = "'.$_SESSION['Dominio'].'" '.
								' and Codigo_Banco = "'.$registro->EGF_Banco.'" '.
								' and Situacao <> "E" ';
					$res_banco = consulta_sql($cons_banco);
					$reg_banco = consulta_ler_linha($res_banco);
					consulta_limpa($res_banco);

					$txt_obs.= ' '.$reg_banco[0];
				}

				if($registro->EGF_Produto>0){
					$cons_desp = 'select Descricao from produto_grupo '.
						   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' and Codigo_Depart = 14 '.
						   ' and Codigo_Grupo = "'.$registro->EGF_Produto.'"';
					$res_desp = consulta_sql($cons_desp);
					$reg_desp = consulta_ler_linha($res_desp);
					consulta_limpa($res_desp);
					if($txt_obs!=''){
						$txt_obs.= ' -';
					}
					$txt_obs.= ' '.$reg_desp[0];


					//TOTAIS QTD
					if(isset($lista_qtd_egf[$registro->EGF_Produto])){
						$lista_campos = $lista_qtd_egf[$registro->EGF_Produto];
					}else{
						$lista_campos['QtdTotal'] = 0;
					}
					$lista_campos['QtdTotal']+= $registro->EGF_Qtd;

					$lista_qtd_egf[$registro->EGF_Produto] = $lista_campos;
				}

				if($registro->EGF_Qtd>0){
					if($txt_obs!=''){
						$txt_obs.= ' -';
					}
					$txt_obs.= ' '.formata_qtd($registro->EGF_Qtd,3,false).' KG';
				}

				if($registro->EGF_Data>0){
					$txt_obs.= ' ('.dataf($registro->EGF_Data).')';
				}

				if($registro->EGF_Taxa>0){
					if($txt_obs!=''){
						$txt_obs.= ' -';
					}
					$txt_obs.= ' '.formata_qtd($registro->EGF_Taxa,2,false);
					if($registro->EGF_TaxaTipo!=''){
						$txt_obs.= '%A'.$registro->EGF_TaxaTipo;
					}
				}

				if($registro->Observacao!=''){
					if($txt_obs!=''){
						$txt_obs.= ' - ';
					}
					$txt_obs.= $registro->Observacao;
				}
            }else{
				$txt_obs = ' ';
            }
            $worksheet1->write_string($linha_ini,$coluna,$txt_obs,$formatotl);
            $coluna++;


            if(($registro->Desconto_Pre_Aprovado=='')||($registro->Desconto_Pre_Aprovado==0)){
				$desc_pre_aprov = '';
            }else{
				$desc_pre_aprov = $registro->Desconto_Pre_Aprovado;
            }	
            $worksheet1->write_number($linha_ini,$coluna,$desc_pre_aprov,$formatotpreco);
            $coluna++;


            if(($registro->Valor=='')||($registro->Valor==0)){
				$txt_valor = '';
            }else{
				$txt_valor = $registro->Valor;
            }
            $worksheet1->write_number($linha_ini,$coluna,$txt_valor,$formatotpreco);
            $coluna++;


            $linha_ini++;

            if ($contar_total){
				$vl_valor+= $registro->Valor;
				$vl_valor_geral+= $registro->Valor;
            }

            $tot_desc+= $registro->Desconto_Pre_Aprovado;
            $tot_desc_geral+= $registro->Desconto_Pre_Aprovado;


            if($registro->Nr_Pedido_Compra!=''){
				if((strpos($lista_pedidos, ';'.$registro->Nr_Pedido_Compra.';') > 0)){
					$lista_pedidos_repetidos.= ' ;'.$registro->Nr_Pedido_Compra.';';
				}else{
					$lista_pedidos.= ' ;'.$registro->Nr_Pedido_Compra.';';
				}
            }

            if(strstr($lista_pedidos_repetidos, ' ;'.$registro->Nr_Pedido_Compra.';')==FALSE){
				if($registro->Valor_Pedido_Compra>0){
					$vl_pedido_grupo+= $registro->Valor_Pedido_Compra;
					$vl_pedido_geral+= $registro->Valor_Pedido_Compra;

					$vl_saldo_grupo+= ($registro->Valor_Pedido_Compra-$registro->Valor);
					$vl_saldo_geral+= ($registro->Valor_Pedido_Compra-$registro->Valor);
				}
            }else{
				if($registro->Valor_Pedido_Compra>0){
					$vl_saldo_grupo-= ($registro->Valor);
					$vl_saldo_geral-= ($registro->Valor);
				}
            }
        }

        $coluna = 0;

        if($ordenacao=='V'){

            if($id_data!=''){
				$coluna=0;

				$worksheet1->write_string($linha_ini,$coluna,'TOTAL',$formatotlb);
				for($lta=0;$lta<=4;$lta++){
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
				}

				if($contrato!='N'){
					$coluna++;
					$worksheet1->write_string($linha_ini,$coluna,'S Contratos: '.str_replace('"','',to_money($vl_com_contratos_grupo)),$formatotlb);
					$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_string($linha_ini,$coluna,'Sem Contratos: '.str_replace('"','',to_money($vl_sem_contratos_grupo)),$formatotlb);
				}else{
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
				}

				$coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$tot_desc,$formatotbpreco);

				$coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$vl_valor,$formatotbpreco);
				$linha_ini++;

				$vl_valor = 0;
				$tot_desc = 0;

			}

        }else{

            if($id_fornec!=''){
				$coluna=0;

				$worksheet1->write_string($linha_ini,$coluna,'TOTAL - Pedido: '.str_replace('"','',to_money($vl_pedido_grupo)),$formatotlb);
				/*for($lb=0;$lb<=4;$lb++){
				$coluna++;
				$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
				}*/

				$coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Saldo Pedido: '.str_replace('"','',to_money($vl_saldo_grupo)),$formatotlb);
				$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
				for($lb=0;$lb<=3;$lb++){
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
				}

				if($contrato!='N'){
					$coluna++;
					$worksheet1->write_string($linha_ini,$coluna,'S Contratos: '.str_replace('"','',to_money($vl_com_contratos_grupo)),$formatotlb);
					$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_string($linha_ini,$coluna,'Sem Contratos: '.str_replace('"','',to_money($vl_sem_contratos_grupo)),$formatotlb);
				}else{
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
				}

				$coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$tot_desc,$formatotbpreco);

				$coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$vl_valor,$formatotbpreco);
				$linha_ini++;

				$vl_valor = 0;
				$tot_desc = 0;

            }
        }
        $linha_ini++;
        $coluna=0;

        $worksheet1->write_string($linha_ini,$coluna,'TOTAL GERAL - Pedido: '.str_replace('"','',to_money($vl_pedido_geral)),$formatotlb);

        /*for($lta=0;$lta<=4;$lta++){
            $coluna++;
            $worksheet1->write_blank($linha_ini,$coluna,$formatotc);
        }*/
        $coluna++;
        $worksheet1->write_string($linha_ini,$coluna,'Saldo Pedido: '.str_replace('"','',to_money($vl_saldo_geral)),$formatotlb);
        $worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
        for($lb=0;$lb<=3;$lb++){
            $coluna++;
            $worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
        }


        if($contrato!='N'){
			$coluna++;
			$worksheet1->write_string($linha_ini,$coluna,'S Contratos: '.str_replace('"','',to_money($vl_com_contratos)),$formatotlb);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
			$coluna++;
			$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

			$coluna++;
			$worksheet1->write_string($linha_ini,$coluna,'Sem Contratos: '.str_replace('"','',to_money($vl_sem_contratos)),$formatotlb);
        }else{
			$coluna++;
			$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

			$coluna++;
			$worksheet1->write_blank($linha_ini,$coluna,$formatotc);

			$coluna++;
			$worksheet1->write_blank($linha_ini,$coluna,$formatotc);
        }

        $coluna++;
        $worksheet1->write_number($linha_ini,$coluna,$tot_desc_geral,$formatotbpreco);

        $coluna++;
        $worksheet1->write_number($linha_ini,$coluna,$vl_valor_geral,$formatotbpreco);

        $linha_ini++;


        //TOTAL LIQUIDO (VALOR - DESCONTO)
        $coluna=0;

        $worksheet1->write_string($linha_ini,$coluna,'TOTAL LQUIDO',$formatotlb);
        /*for($lta=0;$lta<=4;$lta++){
            $coluna++;
            $worksheet1->write_blank($linha_ini,$coluna,$formatotc);
        }*/

        $coluna++;
        $worksheet1->write_string($linha_ini,$coluna,'',$formatotlb);
        $worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
        for($lb=0;$lb<=3;$lb++){
            $coluna++;
            $worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
        }

        $coluna++;
        $worksheet1->write_blank($linha_ini,$coluna,$formatotc);

        $coluna++;
        $worksheet1->write_blank($linha_ini,$coluna,$formatotc);

        $coluna++;
        $worksheet1->write_blank($linha_ini,$coluna,$formatotc);

        $coluna++;
        $worksheet1->write_blank($linha_ini,$coluna,$formatotc);


        $coluna++;
        $worksheet1->write_number($linha_ini,$coluna,($vl_valor_geral-$tot_desc_geral),$formatotbpreco);
        $linha_ini++;



        //TOTAL QTD EGF
        if(count($lista_qtd_egf)>0){
			$total_qtd_egf = 0;
			$linha_ini++;
			$coluna=0;

			$worksheet1->write_string($linha_ini,$coluna,'Total Quantidade EGF',$formatotcb);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+2);
			for($lb=0;$lb<2;$lb++){
				$coluna++;
				$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
			}

			ksort($lista_qtd_egf);

			foreach($lista_qtd_egf as $idprod => $valor){
				$lista_egf = $lista_qtd_egf[$idprod];

				$coluna=0;
				$linha_ini++;

				$cons_prod = 'select Descricao from produto_grupo '.
						   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' and Codigo_Depart = 14 '.
						   ' and Codigo_Grupo = "'.$idprod.'"';
				$res_prod = consulta_sql($cons_prod);
				$reg_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);

				$worksheet1->write_string($linha_ini,$coluna,$reg_prod[0],$formatotlb);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,formata_qtd($lista_egf['QtdTotal'],3,false).' KG',$formatotrb);
				$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
				for($qb=0;$qb<1;$qb++){
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
				}

				$total_qtd_egf+= $lista_egf['QtdTotal'];
			}

			$coluna=0;
			$linha_ini++;

			$worksheet1->write_string($linha_ini,$coluna,'TOTAL',$formatotlb);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,formata_qtd($total_qtd_egf,3,false).' KG',$formatotrb);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+1);
			for($tb=0;$tb<1;$tb++){
				$coluna++;
				$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
			}
        }

    }else{
        $worksheet1->write(10,0,"No existem registros para este filtro!");
    }
    consulta_limpa($resultado);

    //ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
    $insert = 'insert into relatorio_tmp ( '.
              ' Dominio, '.
              ' Usuario, '.
              ' Descricao ) values ('.
              '"'.$_SESSION['Dominio'].'", '.
              '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
              '"")';
    consulta_sql($insert);
    $workbook->close();
	
?>