<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	//require_once('../../includes/header.inc');
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

if(session::usr_conectado($_REQUEST['USER_ID'])){

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('CONTAS_PAG_VENCIMENTO.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'CONTAS_PAG_VENCIMENTO';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(12);

	$worksheet1->write_string(0,0,'RELATRIO CONTAS PAGAR VENCIMENTO', $formatot);
	$worksheet1->set_row(1,6);
	$worksheet1->write(2,0, config_pad('sistema_licenca'));
	$worksheet1->write(3,0, "Data: ".$hoje." - Hora: ".$hora." - Usurio: ".base64_decode_si($_REQUEST['USER_ID']));

	// Format for the headings
	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_align('vcenter');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_bold(1);
	$fmt_cabec->set_border(1);

	$fmt_cabec_sub =& $workbook->add_format();
	$fmt_cabec_sub->set_align('center');
	$fmt_cabec_sub->set_align('vcenter');
	$fmt_cabec_sub->set_pattern();
	$fmt_cabec_sub->set_fg_color('silver');
	$fmt_cabec_sub->set_bold(1);
	$fmt_cabec_sub->set_italic(1);
	$fmt_cabec_sub->set_border(1);
	$fmt_cabec_sub->set_size(8);

	$fmt_cabec_sub2 =& $workbook->add_format();
	$fmt_cabec_sub2->set_align('center');
	$fmt_cabec_sub2->set_align('vcenter');
	$fmt_cabec_sub2->set_pattern();
	$fmt_cabec_sub2->set_italic(1);
	$fmt_cabec_sub2->set_border(1);
	$fmt_cabec_sub2->set_size(8);

	// Format for the headings
	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_align('left');

	$fmt_txt_l_sub =& $workbook->add_format();
	$fmt_txt_l_sub->set_border(1);
	$fmt_txt_l_sub->set_align('left');
	$fmt_txt_l_sub->set_size(8);
	$fmt_txt_l_sub->set_italic(1);

	$fmt_txt_lb =& $workbook->add_format();
	$fmt_txt_lb->set_border(1);
	$fmt_txt_lb->set_align('left');
	$fmt_txt_lb->set_bold(1);


	$fmt_txt_r =& $workbook->add_format();
	$fmt_txt_r->set_border(1);
	$fmt_txt_r->set_align('right');
	$fmt_txt_r->set_size(8);

	$fmt_txt_r_b =& $workbook->add_format();
	$fmt_txt_r_b->set_border(1);
	$fmt_txt_r_b->set_align('right');
	$fmt_txt_r_b->set_size(8);
	$fmt_txt_r_b->set_bold(1);

	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_border(1);
	$fmt_txt_c->set_align('center');

	$fmt_txt_sub_c =& $workbook->add_format();
	$fmt_txt_sub_c->set_border(1);
	$fmt_txt_sub_c->set_align('center');
	$fmt_txt_sub_c->set_size(8);
	$fmt_txt_sub_c->set_italic(1);

	$fmt_aviso =& $workbook->add_format();
	$fmt_aviso->set_size(10);
	$fmt_aviso->set_bold(1);

	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('right');
	$fmt_qtd->set_num_format('#,##0.000_);-#,##0.000_)');
	//$fmt_qtd->set_num_format('#,##0.0##_);-#,##0.0##_)');

	$fmt_qtd_b =& $workbook->add_format();
	$fmt_qtd_b->set_border(1);
	$fmt_qtd_b->set_align('right');
	$fmt_qtd_b->set_size(10);
	$fmt_qtd_b->set_bold(1);
	//$fmt_qtd_b->set_num_format('#,##0_);-#,##0_)');
	$fmt_qtd_b->set_num_format('#,##0.0##_);-#,##0.0##_)');

	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	$fmt_valor->set_size(8);
	$fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_valor_sub =& $workbook->add_format();
	$fmt_valor_sub->set_border(1);
	$fmt_valor_sub->set_align('right');
	$fmt_valor_sub->set_italic(1);
	$fmt_valor_sub->set_size(8);
	$fmt_valor_sub->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_valor_b =& $workbook->add_format();
	$fmt_valor_b->set_border(1);
	$fmt_valor_b->set_align('right');
	$fmt_valor_b->set_size(8);
	$fmt_valor_b->set_bold(1);
	$fmt_valor_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	$filtro = '';

	$listas_contados = array();

	$empresa = $_REQUEST['empresa'];
	$fornecedor = $_REQUEST['fornecedor'];
	$tipo_data = $_REQUEST['tipo_data'];
	$tipo_data_ini = $_REQUEST['tipo_data_ini'];
	$tipo_data_fim = $_REQUEST['tipo_data_fim'];
	$tipo = $_REQUEST['tipo'];
	$situacao = $_REQUEST['situacao'];

	$consulta = 'SELECT * FROM contas_pr cp '.
			  ' WHERE cp.Dominio = "'.$_SESSION['Dominio'].'" '.
			  ' AND cp.TipoPR = "P" '.
			  ' AND cp.Situacao <> "E" ';

	$txt_label = 'Pagar/Pagos';
	if($situacao=='F'){
		$consulta.= ' AND cp.Situacao = "F" ';
		$filtro.= 'Pagos';
		$txt_label = 'Pagos';
	}else if($situacao=='A'){
		$consulta.= ' AND cp.Situacao = "A" ';
		$filtro.= 'A Pagar';
		$txt_label = 'Pagar';
	}

	if($empresa>0){
		$consulta.= ' AND cp.Empresa = "'.$empresa.'" ';

		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}


	if($tipo_data=="V"){
		if(($tipo_data_ini != '') || ($tipo_data_fim != '')){
            $filtro.= ' Data de: "Vencimento":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' AND (cp.DT_Vencto >= "'.datad($tipo_data_ini).'" '.
							' AND cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
            }else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp.DT_Vencto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp.DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}else if($tipo_data=="P"){
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
            $filtro.= ' Data de: "Pagamento":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' AND (cp.DT_Pagto >= "'.datad($tipo_data_ini).'" '.
							' AND cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'" ';
            }else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp.DT_Pagto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp.DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}else{
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
            $filtro.= ' Data de: "Emisso":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' and (cp.DH_Criacao >= "'.datad($tipo_data_ini).'" '.
							' and cp.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
            }else if($tipo_data_ini!=''){
				$consulta.= ' AND (cp.DH_Criacao >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' AND (cp.DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}

	if($fornecedor>0){
		$consulta.= ' AND cp.Pessoa = "'.$fornecedor.'" ';
		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' AND Pessoa = "'.$fornecedor.'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Pessoa: "'.$reg_empresa[0].'"';
	}

	$consulta.= ' ORDER BY cp.DT_Vencto, cp.Pessoa, cp.Empresa, cp.Nr_Doc, cp.Serie, cp.Modelo, cp.Parcela, cp.Seq';

	$worksheet1->set_row(4,6);
	$worksheet1->write(5,0,"Filtro: ".$filtro);

	$linha_ini = 7;

	set_time_limit(60);
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	if($nrows>0){
		if($tipo=='A'){
            $coluna=0;

            $worksheet1->set_column($coluna,$coluna,100);
            $worksheet1->write_string($linha_ini,$coluna,'Fornecedor',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,10);
            $worksheet1->write_string($linha_ini,$coluna,'Dt Venc',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,10);
            $worksheet1->write_string($linha_ini,$coluna,'Dt Pagto',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,10);
            $worksheet1->write_string($linha_ini,$coluna,'Dt Baixa',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,12);
            $worksheet1->write_string($linha_ini,$coluna,'Nr Fatura',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,5);
            $worksheet1->write_string($linha_ini,$coluna,'Parc',$fmt_cabec);
            $coluna++;

            $worksheet1->set_column($coluna,$coluna,30);
            $worksheet1->write_string($linha_ini,$coluna,'Observao',$fmt_cabec);
            $coluna++;
		}else{
            $worksheet1->set_column($coluna,$coluna,60);
            $worksheet1->write_string($linha_ini,$coluna,'',$fmt_cabec);
            $coluna++;
		}

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Desconto',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Acrscimo',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Pagar',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Pago',$fmt_cabec);
		$coluna++;

		$vl_desconto = 0;
		$vl_acrescimo = 0;
		$vl_valor = 0;
		$vl_pago = 0;

		$id_data = '';

		$vl_pago_total_pag = 0;
		$vl_pago_total_rec = 0;
		$vl_valor_total_rec = 0;
		$vl_valor_total_pag = 0;

		$vl_desconto_total = 0;
		$vl_acrescimo_total = 0;

		for($i=0;$i<$nrows;$i++){
            $registro = consulta_ler_objeto($resultado);
            set_time_limit(60);
            if($id_data!=$registro->DT_Vencto){
				if($id_data!=''){
					$coluna = 0;
					$linha_ini++;
					$formato = $fmt_txt_r;
					$formato_vl = $fmt_valor;
					if($tipo == 'A'){
						for($ca=0;$ca<6;$ca++){
							$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
							$coluna++;
						}
						$coluna = 6;
						$formato = $fmt_txt_r_b;
						$formato_vl = $fmt_valor_b;
					}

					$worksheet1->write_string($linha_ini,$coluna,'Total '.$txt_label.' Dia '.dataf($id_data),$formato);
					$coluna++;

					//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_desconto_data, false),$formato);
					$worksheet1->write_number($linha_ini,$coluna,$vl_desconto_data,$formato_vl);
					$coluna++;

					//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_acrescimo_data, false),$formato);
					$worksheet1->write_number($linha_ini,$coluna,$vl_acrescimo_data,$formato_vl);
					$coluna++;

					//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_valor_data, false),$formato);
					$worksheet1->write_number($linha_ini,$coluna,$vl_valor_data,$formato_vl);
					$coluna++;

					//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_pago_data, false),$formato);
					$worksheet1->write_number($linha_ini,$coluna,$vl_pago_data,$formato_vl);
					$coluna++;
				}

				$vl_desconto_data = 0;
				$vl_acrescimo_data = 0;
				$vl_valor_data = 0;
				$vl_pago_data = 0;


            }
            $id_data = $registro->DT_Vencto;

            $contar_total = true;
            if(isset($listas_contados[$registro->Empresa.'-'.$registro->Nr_Contas])){
				$contar_total = false;
            }else{
				$listas_contados[$registro->Empresa.'-'.$registro->Nr_Contas] = $registro->Seq;
            }

            if($tipo=='A'){

				$coluna = 0;
				$linha_ini++;

				$con_pessoa = 'SELECT Nome_Razao FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Pessoa="'.$registro->Pessoa.'"';
				$res_pessoa = consulta_sql($con_pessoa);
				$reg_pessoa = consulta_ler_linha($res_pessoa);
				consulta_limpa($res_pessoa);

				$worksheet1->write_string($linha_ini,$coluna,$registro->Pessoa.'-'.$reg_pessoa[0],$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,dataf($registro->DT_Vencto),$fmt_txt_l);
				$coluna++;

				if(($registro->DT_Pagto == '') || ($registro->DT_Pagto == '0000-00-00')){
					$dt_pagto = ' ';
				}else{
					$dt_pagto = dataf($registro->DT_Pagto);
				}

				$worksheet1->write_string($linha_ini,$coluna,$dt_pagto,$fmt_txt_l);
				$coluna++;

				if(($registro->DH_Baixa == '') || ($registro->DH_Baixa == '0000-00-00 00:00:00')){
					$dt_baixa = ' ';
				}else{
					$dt_baixa = dataf($registro->DH_Baixa);
				}

				$worksheet1->write_string($linha_ini,$coluna,$dt_baixa,$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo,$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$registro->Parcela,$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$registro->Observacao,$fmt_txt_l);
				$coluna++;

				if(($registro->Valor_Desconto==''|| $registro->Valor_Desconto==0)){
					$valor_desconto = ' ';
					$worksheet1->write_string($linha_ini,$coluna,$valor_desconto,$fmt_txt_r);
				}else{
					$valor_desconto = $registro->Valor_Desconto;
					$worksheet1->write_number($linha_ini,$coluna,$valor_desconto,$fmt_valor);
				}               
				$coluna++;

				if(($registro->Valor_Acrescimo==''|| $registro->Valor_Acrescimo==0)){
					$valor_acrescimo = ' ';
					$worksheet1->write_string($linha_ini,$coluna,$valor_acrescimo,$fmt_txt_r);
				}else{
					$valor_acrescimo = $registro->Valor_Acrescimo;
					$worksheet1->write_number($linha_ini,$coluna,$valor_acrescimo,$fmt_valor);
				}
				$coluna++;

				if(($registro->Valor==''|| $registro->Valor==0)){
					$valor = ' ';
					$worksheet1->write_string($linha_ini,$coluna,$valor,$fmt_txt_r);
				}else{
					$valor = $registro->Valor;
					$worksheet1->write_number($linha_ini,$coluna,$valor,$fmt_valor);
				}               
				$coluna++;

				if(($registro->Valor_Liquido==''|| $registro->Valor_Liquido==0)){
					$valor_liquido = ' ';
					$worksheet1->write_string($linha_ini,$coluna,$valor_liquido,$fmt_txt_r);
				}else{
					$valor_liquido = $registro->Valor_Liquido;
					$worksheet1->write_number($linha_ini,$coluna,$valor_liquido,$fmt_valor);
				}
				$coluna++;               

				//$pdf->SetFillColor(255,255,255);
				//$fundo = 0;
				//if(($i%2)==0){
				//  $fundo = 1;
				//  $pdf->SetFillColor(220,220,220);
				//}               

				$linha++;

            }

            $vl_desconto_data+= $registro->Valor_Desconto;
            $vl_acrescimo_data+= $registro->Valor_Acrescimo;

            $vl_desconto_total+= $registro->Valor_Desconto;
            $vl_acrescimo_total+= $registro->Valor_Acrescimo;

            if($contar_total){
				$vl_valor_data+= $registro->Valor;
				$vl_valor_total_pag+= $registro->Valor;
            }
            $vl_pago_data+= $registro->Valor_Liquido;
            $vl_pago_total_pag+= $registro->Valor_Liquido;
        }

        if($id_data != ''){
            $coluna = 0;
            $linha_ini++;
            $formato = $fmt_txt_r;
            $formato_vl = $fmt_valor;
            if($tipo == 'A'){
				$formato = $fmt_txt_r_b;
				$formato_vl = $fmt_valor_b;
				for($ca=0;$ca<6;$ca++){
					$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
					$coluna++;
				}
				$coluna = 6;
            }

            $worksheet1->write_string($linha_ini,$coluna,'Total '.$txt_label.' Dia '.dataf($id_data),$formato);
            $coluna++;
   
            //$worksheet1->write_string($linha_ini,$coluna,to_money($vl_desconto_data, false),$formato);
            $worksheet1->write_number($linha_ini,$coluna,$vl_desconto_data,$formato_vl);
            $coluna++;
   
            //$worksheet1->write_string($linha_ini,$coluna,to_money($vl_acrescimo_data, false),$formato);
            $worksheet1->write_number($linha_ini,$coluna,$vl_acrescimo_data,$formato_vl);
            $coluna++;
   
            //$worksheet1->write_string($linha_ini,$coluna,to_money($vl_valor_data, false),$formato);
            $worksheet1->write_number($linha_ini,$coluna,$vl_valor_data,$formato_vl);
            $coluna++;
   
            //$worksheet1->write_string($linha_ini,$coluna,to_money($vl_pago_data, false),$formato);
            $worksheet1->write_number($linha_ini,$coluna,$vl_pago_data,$formato_vl);
            $coluna++;
   
            $linha++;
		}

		$coluna = 0;
		$linha_ini++;
		if($tipo == 'A'){            
			for($ca=0;$ca<6;$ca++){
				$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
				$coluna++;
			}
			$coluna = 6;
		}

		$worksheet1->write_string($linha_ini,$coluna,'Total '.$txt_label.' Perodo',$fmt_txt_r_b);
		$coluna++;

		//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_desconto_total, false),$fmt_txt_r_b);
		$worksheet1->write_number($linha_ini,$coluna,$vl_desconto_total,$fmt_valor_b);
		$coluna++;

		//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_acrescimo_total, false),$fmt_txt_r_b);
		$worksheet1->write_number($linha_ini,$coluna,$vl_acrescimo_total,$fmt_valor_b);
		$coluna++;
       
		//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_valor_total_pag, false),$fmt_txt_r_b);
		$worksheet1->write_number($linha_ini,$coluna,$vl_valor_total_pag,$fmt_valor_b);
		$coluna++;

		//$worksheet1->write_string($linha_ini,$coluna,to_money($vl_pago_total_pag, false),$fmt_txt_r_b);
		$worksheet1->write_number($linha_ini,$coluna,$vl_pago_total_pag,$fmt_valor_b);
		$coluna++;

		$linha++;

	}else{
		$worksheet1->write(7,0,"No existem registros para este filtro!",$fmt_aviso);
	}
	consulta_limpa($resultado);

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'INSERT INTO relatorio_tmp ( '.
			' Dominio, '.
			' Usuario, '.
			' Descricao ) VALUES ('.
			'"'.$_SESSION['Dominio'].'", '.
			'"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			'"")';
	consulta_sql($insert);

	$workbook->close();
	
}
?>