<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
	
if(session::usr_conectado($_REQUEST['USER_ID'])){

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	class PDF extends FPDF{
		var $TipoRel;

		function Header($tipo_cab='tudo'){
            if ($this->DefOrientation=='P'){
				$tamanho_total_linha = 190;
            }else{
				$tamanho_total_linha = 275;
            }
            $this->SetFillColor(255,255,255);
            $date=getdate();
            $hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
            $hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);

            $consulta_usuario = 'select Nome from usuario '.
                                ' where Dominio="'.$_SESSION["Dominio"].'"'.
                                ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"';
            $res = consulta_sql($consulta_usuario);
            $row = consulta_ler_linha($res);
            $nome_usuario = $row[0];
            consulta_limpa($res);

            $cons_emp = 'select Nome_Razao from pessoa '.
                        ' where Dominio="'.$_SESSION["Dominio"].'"'.
                        ' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'"';
            $res_emp = consulta_sql($cons_emp);
            $row_emp = consulta_ler_linha($res_emp);

            $nome_razao = $row_emp[0];
            consulta_limpa($res_emp);

            //Seleciona fonte Arial 8
            $this->SetFont('Arial','B',10);
            //Imprime Cabealho
            $this->Cell(1,  15, ' ', 0,0,'C');
            if($this->Logotipo){
				$h=60;
				$w=0;
				$x=28;
				$y=5;
				$logo=busca_imagem_empresa('logo_menu.jpg', '../../');
				if(file_exists($logo)){
					$logoInfo = getimagesize($logo);
					//largura da imagem em mm
					$logoWmm = ($logoInfo[0]/72)*25.4;
					//altura da imagem em mm
					$logoHmm = ($logoInfo[1]/72)*25.4;
					$nImgH = round($h/3, 0);
					$nImgW = round($logoWmm * ($nImgH/$logoHmm), 0);
					$xImg = round(($w-$nImgW)/2+$x, 0);
					$yImg = $y;
					$this->Image($logo, $xImg, $yImg, $nImgW, $nImgH);
				}
				$this->Cell(30, 15, " ", 0,0,'L');
            }else if ($tipo_cab=='tudo'){
				$this->Cell(30, 15, "Data: ".dataf($hoje), 0,0,'L');
            }else{
				$this->Cell(30, 15, " ", 0,0,'L');
            }
            $lns_cabecalho = $this->Lines_MultiCell(($tamanho_total_linha-60),5,$this->Cabecalho,1);
            $y=$this->y;
            $this->MultiCell(($tamanho_total_linha-60), (15/($lns_cabecalho*5)) * 5, $this->Cabecalho, 0,'C');
            $this->y=$y;

            if($this->Logotipo){

            }else if ($tipo_cab=='tudo'){
				$this->Cell(30, 15, "Hora: ".($hora), 0,0,'R');
            }

            $this->Cell(1,  15, ' ', 0,1,'C');

            //Seleciona fonte Arial 8
            $this->SetFont('Arial','',8);
            //Imprime Cabealho
            if ($tipo_cab=='tudo'){
				$this->Cell(1,  10, ' ', 0,0,'C');
				$this->Cell(($tamanho_total_linha/2), 10,$nome_razao, 0,0,'L'); //config_pad('sistema_licenca')
				$this->Cell(($tamanho_total_linha/2), 10, $nome_usuario, 0,0,'R');
				$this->Cell(1,  10, ' ', 0,1,'C');
            }

            if($this->Sub_Cabecalho_Texto!=''){

				$this->SetFont('Arial',$this->Sub_Cabecalho_Style,10);
				$lns_cabecalho = $this->Lines_MultiCell($tamanho_total_linha,5,$this->Sub_Cabecalho_Texto,$this->Sub_Cabecalho_Border);
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,0,'C');
				$y=$this->y;
				$this->MultiCell($tamanho_total_linha, 5 , $this->Sub_Cabecalho_Texto, $this->Sub_Cabecalho_Border,$this->Sub_Cabecalho_Align);
				$this->y=$y;
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,1,'C');
				$this->x=$this->lMargin;
				$this->y=$y+($lns_cabecalho*5);
				$this->SetAutoPageBreak(true,30);
				$this->SetFont('Arial','',8);

            }else if($this->CabecalhoGrid_Texto != ''){
				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->SetFont('Arial','B',8);

				foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');

				//quebra de pgina - cabecalho do item
				if(isset($this->CabecalhoGrid_Texto_Item)){
					$this->SetFont('Arial','B',6);
					foreach($this->CabecalhoGrid_Texto_Item as $key => $reg){
						$tamanho = $this->CabecalhoGrid_Tamanho_Item[$key];
						$tamanho = $tamanho/100;
						$tamanho = $tamanho_total_linha*$tamanho;
						$valor = $this->CabecalhoGrid_Texto_Item[$key];
						$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border_Item[$key],0,$this->CabecalhoGrid_Align_Item[$key]);
					}
					$this->Cell(1,  5, ' ', 0,1,'C');
				}
			}
			$this->SetFont('Arial','',8);
		}
	}

	$label = label_vendedor_ou_rep_comercial('S');
	$filtro = '';

	$empresa = $_REQUEST['empresa'];
	$cliente = $_REQUEST['pessoa'];

	$vendedor = $_REQUEST['vendedor'];
	$advogado = $_REQUEST['advogado'];
	$numero_processo = $_REQUEST['numero_processo'];
	$forum = $_REQUEST['forum'];
	$forum_uf = $_REQUEST['forum_uf'];
	$forum_cidade = $_REQUEST['forum_cidade'];
	$unidade = $_REQUEST['unidade'];

	$tipo_data = $_REQUEST['tipo_data'];
	$tipo_data_ini = $_REQUEST['tipo_data_ini'];
	$tipo_data_fim = $_REQUEST['tipo_data_fim'];

	$consulta = 'SELECT Nr_Doc, Modelo, Serie, Pessoa, Parcela, DT_Vencto, DH_Baixa, '.
                  ' Valor, Valor_Liquido, '.
                  ' Empresa, Vendedor, DH_Criacao, Nr_Contas, Seq, PRC, Nr_Nota, Cobranca_Para, '.
                  ' Numero_Processo, Forum, Unidade, Advogado FROM contas_pr '.
                  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                  ' AND TipoPR = "R" '.
                  ' AND (PRC = "J") AND (Situacao="A")'; // Em Cobrana
	if($empresa > 0){
		$consulta.= ' AND Empresa = "'.$empresa.'" ';

		$cons_empresa = 'select Nome_Listas from pessoa '.
					 ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' and Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);

		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	if($cliente > 0){
		$consulta.= ' AND Pessoa = "'.$cliente.'" ';

		$cons_cli = 'SELECT Nome_Listas FROM pessoa '.
				 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				 ' AND Pessoa = "'.$cliente.'"';
		$res_cli = consulta_sql($cons_cli);
		$reg_cli = consulta_ler_linha($res_cli);
		consulta_limpa($res_cli);

		$filtro.= ' Cliente: "'.$cliente.' - '.$reg_cli[0].'"';
	}

	if($vendedor != ''){
		$consulta.= ' and Vendedor = "'.$vendedor.'" ';

		$cons_fornec = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$vendedor.'"';
		$res_fornec = consulta_sql($cons_fornec);
		$reg_fornec = consulta_ler_linha($res_fornec);
		consulta_limpa($res_fornec);

		$label_emp = empresa_representante($vendedor, 'S');

		$filtro.= $label.': '.$label_emp;
	}

	if($tipo_data == "V"){
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
            $filtro.= ' Data de: "Vencimento":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' and (DT_Vencto >= "'.datad($tipo_data_ini).'" '.
							' and DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
            }else if($tipo_data_ini!=''){
				$consulta.= ' and (DT_Vencto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' and (DT_Vencto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}else if($tipo_data == "P"){
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
            $filtro.= ' Data de: "Pagamento":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' and (DT_Pagto >= "'.datad($tipo_data_ini).'" '.
                           ' and DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'" ';
            }else if($tipo_data_ini!=''){
				$consulta.= ' and (DT_Pagto >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' and (DT_Pagto <= "'.datad($tipo_data_fim).'") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}else{
		if(($tipo_data_ini!='')||($tipo_data_fim!='')){
            $filtro.= ' Data de: "Emisso":';
            if(($tipo_data_ini!='')&&($tipo_data_fim!='')){
				$consulta.= ' and (DH_Criacao >= "'.datad($tipo_data_ini).'" '.
                           ' and DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' De "'.$tipo_data_ini.'" At "'.$tipo_data_fim.'"';
            }else if($tipo_data_ini!=''){
				$consulta.= ' and (DH_Criacao >= "'.datad($tipo_data_ini).'") ';
				$filtro.= ' De "'.$tipo_data_ini.'"';
            }else if($tipo_data_fim!=''){
				$consulta.= ' and (DH_Criacao <= "'.datad($tipo_data_fim).' 23:59:59") ';
				$filtro.= ' At "'.$tipo_data_fim.'"';
            }
		}
	}

	if($advogado != ''){
		$consulta.= ' and Advogado = "'.$advogado.'" ';

		$cons_advog = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$advogado.'"';
		$res_advog = consulta_sql($cons_advog);
		$reg_advog = consulta_ler_linha($res_advog);
		consulta_limpa($res_advog);

		$filtro.= $advogado.' - '.$reg_advog[0];
	}

	if($numero_processo != ''){
		$consulta.= ' and Numero_Processo = "'.$numero_processo.'" ';
		$filtro.= ' Numero Processo: '.$numero_processo;
	}

	if($forum != ''){
		$consulta.= ' and Forum = "'.UpperDados($forum).'" ';
		$filtro.= ' Frum: '.UpperDados($forum);
	}

	if($forum_uf != ''){
		$consulta.= ' and Forum_UF = "'.$forum_uf.'" ';
		$filtro.= ' UF: '.$forum_uf;
	}

	if($forum_cidade != ''){
		$consulta.= ' and Forum_Codigo_Cidade = "'.$forum_cidade.'" ';

		$con_cidade = 'select Nome from cidade '.
			   ' where Dominio="'.$_SESSION['Dominio'].'"'.
			   ' and Codigo_Cidade = "'.$forum_cidade.'"';
		$res_cidade = consulta_sql($con_cidade);
		$reg_cidade = consulta_ler_linha($res_cidade);
		consulta_limpa($res_cidade);
		$filtro.= ' Cidade: '.$reg_cidade[0];
	}

	if($unidade != ''){
		$consulta.= ' and Unidade = "'.$unidade.'" ';

		$cons_unid = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$unidade.'"';
		$res_unid = consulta_sql($cons_unid);
		$reg_unid = consulta_ler_linha($res_unid);
		consulta_limpa($res_unid);

		$filtro.= ' Unidade: '.$unidade.' - '.$reg_unid[0];
	}

	$consulta.= ' ORDER BY Empresa, Pessoa, DT_Vencto, Nr_Doc, Serie, Modelo, Parcela, Seq';



	$pdf=new PDF();
	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio de Cobranas';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	$lista_geral = array();

	set_time_limit(60);
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	for($k=0;$k<$nrows;$k++){
		$registro = consulta_ler_objeto($resultado);

		$con_pessoa = 'SELECT Nome_Listas FROM pessoa '.
				   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' AND Pessoa = "'.$registro->Pessoa.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);

		$cons_advog = 'SELECT Nome_Listas FROM pessoa '.
				   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' AND Pessoa = "'.$registro->Advogado.'"';
		$res_advog = consulta_sql($cons_advog);
		$reg_advog = consulta_ler_linha($res_advog);
		consulta_limpa($res_advog);

		$cons_unid = 'SELECT Nome_Listas FROM pessoa '.
                      ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                      ' AND Pessoa = "'.$registro->Unidade.'"';
		$res_unid = consulta_sql($cons_unid);
		$reg_unid = consulta_ler_linha($res_unid);
		consulta_limpa($res_unid);

		$processo = $registro->Numero_Processo.'-'.$registro->Pessoa;


		if (!(isset($lista_geral[$processo]))){
            $lista_geral[$processo]['Pessoa'] = $registro->Pessoa;
            $lista_geral[$processo]['Nome_Listas'] = $reg_pessoa[0];
            $lista_geral[$processo]['Advogado'] = $registro->Advogado;
            $lista_geral[$processo]['Advogado_Descricao'] = $reg_advog[0];
            $lista_geral[$processo]['Numero_Processo'] = $registro->Numero_Processo;
            if ($lista_geral[$processo]['Numero_Processo']==''){
				$lista_geral[$processo]['Numero_Processo'] = 'No Informado';
            }
            $lista_geral[$processo]['Forum'] = $registro->Forum;
            $lista_geral[$processo]['Unidade'] = $registro->Unidade;
            $lista_geral[$processo]['Unidade_Descricao'] = $reg_unid[0];
            $lista_geral[$processo]['Observacao'] = $registro->Cobranca_Para;
            $lista_geral[$processo]['TotalF'] = 0;
            $lista_geral[$processo]['TotalC'] = 0;
            $lista_geral[$processo]['faturas'] = array();
            $lista_geral[$processo]['custas'] = array();
        }
        if ($reg_advog[0]!=''){
            $lista_geral[$processo]['Advogado'] = $registro->Advogado;
            $lista_geral[$processo]['Advogado_Descricao'] = $reg_advog[0];
        }
        if ($registro->Forum!=''){
            $lista_geral[$processo]['Forum'] = $registro->Forum;
        }
        if ($reg_unid[0]!=''){
            $lista_geral[$processo]['Unidade'] = $registro->Unidade;
            $lista_geral[$processo]['Unidade_Descricao'] = $reg_unid[0];
        }
        if ($registro->Cobranca_Para!=''){
            $lista_geral[$processo]['Observacao'] = $registro->Cobranca_Para;
        }
        $lista_geral[$processo]['faturas'][$k]['Valor']     = $registro->Valor;
        $lista_geral[$processo]['faturas'][$k]['Nr_Doc']    = $registro->Nr_Doc;
        $lista_geral[$processo]['faturas'][$k]['Parcela']   = $registro->Parcela;
        $lista_geral[$processo]['faturas'][$k]['Seq']       = $registro->Seq;
        $lista_geral[$processo]['faturas'][$k]['DT_Vencto'] = $registro->DT_Vencto;
        $lista_geral[$processo]['faturas'][$k]['Serie']     = $registro->Serie;
        $lista_geral[$processo]['faturas'][$k]['Modelo']    = $registro->Modelo;

        $lista_geral[$processo]['TotalF']+= $registro->Valor;


        //$reg_movto->Nr_Doc.'/'.$reg_movto->Serie.'-'.$reg_movto->Modelo;

        $custas = $lista_geral[$processo]['custas'];
        $con_custas = 'SELECT Empresa, Nr_Contas, Seq, Seq_Custas, Descricao, Valor, Usuario, Situacao, DH_Custas FROM contas_pr_custas '.
                       ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                       ' AND Empresa = "'.$registro->Empresa.'"'.
                       ' AND Nr_Contas = "'.$registro->Nr_Contas.'"'.
                       ' AND Seq = "'.$registro->Seq.'"'.
                       ' AND (Situacao = "A") '.
                       ' ORDER BY DH_Custas ASC';
        $res_custas = consulta_sql($con_custas);
        $nrw_custas = consulta_num_registros($res_custas);
        for($c=0;$c<$nrw_custas;$c++){
            $reg_custas = consulta_ler_objeto($res_custas);

            $custas[$k.'-'.$c]['Empresa'] = $reg_custas->Empresa;
            $custas[$k.'-'.$c]['Nr_Contas'] = $reg_custas->Nr_Contas;
            $custas[$k.'-'.$c]['Seq'] = $reg_custas->Seq;
            $custas[$k.'-'.$c]['Seq_Custas'] = $reg_custas->Seq_Custas;
            $custas[$k.'-'.$c]['Descricao'] = $reg_custas->Descricao;
            $custas[$k.'-'.$c]['Valor'] = $reg_custas->Valor;
            $custas[$k.'-'.$c]['DH_Custas'] = $reg_custas->DH_Custas;
            
            $lista_geral[$processo]['TotalC']+=$reg_custas->Valor;
        }

        $lista_geral[$processo]['custas'] = $custas;
    }

    //var_dump2($lista_geral);

    if(!empty($lista_geral)){
        $k=0;
		
        $pdf->CabecalhoGrid_Texto[$k] = 'Fatura';
        $pdf->CabecalhoGrid_Tamanho[$k] = '25';
        $pdf->CabecalhoGrid_Align[$k] = 'L';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;
         
        $pdf->CabecalhoGrid_Texto[$k] = 'Parc.';
        $pdf->CabecalhoGrid_Tamanho[$k] = '5';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Dt Venc';
        $pdf->CabecalhoGrid_Tamanho[$k] = '10';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Valor';
        $pdf->CabecalhoGrid_Tamanho[$k] = '20';
        $pdf->CabecalhoGrid_Align[$k] = 'R';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;
         
        $pdf->CabecalhoGrid_Texto[$k] = '';
        $pdf->CabecalhoGrid_Tamanho[$k] = '40';
        $pdf->CabecalhoGrid_Align[$k] = 'L';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $ncampos = 5;
        $lns = 5;
         
        $larg = 190;

        $pdf->AddPage();
        $pdf->SetFont('Arial','',8);

        $lista_empresas = lista_empresas();
         
        foreach($lista_geral as $chave => $registro){

            $lns = 5;
            $pdf->SetFont('Arial','',7);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',7);

            $pdf->SetFillColor(225,225,225);

            $valor  = $registro['Pessoa'].'-'.$registro['Nome_Listas'];
            $lns_linhaG = $pdf->Lines_MultiCell((60/100)*190,$lns,$valor,'T');
            while($lns_linhaG>1){
				$valor = substr($valor,0,strlen($valor)-1);
				$lns_linhaG = $pdf->Lines_MultiCell((60/100)*190,$lns,$valor,'T');
            }
            $y=$pdf->y;
            $pdf->MultiCell((60/100)*$larg, 5, $valor, 'T','L', 1);
            $pdf->y=$y;
            
            $valor  = 'Nr Processo: '.$registro['Numero_Processo'];
            $lns_linhaG = $pdf->Lines_MultiCell((40/100)*190,$lns,$valor,'T');
            while($lns_linhaG>1){
				$valor = substr($valor,0,strlen($valor)-1);
				$lns_linhaG = $pdf->Lines_MultiCell((40/100)*190,$lns,$valor,'T');
            }
            $y=$pdf->y;
            $pdf->MultiCell((40/100)*$larg, 5, $valor, 'T','L', 1);
            $pdf->y=$y;
            
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);
            
            
			$observacao = '';
			if ($registro['Observacao']!=''){
				$observacao = 'Obs: '.$registro['Observacao'];
			}
			if($registro['Advogado'] > 0){
				if ($observacao!=''){
					$observacao.= ' - ';
				}
				$observacao.= 'Advogado: '.$registro['Advogado'].' - '.$registro['Advogado_Descricao'];
			}
			if($registro['Forum'] != ''){
				if ($observacao!=''){
					$observacao.= ' - ';
				}
				$observacao.= 'Frum: '.$registro['Forum'];
			}
			if($registro['Unidade'] > 0){
				if ($observacao!=''){
					$observacao.= ' - ';
				}
				$observacao.= 'Unidade: '.$registro['Unidade'].' - '.$registro['Unidade_Descricao'];
			}

			if ($observacao!=''){
				$lns = 5;
				$pdf->SetFont('Arial','',7);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',7);
				
				$pdf->SetFillColor(225,225,225);
				
				$lns_linhaG = $pdf->Lines_MultiCell((100/100)*190,$lns,$observacao,0);

				$y=$pdf->y;
				$pdf->MultiCell((100/100)*$larg, 5, $observacao, 0,'L', 1);
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+($lns*$lns_linhaG);
				$pdf->SetAutoPageBreak(true,30);
			}
                 
			$fats = $registro['faturas'];
			foreach($fats as $chaveF => $faturas){

				$lns = 5;
				$larg = 190;
				$pdf->SetFont('Arial','',7);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',7);
				$k =0;
				
				$lns_linha = array();
				
				$lns = 0;

				$rowarr[$k] = $faturas['Nr_Doc'].'/'.$faturas['Serie'].'-'.$faturas['Modelo'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$rowarr[$k] = $faturas['Parcela'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;
				
				$rowarr[$k] = dataf($faturas['DT_Vencto']);
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;
				
				$rowarr[$k] = to_money($faturas['Valor'],false);
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;
				
				$rowarr[$k] = '';
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$lns = $lns * 5;
				$pdf->SetFillColor(255,255,255);
				for($k=0;$k<$ncampos;$k++){
					$valor = $vl_linha[$k];
					$y=$pdf->y;
					$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 5)) * 5, $valor, 0,$pdf->CabecalhoGrid_Align[$k], 1);
					$pdf->y=$y;
				}

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$lns = 5;
				//$lns = $lns * 3;
				$larg = 190;
			}

			$lns = 5;
			$larg = 190;
			$pdf->SetFont('Arial','',7);
			$pdf->Cell(1,      $lns, '', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','B',7);
			$k =0;

			$lns_linha = array();

			$lns = 0;

			$rowarr[$k] = 'TOTAL DO PROCESSO';
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = '';
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = '';
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = to_money($registro['TotalF'], false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = '';
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$lns = $lns * 5;
			$pdf->SetFillColor(255,255,255);
			for($k=0;$k<$ncampos;$k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 5)) * 5, $valor, 0,$pdf->CabecalhoGrid_Align[$k], 1);
				$pdf->y=$y;
			}

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);

			$lns = 5;
			//$lns = $lns * 3;
			$larg = 190;
	 


            $totalC = to_money($registro['TotalC'], false);
            $custas = $registro['custas'];
            $nc=0;
            foreach($custas as $custa){
				$m = 0;
				$lns = 0;
				$larg = 190;

				$nc++;
				if ($nc==1){
					$pdf->SetFont('Arial','',8);
					$pdf->Cell(1,      $lns, ' ', 0,0,'C');
					$pdf->SetAutoPageBreak(false,30);
					$pdf->SetFont('Arial','BI',8);

					$valor = 'Custas do Processo';
					$y=$pdf->y;
					$pdf->MultiCell((25/100)*$larg, 3, $valor, 0,'L');
					$pdf->y=$y;

					$valor = 'Data';
					$y=$pdf->y;
					$pdf->MultiCell((15/100)*$larg, 3, $valor, 0,'C');
					$pdf->y=$y;

					$valor = 'Valor';
					$y=$pdf->y;
					$pdf->MultiCell((15/100)*$larg, 3, $valor, 0,'R');
					$pdf->y=$y;

					$valor = 'Descrio';
					$y=$pdf->y;
					$pdf->MultiCell((45/100)*$larg, 3, $valor, 0,'L');
					$pdf->y=$y;
                   
					$pdf->Cell(1,      $lns, ' ', 0,1,'C');
					//Prxima Linha
					$pdf->x=$pdf->lMargin;
					$pdf->y=$y+3;
					$pdf->SetAutoPageBreak(true,30);                   
				}

               
				$lns = 3;
				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				$valor = $totalC;
				if ($nc==1){
					$totalC = '';
				}
				$y=$pdf->y;
				$pdf->MultiCell((25/100)*$larg, 3, $valor, 0,'C');
				$pdf->y=$y;

				$valor = dataf($custa['DH_Custas']);
				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, 3, $valor, 0,'C');
				$pdf->y=$y;

				$valor = to_money($custa['Valor'], false);
				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, 3, $valor, 0,'R');
				$pdf->y=$y;

				$valor = $custa['Descricao'];
				$lns_linha = $pdf->Lines_MultiCell((45/100)*190,$lns,$valor,0);
				while($lns_linha>1){
					$valor = substr($valor,0,strlen($valor)-1);
					$lns_linha = $pdf->Lines_MultiCell((45/100)*190,$lns,$valor,0);
				}
				$y=$pdf->y;
				$pdf->MultiCell((45/100)*$larg, 3, $valor, 0,'L');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+3;
				$pdf->SetAutoPageBreak(true,30);
               


			}
		}
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	consulta_limpa($resultado);

	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>