<?php
	/* error_reporting(E_ALL);
	ini_set('display_errors', true);
	ini_set('display_startup_errors', true); */

	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	session::usr_conectado($_REQUEST['USER_ID']);

	$dominios = array();
	$empresa = $_SESSION['Empresa_Codigo'];

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename){
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$filtro = '';

	$empresa = $_REQUEST['empresa'];
	$vendedor = $_REQUEST['vendedor'];
	$anoApartir = $_REQUEST['ano'];
	$tipoEmissao = $_REQUEST['tipo_emissao'];

	$label = label_vendedor_ou_rep_comercial('S');

	$anoAtual = date('Y');

	$listaAnos = range($anoApartir, $anoAtual);

	// Adiciona o ano "0" no comeo do array
	array_unshift($listaAnos, 0);
	// Ordena a lista de anos (s pra garantir)
	sort($listaAnos);

	$listaRel = array();
	$listaRelDet = array();

	$listaEmpresas = lista_empresas();

	$consulta = 'SELECT Empresa, Pessoa, Valor, DT_Vencto, Vendedor, Nr_Doc, Serie, Modelo, Parcela, DH_Criacao, '.
			   ' Valor_Liquido, Observacao, UsuarioCriacao, Forma_Pagto_Contas, Tipo_Docto, PRC '.
			   ' FROM contas_pr '.
			   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" ';
	if($empresa > 0){
		$consulta.= ' AND Empresa = "'.$empresa.'" ';

		$conEmpresa = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Pessoa = "'.$empresa.'"';
		$resEmpresa = consulta_sql($conEmpresa);
		$regEmpresa = consulta_ler_linha($resEmpresa);
		consulta_limpa($resEmpresa);

		$filtro.= 'Empresa: "'.$regEmpresa[0].'" ';
	}

	$consulta.= ' AND TipoPR = "R"'.
			   ' AND Situacao = "A" '.
			   ' AND DT_Vencto < "'.data_atual('date').'" '.
			   ' AND PRC <> "S"';
	if($vendedor != ''){
		$consulta.= ' AND Vendedor = "'.$vendedor.'" ';
		$label_emp = empresa_representante($vendedor, 'S');
		$filtro.= ' '.$label.': "'.$label_emp.'"';
	}

	$filtro.= ' Ano: "'.$anoApartir.'"';

	if($tipoEmissao != ''){
		if($tipoEmissao == 'P'){
			$filtro.= ' Cereais: "Somente Cereais"';
			$consulta.= ' AND Nr_Boletim_Pesagem <> 0 ';
		}else{
			$filtro.= ' Cereais: "Somente No Cereais"';
			$consulta.= ' AND Nr_Boletim_Pesagem = 0 ';
		}
	}

	$consulta.= ' ORDER BY Empresa, Vendedor, DT_Vencto';
	$resultado = consulta_sql($consulta);

	$d = 0;
	while($registro = consulta_ler_objeto($resultado)){
		$chaveEmpresa = $registro->Empresa;
		$chaveVendedor = $registro->Vendedor;
		$valor = $registro->Valor;

		$anoVencimento = substr($registro->DT_Vencto, 0, 4);

		if(!isset($listaRel[$chaveEmpresa])){
			$listaRel[$chaveEmpresa]['Empresa'] = $registro->Empresa;
			$listaRel[$chaveEmpresa]['Empresa_Nome'] = nome_empresa($listaEmpresas, $registro->Empresa);
			$listaRel[$chaveEmpresa]['Vendedores'] = array();
		}

		// Armazena em uma varivel temporria os vendedores da filial
		$listaVendedoresEmpresa = $listaRel[$chaveEmpresa]['Vendedores'];

		if(!isset($listaVendedoresEmpresa[$chaveVendedor])){
			$nomeVendedor = 'Sem Vendedor';

			if($registro->Vendedor > 0){
				$conVendedor = 'SELECT Nome_Listas FROM pessoa '.
							   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							   ' AND Pessoa = "'.$registro->Vendedor.'"';
				$resVendedor = consulta_sql($conVendedor);
				$regVendedor = consulta_ler_linha($resVendedor);
				consulta_limpa($resVendedor);

				if(isset($regVendedor)){
					$nomeVendedor = $regVendedor[0];
				}
			}

			$listaVendedoresEmpresa[$chaveVendedor]['Vendedor'] = $registro->Vendedor;
			$listaVendedoresEmpresa[$chaveVendedor]['Vendedor_Nome'] = $nomeVendedor;
			$listaVendedoresEmpresa[$chaveVendedor]['Anos'] = array();

			// Ano "0" recebe os anos anteriores ao filtro "a partir de"
			foreach($listaAnos as $ano){
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][$ano]['Ano'] = $ano;
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][$ano]['Total'] = 0;
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][$ano]['Total_PRC'] = 0;
			}
		}

		$emCobranca = ($registro->PRC == 'J');

		// Aloca no ano do vencimento
		if($anoVencimento >= $anoApartir){
			if($emCobranca){
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][$anoVencimento]['Total_PRC']+= $valor;
			}else{
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][$anoVencimento]['Total']+= $valor;
			}
		}else{ // Aloca no ano genrico
			if($emCobranca){
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][0]['Total_PRC']+= $valor;
			}else{
				$listaVendedoresEmpresa[$chaveVendedor]['Anos'][0]['Total']+= $valor;
			}
		}

		// Devolve pra varivel principal
		$listaRel[$chaveEmpresa]['Vendedores'] = $listaVendedoresEmpresa;

		// ---------------------------------------------------
		// Detalhamento
		// ---------------------------------------------------

		$obs = $registro->Observacao;
		if($registro->Forma_Pagto_Contas > 0){
			$con_pgto = 'SELECT Descricao FROM forma_pagto_contas '.
					 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Codigo_Pagto = "'.$registro->Forma_Pagto_Contas.'"';
			$res_pgto = consulta_sql($con_pgto);
			$reg_pgto = consulta_ler_linha($res_pgto);
			consulta_limpa($res_pgto);

			if($obs != ''){
				$obs.= ' Forma Pagto: '.$reg_pgto[0];
			}else{
				$obs = 'Forma Pagto: '.$reg_pgto[0];
			}
		}

		$dataDigitacao = dataf($registro->DH_Criacao);
		$dataVencimento = dataf($registro->DT_Vencto);

		$vendedorNome = '';
		if($registro->Vendedor > 0){
			$label_emp = empresa_representante($registro->Vendedor, 'S');
			$vendedorNome = $label_emp;
		}

		$valor = 0;
		if($registro->Valor > 0){
			$valor = $registro->Valor;
		}

		$valorPago = 0;
		if($registro->Valor_Liquido > 0){
			$valorPago = $registro->Valor_Liquido;
		}

		$conPessoa = 'SELECT Nome_Listas, CPF_CNPJ FROM pessoa  '.
			   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
			   ' AND Pessoa = "'.$registro->Pessoa.'"';
		$resPessoa = consulta_sql($conPessoa);
		$regPessoa = consulta_ler_linha($resPessoa);
		consulta_limpa($resPessoa);

		$pessoaNome = '';
		$pessoaCpfCnpj = '';
		if(isset($regPessoa)){
			$pessoaNome = $regPessoa[0];
			$pessoaCpfCnpj = $regPessoa[1];
		}

		$listaRelDet[$d]['Tipo_Docto'] = $registro->Tipo_Docto;
		$listaRelDet[$d]['Nr_Fatura'] = $registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo;
		$listaRelDet[$d]['Parcela'] = $registro->Parcela;
		$listaRelDet[$d]['Pessoa'] = $registro->Pessoa;
		$listaRelDet[$d]['Pessoa_Nome'] = $pessoaNome;
		$listaRelDet[$d]['Cliente'] = '';
		$listaRelDet[$d]['DH_Criacao'] = $dataDigitacao;
		$listaRelDet[$d]['DT_Vencto'] = $dataVencimento;
		$listaRelDet[$d]['Empresa_Nome'] = nome_empresa($listaEmpresas, $registro->Empresa);
		$listaRelDet[$d]['Vendedor_Nome'] = $vendedorNome;
		$listaRelDet[$d]['Valor'] = $valor;
		$listaRelDet[$d]['Valor_Liquido'] = $valorPago;
		$listaRelDet[$d]['CPF_CNPJ'] = $pessoaCpfCnpj;
		$listaRelDet[$d]['Observacao'] = $obs;
		$listaRelDet[$d]['UsuarioCriacao'] = $registro->UsuarioCriacao;

		$d++;
	}
	consulta_limpa($resultado);

	//var_dump2($listaRel);
	//exit;

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('CONTASREC_INADIMPLENCIA.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'RESUMO';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE INADIMPLNCIA',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$worksheet1->write(7,0,"Filtro: ".$filtro);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	// Format for the headings
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco_b =& $workbook->add_format();
	$formatotpreco_b->set_border(1);
	$formatotpreco_b->set_align('right');
	$formatotpreco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$formatotpreco_b->set_bold(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	// Format for the headings
	$formatot_blank =& $workbook->add_format();
	$formatot_blank->set_border(0);
	$formatot_blank->set_align('left');

	if(!empty($listaRel)){
		$listaRel = array_orderby($listaRel, 'Empresa_Nome', SORT_ASC);

		$linha_ini = 9;

		$linhaFinalResumo = 1;

		// FOR para reutilizar o cdigo que monta as tabelas por filiais
		for($k=1;$k<=2;$k++){
			$tabResumo = ($k == 1);
			$tabEmCobranca = ($k == 2);

			if($tabEmCobranca){
				$titulo_sheet = 'EM COBRANA';
				$worksheet1 =& $workbook->add_worksheet($titulo_sheet);
				$worksheet1->write_string(0, 0, $titulo_sheet, $formatot);
				$linha_ini = 2;
			}

			$listaFormula = array();

			foreach($listaRel as $registro){
				$coluna = 0;
				$worksheet1->set_column($coluna,$coluna, 50);
				$worksheet1->write_string($linha_ini, $coluna, $registro['Empresa_Nome'], $formatott);
				$coluna++;

				foreach($listaAnos as $ano){
					$texto = $ano;
					// Ano genrico
					if($ano == 0){
						$texto = '< '.$anoApartir;
					}
					$worksheet1->set_column($coluna,$coluna, 20);
					$worksheet1->write_string($linha_ini, $coluna, $texto, $formatott);
					$coluna++;
				}

				$worksheet1->set_column($coluna,$coluna, 20);
				$worksheet1->write_string($linha_ini, $coluna, 'Total', $formatott);
				$coluna++;

				$linha_ini++;
				$linhaInicioFormula = ($linha_ini + 1);

				$registro['Vendedores'] = array_orderby($registro['Vendedores'], 'Vendedor_Nome', SORT_ASC);

				foreach($registro['Vendedores'] as $registroVendedor){
					$coluna = 0;

					$worksheet1->write_string($linha_ini, $coluna, $registroVendedor['Vendedor_Nome'], $formatotlb);
					$coluna++;

					foreach($registroVendedor['Anos'] as $registroVendedorAno){
						$total = $registroVendedorAno['Total'];
						if($tabEmCobranca){
							$total = $registroVendedorAno['Total_PRC'];
						}
						$worksheet1->write_number($linha_ini, $coluna, $total, $formatotpreco);
						$coluna++;
					}

					$worksheet1->write_formula($linha_ini,$coluna,'=SUM(B'.($linha_ini + 1).':'.letra_coluna2($coluna).($linha_ini + 1).')',$formatotpreco);
					$coluna++;

					$linha_ini++;
				}

				$coluna = 0;

				$worksheet1->write_string($linha_ini, $coluna, 'TOTAL', $formatotlb);
				$coluna++;

				foreach($listaAnos as $ano){
					$listaFormula[$ano][] = letra_coluna2($coluna + 1).($linha_ini + 1);
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM('.letra_coluna2($coluna + 1).($linhaInicioFormula).':'.letra_coluna2($coluna + 1).($linha_ini).')',$formatotpreco_b);
					$coluna++;
				}

				$listaFormula['TOTAL'][] = letra_coluna2($coluna + 1).($linha_ini + 1);

				$worksheet1->write_formula($linha_ini,$coluna,'=SUM('.letra_coluna2($coluna + 1).($linhaInicioFormula).':'.letra_coluna2($coluna + 1).($linha_ini).')',$formatotpreco_b);
				$coluna++;

				$linha_ini++;
				$linha_ini++;
			}

			// ----------------------------------------
			// Totais das abas "Resumo" e "Em Cobrana"
			// ----------------------------------------

			$linha_ini++;

			$linha_ini_total = $linha_ini;

			$coluna = 0;

			$worksheet1->write_string($linha_ini, $coluna, 'TOTAL', $formatott);
			$coluna++;

			foreach($listaAnos as $ano){
				// Voltar linha
				$linha_ini = $linha_ini_total;

				$texto = $ano;

				// Ano genrico
				if($ano == 0){
					$texto = '< '.$anoApartir;
				}

				$worksheet1->write_string($linha_ini, $coluna, $texto, $formatott);

				// Pular linha
				$linha_ini++;

				$formula = '';
				if(isset($listaFormula[$ano])){
					$formula = implode('+', $listaFormula[$ano]);
				}

				$worksheet1->write_formula($linha_ini, $coluna, $formula, $formatotpreco_b);
				$coluna++;
			}

			$linha_ini = $linha_ini_total;

			$worksheet1->write_string($linha_ini, $coluna, 'TOTAL', $formatott);
			$linha_ini++;

			$formula = '';
			if(isset($listaFormula['TOTAL'])){
				$formula = implode('+', $listaFormula['TOTAL']);
			}

			$worksheet1->write_formula($linha_ini, $coluna, $formula, $formatotpreco_b);
			$coluna++;
		}

		// -----------------------
		// Aba Detalhamento
		// -----------------------

		$titulo_sheet = 'DETALHAMENTO';
		$worksheet1 =& $workbook->add_worksheet($titulo_sheet);
		$worksheet1->write_string(0, 0, $titulo_sheet, $formatot);

		$linha_ini = 2;
		$coluna = 0;

		$worksheet1->set_column($coluna, $coluna, 3);
		$worksheet1->write_string($linha_ini, $coluna, '', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 12);
		$worksheet1->write_string($linha_ini, $coluna, 'NrFatura', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 5);
		$worksheet1->write_string($linha_ini, $coluna, 'Par', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 40);
		$worksheet1->write_string($linha_ini, $coluna, 'Cliente', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 12);
		$worksheet1->write_string($linha_ini, $coluna, 'Dt Digit', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 12);
		$worksheet1->write_string($linha_ini, $coluna, 'Dt Venc', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 16);
		$worksheet1->write_string($linha_ini, $coluna, 'Empresa', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 40);
		$worksheet1->write_string($linha_ini, $coluna, $label, $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 18);
		$worksheet1->write_string($linha_ini, $coluna, 'Valor', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 16);
		$worksheet1->write_string($linha_ini, $coluna, 'Valor Pago', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 40);
		$worksheet1->write_string($linha_ini, $coluna, 'Observaao', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 18);
		$worksheet1->write_string($linha_ini, $coluna, 'CPF/CNPJ', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna, $coluna, 18);
		$worksheet1->write_string($linha_ini, $coluna, 'Usuario Criao', $formatott);
		$coluna++;

		$linha_ini++;

		foreach($listaRelDet as $registroDet){
			$coluna = 0;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Tipo_Docto'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Nr_Fatura'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Parcela'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Pessoa'].' - '.$registroDet['Pessoa_Nome'], $formatotl);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['DH_Criacao'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['DT_Vencto'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Empresa_Nome'], $formatotl);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Vendedor_Nome'], $formatotl);
			$coluna++;

			$worksheet1->write_number($linha_ini, $coluna, $registroDet['Valor'], $formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini, $coluna, $registroDet['Valor_Liquido'], $formatotpreco);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['Observacao'], $formatotl);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['CPF_CNPJ'], $formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini, $coluna, $registroDet['UsuarioCriacao'], $formatotc);
			$coluna++;

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"Nao existem registros para este filtro!");
	}

    //ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
    $insert = 'insert into relatorio_tmp ( '.
              ' Dominio, '.
              ' Usuario, '.
              ' Descricao ) values ('.
              '"'.$_SESSION['Dominio'].'", '.
              '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
              '"")';
    consulta_sql($insert);

    $workbook->close();
?>