<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');

if(session::usr_conectado($_REQUEST['USER_ID'])){

	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$empresa = $_REQUEST['empresa'];
	$usuario = $_REQUEST['usuario'];

	$filtro = '';
	$lista_geral = array();
	$lista_usuarios = array();

	$consulta = 'SELECT Caixa_Empresa, Nr_Lote_Baixa, Caixa_DT, MIN(Caixa_Seq_Baixa) as Caixa_Seq_Baixa, '.
                  ' SUM(Valor_Liquido) as Valor_Liquido_Soma, Pessoa, Modelo, Nr_Boletim_Pesagem FROM contas_pr '.
                  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                  ' AND TipoPR = "R" '.
                  ' AND Situacao = "F" '.
                  ' AND Nr_Lote_Baixa > 0 ';
	if(($dt_ini != '') && ($dt_fim != '')){
		$consulta.= 'AND ((Caixa_DT >= "'.datad($dt_ini).'") '.
					'AND (Caixa_DT <= "'.datad($dt_fim).'")) ';

		$filtro.= 'Perodo: De "'.$dt_ini.'"'.
					' At "'.$dt_fim.'"';
	}

	if($empresa != ''){
		$consulta.= ' AND Caixa_Empresa = "'.$empresa.'" ';

		$con_empresa = 'SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);

		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	$consulta.= ' GROUP BY Nr_Lote_Baixa, Caixa_Empresa ';
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	for($t=0;$t<$nrows;$t++){
        $registro = consulta_ler_objeto($resultado);
        $ok = true;
        $con_usuario = 'SELECT Usuario FROM caixa_movto '.
                        ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                        ' AND Empresa = "'.$registro->Caixa_Empresa.'"'.
                        ' AND DT_Caixa = "'.$registro->Caixa_DT.'"'.
                        ' AND Seq_Mov = "'.$registro->Caixa_Seq_Baixa.'"';
        $res_usuario = consulta_sql($con_usuario);
        $reg_usuario = consulta_ler_linha($res_usuario);
        $usuario_quitacao = $reg_usuario[0];

        if(($usuario != '') && ($usuario != $usuario_quitacao)){
            $ok = false;
        }

        if($ok){
            $recibo = $registro->Caixa_Empresa.'_'.str_replace('/','', dataf($registro->Caixa_DT)).'_'.$registro->Caixa_Seq_Baixa;
            
            $con_cli = 'SELECT Nome_Listas FROM pessoa '.
                       ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                       ' AND Pessoa = "'.$registro->Pessoa.'"';
            $res_cli = consulta_sql($con_cli);
            $reg_cli = consulta_ler_linha($res_cli);
            consulta_limpa($res_cli);
            
            $lista_geral[$recibo]['Recibo'] = $recibo;
            $lista_geral[$recibo]['Data'] = $registro->Caixa_DT;
            $lista_geral[$recibo]['Cliente'] = $registro->Pessoa.' - '.$reg_cli[0];
            $lista_geral[$recibo]['Caixa'] = $registro->Caixa_Seq_Baixa;
            $lista_geral[$recibo]['Filial'] = $registro->Caixa_Empresa;
            $lista_geral[$recibo]['Valor'] = $registro->Valor_Liquido_Soma;
            $lista_geral[$recibo]['Usuario'] = $usuario_quitacao;
            if (!isset($lista_usuarios[$usuario_quitacao])){
				$lista_usuarios[$usuario_quitacao]['Usuario']=$usuario_quitacao;
				$lista_usuarios[$usuario_quitacao]['Valor']=0;

				$lista_usuarios[$usuario_quitacao]['I']=0;
				$lista_usuarios[$usuario_quitacao]['C']=0;
				$lista_usuarios[$usuario_quitacao]['S']=0;
            }
            $tipo='I';
            if ($registro->Nr_Boletim_Pesagem!=0){
				$tipo='C';
            }else if ($registro->Modelo=='98'){
				$tipo='S';
            }
            $lista_usuarios[$usuario_quitacao]['Valor']+=$registro->Valor_Liquido_Soma;
            $lista_usuarios[$usuario_quitacao][$tipo]+=$registro->Valor_Liquido_Soma;
		}
	} //fim for
	consulta_limpa($resultado);

	//var_dump2($lista_geral);

	/* $consulta = 'select ad.Empresa, ad.Valor, ad.Resumo_Tipo '.
	  ' from contas_ad ad '.
	  ' where ad.Dominio = "'.$_SESSION['Dominio'].'"'.
	  ' and ad.Situacao <> "E"'.
	  ' and ad.Situacao = "A"';

	//if(($dt_ini!='')&&($dt_fim!='')){
	//   $consulta.= ' and ((ad.DT_Criacao >= "'.datad($dt_ini).'")'.
	//              ' and (ad.DT_Criacao <= "'.datad($dt_fim).'"))';
	//}

	if($cliente!=''){
	$consulta.= ' and ad.Pessoa = "'.$cliente.'"';
	}


	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	for($ad=0;$ad<$nrows;$ad++){
	$registro = consulta_ler_objeto($resultado);

	$codigo = $registro->Empresa;
	$sub_chave = $registro->Resumo_Tipo;
	if(($sub_chave!='C')&&($sub_chave!='S')){
	$sub_chave = 'I';
	}

	if(!(isset($lista_geral[$codigo]))){
	$lista_geral[$codigo]['Todos_Receber'] = 0;
	$lista_geral[$codigo]['Servico_Receber'] = 0;
	$lista_geral[$codigo]['Cereais_Receber'] = 0;
	$lista_geral[$codigo]['Insumos_Receber'] = 0;

	$lista_geral[$codigo]['Todos_Recebidos'] = 0;
	$lista_geral[$codigo]['Servico_Recebidos'] = 0;
	$lista_geral[$codigo]['Cereais_Recebidos'] = 0;
	$lista_geral[$codigo]['Insumos_Recebidos'] = 0;

	$lista_geral[$codigo]['T'] = 0;
	$lista_geral[$codigo][$sub_chave] = 0;
	}
	$lista_geral[$codigo]['T']+= $registro->Valor;
	$lista_geral[$codigo][$sub_chave]+= $registro->Valor;
	}
	consulta_limpa($resultado); */

	$pdf=new FPDF();
	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio de Recibos';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';

	set_time_limit(60);

	if(!empty($lista_geral)){
		$lns = 0;
		$k=0;
		$pdf->CabecalhoGrid_Texto[$k] = 'Recibo';
		$pdf->CabecalhoGrid_Tamanho[$k] = '14';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;         

		$pdf->CabecalhoGrid_Texto[$k] = 'Data';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
		$pdf->CabecalhoGrid_Tamanho[$k] = '50';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Valor';
		$pdf->CabecalhoGrid_Tamanho[$k] = '14';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Usurio';
		$pdf->CabecalhoGrid_Tamanho[$k] = '12';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos = 5;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$lns = 5;
		$larg = 190;

		$total_recibos = 0;
		$total_valor = 0;

		foreach($lista_geral as $chave => $valor){
            $lns = 0;
            $k = 0;
            
            $total_recibos++;
            $total_valor+= $valor['Valor'];

            $pdf->SetFont('Arial','',7);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',7);

            $rowarr[$k]  = $valor['Recibo'];
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;
            
            $rowarr[$k] = dataf($valor['Data']);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;
            
            $rowarr[$k] = $valor['Cliente'];
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;

            $rowarr[$k] = to_money($valor['Valor'], false);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;

            $rowarr[$k] = $valor['Usuario'];
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;

            $lns = $lns * 5;

            for($k=0;$k<$ncampos;$k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);
		}

		$lns = 5;
		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1,      $lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$pdf->MultiCell((14/100)*190, $lns, 'Recibos: '.$total_recibos, 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		//$pdf->MultiCell((22/100)*190, $lns, str_replace('"','',to_money($total_receber)), 'T', 'R');
		$pdf->MultiCell((60/100)*190, $lns, '', 'T', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((14/100)*190, $lns, to_money($total_valor, false), 'T', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*190, $lns, '', 'T', 'R');
		$pdf->y=$y;


		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->y=$y+$lns;
		$pdf->y=$pdf->y+$lns;
		$pdf->y=$pdf->y+$lns;

         
		$pdf->CabecalhoGrid_Texto = '';

		$lns = 5;
		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1,      $lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*190, $lns, 'Usurios', 'TB', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*190, $lns, 'Servios', 'TB', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*190, $lns, 'Cereais', 'TB', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*190, $lns, 'Insumos', 'TB', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*190, $lns, 'Total', 'TB', 'R');
		$pdf->y=$y;



		$k=0;
		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->CabecalhoGrid_Texto[$k] = 'Usurio';
		$pdf->CabecalhoGrid_Tamanho[$k] = '20';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Servios';
		$pdf->CabecalhoGrid_Tamanho[$k] = '20';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Cereais';
		$pdf->CabecalhoGrid_Tamanho[$k] = '20';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Insumos';
		$pdf->CabecalhoGrid_Tamanho[$k] = '20';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Total';
		$pdf->CabecalhoGrid_Tamanho[$k] = '20';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos =5;
         
		//
		asort($lista_usuarios);
		foreach($lista_usuarios as $chave => $valor){
            $lns = 0;
            $k = 0;
            $pdf->SetFont('Arial','',7);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',7);


            $rowarr[$k] = $valor['Usuario'];
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;

            $rowarr[$k] = to_money($valor['S'], false);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;
            
            $rowarr[$k] = to_money($valor['C'], false);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;
            
            $rowarr[$k] = to_money($valor['I'], false);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;
            
            $rowarr[$k] = to_money($valor['Valor'], false);
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
            }
            $k++;



            $lns = $lns * 5;

            for($k=0;$k<$ncampos;$k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);
		}

	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}

	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>