<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('DEMONSTRATIVO_ESTOQUE.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'DEMONSTRATIVO';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(12);

	$fmt_titulo_c =& $workbook->add_format();
	$fmt_titulo_c->set_align('center');
	$fmt_titulo_c->set_pattern();
	$fmt_titulo_c->set_fg_color(40);
	$fmt_titulo_c->set_bold(1);
	$fmt_titulo_c->set_border(1);

	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_align('left');
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_size(10);

	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('right');
	$fmt_qtd->set_num_format('@');
	//$fmt_qtd->set_num_format('#,##0.0##_);-#,##0.0##_)');

	$filtro = '';

	$worksheet1->write_string(0,0,'RELATRIO DE DEMONSTRATIVO DE ESTOQUE',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$empresa = $_REQUEST['empresa'];
	$produto = $_REQUEST['produto'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];
	$fornec = $_REQUEST['fornec'];
	$prod_dep = $_REQUEST['depart'];
	$tipo_rel = $_REQUEST['tipo_rel'];
	$filtro.= ' De "'.$data_ini.'"';
	$filtro.= ' At "'.$data_fim.'"';

	$lista_geral = array();
	$lista_prod = array();

	//ESTOQUE
	$cons_estoque = 'select prod_saldo.Codigo_Empresa, '.
					' prod_saldo.Id_Produto, '.
					' SUM(prod_saldo.Saldo_Atual) as Saldo_Atual '.
					' from produto_saldo_filial prod_saldo '.
					' inner join produto prod '.
					' on prod_saldo.Dominio = prod.Dominio and '.
					' prod_saldo.Id_Produto = prod.Id_Produto '.
					' Where prod_saldo.Dominio = "'.$_SESSION['Dominio'].'"'.
					' and prod.Codigo_Depart <> "0" and prod.Id_Produto > 0 and prod_saldo.Saldo_Atual <> 0';

	if($empresa!=''){
		$cons_estoque.= ' and prod_saldo.Codigo_Empresa = "'.$empresa.'"';
		$con_empr = 'select Pessoa, Nome_Listas from pessoa '.
				   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empr = consulta_sql($con_empr);
		$reg_empr = consulta_ler_linha($res_empr);
		consulta_limpa($res_empr);
		$filtro.= ' Empresa: "'.$reg_empr[1].'"';
	}

	if($produto!=''){
		$cons_estoque.= ' and prod_saldo.Id_Produto="'.$produto.'"';
		//$filtro.= ' Produto "'.$_REQUEST['produto'].'"';
		$con_prod = 'select Descricao_Completa, Codigo_Produto from produto '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);
		$filtro.= ' Produto: "'.$reg_prod[1].'-'.$reg_prod[0].'"';
	}

	if($fornec!=''){
		$cons_estoque.= ' and prod.Codigo_Fornecedor = "'.$fornec.'" ';
		$cons_pessoa = 'select Nome_Razao, Pessoa from pessoa '.
						' where Dominio = "'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$fornec.'"';
		$res_pessoa = consulta_sql($cons_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$filtro.= ' Fornecedor: "'.$reg_pessoa[0].'"';
	}

	$filtro_depart = '';
	$depart = '';
	$con_filtro = '';

	$lista_depart = explode(';',$prod_dep);
	foreach($lista_depart as $key => $valor){
		if ($valor!=''){
			if($con_filtro != ''){
				$con_filtro.= 'or';
			}
			$con_filtro.= ' (prod.Codigo_Depart = "'.$valor.'") ';
			$depart[$valor] = '1';
			if ($filtro_depart==''){
				$filtro_depart = ' Departamentos:';
			}else{
				$filtro_depart.= ',';
			}

			$cons_filt_depart = 'select Codigo_Depart, Descricao '.
								' from produto_departamento '.
								' where Dominio = "'.$_SESSION['Dominio'].'" '.
								' and Codigo_Depart <> 0 '.
								' and Codigo_Depart = "'.$valor.'" '.
								' and Situacao <> "E" '.
								' order by Descricao ';
			$res_filt_depart = consulta_sql($cons_filt_depart);
			$reg_filt_depart = consulta_ler_linha($res_filt_depart);
			$filtro_depart.= ' "'.$reg_filt_depart[1].'"';
		}
	}

	if($con_filtro != ''){
		$cons_estoque.= ' and ('.$con_filtro.')';
		if($filtro != ''){
			$filtro.= ' /'.$filtro_depart;
		}
	}
	/*
		if($data_ini!=''){
			$cons_estoque.= ' and prod_saldo.Data_Mov>="'.datad($data_ini).'"';
			$filtro.= ' De "'.$data_ini.'"';
		}
		if($data_fim!=''){
			$cons_estoque.= ' and prod_saldo.Data_Mov<="'.datad($data_fim).' 23:59:59"';
			$filtro.= ' At "'.$data_fim.'"';
		}
	*/
	$cons_estoque.= ' group by prod_saldo.Id_Produto';
	//if($produto!=''){
	//	$cons_estoque.= ', prod_saldo.Codigo_Empresa ';
	//}

	$cons_estoque.= ' order by prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';

	$res_estoque = consulta_sql($cons_estoque);
	$nrows_estoque = consulta_num_registros($res_estoque);

	$counter = 0;

	for($e=0;$e<$nrows_estoque;$e++){
		$reg_estoque = consulta_ler_objeto($res_estoque);
		$ok_linha = true;

		$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$reg_estoque->Id_Produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		if($ok_linha){
			if($depart!=''){
				$ok_linha = (isset($depart[$reg_prod[2]]));
			}
		}

		if($ok_linha){
			if($fornec!=''){
				$ok_linha = ($fornec==$reg_prod[3]);
			}
		}

		if($ok_linha){
			$counter++;
			if(isset($lista_geral[$reg_estoque->Id_Produto])){
				$lista_todos = $lista_geral[$reg_estoque->Id_Produto];
			}else{
				$lista_todos['cod_prod'] = $reg_prod[1];
				$lista_todos['nome_prod'] = $reg_prod[0];
				$lista_todos['estoque_min'] = $reg_prod[4];
				$lista_todos['estoque'] = 0;
				$lista_todos['vendas'] = 0;
				$lista_todos['venda_fut'] = 0;
				$lista_todos['pedido'] = 0;
				$lista_todos['ped_compra'] = 0;
				$lista_prod[$reg_estoque->Id_Produto] = $reg_prod[0];
			}
			$lista_todos['estoque']+= $reg_estoque->Saldo_Atual;

			$lista_geral[$reg_estoque->Id_Produto] = $lista_todos;
		}
	}
	consulta_limpa($res_estoque);
	
	/**Tipo rel
	 * ECV  == Estoque + Compra - Venda
	 * EV  == Estoque - Venda
	 * C == Completo  [como era antes ]
	 */
	if( $tipo_rel=='C'){
		$filtro.= ' Relatrio Completo';
	}else if( $tipo_rel=='ECV' ){
		$filtro.= ' Rel. Entradas+Compras-Vendas ';
	}else if( $tipo_rel=='EV' ){
		$filtro.= ' Rel. Entradas-Vendas ';
	}

	if (($tipo_rel=='ECV')||($tipo_rel=='C')){
		//VENDAS
		$cons_nota = 'select NrDoc, Modelo, Serie, Destinatario, Dest_Razao, '.
					 ' DH_EntSai as DH_Emissao, DH_EntSai as DT_Emissao, Empresa, Nr_Nota, '.
					 ' Nat_Op_CFOP, Nat_Op_Descricao, Vendedor, Vendedor_Nome, '.
					 ' Peso_Bruto, Peso_Liquido, '.
					 ' Total_ICMS_Valor, Total_IPI, '.
					 ' Total_Desconto, Total_Produtos, Total_Servicos, Total_NF, '.
					 ' "" as LetraMF, 0 as COO'.
					 ' from nota_fiscal '.
					 ' Where Dominio = "'.$_SESSION['Dominio'].'"';

		if($empresa!=''){
			$cons_nota.= ' and Empresa = "'.$empresa.'" ';
		}

		$cons_nota.= ' and Situacao="F"'.
					 ' and TipoES="1"'.
					 ' and Nat_Op_Gera_Contas = "R"';

		if(($data_ini!='')||($data_fim!='')){
			if($data_ini!=''){
				$cons_nota.= ' and DH_Emissao >= "'.datad($data_ini).'" ';
			}
			if($data_fim!=''){
				$cons_nota.= ' and DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
			}
		}

		$cons_nota.= ' order by Destinatario, DH_Emissao, Empresa, Nr_Nota ';

		$res_nota = consulta_sql($cons_nota);
		$nrows_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrows_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);

			$cons_item = 'select Seq_Item, Id_Produto, Codigo_Produto, Prod_Descricao, '.
						 ' Quantidade_Estoque, Unidade_Estoque, '.
						 ' Valor_Unitario, Valor_Total, Valor_Desconto, Qtd_Devolvida '.
						 ' from nota_fiscal_item '.
						 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						 ' and Empresa = "'.$reg_nota->Empresa.'" '.
						 ' and Nr_Nota = "'.$reg_nota->Nr_Nota.'" ';
			$res_item = consulta_sql($cons_item);
			$nrows_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrows_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				$ok_linha = true;

				$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_item->Id_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$reg_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);

				if($ok_linha){
					$ok_linha = ($reg_item->Id_Produto>0);
				}

				if($ok_linha){
					if($produto!=''){
						$ok_linha = ($produto==$reg_item->Id_Produto);
					}
				}

				if($ok_linha){
					if($depart!=''){
						$ok_linha = (isset($depart[$reg_prod[2]]));
					}
				}

				if($ok_linha){
					if($fornec!=''){
						$ok_linha = ($fornec==$reg_prod[3]);
					}
				}

				if($ok_linha){
					$counter++;
					if(isset($lista_geral[$reg_item->Id_Produto])){
						$lista_todos = $lista_geral[$reg_item->Id_Produto];
					}else{
						$lista_todos['cod_prod'] = $reg_prod[1];
						$lista_todos['nome_prod'] = $reg_prod[0];
						$lista_todos['estoque_min'] = $reg_prod[4];
						$lista_todos['estoque'] = 0;
						$lista_todos['vendas'] = 0;
						$lista_todos['venda_fut'] = 0;
						$lista_todos['pedido'] = 0;
						$lista_todos['ped_compra'] = 0;
						$lista_prod[$reg_item->Id_Produto] = $reg_prod[0];
					}
					$lista_todos['vendas']+= $reg_item->Quantidade_Estoque-$reg_item->Qtd_Devolvida;
					$lista_geral[$reg_item->Id_Produto] = $lista_todos;
				}
			}
		}
		consulta_limpa($res_nota);

		$cons_ecf = 'select COO as NrDoc, "2D" as Modelo, NrFab, Pessoa, Pessoa_CNPJ, Pessoa_Nome, '.
					' DH_Movto as DH_Emissao, DT_Emissao, Empresa, 0, '.
					' "5.102" as Nat_Op_CFOP, "VENDA CF" as Nat_Op_Descricao, Vendedor, "" as Vendedor_Nome, '.
					' 0, 0, 0, 0, '.
					' Desconto, SubTotal, 0, (SubTotal + Acrescimo-Desconto) as Total_NF, '.
					' LetraMF, COO '.
					' from ecf_cupom '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Cancelado="N" '.
					' and DH_Movto>="'.datad($data_ini).' 00:00:00"'.
					' and DH_Movto<="'.datad($data_fim).' 23:59:59"';

		if($empresa!=''){
			$cons_ecf.= ' and Empresa = "'.$empresa.'"';
		}

		$cons_ecf.= ' order by DH_Emissao, Empresa, NrDoc ';

		//echo $cons_ecf;

		$res_ecf = consulta_sql($cons_ecf);
		$nrows_ecf = consulta_num_registros($res_ecf);
		for($e=0;$e<$nrows_ecf;$e++){
			$reg_ecf = consulta_ler_objeto($res_ecf);

			$cons_ecfi = 'select Seq_Item, Id_Produto, Codigo_Produto, Descricao_Produto, '.
						 ' Quantidade, Unidade_Medida, '.
						 ' Preco, ValorTotal, Desconto '.
						 ' from ecf_cupom_item '.
						 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						 ' and Empresa = "'.$reg_ecf->Empresa.'"'.
						 ' and NrFab = "'.$reg_ecf->NrFab.'"'.
						 ' and LetraMF = "'.$reg_ecf->LetraMF.'"'.
						 ' and DT_Emissao = "'.$reg_ecf->DT_Emissao.'"'.
						 ' and COO = "'.$reg_ecf->COO.'"'.
						 ' and Cancelado = "N" ';
			$res_ecfi = consulta_sql($cons_ecfi);
			$nrows_ecfi = consulta_num_registros($res_ecfi);
			for($ei=0;$ei<$nrows_ecfi;$ei++){
				$reg_ecfi = consulta_ler_objeto($res_ecfi);
				$ok_linha = true;

				$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_ecfi->Id_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$reg_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);

				if($ok_linha){
					$ok_linha = ($reg_ecfi->Id_Produto>0);
				}

				if($ok_linha){
					if($produto!=''){
						$ok_linha = ($produto==$reg_ecfi->Id_Produto);
					}
				}

				if($ok_linha){
					if($depart!=''){
						$ok_linha = (isset($depart[$reg_prod[2]]));
					}
				}

				if($ok_linha){
					if($fornec!=''){
						$ok_linha = ($fornec==$reg_prod[3]);
					}
				}

				if($ok_linha){
					$counter++;
					if(isset($lista_geral[$reg_ecfi->Id_Produto])){
						$lista_todos = $lista_geral[$reg_ecfi->Id_Produto];
					}else{
						$lista_todos['cod_prod'] = $reg_prod[1];
						$lista_todos['nome_prod'] = $reg_prod[0];
						$lista_todos['estoque_min'] = $reg_prod[4];
						$lista_todos['estoque'] = 0;
						$lista_todos['vendas'] = 0;
						$lista_todos['venda_fut'] = 0;
						$lista_todos['pedido'] = 0;
						$lista_todos['ped_compra'] = 0;
						$lista_prod[$reg_ecfi->Id_Produto] = $reg_prod[0];
					}
					$lista_todos['vendas']+= $reg_ecfi->Quantidade;
					$lista_geral[$reg_ecfi->Id_Produto] = $lista_todos;
				}
			}
		}
		consulta_limpa($res_ecf);
	}

	//VENDA ENTREGA FUTURA
	$cons_vend = 'select ped.Empresa, '.
				 ' pi.Id_Produto, SUM(pi.Quantidade_Estoque - pi.Qtd_Remetida - pi.Qtd_Devolvida) AS Qtd_Pedido '.
				 ' from nota_fiscal ped '.
				 ' inner join nota_fiscal_item pi '.
				 ' on ped.Dominio = pi.Dominio '.
				 ' and ped.Empresa = pi.Empresa '.
				 ' and ped.Nr_Nota = pi.Nr_Nota '.
				 ' where ped.Dominio = "'.$_SESSION['Dominio'].'"'.
                 ' AND ped.Inativo = "0" ';

	if($empresa!=''){
		$cons_vend.= ' and ped.Empresa = "'.$empresa.'" ';
	}

	$cons_vend.= ' and ped.Situacao = "F" '.
				 ' and pi.Id_Produto>0 and pi.Prod_Depart <> 0'.
				 ' and ((pi.CFOP = "4.922") or (pi.CFOP = "5.922") or (pi.CFOP = "6.922") or (pi.CFOP = "7.922")'.
				 ' or (pi.CFOP = "4.505") or (pi.CFOP = "5.505") or (pi.CFOP = "6.505") or (pi.CFOP = "7.505"))';

	if(($data_ini!='')||($data_fim!='')){
		if($data_ini!=''){
			$cons_vend.= ' and ped.DH_Emissao >= "'.datad($data_ini).'" ';
		}

		if($data_fim!=''){
			$cons_vend.= ' and ped.DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
		}
	}

	if($produto!=''){
	   $cons_vend.= ' and pi.Id_Produto = "'.$produto.'"'; 
	}

	$cons_vend.= ' and (pi.Quantidade_Estoque>(pi.Qtd_Remetida+pi.Qtd_Devolvida-pi.Qtd_Remessa_Devolvida))';

	$cons_vend.= ' group by pi.Id_Produto';
	//if($produto!=''){
	//	$cons_vend.= ', ped.Empresa ';
	//}

	$cons_vend.= ' order by pi.Id_Produto, ped.Empresa ';

	$res_vend = consulta_sql($cons_vend);
	$nrows_vend = consulta_num_registros($res_vend);
	for($vf=0;$vf<$nrows_vend;$vf++){
		$reg_vend = consulta_ler_objeto($res_vend);

		$ok_linha = true;

		$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$reg_vend->Id_Produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		if($ok_linha){
			if($depart!=''){
				$ok_linha = (isset($depart[$reg_prod[2]]));
			}
		}

		if($ok_linha){
			if($fornec!=''){
				$ok_linha = ($fornec==$reg_prod[3]);
			}
		}

		if($ok_linha){
			$counter++;
			if(isset($lista_geral[$reg_vend->Id_Produto])){
				$lista_todos = $lista_geral[$reg_vend->Id_Produto];
			}else{
				$lista_todos['cod_prod'] = $reg_prod[1];
				$lista_todos['nome_prod'] = $reg_prod[0];
				$lista_todos['estoque_min'] = $reg_prod[4];
				$lista_todos['estoque'] = 0;
				$lista_todos['vendas'] = 0;
				$lista_todos['venda_fut'] = 0;
				$lista_todos['pedido'] = 0;
				$lista_todos['ped_compra'] = 0;
				$lista_prod[$reg_vend->Id_Produto] = $reg_prod[0];
			}
			$lista_todos['venda_fut']+= $reg_vend->Qtd_Pedido;
			$lista_geral[$reg_vend->Id_Produto] = $lista_todos;
		}
	}
	consulta_limpa($res_vend);

	//PEDIDOS VENDA ABERTOS
	$cons_ped = 'select ped.Empresa, '.
				' pi.ID_Produto, SUM(pi.Qtd - pi.Qtd_Atendida) AS Qtd_Pedido '.
				' from pedido ped '.
				' inner join pedido_item pi '.
				' on ped.Dominio = pi.Dominio '.
				' and ped.Empresa = pi.Empresa '.
				' and ped.Numero_Pedido = pi.Numero_Pedido '.
				' where ped.Dominio = "'.$_SESSION['Dominio'].'"'.
				' and ped.Pessoa>100 ';

	if($empresa!=''){
		$cons_ped.= ' and ped.Empresa = "'.$empresa.'" ';
	}

	if(($data_ini!='')||($data_fim!='')){
		if($data_ini!=''){
			$cons_ped.= ' and ped.DH_Emissao >= "'.datad($data_ini).'" ';
		}

		if($data_fim!=''){
			$cons_ped.= ' and ped.DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
		}
	}

	if($produto!=''){
		$cons_ped.= ' and pi.ID_Produto = "'.$produto.'"'; 
	}

	$cons_ped.= ' and ped.Status <> "E" '.
				' and ped.Status <> "C" '.
				' and ((pi.Status <> "E") '.
				' and  (pi.Status <> "C") '.
				' and  (pi.Status <> "F"))';

	$cons_ped.= ' and (pi.Qtd > pi.Qtd_Atendida) ';

	$cons_ped.= ' group by pi.ID_Produto';
	//if($produto!=''){
	//	$cons_ped.= ', ped.Empresa ';
	//}

	$cons_ped.= ' order by pi.ID_Produto, ped.Empresa ';

	//echo  $cons_ped; 
	$res_ped = consulta_sql($cons_ped);
	$nrows_ped = consulta_num_registros($res_ped);
	for($pv=0;$pv<$nrows_ped;$pv++){
		$reg_ped = consulta_ler_objeto($res_ped);
		$ok_linha = true;

		$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$reg_ped->ID_Produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		if($ok_linha){
			if($depart!=''){
				$ok_linha = (isset($depart[$reg_prod[2]]));
			}
		}

		if($ok_linha){
			if($fornec!=''){
				$ok_linha = ($fornec==$reg_prod[3]);
			}
		}

		if($ok_linha){
			$counter++;
			if(isset($lista_geral[$reg_ped->ID_Produto])){
				$lista_todos = $lista_geral[$reg_ped->ID_Produto];
			}else{
				$lista_todos['cod_prod'] = $reg_prod[1];
				$lista_todos['nome_prod'] = $reg_prod[0];
				$lista_todos['estoque_min'] = $reg_prod[4];
				$lista_todos['estoque'] = 0;
				$lista_todos['vendas'] = 0;
				$lista_todos['venda_fut'] = 0;
				$lista_todos['pedido'] = 0;
				$lista_todos['ped_compra'] = 0;
				$lista_prod[$reg_ped->ID_Produto] = $reg_prod[0];
			}
			$lista_todos['pedido']+= $reg_ped->Qtd_Pedido;
			$lista_geral[$reg_ped->ID_Produto] = $lista_todos;
		}
	}
	consulta_limpa($res_ped);

	//PEDIDO COMPRA
	if (($tipo_rel=='ECV')||($tipo_rel=='C')){
		$cons_compra = ' select ped.Empresa, '.
						' pi.ID_Produto, SUM(pi.Qtd - pi.Qtd_Atendida) AS Qtd_Pedido '.
						' from pedido_compra ped '.
						' inner join pedido_compra_item pi '.
						' on ped.Dominio = pi.Dominio '.
						' and ped.Empresa = pi.Empresa '.
						' and ped.Numero_Pedido = pi.Numero_Pedido '.
						' where ped.Dominio = "'.$_SESSION['Dominio'].'"';

		if($empresa!=''){
			$cons_compra.= ' and ped.Empresa = "'.$empresa.'" ';
		}

		if(($data_ini!='')||($data_fim!='')){
			if($data_ini!=''){
				$cons_compra.= ' and ped.DH_Emissao >= "'.datad($data_ini).'" ';
			}

			if($data_fim!=''){
				$cons_compra.= ' and ped.DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
			}
		}

		$cons_compra.= ' and ped.Status <> "E"'.
						' and ped.Status <> "C"'.
						' and ((ped.Status = "A") or (ped.Status = "L") or (ped.Status = "P"))';

		if($produto!=''){
			$cons_compra.= ' and pi.ID_Produto = "'.$produto.'"'; 
		}

		$cons_compra.= ' group by pi.ID_Produto';

		//echo $cons_compra ;
		//if($produto!=''){
		//	$cons_compra.= ', ped.Empresa ';
		//}

		$cons_compra.= ' order by pi.ID_Produto, ped.Empresa ';
		$res_compra = consulta_sql($cons_compra);
		$nrows_compra = consulta_num_registros($res_compra);
		for($pc=0;$pc<$nrows_compra;$pc++){
			$reg_compra = consulta_ler_objeto($res_compra);
			$ok_linha = true;

			$con_prod = 'select Descricao_Completa, Codigo_Produto, Codigo_Depart, Codigo_Fornecedor, Estoque_Minimo from produto '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto = "'.$reg_compra->ID_Produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			if($ok_linha){
				if($depart!=''){
					$ok_linha = (isset($depart[$reg_prod[2]]));
				}
			}

			if($ok_linha){
				if($fornec!=''){
					$ok_linha = ($fornec==$reg_prod[3]);
				}
			}

			if($ok_linha){
				$counter++;
				if(isset($lista_geral[$reg_compra->ID_Produto])){
					$lista_todos = $lista_geral[$reg_compra->ID_Produto];
				}else{
					$lista_todos['cod_prod'] = $reg_prod[1];
					$lista_todos['nome_prod'] = $reg_prod[0];
					$lista_todos['estoque_min'] = $reg_prod[4];
					$lista_todos['estoque'] = 0;
					$lista_todos['vendas'] = 0;
					$lista_todos['venda_fut'] = 0;
					$lista_todos['pedido'] = 0;
					$lista_todos['ped_compra'] = 0;
					$lista_prod[$reg_compra->ID_Produto] = $reg_prod[0];
				}
				$lista_todos['ped_compra']+= $reg_compra->Qtd_Pedido;
				$lista_geral[$reg_compra->ID_Produto] = $lista_todos;
			}
		}
		consulta_limpa($res_compra);
	}

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	$linha_ini = 9;

	if(!empty($lista_prod)){
		asort($lista_prod);
	}

	if($counter>0){
		$coluna = 0;
		$linha_ini++;

		//ECV === Estoque + Compra - Vendas
		/**Com a solicitao da Odontoville, iremos fazer um completo  e depois o ECV e depois o outro */

		/**
		 * Solicitao Cliente Dominio 119 para voltar oque era antes da atualizao. Realizado em 10-01-2023 por @isabel[campos faltando: Estoque minimo, Vendas, Pedido Venda, Pedido Compra, Necessidade  , Total vendas ] 
		 * Ficar 3 filtros de pedidos:
		 * Completo ( exatamente como era antes )
		 * Estoque + Compra - Venda [ECV]
		 * e
		 * Estoque - Venda [EV]
		 * */


		
		if ($tipo_rel=='C'){

			/**Produto 
			 * Estoque Minimo
			 * Estoque
			 * Pedidos Compra 
			 * Vendas
			 * Venda Entrada Futura
			 * Pedidos Venda 
			 * Necessidade 
			 * Total Vendas 
			 */
			$worksheet1->set_column($coluna,$coluna,35);
			$worksheet1->write_string($linha_ini,$coluna,'Produto',$fmt_titulo_c);
			$coluna++;

			
			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Estoque Mnimo',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Estoque',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Compra',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Vendas',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Venda Ent Futura',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Venda',$fmt_titulo_c);
			$coluna++;

			/**S deve aparecer no completo 

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Compra',$fmt_titulo_c);
			$coluna++;*/

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Necessidade',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Total Vendas',$fmt_titulo_c);
			$coluna++;
		
		}else if ($tipo_rel=='ECV'){
			

			$worksheet1->set_column($coluna,$coluna,35);
			$worksheet1->write_string($linha_ini,$coluna,'Produto',$fmt_titulo_c);
			$coluna++;
			
			/**Solicitao Cliente Dominio 119 para voltar oque era antes da atualizao. Realizado em 10-01-2023 por @isabel[campos faltando: Estoque minimo, Vendas, Pedido Venda, Pedido Compra, Necessidade  , Total vendas ] */

			/*$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Estoque Mnimo',$fmt_titulo_c);
			$coluna++;*/

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Compra',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Estoque',$fmt_titulo_c);
			$coluna++;

			/* Vendas j ocorreram,  portanto j saiu do estoque se aparecer aqui ir ficar redundante
			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Vendas',$fmt_titulo_c);
			$coluna++;*/

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Venda Ent Futura',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Venda',$fmt_titulo_c);
			$coluna++;

			/**S deve aparecer no completo

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Compra',$fmt_titulo_c);
			$coluna++;  */

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Necessidade',$fmt_titulo_c);
			$coluna++;

			/* $worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Total Vendas',$fmt_titulo_c);
			$coluna++;*/ 
		}else{
			$worksheet1->set_column($coluna,$coluna,35);
			$worksheet1->write_string($linha_ini,$coluna,'Produto',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Estoque',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Venda Ent Futura',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Pedidos Venda',$fmt_titulo_c);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,15);
			$worksheet1->write_string($linha_ini,$coluna,'Saldo',$fmt_titulo_c);
			$coluna++;
		}

		$linha_ini++;
		foreach($lista_prod as $cod_prod => $valor_p){
			$lista_geral2 = $lista_geral[$cod_prod];

			$necessidade = 0;
			$total_vendas = 0;

			$coluna = 0;
			if ($tipo_rel=='C'){
				$worksheet1->write_string($linha_ini,$coluna,$lista_geral2['cod_prod'].' - '.$lista_geral2['nome_prod'],$fmt_txt_l);
				$coluna++;

				//Estoque Mnimo
				$valor_est_min = '';
				if(isset($lista_geral2['estoque_min'])){
					$valor_est_min = $lista_geral2['estoque_min'];
					if(($valor_est_min<=0.0001)&&($valor_est_min > (-0.0001))){
						$valor_est_min = '';
					}
				}
				if($valor_est_min!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_est_min  ,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna, $valor_est_min ,$fmt_txt_l);
				}
				$coluna++;

				//Estoque
				$valor_est = '';
				if(isset($lista_geral2['estoque'])){
					$valor_est = $lista_geral2['estoque'];
					if(($valor_est<=0.0001)&&($valor_est > (-0.0001))){
						$valor_est= '';
					}
				}
				if($valor_est!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_est,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_est,$fmt_txt_l);
				}
				$coluna++;

				// Apresentacao do Pedido Compra 
				$valor_pedCompra = '';
				if(isset($lista_geral2['ped_compra'])){
					$valor_pedCompra = $lista_geral2['ped_compra'];
					if($valor_pedCompra<=0){
						$valor_pedCompra = '';
					}
				}
				if($valor_pedCompra!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_pedCompra,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_pedCompra,$fmt_txt_l);
				}
				$coluna++;

				//Vendas
				$valor_vendas = '';
				if(isset($lista_geral2['vendas'])){
					$valor_vendas = $lista_geral2['vendas'];
					if($valor_vendas<=0){
						$valor_vendas = '';
					}
				}
				if($valor_vendas!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_vendas,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_vendas,$fmt_txt_l);
				}
				$coluna++;

				//vendas Futuras 
				$valor_venda_futura = '';
				if(isset($lista_geral2['venda_fut'])){
					$valor_venda_futura = $lista_geral2['venda_fut'];
					if($valor_venda_futura<=0){
						$valor_venda_futura = '';
					}
				}
				if($valor_venda_futura!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_venda_futura,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_venda_futura,$fmt_txt_l);
				}
				$coluna++;

				//pedido de vendas 
				$valor_pedido = '';
				if(isset($lista_geral2['pedido'])){
					$valor_pedido = $lista_geral2['pedido'];
					if($valor_pedido<=0){
						$valor_pedido = '';
					}
				}
				if($valor_pedido!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_pedido,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_pedido,$fmt_txt_l);
				}
				$coluna++;


				
				
				//necessidade 
				$necessidade = (($lista_geral2['venda_fut']+$lista_geral2['pedido'])-($lista_geral2['estoque']+$lista_geral2['ped_compra']));
				$valor_necess = '';
				$valor_necess = $necessidade;
				if($valor_necess<=0.0001){
					$valor_necess = '';
				}
				if($valor_necess!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_necess,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_necess,$fmt_txt_l);
				}
				$coluna++;

				$total_vendas = ($lista_geral2['vendas']+$lista_geral2['pedido']);
				$valor_c = '';
				$valor_c = $total_vendas;
				if($valor_c<=0){
					$valor_c = '';
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

			}else if ($tipo_rel=='ECV'){
				$worksheet1->write_string($linha_ini,$coluna,$lista_geral2['cod_prod'].' - '.$lista_geral2['nome_prod'],$fmt_txt_l);
				$coluna++;

				// Apresentacao do Pedido Compra 
				$valor_pedCompra = '';
				if(isset($lista_geral2['ped_compra'])){
					$valor_pedCompra = $lista_geral2['ped_compra'];
					if($valor_pedCompra<=0){
						$valor_pedCompra = '';
					}
				}
				if($valor_pedCompra!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_pedCompra,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_pedCompra,$fmt_txt_l);
				}
				$coluna++;
				
				
				// Estoque
				$valor_c = '';
				if(isset($lista_geral2['estoque'])){
					$valor_c = $lista_geral2['estoque'];
					if(($valor_c<=0.0001)&&($valor_c > (-0.0001))){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

				//Vendas Entrega Futura
				$valor_c = '';
				if(isset($lista_geral2['venda_fut'])){
					$valor_c = $lista_geral2['venda_fut'];
					if($valor_c<=0){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

				$valor_c = '';
				if(isset($lista_geral2['pedido'])){
					$valor_c = $lista_geral2['pedido'];
					if($valor_c<=0){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;
				

				$necessidade = (($lista_geral2['venda_fut']+$lista_geral2['pedido'])-($lista_geral2['estoque']+$lista_geral2['ped_compra']));
				$valor_c = '';
				$valor_c = $necessidade;
				if($valor_c<=0.0001){
					$valor_c = '';
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

			}else{
				$worksheet1->write_string($linha_ini,$coluna,$lista_geral2['cod_prod'].' - '.$lista_geral2['nome_prod'],$fmt_txt_l);
				$coluna++;

				$valor_c = '';
				if(isset($lista_geral2['estoque'])){
					$valor_c = $lista_geral2['estoque'];
					if(($valor_c<=0.0001)&&($valor_c > (-0.0001))){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

				$valor_c = '';
				if(isset($lista_geral2['venda_fut'])){
					$valor_c = $lista_geral2['venda_fut'];
					if($valor_c<=0){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

				$valor_c = '';
				if(isset($lista_geral2['pedido'])){
					$valor_c = $lista_geral2['pedido'];
					if($valor_c<=0){
						$valor_c = '';
					}
				}
				if($valor_c!=''){
					$worksheet1->write_number($linha_ini,$coluna,$valor_c,$fmt_qtd);
				}else{
					$worksheet1->write_string($linha_ini,$coluna,$valor_c,$fmt_txt_l);
				}
				$coluna++;

				$saldo = $lista_geral2['estoque'] - ($lista_geral2['venda_fut']+$lista_geral2['pedido']);
				$worksheet1->write_number($linha_ini,$coluna,$saldo,$fmt_qtd);
				$coluna++;
			}
			$linha_ini++;
		}
	}else{
		/*
		$titulo_sheet = 'DEMONSTRATIVO';
		$worksheet1 =& $workbook->add_worksheet($titulo_sheet);
		$worksheet1->write_string(0,0,'RELATRIO DE DEMONSTRATIVO DE ESTOQUE',$formatot);
		$worksheet1->write(2,0,config_pad('sistema_licenca'));
		$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
		$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
		$worksheet1->write(7,0,"Filtro: ".$filtro);
		*/
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();
?>