<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$dominios['187'] = "187";

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('POSICAO_ESTOQUE.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'RELATRIO POSIO DE ESTOQUE';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,'RELATRIO DE POSIO DE ESTOQUE',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$fornec = '';
	$filtro_depart = '';
	$filtro_marca = '';
	$depart = '';
	$marca = '';
	$situacao = $_REQUEST['situacao'];
	$tipo = $_REQUEST['tp_estoque'];

	$lista_depart = explode(';',$_REQUEST['depart']);

	foreach($lista_depart as $key => $valor){
		if ($valor!=''){
			$depart[$valor] = '1';
			if ($filtro_depart==''){
				$filtro_depart = ' Por Departamentos';
			}else{
				$filtro_depart.= ',';
			}
			$filtro_depart.= ' "'.$valor.'"';
		}
	}

	$lista_marca = explode(';',$_REQUEST['marca']);

	foreach($lista_marca as $key => $valor){
		if($valor!=''){
			$marca[$valor] = '1';
			if($filtro_marca==''){
				$filtro_marca = ' Por Marcas';
			}else{
				$filtro_marca.= ',';
			}
			$filtro_marca.= ' "'.$valor.'"';
		}
	}

	$campos_remessas = retorna_campos_estoque_remessas($_SESSION['Dominio']);

	$grupo = $_REQUEST['grupo'];
	$linha = $_REQUEST['linha'];

	/*
	$consulta = 'SELECT prod_saldo.Codigo_Empresa, prod.Codigo_Fornecedor, '.
				' prod.Codigo_Depart, prod.Codigo_Grupo, prod.Codigo_Linha, '.
				' prod_saldo.Id_Produto, '.
				' SUM(prod_saldo.Saldo_Atual) as Saldo_Atual, '.
				' MAX(prod_saldo.Preco_Custo) as Preco_Custo, '.
				' MAX(prod_saldo.Data_Mov) as Data_Mov, '.
				' prod.Codigo_Fornecedor, '.
				' prod.Estoque_Minimo, '.
				' prod.Ponto_Pedido, '.
				' SUM(nfi.Quantidade_Estoque)'.
				' FROM produto_saldo_filial prod_saldo '.
				' INNER JOIN produto prod '.
				' ON prod_saldo.Id_Produto = prod.Id_Produto '.
				' INNER JOIN nota_fiscal_item nfi '.
				' ON prod_saldo.Id_Produto = nfi.Id_Produto '.
				' INNER JOIN nota_fiscal nf '.
				' ON nf.Dominio = nfi.Dominio '.
				' AND nf.Empresa = nfi.Empresa '.
				' AND nf.Nr_Nota = nfi.Nr_Nota '.
				' AND nf.Situacao = "A"'.
				' WHERE prod_saldo.Dominio = "'.$_SESSION['Dominio'].'"'.
				' AND prod.Codigo_Depart <> "0" ';
	*/

	$cod_prod_fornec="";
	if($_SESSION['Dominio'] == $dominios['187']){
		$cod_prod_fornec=' , prod_fornec.Codigo_Produto_Fornec, '.
						  ' (SELECT Descricao FROM produto_marca prod_marca '.
						  ' WHERE prod_marca.Dominio="'.$_SESSION['Dominio'].'" '.
						  ' AND prod.Marca=prod_marca.Codigo_Marca '.
						  ' AND prod_marca.Situacao = "A" LIMIT 1) as Desc_Marca ';
	}

	if($_REQUEST['tipo_preco'] == '0'){
		$tipo_preco = ' MAX(prod_saldo.Preco_Custo) ';
	}else if($_REQUEST['tipo_preco'] == '1'){
		$tipo_preco = ' (prod.Preco_Venda1) ';
	}else if($_REQUEST['tipo_preco'] == '2'){
		$tipo_preco = ' (prod.Preco_Venda2) ';
	}else if($_REQUEST['tipo_preco'] == '3'){
		$tipo_preco = ' (prod.Preco_Venda3) ';
	}else if($_REQUEST['tipo_preco'] == '4'){
		$tipo_preco = ' (prod.Preco_Venda4) ';
	}else if($_REQUEST['tipo_preco'] == '5'){
		$tipo_preco = ' (prod.Preco_Venda5) ';
	}else{
		$tipo_preco = ' MAX(prod_saldo.Preco_Custo) ';
	}

	$consulta = 'SELECT prod_saldo.Codigo_Empresa, prod.Codigo_Fornecedor, '.
			   ' prod.Codigo_Depart, prod.Codigo_Grupo, prod.Codigo_Linha, '.
			   ' prod_saldo.Id_Produto, '.
			   ' SUM(prod_saldo.Saldo_Atual) as Saldo_Atual, '.
			   $tipo_preco.' as Preco_Dinamico, '.
			   ' MAX(prod_saldo.Data_Mov) as Data_Mov, '.
			   ' prod.Estoque_Minimo, prod.Ponto_Pedido, prod.Preco_Venda1 '.
			   $cod_prod_fornec.
			   ' FROM produto prod '.
			   ' INNER JOIN produto_saldo_filial prod_saldo '.
			   ' ON prod_saldo.Dominio = prod.Dominio '.
			   ' AND prod_saldo.Id_Produto = prod.Id_Produto ';

	if($_SESSION['Dominio'] == $dominios['187']){
		$consulta.= 'LEFT JOIN (
					 SELECT Id_Produto,
					 MIN(Codigo_Produto_Fornec) AS Codigo_Produto_Fornec
					 FROM produto_fornecedor
					 WHERE Dominio="'.$_SESSION['Dominio'].'"
					 GROUP BY Id_Produto
				  ) prod_fornec ON prod_saldo.Id_Produto= prod_fornec.Id_Produto ';
				  //' AND prod_fornec.Codigo_Fornecedor=prod.Codigo_Fornecedor';
	}

	$consulta.= ' WHERE prod_saldo.Dominio = "'.$_SESSION['Dominio'].'"'.
				' AND prod.Situacao <> "E"';
	if($situacao != ''){
		$consulta.= ' AND prod.Situacao = "'.$situacao.'" ';
	}
	$consulta.= ' AND prod.Codigo_Depart <> "0" ';

	$filtro = '';
	if($_REQUEST['empresa']=='S'){
		$entidade = ' Separado por Empresa ';
	}else if($_REQUEST['empresa']!=''){
		$consulta.= ' AND prod_saldo.Codigo_Empresa = "'.$_REQUEST['empresa'].'"';
		$filtro.= ' Empresa "'.$_REQUEST['empresa'].'"';

		$con_empr = 'SELECT Pessoa, Nome_Listas FROM pessoa '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' AND Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empr = consulta_sql($con_empr);
		$reg_empr = consulta_ler_linha($res_empr);
		consulta_limpa($res_empr);

		$entidade = ' Empresa '.$reg_empr[0].' - '.$reg_empr[1];

	}
	if($_REQUEST['produto']!=''){
		$consulta.= ' AND prod_saldo.Id_Produto="'.$_REQUEST['produto'].'"';
		//$filtro.= ' Produto "'.$_REQUEST['produto'].'"';

		$con_prod = 'SELECT Descricao_Completa, Codigo_Produto FROM produto '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' AND Id_Produto = "'.$_REQUEST['produto'].'"';

		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);
		$filtro.= ' Produto: '.$reg_prod[1].'-'.$reg_prod[0];
	}

	if(($_REQUEST['dt_ini']!='')||($_REQUEST['dt_fim']!='')){
		$filtro.= ' Movimento:';
	}
	if($_REQUEST['dt_ini']!=''){
		$consulta.= ' AND prod_saldo.Data_Mov>="'.datad($_REQUEST['dt_ini']).'"';
		$filtro.= ' De "'.$_REQUEST['dt_ini'].'"';
	}
	if($_REQUEST['dt_fim']!=''){
		$consulta.= ' AND prod_saldo.Data_Mov<="'.datad($_REQUEST['dt_fim']).' 23:59:59"';
		$filtro.= ' At "'.$_REQUEST['dt_fim'].'"';
	}

	$filtro.= ' Estoque:';
	if($_REQUEST['estoque']=='1'){ // Somente Com Saldo
		//$consulta.= ' AND (prod_saldo.Saldo_Atual > 0)';
		$filtro.= ' "Somente c/ Saldo"';
	}else if($_REQUEST['estoque']=='2'){ // Somente Sem Saldo
		//$consulta.= ' AND (prod_saldo.Saldo_Atual = 0)';
		$filtro.= ' "Somente s/ Saldo"';
	}else if($_REQUEST['estoque']=='3'){ // Somente Com Saldo Negativo
		//$consulta.= ' AND (prod_saldo.Saldo_Atual < 0)';
		$filtro.= ' "Somente c/ Saldo Negativo"';
	}else if($_REQUEST['estoque']=='4'){ // Somente c/ Saldo no Mnimo
		$filtro.= ' "Somente c/ Saldo no Mnimo"';
	}else if($_REQUEST['estoque']=='5'){ // Somente c/ Saldo Abaixo do Mnimo
		$filtro.= ' "Somente c/ Saldo Abaixo do Mnimo"';
	}else if($_REQUEST['estoque']=='6'){ // Todos
		$filtro.= ' "Todos"';
	}else if($_REQUEST['estoque']=='7'){ // Todos (Zerar Negativos)
		$filtro.= ' "Todos (Zerar Negativos)"';
	}

	if ($_REQUEST['cod_fornec']!=''){
		$con_fornec = 'SELECT Pessoa, Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Pessoa = "'.$_REQUEST['cod_fornec'].'"';
		$res_fornec = consulta_sql($con_fornec);
		$reg_fornec = consulta_ler_linha($res_fornec);
		consulta_limpa($res_fornec);

		$filtro.= ' Fornecedor: '.$reg_fornec[1];
		$fornec = $_REQUEST['cod_fornec'];
	}

	$filtro.=' Preo: "'.busca_dados_combo('tipo_custo_preco', $_REQUEST['tipo_preco']).'"';

	if($_REQUEST['tipo_item'] != ''){
		$consulta.= ' AND prod.Tipo = "'.$_REQUEST['tipo_item'].'"';
		$filtro.=' Tipo: "'.busca_dados_combo('tipo_item', $_REQUEST['tipo_item']).'"';
	}

	$consulta.= ' GROUP BY prod_saldo.Id_Produto ';
	if(($_REQUEST['produto']!='')||($_REQUEST['empresa']=='S')){
		$consulta.= ', prod_saldo.Codigo_Empresa ';
	}
	//$consulta.= ' ORDER BY prod.Descricao_Completa, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	if($_REQUEST['agrupado']=='F'){
		$consulta.= ' ORDER BY prod.Codigo_Fornecedor, prod.Descricao_Completa, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	}else if($_REQUEST['agrupado']=='M'){
		$consulta.= ' ORDER BY ';
		if($_SESSION['Dominio'] == $dominios['187']){
			$consulta.= ' Desc_Marca, Codigo_Produto_Fornec';
		}
		$consulta.= ' prod.Marca,prod.Codigo_Fornecedor, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	}else if($_REQUEST['agrupado']=='D'){
		$consulta.= ' ORDER BY prod.Codigo_Depart, prod.Codigo_Grupo, prod.Codigo_Linha, prod.Descricao_Completa, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	}else if($_REQUEST['agrupado']=='C'){
		$consulta.= ' ORDER BY ';
		if($_SESSION['Dominio'] == $dominios['187']){
			$consulta.= 'prod_fornec.Codigo_Produto_Fornec,';
		}
		$consulta.= 'prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	}else{
		$consulta.= ' ORDER BY prod.Descricao_Completa, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	}
	//$consulta.= ' ORDER BY prod.Descricao_Completa, prod_saldo.Id_Produto, prod_saldo.Codigo_Empresa ';
	//echo $consulta;

	$filtro.= $filtro_depart;
	$filtro.= $filtro_marca;

	if($grupo!=''){
		if($grupo < 0){
			$cod_depart = '-1';
		}else{
			$cod_depart = key($depart);
		}
		$con_grupo = 'SELECT Descricao FROM produto_grupo '.
			   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
			   ' AND Codigo_Depart = "'.$cod_depart.'"'.
			   ' AND Codigo_Grupo = "'.$grupo.'"';
		$res_grupo = consulta_sql($con_grupo);
		$reg_grupo = consulta_ler_linha($res_grupo);
		consulta_limpa($res_grupo);
		$filtro.= ' Grupo: "'.$reg_grupo[0].'"';
	}

	if($linha!=''){
		$con_linha = 'SELECT Descricao FROM produto_linha '.
				   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' AND Codigo_Depart = "'.key($depart).'"'.
				   ' AND Codigo_Grupo = "'.$grupo.'"'.
				   ' AND Codigo_Linha = "'.$linha.'"';
		$res_linha = consulta_sql($con_linha);
		$reg_linha = consulta_ler_linha($res_linha);
		consulta_limpa($res_linha);
		$filtro.= ' Linha: "'.$reg_linha[0].'"';
	}

	$filtro.=' Estoque:';
	if($tipo=='S'){
		$filtro.= ' "Terceiro" ';
	}else if($tipo=='N'){
		$filtro.= ' "Prprio" ';
	}else {
		$filtro.= ' "Ambos" ';
	}

	$filtro.=' Situao:';
	if($situacao == ''){
		$filtro.= ' "Todos" ';
	}else if($situacao == 'A'){
		$filtro.= ' "Ativos" ';
	}else if($situacao == 'I'){
		$filtro.= ' "Inativos" ';
	}

	//$filtro.= 'Produto: "'.$_REQUEST['produto'].'-'.$reg_prod[1].' ('.$reg_prod[0].')"';

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotnum =& $workbook->add_format();
	$formatotnum->set_border(1);
	$formatotnum->set_align('right');
	//    $formatotnum->set_num_format('#,##0_);(#,##0)');
	$formatotnum->set_num_format('#,##0.000_);(#,##0.000)');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	// Format for the headings
	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//negritos
	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotbqtd =& $workbook->add_format();
	$formatotbqtd->set_border(1);
	$formatotbqtd->set_align('right');
	$formatotbqtd->set_bold(1);
	$formatotbqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	$formatotbnum =& $workbook->add_format();
	$formatotbnum->set_border(1);
	$formatotbnum->set_align('right');
	$formatotbnum->set_bold(1);
	//    $formatotbnum->set_num_format('#,##0_);(#,##0)');
	$formatotbnum->set_num_format('#,##0.000_);(#,##0.000)');

	$formatotbl =& $workbook->add_format();
	$formatotbl->set_border(1);
	$formatotbl->set_bold(1);

	$formatotbc =& $workbook->add_format();
	$formatotbc->set_border(1);
	$formatotbc->set_align('center');
	$formatotbc->set_bold(1);

	//formato para peneira
	$formatotlP =& $workbook->add_format();
	$formatotlP->set_border(1);
	$formatotlP->set_italic(1);

	// Format for the headings
	$formatotnumP =& $workbook->add_format();
	$formatotnumP->set_border(1);
	$formatotnumP->set_align('right');
	$formatotnumP->set_num_format('#,##0.000_);(#,##0.000)');
	$formatotnumP->set_italic(1);

	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$linha_ini = 11;

	if($nrows>0){
		$total_saldo = 0;
		$total_valor = 0;
		$soma_total = 0;

		$total_remessas = 0;

		$worksheet1->set_column(0,0,15); //Saldo Atual
		$worksheet1->write_string($linha_ini,0,'Cdigo',$formatott);
		//configura tamanho das colunas
		//$worksheet1->set_column(0,0,60); //Produto
		if(($_REQUEST['produto']!='')&&($_REQUEST['empresa']!='')){
			$worksheet1->set_column(1,1,70); //Produto
			$worksheet1->write_string($linha_ini,1,'Produto',$formatott);
		}else if ($_REQUEST['produto']!=''){
			$worksheet1->set_column(1,1,70); //Produto
			$worksheet1->write_string($linha_ini,1,'Empresa',$formatott);
		}else{ // if ($_REQUEST['empresa']!=''){
			$worksheet1->set_column(1,1,70); //Produto
			$worksheet1->write_string($linha_ini,1,'Produto',$formatott);
		}

		$worksheet1->set_column(2,2,15); //Saldo Atual
		$worksheet1->write_string($linha_ini,2,'Saldo Atual',$formatott);

		$worksheet1->set_column(3,3,15); //Custo/Venda
		$worksheet1->write_string($linha_ini,3, ($_REQUEST['tipo_preco'] == '0') ? 'Custo' : 'Preo', $formatott);

		$worksheet1->set_column(4,4,18); //Valor Total
		$worksheet1->write_string($linha_ini,4,'Valor Total',$formatott);

		$worksheet1->set_column(5,5,10); //Dt. Movto
		$worksheet1->write_string($linha_ini,5,'Dt. Movto',$formatott);

		$worksheet1->set_column(6,6,30); //Fornecedor
		$worksheet1->write_string($linha_ini,6,'Fornecedor',$formatott);

		$worksheet1->set_column(7,7,15); //Ponto de Pedido
		$worksheet1->write_string($linha_ini,7,'Ponto de Pedido',$formatott);

		$worksheet1->set_column(8,8,15); //Estoque Mnimo
		$worksheet1->write_string($linha_ini,8,'Estoque Mnimo',$formatott);

		$worksheet1->set_column(9,9,15); //Preo de Venda
		$worksheet1->write_string($linha_ini,9,'Preo de Venda',$formatott);

		$worksheet1->set_column(10,10,25); //Departamento
		$worksheet1->write_string($linha_ini,10,'Departamento',$formatott);

		$worksheet1->set_column(11,11,15); //Grupo
		$worksheet1->write_string($linha_ini,11,'Grupo',$formatott);

		$worksheet1->set_column(12,12,15); //Linha
		$worksheet1->write_string($linha_ini,12,'Linha',$formatott);

		$worksheet1->set_column(13,13,20); //Marca
		$worksheet1->write_string($linha_ini,13,'Marca',$formatott);

		$worksheet1->set_column(14,14,25); //Produto Fornecedor
		$worksheet1->write_string($linha_ini,14,'Cod. Prod. Fornec.',$formatott);

		$worksheet1->set_column(15,15,25); //Localizao
		$worksheet1->write_string($linha_ini,15,'Localizao',$formatott);	

		if($campos_remessas){
			$worksheet1->set_column(16,16,20); //Remessas em Aberto
			$worksheet1->write_string($linha_ini,16,'Remessas em Aberto',$formatott);

			$worksheet1->set_column(17,17,20); //Saldo s/ Remessas
			$worksheet1->write_string($linha_ini,17,'Saldo na Loja',$formatott);

			//consulta e monta array das resmessas

			$remessas = array();
			$con_notas_abertas = 'SELECT item.Id_Produto,sum(item.Quantidade_Estoque-item.Qtd_Devolvida)'.
							  ' FROM nota_fiscal nota '.
							  ' INNER JOIN nota_fiscal_item item '.
							  ' ON nota.Dominio=item.Dominio '.
							  ' AND nota.Empresa=item.Empresa '.
							  ' AND nota.Nr_Nota=item.Nr_Nota '.
							  ' WHERE nota.Dominio = "'.$_SESSION['Dominio'].'"'.
							  ' AND nota.Situacao="F" '.
							  ' AND ((nota.Nat_Op_CFOP="5.904") OR (nota.Nat_Op_CFOP="5.414"))';
			if($_REQUEST['empresa']!=''){
				$con_notas_abertas.= ' AND nota.Empresa = "'.$_REQUEST['empresa'].'"';
			}
			$con_notas_abertas.= ' AND item.Quantidade_Estoque>item.Qtd_Devolvida';
			$res_notas_abertas = consulta_sql($con_notas_abertas);
			$nrw_notas_abertas = consulta_num_registros($res_notas_abertas);
			for($rem=0;$rem<$nrw_notas_abertas;$rem++){
				$reg_notas_abertas = consulta_ler_linha($res_notas_abertas);
				$remessas[$reg_notas_abertas[0]] = $reg_notas_abertas[1];
			}
			consulta_limpa($res_notas_abertas);
		}

		$linha_ini++;

		for($i=0;$i<$nrows;$i++){
			$rowarr = consulta_ler_objeto($resultado);
			set_time_limit(30);

			$ok_linha = true;

			$con_desc = 'SELECT Descricao_Completa,Codigo_Produto,Terceiros,Codigo_Depart,Codigo_Fornecedor,Estoque_Minimo, '.
					 ' Estoque_Lote,Codigo_Grupo, Codigo_Linha,Marca FROM produto '.
					 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Id_Produto="'.$rowarr->Id_Produto.'"';
			$res_desc = consulta_sql($con_desc);
			$reg_desc = consulta_ler_linha($res_desc);
			consulta_limpa($res_desc);

			$cons_depart = 'SELECT Descricao, Controle_Lote FROM produto_departamento '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Depart = "'.$reg_desc[3].'"'.
						' AND Situacao = "A"';
			$res_depart = consulta_sql($cons_depart);
			$reg_depart = consulta_ler_linha($res_depart);
			consulta_limpa($res_depart);

			$cons_grupo = 'SELECT Descricao, Codigo_Grupo FROM produto_grupo '.
					   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' AND Codigo_Depart = "'.$reg_desc[3].'"'.
					   ' AND Codigo_Grupo = "'.$reg_desc[7].'"'.
					   ' AND Situacao = "A"';
			$res_grupo = consulta_sql($cons_grupo);
			$reg_grupo = consulta_ler_linha($res_grupo);
			consulta_limpa($res_grupo);

			$cons_linha = 'SELECT Descricao, Codigo_Linha FROM produto_linha '.
					   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' AND Codigo_Depart = "'.$reg_desc[3].'"'.
					   ' AND Codigo_Grupo = "'.$reg_desc[7].'"'.
					   ' AND Codigo_Linha = "'.$reg_desc[8].'"'.
					   ' AND Situacao = "A"';
			$res_linha = consulta_sql($cons_linha);
			$reg_linha = consulta_ler_linha($res_linha);
			consulta_limpa($res_linha);

			$cons_marca = 'SELECT Descricao, Codigo_Marca FROM produto_marca  '.
					   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' AND Codigo_Marca = "'.$reg_desc[9].'"'.
					   ' AND Situacao="A"';
			$res_marca = consulta_sql($cons_marca);
			$reg_marca = consulta_ler_linha($res_marca);
			consulta_limpa($res_marca);

			/* $con_prod_fornec = 'SELECT Codigo_Produto_Fornec FROM produto_fornecedor '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Id_Produto = "'.$rowarr->Id_Produto.'"'.
							' AND Codigo_Fornecedor = "'.$rowarr->Codigo_Fornecedor.'"'.
							' ORDER BY Id_Produto ASC LIMIT 1';
			$res_prod_fornec = consulta_sql($con_prod_fornec);
			$reg_prod_fornec = consulta_ler_linha($res_prod_fornec);
			consulta_limpa($res_prod_fornec); */

			if($tipo!='A'){
				$ok_linha = ($tipo==$reg_desc[2]);
			}
			if ($ok_linha){
				if ($depart!=''){
					$ok_linha = (isset($depart[$reg_desc[3]]));
				}
			}
			if($ok_linha){
				if($grupo != ''){
					$ok_linha = ($grupo == $reg_desc[7]);
				}
			}
			if($ok_linha){
				if($linha != ''){
					$ok_linha = ($linha == $reg_desc[8]);
				}
			}
			if($ok_linha){
				if($marca!=''){
					$ok_linha = (isset($marca[$reg_desc[9]]));
				}
			}
			if ($ok_linha){
				if ($fornec!=''){
					$ok_linha = ($fornec==$reg_desc[4]);
				}
			}
			if ($ok_linha){
				if($_REQUEST['estoque']=='1'){
					$ok_linha = ($rowarr->Saldo_Atual>0);
				}else if($_REQUEST['estoque']=='2'){
					$ok_linha = ($rowarr->Saldo_Atual==0);
				}else if($_REQUEST['estoque']=='3'){
					$ok_linha = ($rowarr->Saldo_Atual<0);
				}else if($_REQUEST['estoque']=='4'){
					$ok_linha = (($reg_desc[5]>0) && ($rowarr->Saldo_Atual==$reg_desc[5]));
				}else if($_REQUEST['estoque']=='5'){
					$ok_linha = (($reg_desc[5]>0) && ($rowarr->Saldo_Atual<$reg_desc[5]));
				}
			}

			//var_dump($i);
			//var_dump($ok_linha);

			if($ok_linha){
				if(($_REQUEST['produto']!='')&&($_REQUEST['empresa']!='')){
					$worksheet1->write_string($linha_ini,0,$reg_desc[1],$formatotqtd); //Codigo
					$desc_produto = $reg_desc[0];
					$worksheet1->write_string($linha_ini,1,$desc_produto,$formatotl); //Produto
				}else if ($_REQUEST['produto']!=''){
					$con_prod = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Pessoa = "'.$rowarr->Codigo_Empresa.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);

					$worksheet1->write_string($linha_ini,0,$reg_prod[1],$formatotqtd); //Codigo

					$desc_produto = $reg_prod[0];
					$worksheet1->write_string($linha_ini,1,$desc_produto,$formatotl); //Empresa
				}else{ // if ($_REQUEST['empresa']!=''){
					$worksheet1->write_string($linha_ini,0,$reg_desc[1],$formatotqtd); //Codigo

					$desc_produto = $reg_desc[0];
					$worksheet1->write_string($linha_ini,1,$desc_produto,$formatotl); //Produto
				}

				$total = $rowarr->Preco_Dinamico * $rowarr->Saldo_Atual;

				$worksheet1->write_number($linha_ini,2,$rowarr->Saldo_Atual,$formatotnum); //Saldo Atual
				$worksheet1->write_number($linha_ini,3,$rowarr->Preco_Dinamico,$formatotpreco);
				$worksheet1->write_number($linha_ini,4,$total,$formatotpreco);
				$worksheet1->write_string($linha_ini,5,dataf($rowarr->Data_Mov),$formatotc); //Dt. Movto

				$con_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
							  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							  ' AND Pessoa = "'.$rowarr->Codigo_Fornecedor.'"';
				$res_fornec = consulta_sql($con_fornec);
				$reg_fornec = consulta_ler_linha($res_fornec);
				consulta_limpa($res_fornec);
				$worksheet1->write_string($linha_ini,6,$rowarr->Codigo_Fornecedor.' - '.$reg_fornec[0],$formatotl); //Fornecedor

				$worksheet1->write_number($linha_ini,7,$rowarr->Ponto_Pedido,$formatotnum); //Ponto de Pedido
				$worksheet1->write_number($linha_ini,8,$rowarr->Estoque_Minimo,$formatotnum); //Estoque Minmo
				$worksheet1->write_number($linha_ini,9,$rowarr->Preco_Venda1,$formatotpreco); //Preco Venda
				$worksheet1->write_string($linha_ini,10,$reg_depart[0],$formatotl); //Departamento
				$worksheet1->write_string($linha_ini,11,$reg_grupo[0],$formatotl); //Grupo
				$worksheet1->write_string($linha_ini,12, $reg_linha[0],$formatotl); //Linha
				$worksheet1->write_string($linha_ini,13, $reg_marca[0],$formatotl); //Marca
				$worksheet1->write_string($linha_ini,14, $rowarr->Codigo_Produto_Fornec,$formatotl); //Produto Fornecedor

				if(($_REQUEST['produto']!='')||($_REQUEST['empresa']=='S')){
					$con_localizacao = 'SELECT Localizacao FROM produto_saldo_filial '.
								   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								   ' AND Codigo_Empresa = "'.$rowarr->Codigo_Empresa.'"'.
								   ' AND Id_Produto = "'.$rowarr->Id_Produto.'"'.
								   ' AND Local_Armaz = 0';
					$res_localizacao = consulta_sql($con_localizacao);
					$reg_localizacao = consulta_ler_linha($res_localizacao);
					consulta_limpa($res_localizacao);

					$con_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
								  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								  ' AND Pessoa = "'.$rowarr->Codigo_Empresa.'"';
					$res_fornec = consulta_sql($con_fornec);
					$reg_fornec = consulta_ler_linha($res_fornec);
					consulta_limpa($res_fornec);

					$reg_localizacao[0] = trim($reg_fornec[0].' '.$reg_localizacao[0]);
				}else{
					$con_localizacao = 'SELECT Localizacao FROM produto_saldo_filial '.
								   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								   ' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								   ' AND Id_Produto = "'.$rowarr->Id_Produto.'"'.
								   ' AND Local_Armaz = 0';
					$res_localizacao = consulta_sql($con_localizacao);
					$reg_localizacao = consulta_ler_linha($res_localizacao);
					consulta_limpa($res_localizacao);
				}

				$worksheet1->write_string($linha_ini,15, $reg_localizacao[0],$formatotl); //Localizao

				if($campos_remessas){
					if(isset($remessas[$rowarr->Id_Produto])){
						$qtd_remessas = $remessas[$rowarr->Id_Produto];
					}else{
						$qtd_remessas = 0;
					}
					$worksheet1->write_number($linha_ini,16,$qtd_remessas,$formatotnum); //Ponto de Pedido
					$worksheet1->write_number($linha_ini,17,$rowarr->Saldo_Atual - $qtd_remessas,$formatotnum); //Ponto de Pedido
					$total_remessas+= $qtd_remessas;
				}

				$linha_ini++;
				$total_valor+= $total;
				$total_saldo+= $rowarr->Saldo_Atual;

				if($_REQUEST['mostra_peneira']!='N'){
					$cons_depart2 = 'SELECT Descricao, Controle_Lote FROM produto_departamento '.
								   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								   ' AND Codigo_Depart = "'.$reg_desc[3].'"';
					$res_depart2 = consulta_sql($cons_depart2);
					$reg_depart2 = consulta_ler_linha($res_depart2);
					consulta_limpa($res_depart2);

					$tp_lote = $reg_depart2[1];
					if($reg_desc[6]!='N'){
						$tp_lote = $reg_desc[6];
					}

					if($_REQUEST['mostra_peneira']=='P'){
						$cons_peneira = 'SELECT Peneira, Saldo_Atual, Codigo_Empresa FROM produto_saldo_filial_peneira '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
						if(($_REQUEST['produto']!='')||($_REQUEST['empresa']=='S')){
							$cons_peneira.= ' AND Codigo_Empresa="'.$rowarr->Codigo_Empresa.'" ';
						}else if ($_REQUEST['empresa']!=''){
							$cons_peneira.= ' AND Codigo_Empresa="'.$_REQUEST['empresa'].'" ';
						}
						$cons_peneira.= ' AND Id_Produto = "'.$rowarr->Id_Produto.'" '.
										' AND Saldo_Atual <> 0 '.
										' order by Codigo_Empresa, Peneira';
						$res_peneira = consulta_sql($cons_peneira);
						$nrows_peneira = consulta_num_registros($res_peneira);

						if($nrows_peneira>0){
							for($p=0;$p<$nrows_peneira;$p++){
								$reg_peneira = consulta_ler_linha($res_peneira);

								$worksheet1->write_string($linha_ini,0,'',$formatotl);
								//echo 'Peneira'.$rowarr->Id_Produto;
								if($tp_lote=='F'){
									$worksheet1->write_string($linha_ini,1,'Frmula: '.$reg_peneira[0],$formatotlP);
								}else{
									$worksheet1->write_string($linha_ini,1,'Peneira: '.$reg_peneira[0],$formatotlP);
								}
								$worksheet1->write_number($linha_ini,2,$reg_peneira[1],$formatotnumP);

								for($a=3;$a<15;$a++){
									$worksheet1->write_string($linha_ini,$a,'',$formatotl);
								}

								$con_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
											  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
											  ' AND Pessoa = "'.$reg_peneira[2].'"';
								$res_fornec = consulta_sql($con_fornec);
								$reg_fornec = consulta_ler_linha($res_fornec);
								consulta_limpa($res_fornec);
								$worksheet1->write_string($linha_ini,15,$reg_fornec[0],$formatotlP);

								if($campos_remessas){
									for($a=16;$a<18;$a++){
										$worksheet1->write_string($linha_ini,$a,'',$formatotl);
									}
								}
								$linha_ini++;
							}
						}
						consulta_limpa($res_peneira);
					}

					if($_REQUEST['mostra_peneira']=='L'){
						$cons_peneira = 'SELECT Peneira, Saldo_Atual, NrLote, DT_Validade, Codigo_Empresa FROM produto_saldo_filial_lote '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
						if(($_REQUEST['produto']!='')||($_REQUEST['empresa']=='S')){
							$cons_peneira.= ' AND Codigo_Empresa="'.$rowarr->Codigo_Empresa.'" ';
						}else if ($_REQUEST['empresa']!=''){
							$cons_peneira.= ' AND Codigo_Empresa="'.$_REQUEST['empresa'].'" ';
						}
						$cons_peneira.= ' AND Id_Produto = "'.$rowarr->Id_Produto.'" '.
										' AND Saldo_Atual <> 0 '.
										' order by Codigo_Empresa, Peneira, NrLote';
						$res_peneira = consulta_sql($cons_peneira);
						$nrows_peneira = consulta_num_registros($res_peneira);

						if($nrows_peneira>0){
							for($p=0;$p<$nrows_peneira;$p++){
								$reg_peneira = consulta_ler_linha($res_peneira);

								$worksheet1->write_string($linha_ini,0,'',$formatotl);
								//echo 'Peneira'.$rowarr->Id_Produto;

								$valor1 = '';
								if($reg_peneira[0]!=''){
									if($tp_lote=='F'){
										$valor1 = 'Frmula: '.$reg_peneira[0];
									}else{
										$valor1 = 'Peneira: '.$reg_peneira[0];
									}
								}
								if($valor1!=''){
									$valor1.= '   ';
								}
								$valor1.= 'Lote: '.$reg_peneira[2];

								if($reg_peneira[3]!='0000-00-00'){
									$valor1.= '      Validade: '.dataf($reg_peneira[3]);
								}
								$worksheet1->write_string($linha_ini,1,$valor1,$formatotlP);

								$worksheet1->write_number($linha_ini,2,$reg_peneira[1],$formatotnumP);

								for($a=3;$a<15;$a++){
									$worksheet1->write_string($linha_ini,$a,'',$formatotl);
								}

								$con_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
											  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
											  ' AND Pessoa = "'.$reg_peneira[4].'"';
								$res_fornec = consulta_sql($con_fornec);
								$reg_fornec = consulta_ler_linha($res_fornec);
								consulta_limpa($res_fornec);
								
								$worksheet1->write_string($linha_ini,15,$reg_fornec[0],$formatotlP);

								if($campos_remessas){
									for($a=16;$a<18;$a++){
										$worksheet1->write_string($linha_ini,$a,'',$formatotl);
									}
								}
								$linha_ini++;
							}
						}
						consulta_limpa($res_peneira);
					}
				}

				if($_REQUEST['mostra_barras'] != 'N'){

					$cons_peneira = 'SELECT Codigo_Barras, Saldo_Atual,Codigo_Empresa FROM produto_saldo_filial_barra '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
					if(($_REQUEST['produto']!='')||($_REQUEST['empresa']=='S')){
						$cons_peneira.=' AND Codigo_Empresa="'.$rowarr->Codigo_Empresa.'" ';
					}else if ($_REQUEST['empresa']!=''){
						$cons_peneira.= ' AND Codigo_Empresa="'.$_REQUEST['empresa'].'" ';
					}
					$cons_peneira.=' AND Id_Produto = "'.$rowarr->Id_Produto.'" '.
								   ' AND Saldo_Atual <> 0 '.
								   ' order by Codigo_Empresa, Codigo_Barras';
					$res_peneira = consulta_sql($cons_peneira);
					$nrows_peneira = consulta_num_registros($res_peneira);

					if($nrows_peneira>0){
						for($p=0;$p<$nrows_peneira;$p++){
							$reg_peneira = consulta_ler_linha($res_peneira);

							$con_barra = 'SELECT Complemento FROM produto_cod_barras '.
										 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										 ' AND Id_Produto = "'.$rowarr->Id_Produto.'" '.
										 ' AND Codigo_Barras = "'.$reg_peneira[0].'"';
							$res_barra = consulta_sql($con_barra);
							$reg_barra = consulta_ler_linha($res_barra);
							consulta_limpa($res_barra);

							$valor1 = trim($reg_peneira[0].' '.$reg_barra[0]);
							$worksheet1->write_string($linha_ini,0,'',$formatotl);
							$worksheet1->write_string($linha_ini,1,$valor1,$formatotlP);
							$worksheet1->write_number($linha_ini,2,$reg_peneira[1],$formatotnumP);

							for($a=3;$a<15;$a++){
								$worksheet1->write_string($linha_ini,$a,'',$formatotl);
							}
							$con_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
										  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										  ' AND Pessoa = "'.$reg_peneira[2].'"';
							$res_fornec = consulta_sql($con_fornec);
							$reg_fornec = consulta_ler_linha($res_fornec);
							consulta_limpa($res_fornec);
							$worksheet1->write_string($linha_ini,15,$reg_fornec[0],$formatotlP);
							if($campos_remessas){
								for($a=16;$a<18;$a++){
									$worksheet1->write_string($linha_ini,$a,'',$formatotl);
								}
							}
							$linha_ini++;
						}
					}
					consulta_limpa($res_peneira);
				}
			}
		}

		//TOTAIS
		$worksheet1->set_column(4,4,18);
		$worksheet1->write_string($linha_ini,0,'TOTAL',$formatotbc);
		$worksheet1->write_string($linha_ini,1,'',$formatotbc);
		$worksheet1->write_number($linha_ini,2,$total_saldo,$formatotbnum);
		$worksheet1->write_string($linha_ini,3,'',$formatotbc);
		$worksheet1->write_number($linha_ini,4,$total_valor,$formatotbpreco);

		$worksheet1->write_string($linha_ini,5,'',$formatotbc);
		$worksheet1->write_string($linha_ini,6,'',$formatotbc);
		$worksheet1->write_string($linha_ini,7,'',$formatotbc);
		$worksheet1->write_string($linha_ini,8,'',$formatotbc);
		$worksheet1->write_string($linha_ini,9,'',$formatotbc);
		$worksheet1->write_string($linha_ini,10,'',$formatotbc);
		$worksheet1->write_string($linha_ini,11,'',$formatotbc);
		$worksheet1->write_string($linha_ini,12,'',$formatotbc);
		$worksheet1->write_string($linha_ini,13,'',$formatotbc);
		$worksheet1->write_string($linha_ini,14,'',$formatotbc);
		$worksheet1->write_string($linha_ini,15,'',$formatotbc);

		if($campos_remessas){
			$worksheet1->write_number($linha_ini,16,$total_remessas,$formatotbnum);
			$worksheet1->write_number($linha_ini,17,$total_saldo-$total_remessas,$formatotbnum);
		}
		$linha_ini++;
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}
	consulta_limpa($resultado);
	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();
?>