<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	require_once('relatorio_estoque_fisico_func.php'); 

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('POSICAO_ESTOQUE.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'EST FSICO';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,'RELATRIO DE POSIO DE ESTOQUE FSICO',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotnum =& $workbook->add_format();
	$formatotnum->set_border(1);
	$formatotnum->set_align('right');
	//    $formatotnum->set_num_format('#,##0_);(#,##0)');
	$formatotnum->set_num_format('#,##0.000_);(#,##0.000)');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0_);[Red]-#,##0_)');

	// Format for the headings
	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//negritos
	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotbqtd =& $workbook->add_format();
	$formatotbqtd->set_border(1);
	$formatotbqtd->set_align('right');
	$formatotbqtd->set_bold(1);
	$formatotbqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	$formatotbnum =& $workbook->add_format();
	$formatotbnum->set_border(1);
	$formatotbnum->set_align('right');
	$formatotbnum->set_bold(1);
	//$formatotbnum->set_num_format('#,##0_);(#,##0)');
	$formatotbnum->set_num_format('#,##0.000_);(#,##0.000)');

	$formatotbl =& $workbook->add_format();
	$formatotbl->set_border(1);
	$formatotbl->set_bold(1);

	$formatotbc =& $workbook->add_format();
	$formatotbc->set_border(1);
	$formatotbc->set_align('center');
	$formatotbc->set_bold(1);

	//formato para peneira
	$formatotlP =& $workbook->add_format();
	$formatotlP->set_border(1);
	$formatotlP->set_italic(1);

	// Format for the headings
	$formatotnumP =& $workbook->add_format();
	$formatotnumP->set_border(1);
	$formatotnumP->set_align('right');
	$formatotnumP->set_num_format('#,##0.000_);(#,##0.000)');
	$formatotnumP->set_italic(1);	

	set_time_limit(60);

	$linha_ini=10;

	$exibidos =0;
	if ($nrw_mov>0){
		$ncampos = 6;
		$nr_linha = 0;

		foreach($lista_dados as $produto => $valor){
			set_time_limit(60);
			$lns = 0;
			$k = 0;
			$nr_linha = 0;

			$array_prod = $lista_dados[$produto];
			if ($array_prod['Cargas']>0){

				//if($exibidos==0){

				$worksheet1->set_column($k,$k,15); //Produto
				$worksheet1->write_string($linha_ini,$k,'Produto',$formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				$worksheet1->set_column($k,$k,12); //Data
				$worksheet1->write_string($linha_ini,$k,'Data',$formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				$worksheet1->set_column($k,$k,15); //Saldo Atual
				$worksheet1->write_string($linha_ini,$k,'Saldo Inicial',$formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				$worksheet1->set_column($k,$k,15); //Entradas
				$worksheet1->write_string($linha_ini,$k, 'Entradas', $formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				$worksheet1->set_column($k,$k,15); //Saidas
				$worksheet1->write_string($linha_ini,$k,'Saidas',$formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				$worksheet1->set_column($k,$k,15); //Saldo Final
				$worksheet1->write_string($linha_ini,$k,'Saldo Final',$formatott);
				$worksheet1->merge_cells($linha_ini, $k, $linha_ini+1, $k);   
				$worksheet1->write_blank($linha_ini+1,$k,$formatott);
				$k++;

				foreach($lista_emp as $empresa => $valorE){
					$worksheet1->set_column($k,$k,15); //Fornecedor
					$worksheet1->set_column($k+1,$k+1,15); //Fornecedor
					$worksheet1->write_string($linha_ini,$k, $valorE, $formatott);
					$worksheet1->merge_cells($linha_ini, $k, $linha_ini, $k+1);   
					$worksheet1->write_blank($linha_ini,$k+1,$formatott);

					$worksheet1->write_string($linha_ini+1,$k,'Entradas',$formatott);
					$k++;

					$worksheet1->write_string($linha_ini+1,$k,'Sadas',$formatott);
					$k++;
				}
				//}
				$linha_ini++;
				$linha_ini++;

				$con_grupo = 'select Descricao from produto_grupo '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Depart = "'.$array_prod['Codigo_Depart'].'"'.
							' and Codigo_Grupo = "'.$array_prod['Codigo_Grupo'].'"';
				$res_grupo = consulta_sql($con_grupo);
				$reg_grupo = consulta_ler_linha($res_grupo);
				consulta_limpa($res_grupo);

				$datas = $array_prod['Periodos'];
				foreach($datas as $data => $valor2){
					set_time_limit(60);

					$dados_data = $datas[$data];
					$nr_linha++;

					$k = 0;

					$worksheet1->write_string($linha_ini,$k,$reg_grupo[0],$formatotl); //Codigo
					$k++;

					$worksheet1->write_string($linha_ini,$k,$dados_data['Data'],$formatotc); //Data
					$k++;

					$worksheet1->write_number($linha_ini,$k,$dados_data['Inicial'],$formatotqtd); //Inicial
					$k++;

					if ($dados_data['Entrada']>0){
						$worksheet1->write_number($linha_ini,$k,$dados_data['Entrada'],$formatotqtd); //Inicial
					}else{
						$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Inicial
					}
					$k++;

					if ($dados_data['Saida']>0){
						$worksheet1->write_number($linha_ini,$k,$dados_data['Saida'],$formatotqtd); //Inicial
					}else{
						$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Inicial
					}
					$k++;

					$worksheet1->write_number($linha_ini,$k,$dados_data['Final'],$formatotqtd); //Inicial
					$k++;

					foreach($lista_emp as $empresa => $valorE){	
						if (isset($dados_data['Empresas'][$empresa])){
							if ($dados_data['Empresas'][$empresa]['Entrada']>0){
								$worksheet1->write_number($linha_ini,$k,$dados_data['Empresas'][$empresa]['Entrada'],$formatotqtd); //Inicial
							}else{
								$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Entrada
							}
							$k++;
							
							if ($dados_data['Empresas'][$empresa]['Saida']>0){
								$worksheet1->write_number($linha_ini,$k,$dados_data['Empresas'][$empresa]['Saida'],$formatotqtd); //Inicial
							}else{
								$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Saida
							}
							$k++;
						}else{
							$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Entrada
							$k++;
							
							$worksheet1->write_string($linha_ini,$k,'',$formatotqtd); //Saida
							$k++;
						}
					}//foreach($lista_emp
					$exibidos++;
					$linha_ini++;
				}//foreach($datas
			}
			
			$linha_ini++;
		}
	}

	if($exibidos==0){
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();
?>