<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID']) ){
	require_once('relatorio_estoque_retro_funcao.php');

	$pdf = new FPDF();
	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio de Posio de Estoque';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  'Saldo Retroativo do Dia '.$_REQUEST['dt_ini'];
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'C';
	$pdf->Sub_Cabecalho_Border =  0;
	$valor_total = 0;
	$qtd_total = 0;
	$largura=0;

	set_time_limit(60);

	if($registros>0){
		$k=0;

		$pdf->CabecalhoGrid_Texto[$k] = 'Produto';
		$pdf->CabecalhoGrid_Tamanho[$k] = '60';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Saldo';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Custo';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Vl. Total';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);
		$pdf->SetAutoPageBreak(true,30);
		$ncampos = 4;

		foreach($lista_produtos as $chave => $registro){
			set_time_limit(60);
			$ok_linha = true;
			if($ok_linha){
				$lns = 0;
				$larg = 190;

				$k=0;
				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1,$lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				$rowarr[$k]  =  $registro['Codigo'].'-'.$registro['Descricao'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$rowarr[$k] = $registro['Saldo'];
			   
				//Saldo Atual
				$rowarr[$k]  =  formata_qtd($rowarr[$k],3,false);
				if($negativo){
					$rowarr[$k] = '-'.$rowarr[$k];
				}
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				//Custo
				$rowarr[$k]  =  str_replace('"','',to_money($registro['Custo']));
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$total = $registro['Custo'] * $registro['Saldo'];
				$qtd = $registro['Saldo'];
				//Valor Total
				$rowarr[$k]  =  str_replace('"','',to_money($total));
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$lns = $lns * 4;

				for($k=0;$k<$ncampos;$k++){
					$valor = $vl_linha[$k];
					$y=$pdf->y;
					$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190, ($lns/($lns_linha[$k]* 5)) * 5, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
					$pdf->y=$y;
				}

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$valor_total += $total;
				$qtd_total += $qtd;
			}
		}

		$lns = 5;

		$pdf->Cell(1,$lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$largura=60;
		$pdf->MultiCell(($largura/100)*190, 5, 'TOTAL', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((10/100)*190, 5, formata_qtd($qtd_total,3,false), 'T', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*190, 5, '', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*190, 5, str_replace('"','',to_money($valor_total)), 'T', 'R');
		$pdf->y=$y;

		$pdf->Cell(1,$lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>