<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	$dominios = array();
	$dominios['271'] = '271';

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	require_once('relatorio_fluxo_caixa_pr_function.php');

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('FLUXO_CAIXA.xls');

	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$empresa = $_REQUEST['empresa'];
	$vl_inicial = str2nr(formata_valor($_REQUEST['vl_inicial']));

	$dados = montarRelatorio($dt_ini, $dt_fim, $empresa, $vl_inicial);

	$filtro = $dados['Filtro'];
	$lista_geral = $dados['Dados'];

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'FLUXO CAIXA';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO FLUXO DE CAIXA (PAGAR E RECEBER)',$formatot);
	//$worksheet1->write_string(0,0,'RELATRIO DE KARDEX',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$worksheet1->write(7,0,"Filtro: ".$filtro);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	// Format for the headings
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco_b =& $workbook->add_format();
	$formatotpreco_b->set_border(1);
	$formatotpreco_b->set_align('right');
	$formatotpreco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$formatotpreco_b->set_bold(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	// Format for the headings
	$formatot_blank =& $workbook->add_format();
	$formatot_blank->set_border(0);
	$formatot_blank->set_align('left');

	if(!empty($lista_geral)){
		$coluna = 0;
		$linha_ini = 9;

		$worksheet1->set_column($coluna,$coluna, 10);
		$worksheet1->write_string($linha_ini,$coluna,'Data',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 20);
		$worksheet1->write_string($linha_ini,$coluna,'Saldo Inicial',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 20);
		$worksheet1->write_string($linha_ini,$coluna,'Contas a Pagar',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 20);
		$worksheet1->write_string($linha_ini,$coluna,'Contas a Receber',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 20);
		$worksheet1->write_string($linha_ini,$coluna,'Saldo Dirio',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 20);
		$worksheet1->write_string($linha_ini,$coluna,'Acumulado',$formatott);
		$coluna++;

		$linha_ini++;

		$valorTotalGeral = 0;
		foreach($lista_geral as $registro){
			$coluna = 0;

			$receber = $registro['Receber'];
			$pagar = $registro['Pagar'];

			$worksheet1->write_number($linha_ini,$coluna,data2nr(dataf($registro['DT_Contas'])),$formato_data);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$vl_inicial,$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$pagar,$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$receber,$formatotpreco);
			$coluna++;

			$diferenca = ($receber - $pagar);

			if(($diferenca < 0.0001) && (($diferenca > (-0.0001)))){
				$diferenca = 0;
			}

			$worksheet1->write_number($linha_ini,$coluna,$diferenca,$formatotpreco);
			$coluna++;

			$vl_final = ($vl_inicial + $diferenca);
			$vl_inicial = $vl_final;

			$worksheet1->write_number($linha_ini,$coluna,$vl_final,$formatotpreco);
			$coluna++;

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			  ' Dominio, '.
			  ' Usuario, '.
			  ' Descricao ) values ('.
			  '"'.$_SESSION['Dominio'].'", '.
			  '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			  '"")';
	consulta_sql($insert);

	$workbook->close();
?>