<?php
	require_once('../../includes/base_class.inc');
	require_once('../../includes/header.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
	require_once('relatorio_fluxo_caixa_pr_function.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$empresa = $_REQUEST['empresa'];
	$vl_inicial = str2nr(formata_valor($_REQUEST['vl_inicial']));

	$dados = montarRelatorio($dt_ini, $dt_fim, $empresa, $vl_inicial);

	$filtro = $dados['Filtro'];
	$lista_geral = $dados['Dados'];

	//var_dump2($lista_geral);

	$pdf = new FPDF();
	$pdf->Open();
	$pdf->Cabecalho = 'Relatrio Fluxo de Caixa (Pagar e Receber)';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	set_time_limit(60);

	if(!empty($lista_geral)){
		$lns = 0;
		$k = 0;
		$pdf->CabecalhoGrid_Texto = '';

		$pdf->CabecalhoGrid_Texto[$k] = 'Data';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Saldo Inicial';
		$pdf->CabecalhoGrid_Tamanho[$k] = '17';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Contas a Pagar';
		$pdf->CabecalhoGrid_Tamanho[$k] = '17';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Contas a Receber';
		$pdf->CabecalhoGrid_Tamanho[$k] = '17';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Saldo Dirio';
		$pdf->CabecalhoGrid_Tamanho[$k] = '17';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Acumulado';
		$pdf->CabecalhoGrid_Tamanho[$k] = '17';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos = 6;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$lns = 5;
		$larg = 190;

		$linha = 0;
		foreach($lista_geral as $registro){
			$receber = $registro['Receber'];
			$pagar = $registro['Pagar'];

			$lns = 0;
			$k = 0;

			$pdf->SetFont('Arial','',7);
			$pdf->Cell(1,      $lns, '', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',7);

			$rowarr[$k]  = dataf($registro['DT_Contas']);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = to_money($vl_inicial, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = to_money($pagar, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = to_money($receber, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$diferenca = ($receber - $pagar);

			if(($diferenca < 0.0001) && (($diferenca > (-0.0001)))){
				$diferenca = 0;
			}

			$rowarr[$k] = to_money($diferenca, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$vl_final = ($vl_inicial + ($diferenca));
			$vl_inicial = $vl_final;

			$rowarr[$k] = to_money($vl_final, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$lns = $lns * 5;

			for($k=0; $k<$ncampos; $k++){
				($linha % 2 == 0) ? $fundo = 1 : $fundo = 0;
				$pdf->SetFillColor(225,225,225);

				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k], $fundo);
				$pdf->y=$y;
			}

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);

			$linha++;
		}
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>