<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('ABASTECIMENTOS.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'FROTA_ABASTECIMENTOS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE ABASTECIMENTOS DA FROTA',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$label = label_vendedor_ou_rep_comercial('S');
	$codigo = base64_decode_si($_REQUEST['codigo']);
	$filtro = '';

	$consulta = 'select * from veiculo_abastece '.
				' where Dominio="'.$_SESSION["Dominio"].'"'.
				' and Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
				' and Veiculo="'.$codigo.'"'.
				' and Situacao="A"'.
				' AND Tipo_Combustivel<>"5"'.
				' order by Data DESC, Seq_Abastece DESC'.
				' LIMIT 100';

	$filtro.= 'Veculo: '.busca_dados_combo('select Seq_Veiculo, Placa from pessoa_transportador_veiculo '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Pessoa="'.$_SESSION['Empresa_Codigo'].'" '.
											' order by Placa',$codigo);

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Formato cabecalho
	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_bold(1);
	$fmt_cabec->set_border(1);

	// Formato texto
	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_border(1);
	$fmt_txt_c->set_align('center');

	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_align('left');

	$fmt_txt_l_b =& $workbook->add_format();
	$fmt_txt_l_b->set_border(1);
	$fmt_txt_l_b->set_size(10);
	//$fmt_txt_l_b->set_align('left');
	$fmt_txt_l_b->set_bold(1);

	// Formato quantidade
	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('center');
	//$fmt_qtd->set_num_format('#.##0,00_);-#.##0,00_)');
	//$fmt_qtd->set_num_format('#,##0_);-#,##0_)');
	$fmt_qtd->set_num_format('#,##0.0#_);-#,##0.0#_)');

	$fmt_qtd_b =& $workbook->add_format();
	$fmt_qtd_b->set_border(1);
	$fmt_qtd_b->set_align('center');
	$fmt_qtd_b->set_bold(1);
	$fmt_qtd_b->set_num_format('#,##0.0#_);-#,##0.0#_)');

	/*
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0_);-#,##0_)');

	$formatotqtdb =& $workbook->add_format();
	$formatotqtdb->set_border(1);
	$formatotqtdb->set_align('right');
	$formatotqtdb->set_size(10);
	$formatotqtdb->set_bold(1);
	$formatotqtdb->set_num_format('#,##0_);(-#,##0_)');
	*/
	// 3 casas
	$fmt_qtd3 =& $workbook->add_format();
	$fmt_qtd3->set_border(1);
	$fmt_qtd3->set_align('right');
	$fmt_qtd3->set_num_format('#,##0_);(#,##0)');

	$fmt_qtd3_b =& $workbook->add_format();
	$fmt_qtd3_b->set_border(1);
	$fmt_qtd3_b->set_bold(1);
	$fmt_qtd3_b->set_align('right');
	$fmt_qtd3_b->set_num_format('#,##0.000_);(#,##0.000)');

	// Formato preco/valor
	$fmt_preco =& $workbook->add_format();
	$fmt_preco->set_border(1);
	$fmt_preco->set_align('right');
	$fmt_preco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_preco3 =& $workbook->add_format();
	$fmt_preco3->set_border(1);
	$fmt_preco3->set_align('right');
	$fmt_preco3->set_num_format('R$ #,##0.000_);(R$ #,##0.000)');

	$fmt_preco_b =& $workbook->add_format();
	$fmt_preco_b->set_border(1);
	$fmt_preco_b->set_align('right');
	$fmt_preco_b->set_bold(1);
	$fmt_preco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$linha_ini = 10;

	if ($nrows>0){
		$coluna=0;
		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Data',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,9);
		$worksheet1->write_string($linha_ini,$coluna,'KM',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Litro',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Total',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Mdia KM/L',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Combustvel',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'NrDoc',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Local',$fmt_cabec);
		$coluna++;

		$linha_ini++;
		$valor_total = 0;

		for ($i=0;$i<$nrows;$i++){
			$registro = consulta_ler_objeto($resultado);
			set_time_limit(30);

			$coluna=0;
			$worksheet1->write_string($linha_ini,$coluna,dataf($registro->Data),$fmt_txt_c);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro->KM,$fmt_qtd3);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro->Valor_Unitario,$fmt_preco3);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro->Valor_Total,$fmt_preco);
			$coluna++;

			$con_km = 'select KM from veiculo_abastece '.
					  ' where Dominio="'.$_SESSION['Dominio'].'"'.
					  ' and Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
					  ' and Veiculo="'.$codigo.'"'.
					  ' and Data <= "'.$registro->Data.'"'.
					  ' and KM < "'.$registro->KM.'"'.
					  ' and Situacao <> "E"'.
					  ' order by Data DESC, Seq_Abastece DESC'.
					  ' LIMIT 1';
			$res_km = consulta_sql($con_km);
			$reg_km = consulta_ler_linha($res_km);
			consulta_limpa($res_km);
			//Mdia Km Litros (KmCadastrada - KmAnterior / Qtd_Litros (cadastrada))
			if($reg_km[0]>0){
				$media_km = (($registro->KM-$reg_km[0])/$registro->Litros);
				$worksheet1->write_number($linha_ini,$coluna,$media_km,$fmt_qtd);
			}else{
				$media_km = '';
				$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_c);
			}
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,busca_dados_combo('tipo_combustivel',$registro->Tipo_Combustivel),$fmt_txt_c);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro->NrDoc,$fmt_txt_c);
			$coluna++;

			$cons_cliente = 'select Nome_Listas from pessoa where Dominio = "'.$_SESSION['Dominio'].'" and Pessoa = "'.$registro->Local.'"';
			$res_cliente = consulta_sql($cons_cliente);
			$reg_cliente = consulta_ler_linha($res_cliente);
			consulta_limpa($res_cliente);
			$worksheet1->write_string($linha_ini,$coluna,$registro->Local.'-'.$reg_cliente[0],$fmt_txt_l);
			$coluna++;

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}
	consulta_limpa($resultado);
	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			  ' Dominio, '.
			  ' Usuario, '.
			  ' Descricao ) values ('.
			  '"'.$_SESSION['Dominio'].'", '.
			  '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			  '"")';
	consulta_sql($insert);
	$workbook->close();
?>