<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');
    
	$filtro = '';

    $veiculo = $_REQUEST['veiculo'];
    $dt_ini = $_REQUEST['dt_ini'];
    $dt_fim = $_REQUEST['dt_fim'];
    $local = $_REQUEST['pessoa'];
   
    $info_abastece = array();
    $array_km_anterior = array();

    //para verificar se existe registro anterior de KM 
    /*
    SELECT Veiculo, MAX(Data) as MaxData, KM , Seq_Abastece FROM veiculo_abastece 
            WHERE Dominio="'.$_SESSION['Dominio'].'"'.
            ' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
            ' AND Data < "'.datad($dt_ini).'"'.
            ' AND Tipo_Combustivel <>"5" ';
    if( $local != '' ){
        $con_km.=' AND Local= "'.$local.'" ';
    }
    if( $veiculo != '' ){
        $con_km.= ' AND Veiculo="'.$veiculo.'"';
    }
    $con_km.=' AND Situacao <> "E"'.
            ' GROUP BY Veiculo ORDER BY MaxData ASC ';
    */



    $con_km=' SELECT va.Veiculo, va.Data, va.KM, va.seq_abastece '.
            ' FROM veiculo_abastece va '.
            ' JOIN ('.
                ' SELECT Veiculo, MAX(Data) as MaxData'.
                ' FROM veiculo_abastece'.
                ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                ' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
                ' AND Data < "'.datad($dt_ini).'"'.
                ' AND Tipo_Combustivel <> "5" '.
                ' AND Situacao <> "E" ';
    if( $veiculo != '' ){
        $con_km.= ' AND Veiculo="'.$veiculo.'"';
    }
    $con_km.= ' GROUP BY Veiculo'.
            ' ) subq ON va.Veiculo = subq.Veiculo AND va.Data = subq.MaxData'.
            ' WHERE va.Dominio="'.$_SESSION['Dominio'].'"'.
            ' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
            ' AND va.Data< "'.datad($dt_ini).'" '.
            ' AND va.Tipo_Combustivel <> "5"  ';
    if( $veiculo != '' ){
        $con_km.= ' AND va.Veiculo="'.$veiculo.'"';
    }
    $con_km.= ' AND va.Situacao <> "E" ORDER BY `va`.`Veiculo` ASC';
    $res_km = consulta_sql($con_km);  
    $num_km = consulta_num_registros( $res_km );
    
    if( $num_km > 0 ){
        for ($i=0;$i<$num_km;$i++){
            $reg_km = consulta_ler_linha($res_km);
            $k_veiculo = $reg_km[0];
            if( !isset(  $array_km_anterior[$k_veiculo])){
                $array_km_anterior[$k_veiculo]['kmAnterior']= $reg_km[2];
                $array_km_anterior[$k_veiculo]['DataAnterior']= $reg_km[1];
                $array_km_anterior[$k_veiculo]['veiculo']= $reg_km[0];
                $array_km_anterior[$k_veiculo]['seq']= $reg_km[3];
            }
        }
    }
    consulta_limpa($res_km);
    //Mdia Km Litros (KmCadastrada - KmAnterior / Qtd_Litros (cadastrada))
    
    /**Para descobrir quais as informaes de cada carro */
    $info_descricao = array();
    $con_veiculo='SELECT Seq_Veiculo, Tipo_Veiculo, Placa, Veiculo_Marca, Veiculo_Modelo  '. 
                ' FROM  pessoa_transportador_veiculo '.
                ' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
                ' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'" '.
                ' AND Situacao="A" ';
    if( $veiculo != '' ){
        $con_veiculo.= ' AND Seq_Veiculo="'.$veiculo.'"';
    }
    $con_veiculo.=' ORDER BY  Seq_Veiculo ';
    $res_veiculo = consulta_sql($con_veiculo);
    $nro_veiculo = consulta_num_registros($res_veiculo);
    for($v=0;$v<$nro_veiculo;$v++){
		$reg_veiculoDesc = consulta_ler_linha($res_veiculo);
		
        $k_vDescricao  = $reg_veiculoDesc[0];
        if( !isset($info_descricao [$k_vDescricao])){
            $info_descricao[$k_vDescricao]['veiculo']= $k_vDescricao;
            $info_descricao[$k_vDescricao]['tipo']= $reg_veiculoDesc[1];
            $info_descricao[$k_vDescricao]['tipoDescricao']= busca_dados_combo('tipo_veiculo',$reg_veiculoDesc[1] );;
            $info_descricao[$k_vDescricao]['placa']= $reg_veiculoDesc[2];
            $info_descricao[$k_vDescricao]['marca']= $reg_veiculoDesc[3];
            $info_descricao[$k_vDescricao]['modelo']= $reg_veiculoDesc[4];
        }
	}    
    consulta_limpa($res_veiculo);

    /**Consulta dos registros conforme filtro */
    $consulta = 'SELECT * FROM veiculo_abastece '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
                ' AND Situacao="A"';
    if( $veiculo != ''){
        $consulta .=' AND Veiculo="'.$_REQUEST['veiculo'].'"';
        $filtro.= ' Veculo: '.$_REQUEST['veiculo'];
    }else{
        $filtro.= ' Toda a frota ';
    }
    if($dt_ini != ''){
        $consulta .= ' AND Data >= "'.datad($dt_ini).'"';
        $filtro.= ' Perodo De: "'.$dt_ini.'"';
	}
    if($dt_fim != ''){
        $consulta .= ' AND Data <= "'.datad($dt_fim ).'"';
        $filtro.= ' At: "'.$dt_fim.'"';
	}
    $consulta .=' order by Data , Seq_Abastece ';
    // echo  $consulta ;
    
    /**
     * 
     * SELECT * FROM veiculo_abastece  WHERE Dominio="214" AND Pessoa="1" AND Situacao="A" AND Data >= "2020-01-01" AND Data <= "2023-12-21" order by Data 
     */


    $resultado = consulta_sql($consulta);
    $nrows = consulta_num_registros($resultado);
    
    $cont_abastece=0;
    $cont_manutencao=0;
    if ($nrows>0){
        for ($i=0;$i<$nrows;$i++){
           
			$registro = consulta_ler_objeto($resultado);
			set_time_limit(30);

            $chave_veiculo = $registro->Veiculo;
            $chave_veiculo_seq= $registro->Seq_Abastece;

            if( !isset($info_abastece[$chave_veiculo]) ){
                if (!isset($info_descricao[$chave_veiculo]['veiculoDescricao'])){
                    $info_abastece[$chave_veiculo]['veiculoDescricao'] = $info_descricao[$chave_veiculo]['placa'] .' - '. $info_descricao[$chave_veiculo]['marca'].'('.$info_descricao[$chave_veiculo]['tipoDescricao'].')';
                }else{
                    $info_abastece[$chave_veiculo]['veiculoDescricao'] = 'Veculo No Cadastrado';
                }
                $info_abastece[$chave_veiculo]['abastece'] = array();
                $info_abastece[$chave_veiculo]['manutencao'] = array();
            } 
            
            if( $registro->Tipo_Combustivel != 5 ){
                $cont_abastece++;
                
                $cons_cliente = 'select Nome_Listas from pessoa where Dominio = "'.$_SESSION['Dominio'].'" and Pessoa = "'.$registro->Local.'"';
                $res_cliente = consulta_sql($cons_cliente);
                $reg_cliente = consulta_ler_linha($res_cliente);
                consulta_limpa($res_cliente);

                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['veiculo'] = $registro->Veiculo;

                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['seq'] = $registro->Seq_Abastece;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['data'] = $registro->Data;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['km'] = $registro->KM;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['litros'] = $registro->Litros;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['vl_unit'] = $registro->Valor_Unitario;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['vl_total'] = $registro->Valor_Total;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['local'] = $registro->Local;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['tipoC'] = $registro->Tipo_Combustivel;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['doc'] = $registro->NrDoc;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['obs'] = $registro->Observacao;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['nomeC'] = busca_dados_combo('tipo_combustivel',$registro->Tipo_Combustivel);
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['local'] = $registro->Local;
                $info_abastece[$chave_veiculo]['abastece'][$chave_veiculo_seq]['localNome'] = $reg_cliente[0];
            }else{
                $cont_manutencao++;
                

                if( !isset($info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq])){
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['veiculo'] = $registro->Veiculo;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['seq'] = $registro->Seq_Abastece;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['data'] = $registro->Data;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['km'] = $registro->KM;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['litros'] = $registro->Litros;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['vl_unit'] = $registro->Valor_Unitario;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['vl_total'] = $registro->Valor_Total;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['local'] = $registro->Local;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['tipoC'] = $registro->Tipo_Combustivel;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['doc'] = $registro->NrDoc;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['obs'] = $registro->Observacao;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['nomeC'] = busca_dados_combo('tipo_combustivel',$registro->Tipo_Combustivel);
                    $cons_cliente = 'select Nome_Listas from pessoa where Dominio = "'.$_SESSION['Dominio'].'" and Pessoa = "'.$registro->Local.'"';
                    $res_cliente = consulta_sql($cons_cliente);
                    $reg_cliente = consulta_ler_linha($res_cliente);
                    consulta_limpa($res_cliente);
    
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['local'] = $registro->Local;
                    $info_abastece[$chave_veiculo]['manutencao'][$chave_veiculo_seq]['localNome'] = $reg_cliente[0];
    
                }
            }
        }
        consulta_limpa($resultado);
    }


    // HTTP headers
	HeaderingExcel('ControleDeFrota.xls');
    //Aqui Comeca o abastecimento

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'ABASTECIMENTOS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);
    
    // Formato cabecalho
	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_bold(1);
	$fmt_cabec->set_border(1);

    $fmt_titulo =& $workbook->add_format();
    $fmt_titulo->set_align('left');
    $fmt_titulo->set_bold(1);
    $fmt_titulo->set_size(12);

	// Formato texto
	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_border(1);
	$fmt_txt_c->set_align('center');

	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_align('left');

	$fmt_txt_l_b =& $workbook->add_format();
	$fmt_txt_l_b->set_border(1);
	$fmt_txt_l_b->set_size(10);
	//$fmt_txt_l_b->set_align('left');
	$fmt_txt_l_b->set_bold(1);

	// Formato quantidade
	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('center');
	$fmt_qtd->set_num_format('#,##0.0#_);-#,##0.0#_)');

	$fmt_qtd_b =& $workbook->add_format();
	$fmt_qtd_b->set_border(1);
	$fmt_qtd_b->set_align('center');
	$fmt_qtd_b->set_bold(1);
	$fmt_qtd_b->set_num_format('#,##0.0#_);-#,##0.0#_)');

	// 3 casas
	$fmt_qtd3 =& $workbook->add_format();
	$fmt_qtd3->set_border(1);
	$fmt_qtd3->set_align('right');
	$fmt_qtd3->set_num_format('#,##0_);(#,##0)');

	$fmt_qtd3_b =& $workbook->add_format();
	$fmt_qtd3_b->set_border(1);
	$fmt_qtd3_b->set_bold(1);
	$fmt_qtd3_b->set_align('right');
	$fmt_qtd3_b->set_num_format('#,##0.000_);(#,##0.000)');

	// Formato preco/valor
	$fmt_preco =& $workbook->add_format();
	$fmt_preco->set_border(1);
	$fmt_preco->set_align('right');
	$fmt_preco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_preco3 =& $workbook->add_format();
	$fmt_preco3->set_border(1);
	$fmt_preco3->set_align('right');
	$fmt_preco3->set_num_format('R$ #,##0.000_);(R$ #,##0.000)');

	$fmt_preco_b =& $workbook->add_format();
	$fmt_preco_b->set_border(1);
	$fmt_preco_b->set_align('right');
	$fmt_preco_b->set_bold(1);
	$fmt_preco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

    $formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_size(14);
	//$formatotlb->set_align('left');
	$formatotlb->set_bold(1);


    //parte a ser replicada em cada aba 
    $worksheet1->write_string(0,0,'RELATRIO DE ABASTECIMENTOS DA FROTA',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
    $worksheet1->write(7,0,"Filtro: ".$filtro);
    
    $linha_ini = 9;
    if( $cont_abastece >0 ){

        $coluna=0;
        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'Data',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,15);
        $worksheet1->write_string($linha_ini,$coluna,'KM',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'Valor Litro',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,14);
        $worksheet1->write_string($linha_ini,$coluna,'Valor Total',$fmt_cabec);
        $coluna++;
        /** A mdia de km por litro */
        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'Mdia KM/L',$fmt_cabec);
        $coluna++;
        
        
        $worksheet1->set_column($coluna,$coluna,20);
        $worksheet1->write_string($linha_ini,$coluna,'Combustvel',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'NrDoc',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,40);
        $worksheet1->write_string($linha_ini,$coluna,'Local',$fmt_cabec);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,15);
        $worksheet1->write_string($linha_ini,$coluna,'KM Rodados',$fmt_cabec);
        $coluna++;
        
        $worksheet1->set_column($coluna,$coluna,10);
        $worksheet1->write_string($linha_ini,$coluna,'Litros',$fmt_cabec);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,10);
        $worksheet1->write_string($linha_ini,$coluna,'KM Acum.',$fmt_cabec);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,15);
        $worksheet1->write_string($linha_ini,$coluna,'Litros Acum.',$fmt_cabec);
        $coluna++;

        $worksheet1->set_column($coluna,$coluna,12);
        $worksheet1->write_string($linha_ini,$coluna,'Mdia KM/L',$fmt_cabec);
        $coluna++;

        $linha_ini++;
    }else{
        $worksheet1->write(10,0,"No existem registros para este filtro!");
    }

    $km_rodados = 0;   
    $km_acumulado = 0;  
    $litro_acumulado = 0; 
    $media_acumulado = 0; 
    $veiculo_atual = 0 ;
    
    $info_abastece  = array_orderby($info_abastece , 'veiculoDescricao', SORT_ASC);
    $litros_acumulados= array();

    set_time_limit(30);
    foreach(  $info_abastece as $k => $value ){
        if( $value['abastece'] ){
            $coluna=0;
            $worksheet1->write_string($linha_ini,$coluna,'Veculo: '.  $value['veiculoDescricao'] ,$formatotlb);
            $veiculo_atual = $value['veiculo'];
            $worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+11);
            for($la=0;$la<=11;$la++){
                $coluna++;
                $worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
            }
        }
        $coluna++;
        $linha_ini++;
        
        $seqAbastecimento = $value['abastece'];
        foreach( $seqAbastecimento  as $Abastece => $value){
            $coluna=0;
            $worksheet1->write_string($linha_ini,$coluna,dataf($value['data'] ),$fmt_txt_c);
            $coluna++;
            
            $worksheet1->write_number($linha_ini,$coluna, $value['km'] ,$fmt_qtd3);
            $coluna++;
                
            $worksheet1->write_number($linha_ini,$coluna, $value['vl_unit'],$fmt_preco3);
            $coluna++;
                
            $worksheet1->write_number($linha_ini,$coluna, $value['vl_total'],$fmt_preco);
            $coluna++;
            
            /* Descobrir a km anterior dos veiculos para gerar a media por km */            
            (  $array_km_anterior[$value['veiculo']]['kmAnterior'] >0) ? $media = (($value['km']- $array_km_anterior[$value['veiculo']]['kmAnterior'])/$value['litros']): $media = 0 ;
            $worksheet1->write_number($linha_ini,$coluna, $media , $fmt_qtd );
            $coluna++;
                
                
            $worksheet1->write_string($linha_ini,$coluna,  $value['nomeC'] ,$fmt_txt_c);
            $coluna++;
                
            $worksheet1->write_string($linha_ini,$coluna, $value['doc'] ,$fmt_txt_c);
            $coluna++;
                
            $worksheet1->write_string($linha_ini,$coluna, $value['local'].'-'. $value['localNome'] ,$fmt_txt_l);
            $coluna++;
             
            /**Km rodados  */
            $km_rodados =  $value['km'] -  $array_km_anterior[$value['veiculo']]['kmAnterior'];
            $worksheet1->write_number($linha_ini,$coluna, $km_rodados , $fmt_qtd3 );
            $coluna++;
                
            $worksheet1->write_number($linha_ini,$coluna, $value['litros'], $fmt_qtd );
            $coluna++;
                
            $km_acumulado += $km_rodados;
            $worksheet1->write_number($linha_ini,$coluna,  $km_acumulado, $fmt_qtd3 );
            $coluna++;
                
            $litros_acumulados[$value['veiculo']] += $value['litros'];
            $litro_acumulado += $value['litros'];
            $worksheet1->write_number($linha_ini,$coluna, $litro_acumulado, $fmt_qtd );
            $coluna++;
                
            $media_acumulado= ($km_acumulado/ $litro_acumulado ) ;
            $worksheet1->write_number($linha_ini,$coluna,  $media_acumulado , $fmt_qtd );
            $coluna++;
                
            $array_km_anterior[$value['veiculo']]['kmAnterior'] = $value['km'];
            $data_anterior  = $value['data'];
            $linha_ini++;
        }
    }
    //At aqui vai o ABASTECIMENTO


    ////////////////////////////////////////////////////////////////////////
    // Aqui comea o Movimento
    $cons_movto = 'SELECT * FROM veiculo_movto '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Pessoa="'.$_SESSION['Empresa_Codigo'].'"'.
				' AND Situacao="A"';

    if( $veiculo != ''){
        $cons_movto .=' AND Veiculo="'.$_REQUEST['veiculo'].'"';
        $filtro.= ' Veculo: '.$_REQUEST['veiculo'];
    }else{
        $filtro.= ' Movimento de toda a frota ';
    }
                
    if($dt_ini != ''){
        $cons_movto .=	' AND Data_Saida>= "'.datad($dt_ini).'"';
    }
    if($dt_fim != ''){
        $cons_movto .=	' AND Data_Saida<= "'.datad($dt_fim).'"';
    }
    $cons_movto .=	' order by Data_Saida DESC, KM_Saida DESC, Seq_Mov DESC';

	$worksheet1 =& $workbook->add_worksheet( 'MOVIMENTO');

	$worksheet1->write_string(0,0,'RELATRIO DE MOVIMENTO DA FROTA',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
    $worksheet1->write(7,0,"Filtro: ".$filtro);

    $res_movto = consulta_sql($cons_movto);
	$nrows_movto = consulta_num_registros($res_movto);
	$linha_ini = 9;

    if ($nrows_movto>0){
		$coluna=0;
		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Data Sada',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'KM Sada',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Data Retorno',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'KM Retorno',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'KM Rodado',$fmt_cabec);
		$coluna++;
        $worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'KM Acumulado',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Motorista',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'NrDoc',$fmt_cabec);
		$coluna++;
        
        $linha_ini++;
        $km_acum_movto = 0 ;

		for ($i=0;$i<$nrows_movto;$i++){
			$reg_movto = consulta_ler_objeto($res_movto);
			set_time_limit(30);

            /**Adicionar o veiculo  */
            $coluna=0;
            $worksheet1->write_string($linha_ini,$coluna,'Veculo: '.  $info_descricao[$reg_movto->Veiculo]['placa'] .' - '. $info_descricao[$reg_movto->Veiculo]['marca'].'('.$info_descricao[$reg_movto->Veiculo]['tipoDescricao'].')',$formatotlb);
           
            $worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+6);
            for($la=0;$la<=6;$la++){
                $coluna++;
                $worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
            }
            $linha_ini++;

			$coluna=0;
			$worksheet1->write_string($linha_ini,$coluna,dataf($reg_movto->Data_Saida),$fmt_txt_c);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$reg_movto->KM_Saida,$fmt_qtd3);
			$coluna++;

			$dt_retorno = '';
			if($reg_movto->Data_Retorno!='0000-00-00'){
				$dt_retorno = dataf($reg_movto->Data_Retorno);
			}
			$worksheet1->write_string($linha_ini,$coluna,$dt_retorno,$fmt_txt_c);
			$coluna++;

			if($reg_movto->KM_Retorno>0){
				$worksheet1->write_number($linha_ini,$coluna,$reg_movto->KM_Retorno,$fmt_qtd3);
			}else{
				$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_c);
			}
			$coluna++;

			if($reg_movto->KM_Retorno>0){                      
				$km_rodado = ($reg_movto->KM_Retorno-$reg_movto->KM_Saida);
				$worksheet1->write_number($linha_ini,$coluna,$km_rodado,$fmt_qtd3);
			}else{
                $km_rodado=0;
				$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_c);
			}
			$coluna++;

            $km_acum_movto+= $km_rodado;
            $worksheet1->write_number($linha_ini,$coluna, $km_acum_movto ,$fmt_qtd3);
            $coluna++;

			$cons_cliente = 'select Nome_Listas from pessoa where Dominio = "'.$_SESSION['Dominio'].'" and Pessoa = "'.$reg_movto->Motorista.'"';
			$res_cliente = consulta_sql($cons_cliente);
			$reg_cliente = consulta_ler_linha($res_cliente);
			consulta_limpa($res_cliente);
			$worksheet1->write_string($linha_ini,$coluna,$reg_movto->Motorista.'-'.$reg_cliente[0],$fmt_txt_l);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$reg_movto->NrDoc,$fmt_txt_c);
			$coluna++;

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}
    //At aqui vai o Movimento



    ////////////////////////////////////////////////////////////////////////
    // Aqui comea o Manuteno
    $worksheet1 =& $workbook->add_worksheet( 'MANUTENO' );
    
    $worksheet1->write_string(0,0,'RELATRIO DE MANUTENO DA FROTA',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
    $worksheet1->write(7,0,"Filtro: ".$filtro);

    /* 
    $worksheet1->set_column(0,0,12);
	$worksheet1->write_string(8,0,'Placa:', $fmt_titulo );
    $worksheet1->set_column(1,1,12);
	$worksheet1->write_string(8,1,$reg_veiculo[2], $fmt_titulo );

    $worksheet1->set_column(4,4,12);
	$worksheet1->write_string(8,4,'Veculo:', $fmt_titulo );
    $worksheet1->set_column(5,5,12);
	$worksheet1->write_string(8,5, busca_dados_combo('tipo_veiculo',$reg_veiculo[1]) , $fmt_titulo );
    */

    if ( $cont_manutencao>0 ){
        $linha_ini = 9 ;
		$coluna=0;
		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Data',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,15);
		$worksheet1->write_string($linha_ini,$coluna,'km',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,15);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Total',$fmt_cabec);
		$coluna++;
        
        $worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Peas/Servios',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'NrDoc',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,50);
		$worksheet1->write_string($linha_ini,$coluna,'Fornecedor',$fmt_cabec);
		$coluna++;

        $worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Acumulado',$fmt_cabec);
		$coluna++;

		$linha_ini++;
    }else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

    if( $cont_manutencao>0 ){
        $valor_total = 0;
        
        foreach ( $info_abastece as $Manutencao => $valueM){
            if($valueM['manutencao']){
                $coluna=0;
                $worksheet1->write_string($linha_ini,$coluna,'Veculo: '.  $valueM['veiculoDescricao'] ,$formatotlb);
           
                $worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+6);
                for($la=0;$la<=6;$la++){
                    $coluna++;
                    $worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
                }
                $linha_ini++;

            }
            $seqManutencao  = $valueM['manutencao'];
            foreach( $seqManutencao as $Manutencao2 => $manutencao){
                set_time_limit(30);
                $coluna=0;
                $worksheet1->write_string($linha_ini,$coluna,dataf($manutencao['data'] ),$fmt_txt_c);
                $coluna++;

                $worksheet1->write_number($linha_ini,$coluna,$manutencao['km'],$fmt_qtd3);
                $coluna++;
                
                $worksheet1->write_number($linha_ini,$coluna,$manutencao['vl_total'],$fmt_preco);
                $coluna++;

                $worksheet1->write_string($linha_ini,$coluna, $manutencao['obs'], $fmt_txt_l);
                $coluna++;
                
                $worksheet1->write_string($linha_ini,$coluna,$manutencao['doc'],$fmt_txt_c);
                $coluna++;

                if( $manutencao['local'] > 0){
                    $worksheet1->write_string($linha_ini,$coluna,$manutencao['local'].'-'.$manutencao['localNome'],$fmt_txt_l);
                }else{
                    $worksheet1->write_string($linha_ini,$coluna, '' ,$fmt_txt_l);
                }
                $coluna++;
                $valor_total += $manutencao['vl_total'];
                $worksheet1->write_number($linha_ini,$coluna, $valor_total, $fmt_preco );
                $coluna++;
                $linha_ini++;

            }
        }
    }
    //At aqui vai a Manuteno
    
    //ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			  ' Dominio, '.
			  ' Usuario, '.
			  ' Descricao ) values ('.
			  '"'.$_SESSION['Dominio'].'", '.
			  '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			  '"")';
	consulta_sql($insert);
	$workbook->close();
?>