<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	set_time_limit(60);

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('LUCRO.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'RELATRIO DE MARGEM DE LUCRO';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	if($_SESSION['Dominio'] == '2'){
		//$worksheet1->insert_bitmap(0,6,'../../../arquivos_clientes/'.$_SESSION['Dominio'].'/empresa/logo_menu.bmp',0,0, 0.25, 1);
	}
	$worksheet1->write_string(0,0,'RELATRIO DE MARGEM DE LUCRO',$formatot);
	//$worksheet1->write_string(0,0,'RELATRIO DE KARDEX',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	// Format for the headings
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco_b =& $workbook->add_format();
	$formatotpreco_b->set_border(1);
	$formatotpreco_b->set_align('right');
	$formatotpreco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$formatotpreco_b->set_bold(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	$formato_hora =& $workbook->add_format();
	$formato_hora->set_border(1);
	$formato_hora->set_align('center');
	$formato_hora->set_num_format('hh:mm:ss');

	// Format for the headings
	$formatot_blank =& $workbook->add_format();
	$formatot_blank->set_border(0);
	$formatot_blank->set_align('left');

	$fmt_perc =& $workbook->add_format();
	$fmt_perc->set_border(1);
	$fmt_perc->set_align('right');
	$fmt_perc->set_num_format('0.00%;-0.00%');

	$fmt_perc_b =& $workbook->add_format();
	$fmt_perc_b->set_border(1);
	$fmt_perc_b->set_align('right');
	$fmt_perc_b->set_num_format('0.00%;-0.00%');
	$fmt_perc_b->set_bold(1);

	$empresa = $_REQUEST['empresa'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];
	$produto = $_REQUEST['produto'];
	$fornecedor = $_REQUEST['fornecedor'];
	$tipo_preco_custo = $_REQUEST['tipo_preco_custo']; // D - Dia da venda; A - Atual

	$hr_ini = $_REQUEST['hr_ini'];
	$hr_fim = $_REQUEST['hr_fim'];

	$hr_ini_bd = $hr_ini.':00';
	$hr_fim_bd = $hr_fim.':59';

	$custo_atual = ($tipo_preco_custo == 'A');
	$lista_geral = array();

	$consulta = 'SELECT TipoES, NrDoc, Modelo, Serie, Destinatario, Dest_Razao, '.
			   ' DH_EntSai AS DH_Emissao, Empresa, Nr_Nota, '.
			   ' Vendedor, Vendedor_Nome, '.
			   ' Total_Desconto, Total_Produtos, Total_NF '.
			   ' FROM nota_fiscal '.
			   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
	if($empresa != ''){
		$consulta.= ' AND Empresa = "'.$empresa.'" ';

		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					  ' AND Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);

		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	$consulta.= ' AND ((Nat_Op_CFOP <> "5.929") AND (Nat_Op_CFOP <> "6.929")) '.
			   ' AND Situacao = "F" ';

	if(($data_ini != '') || ($data_fim != '')){
		$filtro.= ' Data:';
		if($data_ini != ''){
			$consulta.= ' AND DATE(DH_EntSai) >= "'.datad($data_ini).'" ';
			$filtro.= ' De: "'.$data_ini.'"';
		}

		if($data_fim!=''){
			$consulta.= ' AND DATE(DH_EntSai) <= "'.datad($data_fim).'" ';
			$filtro.= ' At: "'.$data_fim.'"';
		}
		if(($hr_ini != '') || ($hr_fim != '')){
			$filtro.= ' Hora:';

			if($hr_ini != ''){
				$consulta.= ' AND TIME(DH_EntSai) >= "'.$hr_ini_bd.'" ';
				$filtro.= ' De: "'.$hr_ini.'"';
			}

			if($hr_fim != ''){
				$consulta.= ' AND TIME(DH_EntSai) <= "'.$hr_fim_bd.'" ';
				$filtro.= ' At: "'.$hr_fim.'"';
			}
		}
	}

	if($vendedor != ''){
		$consulta.= ' AND Vendedor = "'.$vendedor.'" ';
		$label_emp = empresa_representante($vendedor);
		$filtro.= ' '.$label.': "'.$label_emp.'"';
	}

	if($cliente != ''){
		$consulta.= ' AND Destinatario = "'.$cliente.'" ';

		$cons_cliente = 'SELECT Nome_Razao FROM pessoa '.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					  ' AND Pessoa = "'.$cliente.'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);

		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';
	}

	if($produto != ''){
		$con_prod = 'SELECT Codigo_Produto, Descricao_Completa FROM produto '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' AND Id_Produto = "'.$_REQUEST['produto'].'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		$filtro.= ' Produto: '.$reg_prod[0].'-'.$reg_prod[1];
	}
	$consulta.= ' ORDER BY Destinatario, DH_Emissao, Empresa, Nr_Nota ';
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$c = 0;
	for($k=0;$k<$nrows;$k++){
		$registro = consulta_ler_objeto($resultado);

		$indice = 1;
		//if($registro->TipoES == '0'){
		//	$indice = -1;
		//}

		$cons_item = 'SELECT Seq_Item, Id_Produto, Codigo_Produto, Prod_Descricao, '.
				   ' Quantidade_Estoque, Unidade_Estoque, '.
				   ' Valor_Unitario, Valor_Total, Valor_Outros, ICMSST_Valor, IPI_Valor, Valor_Frete, '.
				   ' Valor_Seguro, Valor_Desconto, Qtd_Devolvida, Preco_Custo '.
				   ' FROM nota_fiscal_item '.
				   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' AND Empresa = "'.$registro->Empresa.'" '.
				   ' AND Nr_Nota = "'.$registro->Nr_Nota.'" '.
				   ' AND Prod_Depart <> 0 '.
				   ' AND Id_Produto > 0 ';
		if($produto != ''){
			$cons_item.= ' AND Id_Produto = "'.$produto.'" ';
		}

		$indice = 1;

		$cfopGeraContas = 'R';
		if($registro->TipoES == '0'){
			$cfopGeraContas = 'A';
			$indice = -1;
		}

		$cons_item.= ' AND CFOP_Gera_Contas = "'.$cfopGeraContas.'"';

		$res_item = consulta_sql($cons_item);
		$nrows_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrows_item;$i++){
			$reg_item = consulta_ler_objeto($res_item);

			$ok = true;

			$con_prod = 'SELECT Codigo_Produto, Descricao_Completa, Codigo_Fornecedor, Preco_Custo, Marca FROM produto '.
					 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Id_Produto = "'.$reg_item->Id_Produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			if($fornecedor != ''){
				$ok = ($fornecedor == $reg_prod[2]);
			}

			if($ok){
				$preco_custo = $reg_item->Preco_Custo;
				if($custo_atual){
					$preco_custo = $reg_prod[3];
				}
				
				$valorTotal = ($reg_item->Valor_Total + $reg_item->Valor_Outros + $reg_item->ICMSST_Valor + $reg_item->IPI_Valor + $reg_item->Valor_Frete + $reg_item->Valor_Seguro);

				//$reg_item->Valor_Total + $reg_item->Valor_Outros + $reg_item->ICMSST_Valor + $reg_item->IPI_Valor + $reg_item->Valor_Frete + $reg_item->Valor_Seguro

				//$valor_unitario = (($reg_item->Valor_Unitario + $reg_item->Valor_Outros) - $reg_item->Valor_Desconto);
				$valor_unitario = $reg_item->Valor_Unitario;
				$valor_custo = ($reg_item->Quantidade_Estoque * $preco_custo);
				$valor_total_liquido = $valorTotal;

				$valor_desc_acre = ($reg_item->Valor_Outros - $reg_item->Valor_Desconto);

				$margem = ($valor_total_liquido - $valor_custo);
				$margem_perc = 0;
				if($valor_custo > 0){
					//$margem_perc = ((($margem * 100) / $valor_custo) / 100);
					$margem_perc = ($margem / $valor_custo);
				}

				$marcaDescricao = '';
				if($reg_prod[4] > 0){
					$conMarca = 'SELECT Descricao FROM produto_marca '.
							   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							   ' AND Codigo_Marca = "'.$reg_prod[4].'"';
					$resMarca = consulta_sql($conMarca);
					$regMarca = consulta_ler_linha($resMarca);
					consulta_limpa($resMarca);

					$marcaDescricao = $regMarca[0];
				}

				$lista_geral[$c]['DH_Emissao'] = $registro->DH_Emissao;
				$lista_geral[$c]['Nota_Cupom'] = $registro->NrDoc.'/'.$registro->Serie.'-'.$registro->Modelo;
				$lista_geral[$c]['Id_Produto'] = $reg_item->Id_Produto;
				$lista_geral[$c]['Codigo_Produto'] = $reg_item->Codigo_Produto;
				$lista_geral[$c]['Produto_Descricao'] = $reg_prod[0].'-'.$reg_prod[1];
				$lista_geral[$c]['Quantidade'] = $reg_item->Quantidade_Estoque * $indice;
				$lista_geral[$c]['Valor_Unitario'] = $valor_unitario * $indice;
				$lista_geral[$c]['Valor_Desc_Acre'] = $valor_desc_acre * $indice;
				$lista_geral[$c]['Valor_Total_Liquido'] = $valor_total_liquido * $indice;
				$lista_geral[$c]['Valor_Total_Bruto'] = ($valorTotal + $reg_item->Valor_Desconto) * $indice;
				$lista_geral[$c]['Valor_Custo'] = $valor_custo * $indice;
				$lista_geral[$c]['Margem'] = $margem * $indice;
				$lista_geral[$c]['Margem_Perc'] = $margem_perc * $indice;
				$lista_geral[$c]['Marca_Descricao'] = $marcaDescricao;

				$c++;
			}
		}
	}
	consulta_limpa($resultado);

	//--------------------------------------------------------------------------------------------------------------
	$consulta = 'SELECT Empresa, COO as NrDoc, "2D" as Modelo, Pessoa, DT_Emissao, Vendedor, COO, LetraMF, NrFab, TIME(DH_Movto) AS HR_Emissao '.
			   ' FROM ecf_cupom '.
			   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" ';

	if($empresa != ''){
		$consulta.= ' AND Empresa = "'.$empresa.'"';
	}

	if(($data_ini != '') || ($data_fim != '')){
		if($data_ini != ''){
			$consulta.= ' AND DT_Emissao >= "'.datad($data_ini).'" ';
		}
		if($data_fim!=''){
			$consulta.= ' AND DT_Emissao <= "'.datad($data_fim).'" ';
		}
		if(($hr_ini != '') || ($hr_fim != '')){
			if($hr_ini != ''){
				$consulta.= ' AND TIME(DH_Movto) >= "'.$hr_ini_bd.'" ';
			}
			if($hr_fim != ''){
				$consulta.= ' AND TIME(DH_Movto) <= "'.$hr_fim_bd.'" ';
			}
		}

	}

	if($cliente != ''){
		$consulta.= ' AND Pessoa = "'.$cliente.'"';
	}

	if($vendedor != ''){
		$consulta.= ' AND Vendedor = "'.$vendedor.'"';
	}

	$consulta.= ' AND Cancelado = "N"'.
				' ORDER BY Dominio, Empresa, NrFab, DT_Emissao, COO';
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$tipo = array();
	$con_tipo = 'SELECT Empresa, NrFab, LetraMF, NrCaixa FROM ecf '.
			   ' WHERE Dominio="'.$_SESSION["Dominio"].'"';
	$res_tipo = consulta_sql($con_tipo);
	$nrw_tipo = consulta_num_registros($res_tipo);
	for($t=0;$t<$nrw_tipo;$t++){
		$reg_tipo = consulta_ler_linha($res_tipo);
		$tipo[$reg_tipo[0].'_'.$reg_tipo[1].'_'.$reg_tipo[2]] = $reg_tipo[3];
	}
	consulta_limpa($res_tipo);

	for($k=0;$k<$nrows;$k++){
		$registro = consulta_ler_objeto($resultado);
		$vl_seq = cupom_fiscal_calcula_desc_acre_proporcional($registro->Empresa,$registro->NrFab,$registro->DT_Emissao,$registro->COO,0,0);

		$cons_item= 'SELECT Seq_Item, Id_Produto, Codigo_Produto, Descricao_Produto, '.
				  ' Quantidade, Unidade_Medida, '.
				  ' Preco, ValorTotal, Desconto, Preco_Custo, Acrescimo '.
				  ' FROM ecf_cupom_item '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' AND Empresa = "'.$registro->Empresa.'"'.
				  ' AND NrFab = "'.$registro->NrFab.'"'.
				  ' AND LetraMF = "'.$registro->LetraMF.'"'.
				  ' AND DT_Emissao = "'.$registro->DT_Emissao.'"'.
				  ' AND COO = "'.$registro->COO.'"'.
				  ' AND Cancelado = "N" ';
		if($produto != ''){
			$cons_item.= ' AND Id_Produto = "'.$produto.'" ';
		}
		$res_item = consulta_sql($cons_item);
		$nrows_item = consulta_num_registros($res_item);
		for($e=0;$e<$nrows_item;$e++){
			$reg_item = consulta_ler_objeto($res_item);
			$ok = true;

			$con_prod = 'SELECT Codigo_Produto, Descricao_Completa, Codigo_Fornecedor, Preco_Custo, Marca FROM produto '.
					 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Id_Produto = "'.$reg_item->Id_Produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			if($fornecedor != ''){
				$ok = ($fornecedor == $reg_prod[2]);
			}

			if($ok){
				$preco_custo = $reg_item->Preco_Custo;
				if($custo_atual){
					$preco_custo = $reg_prod[3];
				}

				$valor_desc_acre = $vl_seq[$reg_item->Seq_Item]['d'];
				//se for acrscimo
				//if($valor_desc_acre < 0){
				$valor_desc_acre = ($valor_desc_acre * (-1));
				//}
				$valor_unitario = $reg_item->Preco;
				$valor_custo = ($reg_item->Quantidade * $preco_custo);
				$valor_total_liquido = ($reg_item->ValorTotal + $valor_desc_acre);

				$margem = ($valor_total_liquido - $valor_custo);
				$margem_perc = 0;
				if($valor_custo > 0){
					//$margem_perc = ((($margem * 100) / $valor_custo) / 100);
					$margem_perc = ($margem / $valor_custo);
				}

				$nr_caixa = 1;
				if(isset($tipo[$reg_item->Empresa.'_'.$reg_item->NrFab.'_'.$reg_item->LetraMF])){
					$nr_caixa = $tipo[$reg_item->Empresa.'_'.$reg_item->NrFab.'_'.$reg_item->LetraMF];
				}

				$marcaDescricao = '';
				if($reg_prod[4] > 0){
					$conMarca = 'SELECT Descricao FROM produto_marca '.
							   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							   ' AND Codigo_Marca = "'.$reg_prod[4].'"';
					$resMarca = consulta_sql($conMarca);
					$regMarca = consulta_ler_linha($resMarca);
					consulta_limpa($resMarca);

					$marcaDescricao = $regMarca[0];
				}

				$lista_geral[$c]['DH_Emissao'] = $registro->DT_Emissao.' '.$registro->HR_Emissao;
				$lista_geral[$c]['Nota_Cupom'] = $registro->NrDoc.'/'.$nr_caixa.'-'.$registro->Modelo;
				$lista_geral[$c]['Id_Produto'] = $reg_item->Id_Produto;
				$lista_geral[$c]['Codigo_Produto'] = $reg_item->Codigo_Produto;
				$lista_geral[$c]['Produto_Descricao'] = $reg_prod[0].'-'.$reg_prod[1];
				$lista_geral[$c]['Quantidade'] = $reg_item->Quantidade;
				$lista_geral[$c]['Valor_Unitario'] = $valor_unitario;
				$lista_geral[$c]['Valor_Desc_Acre'] = $valor_desc_acre;
				$lista_geral[$c]['Valor_Total_Liquido'] = $valor_total_liquido;
				$lista_geral[$c]['Valor_Total_Bruto'] = $reg_item->ValorTotal;
				$lista_geral[$c]['Valor_Custo'] = $valor_custo;
				$lista_geral[$c]['Margem'] = $margem;
				$lista_geral[$c]['Margem_Perc'] = $margem_perc;
				$lista_geral[$c]['Marca_Descricao'] = $marcaDescricao;

				$c++;
			}
		}
	}
	//var_dump($lista_geral);

	$worksheet1->write(7,0,"Filtro: ".$filtro);
	$linha_ini = 9;

	if(!empty($lista_geral)){
		$coluna = 0;
		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Data',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,8);
		$worksheet1->write_string($linha_ini,$coluna,'Hora',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Cupom/NF',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Cdigo',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Descrio',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Qtde',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Unitrio',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Venda Lquida',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,25);
		$worksheet1->write_string($linha_ini,$coluna,'Desconto/Acrscimo',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Venda Bruta',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Custo',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Margem',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'(%)',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,30);
		$worksheet1->write_string($linha_ini,$coluna,'Marca',$formatott);
		$coluna++;

		$worksheet1->repeat_rows(0,$linha_ini);
		$linha_ini++;

		$lista_empresas = lista_empresas();

		$total_liquido = 0;
		$total_bruto = 0;
		$total_custo = 0;
		$total_desc_acre = 0;
		$total_margem = 0;

		$lista_geral = array_orderby($lista_geral, 'DH_Emissao', SORT_ASC, 'Nota_Cupom', SORT_ASC);
		foreach($lista_geral as $registro){
			$coluna = 0;

			$worksheet1->write_number($linha_ini,$coluna,data2nr(dataf($registro['DH_Emissao'])),$formato_data);
			$coluna++;

			//$worksheet1->write_number($linha_ini,$coluna,hora2nr(substr($registro['DH_Emissao'], 11, 8)),$formato_hora);
			//$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,substr($registro['DH_Emissao'], 11, 8),$formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Nota_Cupom'],$formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Codigo_Produto'],$formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Produto_Descricao'],$formatotl);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Quantidade'],$formatotqtd);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Valor_Unitario'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Valor_Total_Liquido'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Valor_Desc_Acre'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Valor_Total_Bruto'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Valor_Custo'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Margem'],$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Margem_Perc'],$fmt_perc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Marca_Descricao'],$formatotl);
			$coluna++;

			$total_liquido+= $registro['Valor_Total_Liquido'];
			$total_bruto+= $registro['Valor_Total_Bruto'];
			$total_custo+= $registro['Valor_Custo'];
			$total_desc_acre+= $registro['Valor_Desc_Acre'];
			$total_margem+= $registro['Margem'];

			$linha_ini++;
		}
		//totais

		$coluna = 0;
		//$linha_ini++;

		$worksheet1->write_string($linha_ini,$coluna,'Total Geral: ',$formatotlb);
		for($col=1;$col<7;$col++){
			$worksheet1->write_string($linha_ini,$col,'',$formatotlb);
		}

		$worksheet1->write_number($linha_ini,7,$total_liquido,$formatotpreco_b);
		$worksheet1->write_number($linha_ini,8,$total_desc_acre,$formatotpreco_b);
		$worksheet1->write_number($linha_ini,9,$total_bruto,$formatotpreco_b);
		$worksheet1->write_number($linha_ini,10,$total_custo,$formatotpreco_b);
		$worksheet1->write_number($linha_ini,11,$total_margem,$formatotpreco_b);

		$total_margem_perc = 0;
		if($total_custo > 0){
			$total_margem_perc = ($total_margem / $total_custo);
			//$total_margem_perc = (($total_margem * 100) / $total_custo);
		}
		$worksheet1->write_number($linha_ini,12,$total_margem_perc,$fmt_perc_b);
		$worksheet1->write_string($linha_ini,13,'',$formatotlb);

		$linha_ini++;
		$coluna=0;
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'INSERT INTO relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) VALUES ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);

	$workbook->close();
?>