<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('COMPARATIVO_CEREAIS.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'COMP CEREAIS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'Relatrio Comparativo de Compra Cereais',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$label = label_vendedor_ou_rep_comercial('S');

	$empresa = $_REQUEST['empresa'];
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$cliente = $_REQUEST['cliente'];
	$produto = $_REQUEST['produto'];
	$nrped = $_REQUEST['nrped'];
	$tipo_rel = $_REQUEST['tiporel'];
	$situacao = $_REQUEST['situacao'];

	$filtro = '';

	$consulta = 'SELECT ped.Empresa, ped.Numero_Pedido, ped.DH_Emissao, ped.Pessoa, ped.Vendedor, ped.Valor_Total_Liquido, '.
				' pedi.Seq_Item, pedi.ID_Produto, pedi.Barra_Produto, pedi.Qtd, pedi.Qtd_Liberada, '.
				' pedi.Valor_Unitario, pedi.Valor_Desconto, pedi.Valor_Acrescimo, pedi.Valor_Total, pedi.Status '.
				' FROM pedido ped '.
				' inner join pedido_item pedi '.
				' on ped.Dominio = pedi.Dominio '.
				' and ped.Empresa = pedi.Empresa '.
				' and ped.Numero_Pedido = pedi.Numero_Pedido '.
				' inner join produto prod '.
				' on pedi.Dominio = prod.Dominio '.
				' and pedi.ID_Produto = prod.Id_Produto '.
				' WHERE ped.Dominio = "'.$_SESSION['Dominio'].'" ';

	if($empresa!=''){
		$consulta.= ' and ped.Empresa = "'.$empresa.'"';
		$filtro.= ' Empresa: "'.nome_empresa($lista_empresas,$empresa).'"';
	}

	if($nrped!=''){
		$consulta.= ' and ped.Numero_Pedido = "'.$nrped.'"';
		$filtro.= ' Nr Pedido: "'.$nrped.'"';
	}

	$consulta.= 'AND ((ped.DH_Emissao >= "'.datad($dt_ini).' 00:00:00") '.
				'AND (ped.DH_Emissao <= "'.datad($dt_fim).' 23:59:59"))';

	$filtro.= 'Data: De "'.$dt_ini.'" At "'.$dt_fim.'"';

	if($cliente!=''){
		$consulta.= ' and ped.Pessoa = "'.$cliente.'"';
		$con_pessoa = 'select Nome_Listas from pessoa '.
				 ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				 ' and Pessoa = "'.$cliente.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);

		$filtro.=' Cliente: "'.$reg_pessoa[0].'"';
	}

	$consulta.= ' and pedi.Status <> "E"'.
				' and ((pedi.Status = "L") or (pedi.Status = "P") or (pedi.Status = "F")or (pedi.Status = "A"))';

	if($produto!=''){
		$consulta.= ' and pedi.ID_Produto = "'.$produto.'"';
		$con_prod = 'select Descricao_Curta, Codigo_Produto from produto '.
			   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
			   ' and Id_Produto="'.$produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);
		$filtro.=' Cliente: "'.$reg_prod[1].'-'.$reg_prod[0].'"';
	}

	$consulta.= ' and ped.Tipo_Pedido <> 9 '.
				' and not ((ped.Tipo_Pedido=1) and (ped.Variacao = 2)) '.
				' and not ((ped.Tipo_Pedido=5) and (ped.Variacao = 12)) '.
				' and prod.Codigo_Depart = "14"';

	if($situacao!=''){
		if($situacao=='A'){
			$consulta.= ' and pedi.Qtd_Entrada < pedi.Qtd ';
			$filtro.= ' Situao Compra: "Abertos"';
		}
		if($situacao=='F'){
			$consulta.= ' and pedi.Qtd_Entrada >= pedi.Qtd ';
			$filtro.= ' Situao Compra: "Fechados"';
		}
	}

	$tipoped = $_REQUEST['tipoped'];
	if($tipoped!=''){
		if($tipoped=='F'){
			$consulta.= ' and pedi.Qtd_Atendida<=0 ';
			$filtro.= ' Situao Pedido: "Entrega Futura"';
		}
		if($tipoped=='E'){
			$consulta.= ' and pedi.Qtd_Atendida>0 ';
			$filtro.= ' Situao Pedido: "Entregue"';
		}
	}

	if($tipo_rel!=''){
		if($tipo_rel=='A'){
			$filt_tipo = 'Analtico';
		}else{
			$filt_tipo = 'Sinttico';
		}
		$filtro.= ' Tipo: "'.$filt_tipo.'"';
	}

	$consulta.= ' ORDER BY pedi.ID_Produto, ped.Numero_Pedido, ped.DH_Emissao ';
	//echo $consulta;

	//$valores_frete_adm = array();
	$_REQUEST['valores_frete_adm']['DataI'] = datad(nr2data(data2nr($dt_ini)-365));
	$_REQUEST['valores_frete_adm']['DataF'] = datad($dt_fim);

	function frete_valor($EmpresaPedido,$DestinoOrigem,$tipo,$produto){
		$chave = $EmpresaPedido.'_'.$DestinoOrigem.'_'.$tipo.'_'.$produto;
		if (!(isset($_REQUEST['valores_frete_adm']['Frete'][$chave]))){
			$datas = ' and DH_EntSai>="'.$_REQUEST['valores_frete_adm']['DataI'].' 00:00:00"'.
				   ' and DH_EntSai<="'.$_REQUEST['valores_frete_adm']['DataF'].' 23:59:59"';
			if ($tipo=='T'){ //transferencia
				if ($DestinoOrigem!=$EmpresaPedido){
					$consulta = 'select (sum(Valor_Servico)/(sum(Rodo_PesoLiquido/1000))) from nota_frete '.
							   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Remetente="'.$DestinoOrigem.'"'.
							   ' and Recebedor="'.$EmpresaPedido.'"'.
							   ' and Id_Produto_Predominante="'.$produto.'"'.
							   ' and Situacao="F"'.$datas.
							   ' and Rodo_PesoLiquido>1';
					$resultado = consulta_sql($consulta);
					$registro = consulta_ler_linha($resultado);
					consulta_limpa($resultado);
				}else{
					$registro[0] = 0;
				}
			}else{  //saida para o porto
				$consulta = 'select (sum(Valor_Servico)/(sum(Rodo_PesoLiquido/1000))) from nota_frete '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Remetente="'.$EmpresaPedido.'"'.
							' and ((Recebedor>100) or (Remetente=Recebedor))'.
							' and Id_Produto_Predominante="'.$produto.'"'.
							' and Situacao="F"'.$datas.
							' and Rodo_PesoLiquido>1';
				$resultado = consulta_sql($consulta);
				$registro = consulta_ler_linha($resultado);
				consulta_limpa($resultado);
			}
			$_REQUEST['valores_frete_adm']['Frete'][$chave] = $registro[0];
		}
		return $_REQUEST['valores_frete_adm']['Frete'][$chave];
	}

	function adm_perc($Empresa,$tipoES){
		$chave = $Empresa.'_'.$tipoES;
		if (!(isset($_REQUEST['valores_frete_adm']['ADM'][$chave]))){
			$valor = BuscaParamEmpresa('Custo_ADM_'.$tipoES,$Empresa);
			$_REQUEST['valores_frete_adm']['ADM'][$chave] = $valor;
		}
		return $_REQUEST['valores_frete_adm']['ADM'][$chave];
	}

	function busca_quebra_venda($Empresa,$Numero,$Produto){
		$total_quebra = 0;
		$con_nota = 'select Empresa, Nr_Nota from nota_fiscal '.
				 ' where Dominio="'.$_SESSION['Dominio'].'"'.
				 ' and Pedido_Empresa="'.$Empresa.'"'.
				 ' and Pedido_Nr="'.$Numero.'"';
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);

		for($pn=0;$pn<$nrw_nota;$pn++){
			$reg_nota = consulta_ler_linha($res_nota);

			$con_item = 'select sum(Retencao_Tecnica_Desconto) from nota_fiscal_item '.
					 ' where Dominio="'.$_SESSION['Dominio'].'"'.
					 ' and Empresa="'.$reg_nota->Empresa.'"'.
					 ' and Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
					 ' and Id_Produto="'.$Produto.'"';
			$res_item = consulta_sql($con_item);
			$reg_item = consulta_ler_linha($res_item);
			consulta_limpa($res_item);
			$total_quebra+= ($reg_item[0]/1000);
		}
		consulta_limpa($res_nota);
		return $total_quebra;
	}

	function comissao_perc(){
		$consulta = 'select Comissao_AVista from pessoa_vendedor '.
				   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Pessoa=1';
		$resultado = consulta_sql($consulta);
		$registro = consulta_ler_linha($resultado);
		consulta_limpa($resultado);
		return $registro[0];
	}

	$lista_geral = array();
	$counter = 0;
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	if($nrows>0){
		for($p=0;$p<$nrows;$p++){
			$registro = consulta_ler_objeto($resultado);
			set_time_limit(60);
			$counter++;

			if(isset($lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido])){
				$lista_ped = $lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido];
			}else{
				$lista_ped['Numero'] = $registro->Numero_Pedido;
				$lista_ped['Empresa'] = $registro->Empresa;
				$lista_ped['Cliente'] = $registro->Pessoa;
				$lista_ped['Data'] = $registro->DH_Emissao;
				$lista_ped['Qtd_Vendida'] = 0;
				$lista_ped['ValorUnit'] = $registro->Valor_Unitario;
				$lista_ped['ValorTotal'] = 0;
				$lista_ped['CustoTotal'] = 0;
				$lista_ped['nf'] = array();
				$con_parce = 'select DT_Vencimento from pedido_parcela '.
							 ' where Dominio="'.$_SESSION['Dominio'].'"'.
							 ' and Empresa="'.$registro->Empresa.'"'.
							 ' and Numero_Pedido="'.$registro->Numero_Pedido.'"';
				$res_parce = consulta_sql($con_parce);
				$reg_parce = consulta_ler_linha($res_parce);
				consulta_limpa($res_parce);
				$lista_ped['Vencto'] = $reg_parce[0];
				if ($lista_ped['Vencto']==''){
					$lista_ped['Vencto'] = $lista_ped['Data'];
				}
			}

			$vl_tot = 0;
			$vl_desc = 0;
			$perc_desc = 0;

			$qtd_a = ($registro->Qtd);
			$vl_tot = ($registro->Valor_Unitario * ($qtd_a));

			$lista_ped['Qtd_Vendida']+= ($qtd_a);
			$lista_ped['ValorTotal']+= ($vl_tot);

			$con_compl = 'select sum(Valor_Complemento) from pedido_fixacao '.
						' where Dominio="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$registro->Empresa.'"'.
						' and Numero_Pedido="'.$registro->Numero_Pedido.'"'.
						' and Seq_Item="'.$registro->Seq_Item.'"';
			$res_compl = consulta_sql($con_compl);
			$reg_compl = consulta_ler_linha($res_compl);
			consulta_limpa($res_compl);
			$lista_ped['ValorTotal']+=$reg_compl[0];

			$lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido] = $lista_ped;
			$con_pednota = 'select * from pedido_nota_fiscal '.
						  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						  ' and Empresa = "'.$registro->Empresa.'"'.
						  ' and Numero_Pedido = "'.$registro->Numero_Pedido.'"'.
						  ' and Seq_Item = "'.$registro->Seq_Item.'"';
			$res_pednota = consulta_sql($con_pednota);
			$nrows_pednota = consulta_num_registros($res_pednota);
			if($nrows_pednota>0){
				for($pn=0;$pn<$nrows_pednota;$pn++){
					$reg_pednota = consulta_ler_objeto($res_pednota);
					if(isset($lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['nf'][$reg_pednota->Empresa_NF.'_'.$reg_pednota->Nr_Nota.'_'.$reg_pednota->Seq_Item_NF])){
						$lista_nf = $lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['nf'][$reg_pednota->Empresa_NF.'_'.$reg_pednota->Nr_Nota.'_'.$reg_pednota->Seq_Item_NF];
					}else{
						$con_nf = 'select NrDoc,Serie,Modelo,'.
								  ' Destinatario,Empresa, DH_Emissao '.
								  ' from nota_fiscal '.
								  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								  ' and Empresa = "'.$reg_pednota->Empresa_NF.'"'.
								  ' and Nr_Nota = "'.$reg_pednota->Nr_Nota.'"';
						$res_nf = consulta_sql($con_nf);
						$reg_nf = consulta_ler_objeto($res_nf);
						consulta_limpa($res_nf);

						$con_nfi = 'select Valor_Unitario, Seco_Limpo_Perc '.
								   'from nota_fiscal_item '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Empresa = "'.$reg_pednota->Empresa_NF.'"'.
								   ' and Nr_Nota = "'.$reg_pednota->Nr_Nota.'"'.
								   ' and Seq_Item = "'.$reg_pednota->Seq_Item_NF.'"';
						$res_nfi = consulta_sql($con_nfi);
						$reg_nfi = consulta_ler_objeto($res_nfi);
						consulta_limpa($res_nfi);

						$con_nfp = 'select DT_Vencimento '.
								   ' from nota_fiscal_parcela '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Empresa = "'.$reg_pednota->Empresa_NF.'"'.
								   ' and Nr_Nota = "'.$reg_pednota->Nr_Nota.'"';
						$res_nfp = consulta_sql($con_nfp);
						$reg_nfp = consulta_ler_objeto($res_nfp);
						consulta_limpa($res_nfp);

						$lista_nf['NrDoc'] = $reg_nf->NrDoc.'/'.$reg_nf->Serie.'-'.$reg_nf->Modelo;
						$lista_nf['Fornec'] = $reg_nf->Destinatario;
						$lista_nf['Empresa'] = $reg_nf->Empresa;
						$lista_nf['Data'] = $reg_nf->DH_Emissao;
						$lista_nf['Vencto'] = $reg_nfp->DT_Vencimento;
						$lista_nf['ValorUnit'] = $reg_nfi->Valor_Unitario;
						$lista_nf['Qtdade'] = 0;
						$lista_nf['ValorTotal'] = 0;

						$lista_nf['FreteT'] = frete_valor($registro->Empresa,$reg_nf->Empresa,'T',$registro->ID_Produto);
						$lista_nf['PerADM'] = adm_perc($reg_nf->Empresa,'E');
						$lista_nf['ValorSaca'] = 0;
						if ($reg_nfi->Seco_Limpo_Perc>0){
							$lista_nf['NrDoc'].='*';
							$lista_nf['FreteT'] = 0;
							$lista_nf['PerADM'] = 0;
						}
					}
					$lista_nf['Qtdade']+= $reg_pednota->Qtd_Atendida;

					$vl_total = ($reg_nfi->Valor_Unitario * $reg_pednota->Qtd_Atendida);
					$lista_nf['ValorTotal']+= $vl_total;
					if ($lista_nf['Qtdade']>0){
						$lista_nf['ValorSaca'] = ((($lista_nf['ValorTotal']/$lista_nf['Qtdade'])*60)/1000);
					}
					$lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['CustoTotal']+= $vl_total;
					$lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['nf'][$reg_pednota->Empresa_NF.'_'.$reg_pednota->Nr_Nota.'_'.$reg_pednota->Seq_Item_NF] = $lista_nf;
				}//fim for pednota
			}//fim if pednota
			consulta_limpa($res_pednota);

			//consulta contratos pendentes
			$consulta = 'SELECT * FROM contratos ped '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' and Pedido_Empresa="'.$registro->Empresa.'"'.
						' and Pedido_Nr="'.$registro->Numero_Pedido.'"'.
						' and Pedido_Item="'.$registro->Seq_Item.'"'.
						' and Quantidade>Qtd_Atendida'.
						' and Situacao="A"'.
						' ORDER BY Nr_Contrato';

			$res_nf = consulta_sql($consulta);
			$nrows_pednota = consulta_num_registros($res_nf);
			for($pn=0;$pn<$nrows_pednota;$pn++){
				$reg_nf = consulta_ler_objeto($res_nf);

				$lista_nf['NrDoc'] = 'CTR '.$reg_nf->Nr_Contrato;
				$lista_nf['Fornec'] = $reg_nf->Pessoa;
				$lista_nf['Empresa'] = $reg_nf->Empresa_Entrega;
				$lista_nf['Data'] = $reg_nf->DH_Criacao;
				$lista_nf['Vencto'] = $reg_nf->DT_Pagto;
				if ($reg_nf->DT_Pagto=='0000-00-00'){
					$lista_nf['Vencto'] = $reg_nf->DT_Entrega;
				}
				$lista_nf['ValorUnit'] = ($reg_nf->Valor_Unitario/60)*1000;
				$lista_nf['Qtdade'] = ($reg_nf->Quantidade-$reg_nf->Qtd_Atendida)/1000;
				$vl_total = round($lista_nf['ValorUnit'] * $lista_nf['Qtdade'],2);
				$lista_nf['ValorTotal'] = $vl_total;

				$lista_nf['FreteT'] = frete_valor($registro->Empresa,$reg_nf->Empresa_Entrega,'T',$registro->ID_Produto);
				$lista_nf['PerADM'] = adm_perc($reg_nf->Empresa_Entrega,'E');
				$lista_nf['ValorSaca'] = 0;
				if ($reg_nf->Seco_Limpo_Perc>0){
					$lista_nf['NrDoc'].='*';
					$lista_nf['FreteT'] = 0;
					$lista_nf['PerADM'] = 0;
				}
				if ($lista_nf['Qtdade']>0){
					$lista_nf['ValorSaca'] = ((($lista_nf['ValorTotal']/$lista_nf['Qtdade'])*60)/1000);
				}
				$lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['CustoTotal']+= $vl_total;
				$lista_geral[$registro->ID_Produto][$registro->Empresa.'_'.$registro->Numero_Pedido]['nf'][$reg_nf->Nr_Contrato.'_'.$reg_nf->Empresa.'_C'] = $lista_nf;
			}//fim for pedido
			consulta_limpa($res_nf);
			//consulta fixaes pendentes
		}//fim for pedido
	}//fim if pedido
	consulta_limpa($resultado);

	//echo $consulta;
	//print_r($lista_geral);

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	$texto_L_N =& $workbook->add_format();
	$texto_L_N->set_align('left');
	$texto_L_N->set_bold(1);

	//Linha 1
	$texto_C_N_RT =& $workbook->add_format();
	$texto_C_N_RT->set_align('center');
	$texto_C_N_RT->set_bold(1);
	$texto_C_N_RT->set_right(2);
	$texto_C_N_RT->set_top(2);

	$texto_C_N_T =& $workbook->add_format();
	$texto_C_N_T->set_align('center');
	$texto_C_N_T->set_bold(1);
	$texto_C_N_T->set_top(2);

	$texto_R_N_T =& $workbook->add_format();
	$texto_R_N_T->set_align('right');
	$texto_R_N_T->set_bold(1);
	$texto_R_N_T->set_top(2);

	$texto_L_N_T =& $workbook->add_format();
	$texto_L_N_T->set_align('left');
	$texto_L_N_T->set_bold(1);
	$texto_L_N_T->set_top(2);

	$texto_C_N_LT =& $workbook->add_format();
	$texto_C_N_LT->set_align('center');
	$texto_C_N_LT->set_bold(1);
	$texto_C_N_LT->set_left(2);
	$texto_C_N_LT->set_top(2);

	//linha 2
	$texto_C_S_L =& $workbook->add_format();
	$texto_C_S_L->set_align('center');
	$texto_C_S_L->set_left(2);

	$texto_C_S_S =& $workbook->add_format();
	$texto_C_S_S->set_align('center');

	$texto_L_S_S =& $workbook->add_format();
	$texto_L_S_S->set_align('left');

	$perce_C_S_S =& $workbook->add_format();
	$perce_C_S_S->set_align('center');
	$perce_C_S_S->set_num_format('0.0%');

	$perce_C_S_R =& $workbook->add_format();
	$perce_C_S_R->set_align('center');
	$perce_C_S_R->set_right(2);
	$perce_C_S_R->set_num_format('[blue]0.0%;[red]-0.0%');

	$quant_R_S_S =& $workbook->add_format();
	$quant_R_S_S->set_align('right');
	$quant_R_S_S->set_num_format('#,##0.000_);(#,##0.000)');

	$preco_R_S_S =& $workbook->add_format();
	$preco_R_S_S->set_align('right');
	$preco_R_S_S->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//linha 3 (italico)
	$texto_C_NI_RT =& $workbook->add_format();
	$texto_C_NI_RT->set_align('center');
	$texto_C_NI_RT->set_bold(1);
	$texto_C_NI_RT->set_italic(1);
	$texto_C_NI_RT->set_right(2);
	$texto_C_NI_RT->set_top(2);

	$texto_C_NI_T =& $workbook->add_format();
	$texto_C_NI_T->set_align('center');
	$texto_C_NI_T->set_bold(1);
	$texto_C_NI_T->set_italic(1);
	$texto_C_NI_T->set_top(2);

	$texto_C_NI_LT =& $workbook->add_format();
	$texto_C_NI_LT->set_align('center');
	$texto_C_NI_LT->set_bold(1);
	$texto_C_NI_LT->set_italic(1);
	$texto_C_NI_LT->set_left(2);
	$texto_C_NI_LT->set_top(2);

	$texto_R_NI_T =& $workbook->add_format();
	$texto_R_NI_T->set_align('right');
	$texto_R_NI_T->set_bold(1);
	$texto_R_NI_T->set_italic(1);
	$texto_R_NI_T->set_top(2);

	$texto_L_NI_T =& $workbook->add_format();
	$texto_L_NI_T->set_align('left');
	$texto_L_NI_T->set_bold(1);
	$texto_L_NI_T->set_italic(1);
	$texto_L_NI_T->set_top(2);

	//linha 4
	$texto_C_I_L =& $workbook->add_format();
	$texto_C_I_L->set_align('center');
	$texto_C_I_L->set_italic(1);
	$texto_C_I_L->set_left(2);

	$texto_C_I_R =& $workbook->add_format();
	$texto_C_I_R->set_align('center');
	$texto_C_I_R->set_italic(1);
	$texto_C_I_R->set_right(2);

	$texto_C_I_S =& $workbook->add_format();
	$texto_C_I_S->set_align('center');
	$texto_C_I_S->set_italic(1);

	$texto_L_I_S =& $workbook->add_format();
	$texto_L_I_S->set_align('left');
	$texto_L_I_S->set_italic(1);

	$perce_C_I_S =& $workbook->add_format();
	$perce_C_I_S->set_align('center');
	$perce_C_I_S->set_italic(1);
	$perce_C_I_S->set_num_format('0.0%');

	$perce_R_I_S =& $workbook->add_format();
	$perce_R_I_S->set_align('right');
	$perce_R_I_S->set_italic(1);
	$perce_R_I_S->set_num_format('0.0%');

	$perce_C_I_R =& $workbook->add_format();
	$perce_C_I_R->set_align('center');
	$perce_C_I_R->set_right(2);
	$perce_C_I_R->set_italic(1);
	$perce_C_I_R->set_num_format('[blue]0.0%;[red]-0.0%');

	$quant_R_I_S =& $workbook->add_format();
	$quant_R_I_S->set_align('right');
	$quant_R_I_S->set_italic(1);
	$quant_R_I_S->set_num_format('#,##0.000_);(#,##0.000)');

	$preco_R_I_S =& $workbook->add_format();
	$preco_R_I_S->set_align('right');
	$preco_R_I_S->set_italic(1);
	$preco_R_I_S->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//final
	$texto_R_NI_S =& $workbook->add_format();
	$texto_R_NI_S->set_align('right');
	$texto_R_NI_S->set_bold(1);
	$texto_R_NI_S->set_italic(1);

	$texto_C_I_BL =& $workbook->add_format();
	$texto_C_I_BL->set_align('center');
	$texto_C_I_BL->set_italic(1);
	$texto_C_I_BL->set_bottom(2);
	$texto_C_I_BL->set_left(2);

	$texto_C_I_BR =& $workbook->add_format();
	$texto_C_I_BR->set_align('center');
	$texto_C_I_BR->set_italic(1);
	$texto_C_I_BR->set_bottom(2);
	$texto_C_I_BR->set_right(2);

	$texto_C_I_B =& $workbook->add_format();
	$texto_C_I_B->set_align('center');
	$texto_C_I_B->set_italic(1);
	$texto_C_I_B->set_bottom(2);

	$texto_R_NI_B =& $workbook->add_format();
	$texto_R_NI_B->set_align('center');
	$texto_R_NI_B->set_italic(1);
	$texto_R_NI_B->set_bold(1);
	$texto_R_NI_B->set_bottom(2);

	$quant_R_NI_B =& $workbook->add_format();
	$quant_R_NI_B->set_align('right');
	$quant_R_NI_B->set_italic(1);
	$quant_R_NI_B->set_bold(1);
	$quant_R_NI_B->set_bottom(2);
	$quant_R_NI_B->set_num_format('#,##0.000_);(#,##0.000)');

	$preco_R_NI_B =& $workbook->add_format();
	$preco_R_NI_B->set_align('right');
	$preco_R_NI_B->set_italic(1);
	$preco_R_NI_B->set_bold(1);
	$preco_R_NI_B->set_bottom(2);
	$preco_R_NI_B->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$linha_ini = 10;

	$coluna=0;
	$worksheet1->set_column($coluna,$coluna,10); $coluna++;  //A
	$worksheet1->set_column($coluna,$coluna,10); $coluna++;  //B
	$worksheet1->set_column($coluna,$coluna,10); $coluna++;  //C
	$worksheet1->set_column($coluna,$coluna,15); $coluna++;  //D
	$worksheet1->set_column($coluna,$coluna,15); $coluna++;  //E
	$worksheet1->set_column($coluna,$coluna,10); $coluna++;  //F
	$worksheet1->set_column($coluna,$coluna,10); $coluna++;  //G
	$worksheet1->set_column($coluna,$coluna,14,$texto_C_S_S,true); $coluna++;  //H
	$worksheet1->set_column($coluna,$coluna,08,$texto_C_S_S,true); $coluna++;  //I
	$worksheet1->set_column($coluna,$coluna,14); $coluna++;  //J
	$worksheet1->set_column($coluna,$coluna,15); $coluna++;  //K
	$worksheet1->set_column($coluna,$coluna,15); $coluna++;  //L
	$worksheet1->set_column($coluna,$coluna,14); $coluna++;  //M
	$worksheet1->set_column($coluna,$coluna,14); $coluna++;  //N
	$worksheet1->set_column($coluna,$coluna,16); $coluna++;  //O
	$worksheet1->set_column($coluna,$coluna,08); $coluna++;  //P

	$lista_empresas = lista_empresas();

	if(sizeof($lista_geral)>0){
		ksort($lista_geral);
		foreach($lista_geral as $idprod => $valor){
			$lista_geral2 = $lista_geral[$idprod];

			$con_prod = 'select Descricao_Completa, Codigo_Produto from produto '.
				   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Id_Produto="'.$idprod.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			$worksheet1->write_string($linha_ini,0,'Produto',$texto_L_N);
			$worksheet1->write_string($linha_ini,1,$reg_prod[1].'-'.$reg_prod[0],$texto_L_N);
			$linha_ini++;
			//Pedido Data Empresa	Cliente		Qtd TON			Vl Saca	Total Venda	Frete	Desp.ADM	Custo Total	Rent (%)
			foreach($lista_geral2 as $id_ped => $valor2){
				$lista_geral3 = $lista_geral2[$id_ped];

				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'Pedido',$texto_C_N_LT);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Dt Emisso',$texto_C_N_T);  $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Dt Vencto',$texto_C_N_T);   $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Empresa',$texto_C_N_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Cliente',$texto_L_N_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_N_T);            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Qtd TON',$texto_R_N_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_N_T);            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_N_T);            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Vl Saca',$texto_R_N_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Total Venda',$texto_R_N_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Frete',$texto_R_N_T);       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Desp.ADM',$texto_R_N_T);    $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Cor.+Quebra',$texto_R_N_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Custo Total',$texto_R_N_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Rent (%)',$texto_C_N_RT);   $coluna++;
				$linha_ini++;

				//segunda linha
				$linha_pedido = ($linha_ini);

				$con_clie = 'select Nome_listas from pessoa '.
						  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						  ' and Pessoa="'.$lista_geral3['Cliente'].'"';
				$res_clie = consulta_sql($con_clie);
				$reg_clie = consulta_ler_linha($res_clie);
				consulta_limpa($res_clie);

				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,$lista_geral3['Numero'],$texto_C_S_L);                       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,dataf($lista_geral3['Data']),$texto_C_S_S);                  $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,dataf($lista_geral3['Vencto']),$texto_C_S_S);                $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,$lista_empresas[$lista_geral3['Empresa']],$texto_C_S_S);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,$lista_geral3['Cliente'].'-'.$reg_clie[0],$texto_L_S_S);     $coluna++;
						  $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$lista_geral3['Qtd_Vendida'],$quant_R_S_S); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_S_S);            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_S_S);            $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(((K'.($linha_pedido+1).'/G'.($linha_pedido+1).')*60)/1000)',$preco_R_S_S); $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$lista_geral3['ValorTotal'],$preco_R_S_S); $coluna++;

				$pedido_frete      = $coluna;  $coluna++;
				$pedido_adm        = $coluna;  $coluna++;
				$pedido_corretagem = $coluna;  $coluna++;
				$pedido_custo      = $coluna;  $coluna++;
				$pedido_perc       = $coluna;  $coluna++;
				$linha_ini++;

				//terceira linha
				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'Nr NF',$texto_C_NI_LT);      $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Dt Emisso',$texto_C_NI_T);  $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Dt Vencto',$texto_C_NI_T);   $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Empresa',$texto_C_NI_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Fornecedor',$texto_L_NI_T);  $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_NI_T);            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Qtd TON',$texto_R_NI_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Frete (R$/TON)',$texto_R_NI_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'ADM/Saca',$texto_R_NI_T);    $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Vl Saca',$texto_R_NI_T);     $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Custo Prod.',$texto_R_NI_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Frete',$texto_R_NI_T);       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Desp.ADM',$texto_R_NI_T);    $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Custo Venda',$texto_R_NI_T); $compra_custo_venda = $coluna; $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Custo Total',$texto_R_NI_T); $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Rent (%)',$texto_C_NI_RT);   $coluna++;
				$linha_ini++;

				$linha_compra=$linha_ini;
				$qtd_compra=0;
				//lista notas
				foreach($lista_geral3['nf'] as $id_nota => $valor3){
					$lista_campos = $lista_geral3['nf'][$id_nota];
					$qtd_compra++;

					$con_clie = 'select Nome_listas from pessoa '.
							  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
							  ' and Pessoa="'.$lista_campos['Fornec'].'"';
					$res_clie = consulta_sql($con_clie);
					$reg_clie = consulta_ler_linha($res_clie);
					consulta_limpa($res_clie);

					$coluna=0;
					$worksheet1->write_string($linha_ini,$coluna,$lista_campos['NrDoc'],$texto_C_I_L);                                     $coluna++;
					$worksheet1->write_string($linha_ini,$coluna,dataf($lista_campos['Data']),$texto_C_I_S);                               $coluna++;
					$worksheet1->write_string($linha_ini,$coluna,dataf($lista_campos['Vencto']),$texto_C_I_S);                             $coluna++;
					$worksheet1->write_string($linha_ini,$coluna,$lista_empresas[$lista_campos['Empresa']],$texto_C_I_S);                  $coluna++;
					$worksheet1->write_string($linha_ini,$coluna,$lista_campos['Fornec'].'-'.$reg_clie[0],$texto_L_I_S);              	   $coluna++;
																		  $coluna++;
					$worksheet1->write_number($linha_ini,$coluna,$lista_campos['Qtdade'],$quant_R_I_S);                                    $coluna++;
					$worksheet1->write_number($linha_ini,$coluna,$lista_campos['FreteT'],$preco_R_I_S);                                    $coluna++;
					$worksheet1->write_number($linha_ini,$coluna,$lista_campos['PerADM'],$preco_R_I_S);                                	   $coluna++;
					$worksheet1->write_number($linha_ini,$coluna,$lista_campos['ValorSaca'],$preco_R_I_S);                                 $coluna++;
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM((J'.($linha_ini+1).'*1000/60)*G'.($linha_ini+1).')',$preco_R_I_S); $coluna++;
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM(G'.($linha_ini+1).'*H'.($linha_ini+1).')',$preco_R_I_S);           $coluna++;
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM(I'.($linha_ini+1).'*(G'.($linha_ini+1).'*1000/60))',$preco_R_I_S); $coluna++;
					/*custo da venda*/                                                                                                     $coluna++;
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM(K'.($linha_ini+1).':N'.($linha_ini+1).')',$preco_R_I_S);           $coluna++;
					$worksheet1->write_formula($linha_ini,$coluna,'=SUM(1-(O'.($linha_ini+1).')/((K$'.($linha_pedido+1).'/G$'.($linha_pedido+1).')*G'.($linha_ini+1).'))',$perce_C_I_R); $coluna++;
					$linha_ini++;
				}

				$FreteT = frete_valor($lista_geral3['Empresa'],$lista_geral3['Cliente'],'V',$idprod);
				$PerADM = adm_perc($lista_geral3['Empresa'],'S');
				$quebra = busca_quebra_venda($lista_geral3['Empresa'],$lista_geral3['Numero'],$idprod);
				$perc_comissao = comissao_perc();

				//final
				$linha_despesas = $linha_ini;
				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_L);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Outros Custos',$texto_R_NI_S);              $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Desp. Venda',$texto_R_NI_S);                $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$FreteT,$preco_R_I_S);                       $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$PerADM,$preco_R_I_S);                       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$coluna++;  //$pedido_frete
				$coluna++;  //$pedido_adm
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_E_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_R);                            $coluna++;
				$linha_ini++; 

				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_L);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_S);                           $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Corretagem',$texto_R_NI_S);                 $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$perce_C_I_S);                            $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$perc_comissao/100,$perce_R_I_S);            $coluna++;
				$coluna++;  //valor comissao
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_R);                            $coluna++;
				$linha_ini++;

				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_L);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_S);                           $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Quebra',$texto_R_NI_S);                     $coluna++;
				$worksheet1->write_number($linha_ini,$coluna,$quebra,$quant_R_I_S);                       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$perce_C_I_S);                            $coluna++;
				$coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(G'.($linha_ini+1).
																'*J'.($linha_ini+1).')',$preco_R_I_S);  $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$preco_R_I_S);                            $coluna++;
				$coluna++;
				$coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_R);                            $coluna++;
				$linha_ini++;

				//total
				$linha_total = $linha_ini;

				$coluna=0;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_BL);                           $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_B);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_B);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_B);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'Total Compras',$texto_R_NI_B);              $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_B);                           $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(G'.($linha_pedido+3).
															   ':G'.($linha_despesas).')',$quant_R_NI_B);                       $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_B);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_B);                            $coluna++;
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_R_NI_B);                            $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(K'.($linha_pedido+3).
																':K'.($linha_despesas).'))',$preco_R_NI_B);    $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(L'.($linha_pedido+3).
																':L'.($linha_despesas+1).'))',$preco_R_NI_B);  $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(M'.($linha_pedido+3).
																':M'.($linha_ini).'))',$preco_R_NI_B);         $coluna++;
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(N'.($linha_pedido+3).
																':N'.($linha_despesas).'))',$preco_R_NI_B);    $coluna++;
																
																
				$worksheet1->write_formula($linha_ini,$coluna,'=SUM(O'.($linha_pedido+3).
																':O'.($linha_ini).'))',$preco_R_NI_B);   $coluna++;
																
				$worksheet1->write_string($linha_ini,$coluna,'',$texto_C_I_BR);   $coluna++;
				$linha_ini++;

				//retrona a primaira linha pra colcoar as ultimas formulas
				$worksheet1->write_formula($linha_pedido,$pedido_frete     ,'=SUM(L'.($linha_total+1).')'                    ,$preco_R_S_S);
				$worksheet1->write_formula($linha_pedido,$pedido_adm       ,'=SUM(M'.($linha_total+1).')'                    ,$preco_R_S_S);
				$worksheet1->write_formula($linha_pedido,$pedido_corretagem,'=SUM(K'.($linha_total-1).':K'.($linha_total).')',$preco_R_S_S);
				$worksheet1->write_formula($linha_pedido,$pedido_custo     ,'=SUM(O'.($linha_total+1).')'                    ,$preco_R_S_S);
				$worksheet1->write_formula($linha_pedido,$pedido_perc      ,'=SUM(1-(O'.($linha_pedido+1).'/((K'.($linha_pedido+1).'/G'.($linha_pedido+1).')*G'.($linha_total+1).')))',$perce_C_S_R);

				//custo venda de cada compra
				for($c=0;$c<$qtd_compra;$c++){
					$worksheet1->write_formula($linha_compra+$c,$compra_custo_venda,'=SUM((L$'.($linha_total-2).
																					 '+M$'.($linha_total-2).
																					 '+K$'.($linha_total-1).
																					 '+K$'.($linha_total).
																					  ')*(G'.($linha_compra+$c+1).
																						'/G$'.($linha_total+1).'))' ,$preco_R_I_S);
				}

				$worksheet1->write_formula($linha_despesas,$pedido_frete,'=SUM(G$'.($linha_total+1).'*H'.($linha_despesas+1).')',$preco_R_S_S);
				$worksheet1->write_formula($linha_despesas,$pedido_adm,'=SUM(I'.($linha_despesas+1).'*(G'.($linha_total+1).'*1000/60))',$preco_R_I_S);

				$worksheet1->write_formula($linha_despesas+1,($pedido_frete-1),'=SUM((K$'.($linha_pedido+1).
																				  '/G$'.($linha_pedido+1).
																				 ')*G$'.($linha_total+1).
																				   '*J'.($linha_total-1).')',$preco_R_I_S);

				$worksheet1->write_formula($linha_despesas+2,($pedido_frete-2),'=SUM((K'.($linha_total+1).
																			   '/G'.($linha_total+1).
																			   '))',$preco_R_I_S);
			}
			//pula uma linha
			$linha_ini++;
			$linha_ini++;
			$linha_ini++;
		}

	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			  ' Dominio, '.
			  ' Usuario, '.
			  ' Descricao ) values ('.
			  '"'.$_SESSION['Dominio'].'", '.
			  '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			  '"")';
	consulta_sql($insert);
	$workbook->close();
?>