<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	HeaderingExcel('DEMONSTRATIVO_DIA.xls');

	$workbook = new Workbook("-");

	// Format for the headings
	$fmt_branco =& $workbook->add_format();
	$fmt_branco->set_size(10);

	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_align('vcenter');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatottl =& $workbook->add_format();
	$formatottl->set_align('left');
	$formatottl->set_pattern();
	$formatottl->set_fg_color(40);
	$formatottl->set_bold(1);
	$formatottl->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');
	$formatotl->set_size(10);
	$formatotl->font='Tahoma';

	$formatotl_filtro =& $workbook->add_format();
	$formatotl_filtro->set_align('left');
	$formatotl_filtro->set_size(10);
	$formatotl_filtro->font='Tahoma';

	$formatotr =& $workbook->add_format();
	$formatotr->set_border(1);
	$formatotr->set_align('right');

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Formato para quantidades
	$formatotqtd3 =& $workbook->add_format();
	$formatotqtd3->set_border(1);
	$formatotqtd3->set_align('center');
	$formatotqtd3->set_pattern();
	$formatotqtd3->set_fg_color('white');
	$formatotqtd3->set_size(10);
	$formatotqtd3->font='Tahoma';
	$formatotqtd3->set_num_format('#,##0.000_);(#,##0.000)');

	$formatotqtd3_b =& $workbook->add_format();
	$formatotqtd3_b->set_border(1);
	$formatotqtd3_b->set_align('center');
	$formatotqtd3_b->set_pattern();
	$formatotqtd3_b->set_fg_color('white');
	$formatotqtd3_b->set_color('navy');
	$formatotqtd3_b->set_size(10);
	$formatotqtd3_b->font='Tahoma';
	$formatotqtd3_b->set_bold(1);
	$formatotqtd3_b->set_num_format('#,##0.000_);(#,##0.000)');

	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//produto set_fg_color 31
	$fmt_produto_txt =& $workbook->add_format();
	$fmt_produto_txt->set_border(1);
	$fmt_produto_txt->set_align('left');
	$fmt_produto_txt->set_pattern();
	$fmt_produto_txt->set_fg_color(44);

	$fmt_romaneio_qtd =& $workbook->add_format();
	$fmt_romaneio_qtd->set_border(1);
	$fmt_romaneio_qtd->set_align('center');
	//$fmt_romaneio_qtd->set_num_format('#.##0_);-#.##0');
	//$fmt_romaneio_qtd->set_num_format('#,##0.00#_);-#,##0.00#_)');
	$fmt_romaneio_qtd->set_num_format('#,##0_);-#,##0_)'); //formata 0.000 e caso seja 00,0 arredonda para cima
	$fmt_romaneio_qtd->set_pattern();
	$fmt_romaneio_qtd->set_fg_color(31);

	$fmt_romaneio_txt =& $workbook->add_format();
	$fmt_romaneio_txt->set_border(1);
	$fmt_romaneio_txt->set_align('center');
	$fmt_romaneio_txt->set_pattern();
	$fmt_romaneio_txt->set_fg_color(31);

	$fmt_romaneio_valor =& $workbook->add_format();
	$fmt_romaneio_valor->set_border(1);
	$fmt_romaneio_valor->set_align('center');
	$fmt_romaneio_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_romaneio_valor->set_pattern();
	$fmt_romaneio_valor->set_fg_color(31);

	//vendas set_fg_color 50
	$fmt_vendas_qtd =& $workbook->add_format();
	$fmt_vendas_qtd->set_border(1);
	$fmt_vendas_qtd->set_align('center');
	$fmt_vendas_qtd->set_num_format('#,##0_);-#,##0_)');
	$fmt_vendas_qtd->set_pattern();
	$fmt_vendas_qtd->set_fg_color(42);

	$fmt_vendas_txt =& $workbook->add_format();
	$fmt_vendas_txt->set_border(1);
	$fmt_vendas_txt->set_align('center');
	$fmt_vendas_txt->set_pattern();
	$fmt_vendas_txt->set_fg_color(42);

	$fmt_vendas_valor =& $workbook->add_format();
	$fmt_vendas_valor->set_border(1);
	$fmt_vendas_valor->set_align('center');
	$fmt_vendas_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_vendas_valor->set_pattern();
	$fmt_vendas_valor->set_fg_color(42);

	$fmt_vendas_total =& $workbook->add_format();
	$fmt_vendas_total->set_border(1);
	$fmt_vendas_total->set_align('center');
	$fmt_vendas_total->set_num_format('0%;-0%');
	$fmt_vendas_total->set_pattern();
	$fmt_vendas_total->set_fg_color(42);

	//trocas set_fg_color 45
	$fmt_trocas_qtd =& $workbook->add_format();
	$fmt_trocas_qtd->set_border(1);
	$fmt_trocas_qtd->set_align('center');
	$fmt_trocas_qtd->set_num_format('#,##0_);-#,##0_)');
	$fmt_trocas_qtd->set_pattern();
	$fmt_trocas_qtd->set_fg_color(43);

	$fmt_trocas_txt =& $workbook->add_format();
	$fmt_trocas_txt->set_border(1);
	$fmt_trocas_txt->set_align('center');
	$fmt_trocas_txt->set_pattern();
	$fmt_trocas_txt->set_fg_color(43);

	$fmt_trocas_valor =& $workbook->add_format();
	$fmt_trocas_valor->set_border(1);
	$fmt_trocas_valor->set_align('center');
	$fmt_trocas_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_trocas_valor->set_pattern();
	$fmt_trocas_valor->set_fg_color(43);

	$fmt_trocas_total =& $workbook->add_format();
	$fmt_trocas_total->set_border(1);
	$fmt_trocas_total->set_align('center');
	$fmt_trocas_total->set_num_format('0%;-0%');
	$fmt_trocas_total->set_pattern();
	$fmt_trocas_total->set_fg_color(43);

	//retorno set_fg_color 52
	$fmt_retorno_qtd =& $workbook->add_format();
	$fmt_retorno_qtd->set_border(1);
	$fmt_retorno_qtd->set_align('center');
	$fmt_retorno_qtd->set_num_format('#,##0_);-#,##0_)');
	$fmt_retorno_qtd->set_pattern();
	$fmt_retorno_qtd->set_fg_color(51);

	$fmt_retorno_txt =& $workbook->add_format();
	$fmt_retorno_txt->set_border(1);
	$fmt_retorno_txt->set_align('center');
	$fmt_retorno_txt->set_pattern();
	$fmt_retorno_txt->set_fg_color(51);

	$fmt_retorno_valor =& $workbook->add_format();
	$fmt_retorno_valor->set_border(1);
	$fmt_retorno_valor->set_align('center');
	$fmt_retorno_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_retorno_valor->set_pattern();
	$fmt_retorno_valor->set_fg_color(51);

	$fmt_retorno_total =& $workbook->add_format();
	$fmt_retorno_total->set_border(1);
	$fmt_retorno_total->set_align('center');
	$fmt_retorno_total->set_num_format('0%;-0%');
	$fmt_retorno_total->set_pattern();
	$fmt_retorno_total->set_fg_color(51);

	$empresa = $_REQUEST['empresa'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$produto = $_REQUEST['produto'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];

	$dia_ini = data2nr($data_ini);

	//romaneio
	//consulta notas fiscais 5.904/5.414 fechadas do periodo e filtros
	//para cada nota, consulta itens
	//para cada nota, cria lista_vendedor
	//se item nao existe na lista_geral, cria item
	//soma qtd lista geral

	//se item nao existe na lista_vendedor, cria item
	//soma qtd lista_vendedor

	//vendas
	//consulta pedidos (todos status menos E e C), Pessoa != Empresa, do periodo e filtros
	//ver data de entrega, se nao, data emissao
	//para cada pedido, consulta itens (todos status menos E e C)
	//para cada pedido, cria lista_vendedor
	//se item nao existe na lista_geral, cria item
	//soma qtd lista_geral

	//se item nao existe na lista_vendedor, cria item
	//soma qtd lista_vendedor

	///se for troca, adicionar na array lista_troca

	$con_nota = 'select Nr_Nota, Empresa, Vendedor, DH_Emissao, DH_EntSai from nota_fiscal '.
			   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
			   ' and Situacao = "F"'.
			   ' and ((Nat_Op_CFOP = "5.904") OR (Nat_Op_CFOP = "5.414"))';

	$con_vendas = 'select Numero_Pedido, Empresa, DH_Emissao, Pessoa, Vendedor, Valor_Sub_Total, '.
				 ' Valor_Total_Liquido, Valor_Imposto, Status, Obs_Cancel, Local_Fatura, '.
				 ' Fatura_Tipo, Forma_Pagto, DH_Emissao, Tipo_Pedido, DH_Entrega '.
				 ' from pedido '.
				 ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				 ' and Status <> "E" and Status <> "C"'.
				 ' and Empresa <> Pessoa'.
				 ' and Pessoa > 100';

	if($empresa!=''){
		$con_nota.= ' and Empresa = "'.$empresa.'" ';
		$con_vendas.= ' and Empresa = "'.$empresa.'" ';

		$cons_empresa = 'select Nome_Listas from pessoa '.
					  ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' and Pessoa = "'.$empresa.'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	if(($data_ini!='')&&($data_fim!='')){
		$filtro.= ' Data: De: "'.$data_ini.'" At: "'.$data_fim.'"';
		$con_nota.= ' and (DH_EntSai >= "'.datad($data_ini).'") and (DH_EntSai <= "'.datad($data_fim).' 23:59:59") ';
		$con_vendas.= ' and (((DH_Emissao >= "'.datad($data_ini).'") and (DH_Emissao <= "'.datad($data_fim).' 23:59:59") '. //DH_Digitacao
					 ' and (DH_Entrega = "0000-00-00 00:00:00")) '.
					 ' or ((DH_Entrega >= "'.datad($data_ini).'") and (DH_Entrega <= "'.datad($data_fim).' 23:59:59")))';
	}

	$sub_cabec = '';
	if($vendedor!=''){
		$con_nota.= ' and Vendedor = "'.$vendedor.'"';
		$con_vendas.= ' and Vendedor = "'.$vendedor.'"';

		$cons_vend = 'select Nome_Listas, Pessoa from pessoa '.
				   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' and Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);

		$label_emp = empresa_representante($vendedor);
		$label_emp2 = empresa_representante($vendedor,'S');

		$filtro.= ' '.$label.': "'.$label_emp.'"';
		$sub_cabec = $label.': '.$label_emp2;
	}

	if($cliente!=''){
		$con_vendas.= ' and Pessoa = "'.$cliente.'"';

		$cons_cliente = 'select Nome_Listas, Pessoa from pessoa '.
					  ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' and Pessoa = "'.$cliente.'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);
		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';
	}

	if($produto!=''){
		$con_prod = 'select Descricao_Curta, Codigo_Produto from produto '.
				  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' and Id_Produto = "'.$produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		$filtro.= ' Produto: "'.$reg_prod[1].' - '.$reg_prod[0].'"';
	}
	$con_nota.= ' order by Vendedor, Empresa, DH_Emissao ';
	$con_vendas.= ' order by Vendedor, Empresa, DH_Emissao ';

	$lista_geral = array();
	$lista_vendedor = array();

	$counter = 0;

	$res_nota = consulta_sql($con_nota);
	$nrows_nota = consulta_num_registros($res_nota);
	for($n=0;$n<$nrows_nota;$n++){
		$reg_nota = consulta_ler_objeto($res_nota);

		$cons_item = 'select Id_Produto, Quantidade_Estoque, Valor_Unitario '.
					 ' from nota_fiscal_item '.
					 ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					 ' and Empresa = "'.$reg_nota->Empresa.'" '.
					 ' and Nr_Nota = "'.$reg_nota->Nr_Nota.'" '.
					 ' order by Dominio, Empresa, Nr_Nota, Seq_Item ';
		$res_item = consulta_sql($cons_item);
		$nrows_item = consulta_num_registros($res_item);
		for($e=0;$e<$nrows_item;$e++){
			$reg_item = consulta_ler_objeto($res_item);
			$ok = true;

			if($ok){
				$ok = ($reg_item->Id_Produto>0);
			}

			if($ok){
				if($produto!=''){
					$ok = ($produto==$reg_item->Id_Produto);
				}
			}

			if($ok){
				//itens
				if(!(isset($lista_produto[$reg_item->Id_Produto]))){
					$counter++;
					//consulta descricao
					$con_prod = 'select Descricao_Curta, Codigo_Produto from produto '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto = "'.$reg_item->Id_Produto.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);

					$lista_produto[$reg_item->Id_Produto]['nome'] = $reg_prod[0];
					$lista_produto[$reg_item->Id_Produto]['cod'] = $reg_prod[1];
				}

				//$data_base = data2nr(dataf($reg_nota->DH_Emissao));
				$data_base = data2nr(dataf($reg_nota->DH_EntSai));
				//geral
				if(isset($lista_geral['G'][$reg_item->Id_Produto][$data_base])){
					$lista_todos = $lista_geral['G'][$reg_item->Id_Produto][$data_base];
				}else{
					$lista_todos['romaneio'] = 0;
					$lista_todos['romaneio_valor'] = 0;
					$lista_todos['vendas'] = 0;
					$lista_todos['vendas_valor'] = 0;
					$lista_todos['trocas'] = 0;
					$lista_todos['trocas_valor'] = 0;
				}
				$lista_todos['romaneio']+= $reg_item->Quantidade_Estoque;
				$lista_todos['romaneio_valor']+= arredonda_numero(($reg_item->Quantidade_Estoque*$reg_item->Valor_Unitario)*100)/100;
				$lista_geral['G'][$reg_item->Id_Produto][$data_base] = $lista_todos;

				if(isset($lista_vendedor[$reg_nota->Vendedor][$reg_item->Id_Produto][$data_base])){
					$lista_todos = $lista_vendedor[$reg_nota->Vendedor][$reg_item->Id_Produto][$data_base];
				}else{
					$lista_todos['romaneio'] = 0;
					$lista_todos['romaneio_valor'] = 0;
					$lista_todos['vendas'] = 0;
					$lista_todos['vendas_valor'] = 0;
					$lista_todos['trocas'] = 0;
					$lista_todos['trocas_valor'] = 0;
				}
				$lista_todos['romaneio']+= $reg_item->Quantidade_Estoque;
				$lista_todos['romaneio_valor']+= arredonda_numero(($reg_item->Quantidade_Estoque*$reg_item->Valor_Unitario)*100)/100;
				$lista_vendedor[$reg_nota->Vendedor][$reg_item->Id_Produto][$data_base] = $lista_todos;
			}
		}//fim for item
		consulta_limpa($res_item);
	}//fim for nota
	consulta_limpa($res_nota);

	//pedidos
	$res_ped = consulta_sql($con_vendas);
	$nrows_ped = consulta_num_registros($res_ped);
	for($p=0;$p<$nrows_ped;$p++){
		$reg_ped = consulta_ler_objeto($res_ped);

		//venda e troca
		$cons_item = 'select ID_Produto, Qtd, Qtd_Atendida, Qtd_Liberada, '.
					' Valor_Unitario, Valor_Total, Valor_Desconto, Valor_Imposto, Status '.
					' from pedido_item '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Empresa = "'.$reg_ped->Empresa.'" '.
					' and Numero_Pedido = "'.$reg_ped->Numero_Pedido.'" '.
					' and Status <> "E" and Status <> "C" '.
					' order by Dominio, Empresa, Numero_Pedido, Seq_Item ';
		$res_item = consulta_sql($cons_item);
		$nrows_item = consulta_num_registros($res_item);
		for($e=0;$e<$nrows_item;$e++){
			$reg_item = consulta_ler_objeto($res_item);
			$ok = true;

			if($ok){
				$ok = ($reg_item->ID_Produto>0);
			}

			if($ok){
				if($produto!=''){
					$ok = ($produto==$reg_item->ID_Produto);
				}
			}

			if($ok){
				if(!(isset($lista_produto[$reg_item->ID_Produto]))){
					$counter++;
					//consulta descricao
					$con_prod = 'select Descricao_Curta, Codigo_Produto from produto '.
							 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
							 ' and Id_Produto = "'.$reg_item->ID_Produto.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);

					$lista_produto[$reg_item->ID_Produto]['nome'] = $reg_prod[0];
					$lista_produto[$reg_item->ID_Produto]['cod'] = $reg_prod[1];
				}

				$data_base = data2nr(dataf($reg_ped->DH_Emissao));
				if(dataf($reg_ped->DH_Entrega)!='00/00/0000'){
					$data_base = data2nr(dataf($reg_ped->DH_Entrega));
				}

				//geral
				if(isset($lista_geral['G'][$reg_item->ID_Produto][$data_base])){
					$lista_todos = $lista_geral['G'][$reg_item->ID_Produto][$data_base];
				}else{
					$lista_todos['romaneio'] = 0;
					$lista_todos['romaneio_valor'] = 0;
					$lista_todos['vendas'] = 0;
					$lista_todos['vendas_valor'] = 0;
					$lista_todos['trocas'] = 0;
					$lista_todos['trocas_valor'] = 0;
				}
				if($reg_ped->Tipo_Pedido=='-1'){
					$lista_todos['trocas']+= $reg_item->Qtd;
					$lista_todos['trocas_valor']+= arredonda_numero(($reg_item->Qtd*$reg_item->Valor_Unitario)*100)/100;
				}else{
					$lista_todos['vendas']+= $reg_item->Qtd;
					$lista_todos['vendas_valor']+= arredonda_numero(($reg_item->Qtd*$reg_item->Valor_Unitario)*100)/100;
				}

				$lista_geral['G'][$reg_item->ID_Produto][$data_base] = $lista_todos;

				if(isset($lista_vendedor[$reg_ped->Vendedor][$reg_item->ID_Produto][$data_base])){
					$lista_todos = $lista_vendedor[$reg_ped->Vendedor][$reg_item->ID_Produto][$data_base];
				}else{
					$lista_todos['romaneio'] = 0;
					$lista_todos['romaneio_valor'] = 0;
					$lista_todos['vendas'] = 0;
					$lista_todos['vendas_valor'] = 0;
					$lista_todos['trocas'] = 0;
					$lista_todos['trocas_valor'] = 0;
				}
				if($reg_ped->Tipo_Pedido=='-1'){
					$lista_todos['trocas']+= $reg_item->Qtd;
					$lista_todos['trocas_valor']+= arredonda_numero(($reg_item->Qtd*$reg_item->Valor_Unitario)*100)/100;
				}else{
					$lista_todos['vendas']+= $reg_item->Qtd;
					$lista_todos['vendas_valor']+= arredonda_numero(($reg_item->Qtd*$reg_item->Valor_Unitario)*100)/100;
				}

				$lista_vendedor[$reg_ped->Vendedor][$reg_item->ID_Produto][$data_base] = $lista_todos;
			}
		}
	}

	if(!empty($lista_vendedor)){
		arsort($lista_vendedor);
	}

	foreach($lista_vendedor as $cod_vend => $valor_v){
		$lista_geral[$cod_vend] = $lista_vendedor[$cod_vend];
	}

	if($vendedor!=''){
		unset($lista_geral['G']);
	}

	//print_r($lista_geral);

	if($counter>0){
		$v = 0;
		foreach($lista_geral as $cod_vend => $valor_v){
			$lista_geral2 = $lista_geral[$cod_vend];

			if(is_numeric($cod_vend)){ // "G" == 0 retorna "true"
				if($cod_vend > 0){
					$cons_vend = 'select Nome_Listas, Pessoa from pessoa '.
								' where Dominio = "'.$_SESSION["Dominio"].'"'.
								' and Pessoa = "'.$cod_vend.'"';
					$res_vend = consulta_sql($cons_vend);
					$reg_vend = consulta_ler_linha($res_vend);
					consulta_limpa($res_vend);

					$nome_vend = '';
					$nome_exp = explode(' ',$reg_vend[0]);
					if($nome_exp[0]!=''){
						$nome_vend = '-'.$nome_exp[0];
					}
					$titulo_sheet = trim('VEND '.$reg_vend[1].$nome_vend);
					$desc_vend = $cod_vend.' - '.$reg_vend[0];

					$tamanho_desc = strlen($titulo_sheet);
					while ($tamanho_desc>31){
						$titulo_sheet = trim(substr($titulo_sheet,0,strlen($titulo_sheet)-1));
						$tamanho_desc = strlen($titulo_sheet);
					}
				}else{
					$titulo_sheet = 'VEND 0';
					$desc_vend = 'SEM VENDEDOR';
				}
			}else{
				$titulo_sheet = 'GERAL';
				$desc_vend = 'TODOS';
			}

			$worksheetT =& $workbook->add_worksheet($titulo_sheet);
			$worksheetT->set_landscape();
			$worksheetT->write_string(0,0,'RELATRIO DE DEMONSTRATIVO POR DIA',$formatot);
			$worksheetT->write(2,0,config_pad('sistema_licenca'));
			$worksheetT->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
			$worksheetT->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
			$worksheetT->write(7,0,"Filtro: ".$filtro);

			$worksheetT->write(8,0,"Vendedor: ".$desc_vend);
			$qtd_dias = diffDate(datad($data_ini), datad($data_fim), 'D');

			$linha_r = 9;
			$linha_vend = 9;

			$linha_r++;
			$coluna_r=0;
			$worksheetT->set_column($coluna_r,$coluna_r,24);
			$worksheetT->write_string($linha_r,$coluna_r,'ITENS',$formatott);
			$worksheetT->write_blank(($linha_r+1),$coluna_r, $formatott);
			$worksheetT->merge_cells($linha_r, $coluna_r, ($linha_r+1), $coluna_r);
			$coluna_r++;

			//ROMANEIO
			$coluna_ini = $coluna_r;
			$worksheetT->set_column($coluna_r,$coluna_r,20);
			$worksheetT->write_string($linha_r,$coluna_r,'ROMANEIO',$formatott);
			$qtd_colunas = ($qtd_dias+2);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+$qtd_colunas-1));
			$coluna_r++;
			for($rb=0;$rb<$qtd_colunas-1;$rb++){
				$worksheetT->write_blank($linha_r,$coluna_r,$formatott); //acertar bordas
				$coluna_r++;
			}

			//$worksheetT->write_blank($linha_r,($coluna_r+$qtd_dias+1), $formatott);
			//$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+$qtd_dias+1));

			$nr_data_ini = data2nr($data_ini);
			$nr_data_fim = data2nr($data_fim);
			for($day=$nr_data_ini;$day<=$nr_data_fim;$day++){
				$worksheetT->set_column($coluna_ini,$coluna_ini,5.5);
				$worksheetT->write_string($linha_r+1,$coluna_ini,substr(nr2data($day),0,5),$formatott);
				$coluna_ini++;
			}
			$coluna_final = $coluna_ini;
			$coluna_r = $coluna_final;

			$worksheetT->set_column($coluna_r,$coluna_r,7);
			$worksheetT->write_string($linha_r+1,$coluna_r,'TOTAL',$formatott);
			$coluna_r++;

			$worksheetT->set_column($coluna_r,$coluna_r,1);
			$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
			$coluna_r++;

			//VENDAS
			$coluna_ini = $coluna_r;
			$worksheetT->set_column($coluna_r,$coluna_r,20);
			$worksheetT->write_string($linha_r,$coluna_r,'VENDAS',$formatott);
			$qtd_colunas = (($qtd_dias+2)*2);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, $coluna_r+$qtd_colunas-1);
			$coluna_r++;
			for($rb=0;$rb<$qtd_colunas-1;$rb++){
				$worksheetT->write_blank($linha_r,$coluna_r,$formatott); //acertar bordas
				$coluna_r++;
			}

			$nr_data_ini = data2nr($data_ini);
			$nr_data_fim = data2nr($data_fim);
			for($day=$nr_data_ini;$day<=$nr_data_fim;$day++){
				$worksheetT->set_column($coluna_ini,$coluna_ini+1,5.5);
				$worksheetT->write_string($linha_r+1,$coluna_ini,substr(nr2data($day),0,5),$formatott);

				$worksheetT->merge_cells($linha_r+1, $coluna_ini, $linha_r+1, ($coluna_ini+1));
				for($rb=0;$rb<1;$rb++){
					$coluna_ini++;
					$worksheetT->write_blank($linha_r+1,$coluna_ini,$formatott); //acertar bordas
				}
				$coluna_ini++;
			}
			$coluna_final = $coluna_ini;
			$coluna_r = $coluna_final;

			$worksheetT->set_column($coluna_r,$coluna_r+1,7);
			$worksheetT->write_string($linha_r+1,$coluna_r,'TOTAL',$formatott);
			$worksheetT->merge_cells($linha_r+1, $coluna_r, $linha_r+1, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r+1,$coluna_r,$formatott); //acertar bordas
			}
			$coluna_r++;

			$worksheetT->set_column($coluna_r,$coluna_r,1);
			$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
			$coluna_r++;
			$coluna_ini = $coluna_r;

			//TROCAS
			$coluna_ini = $coluna_r;
			$worksheetT->set_column($coluna_r,$coluna_r,20);
			$worksheetT->write_string($linha_r,$coluna_r,'TROCAS',$formatott);
			$qtd_colunas = (($qtd_dias+2)*2);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, $coluna_r+$qtd_colunas-1);
			$coluna_r++;
			for($rb=0;$rb<$qtd_colunas-1;$rb++){
				$worksheetT->write_blank($linha_r,$coluna_r,$formatott); //acertar bordas
				$coluna_r++;
			}

			$nr_data_ini = data2nr($data_ini);
			$nr_data_fim = data2nr($data_fim);
			for($day=$nr_data_ini;$day<=$nr_data_fim;$day++){
				$worksheetT->set_column($coluna_ini,$coluna_ini+1,5.5);
				$worksheetT->write_string($linha_r+1,$coluna_ini,substr(nr2data($day),0,5),$formatott);

				$worksheetT->merge_cells($linha_r+1, $coluna_ini, $linha_r+1, ($coluna_ini+1));
				for($rb=0;$rb<1;$rb++){
					$coluna_ini++;
					$worksheetT->write_blank($linha_r+1,$coluna_ini,$formatott); //acertar bordas
				}
				$coluna_ini++;
			}
			$coluna_final = $coluna_ini;
			$coluna_r = $coluna_final;

			$worksheetT->set_column($coluna_r,$coluna_r+1,7);
			$worksheetT->write_string($linha_r+1,$coluna_r,'TOTAL',$formatott);
			$worksheetT->merge_cells($linha_r+1, $coluna_r, $linha_r+1, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r+1,$coluna_r,$formatott); //acertar bordas
			}
			$coluna_r++;

			$worksheetT->set_column($coluna_r,$coluna_r,1);
			$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
			$coluna_r++;
			$coluna_ini = $coluna_r;

			//TROCAS
			$coluna_ini = $coluna_r;
			$worksheetT->set_column($coluna_r,$coluna_r,20);
			$worksheetT->write_string($linha_r,$coluna_r,'RETORNO',$formatott);
			$qtd_colunas = (($qtd_dias+2)*2);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, $coluna_r+$qtd_colunas-1);
			$coluna_r++;
			for($rb=0;$rb<$qtd_colunas-1;$rb++){
				$worksheetT->write_blank($linha_r,$coluna_r,$formatott); //acertar bordas
				$coluna_r++;
			}

			$nr_data_ini = data2nr($data_ini);
			$nr_data_fim = data2nr($data_fim);
			for($day=$nr_data_ini;$day<=$nr_data_fim;$day++){
				$worksheetT->set_column($coluna_ini,$coluna_ini+1,5.5);
				$worksheetT->write_string($linha_r+1,$coluna_ini,substr(nr2data($day),0,5),$formatott);

				$worksheetT->merge_cells($linha_r+1, $coluna_ini, $linha_r+1, ($coluna_ini+1));
				for($rb=0;$rb<1;$rb++){
					$coluna_ini++;
					$worksheetT->write_blank($linha_r+1,$coluna_ini,$formatott); //acertar bordas
				}
				$coluna_ini++;
			}
			$coluna_final = $coluna_ini;
			$coluna_r = $coluna_final;

			$worksheetT->set_column($coluna_r,$coluna_r+1,7);
			$worksheetT->write_string($linha_r+1,$coluna_r,'TOTAL',$formatott);
			$worksheetT->merge_cells($linha_r+1, $coluna_r, $linha_r+1, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r+1,$coluna_r,$formatott); //acertar bordas
			}
			$coluna_geral_final = $coluna_r;

			$linha_r++;
			$linha_r++;

			$total_romaneio_valor = 0;
			$total_vendas_valor = 0;
			$total_trocas_valor = 0;
			$total_retorno_valor = 0;
			foreach($lista_produto as $cod_prod => $valor_p){
				$coluna_r = 0;
				$total_romaneio = 0;
				$total_vendas = 0;
				$total_trocas = 0;
				$total_retorno = 0;

				//cria coluna produto
				$worksheetT->write_string($linha_r,$coluna_r,$lista_produto[$cod_prod]['nome'],$fmt_produto_txt);
				$coluna_r++;

				//for romaneio - difdias+1
				for($d=0;$d<($qtd_dias+1);$d++){
					$valor_c = '';
					if(isset($lista_geral2[$cod_prod][$dia_ini+$d])){
						$valor_c = $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio'];
						if($valor_c<=0){
							$valor_c = '';
						}
						$total_romaneio+= $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio'];
						$total_romaneio_valor+= $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio_valor'];
					}
					if($valor_c!=''){
						$worksheetT->write_number($linha_r,$coluna_r,$valor_c,$fmt_romaneio_qtd);
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,$valor_c,$fmt_romaneio_txt);
					}
					$coluna_r++;
				}
				//total romaneio
				if($total_romaneio>0){
					$worksheetT->write_number($linha_r,$coluna_r,$total_romaneio,$fmt_romaneio_qtd);
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_romaneio_txt);
				}
				$coluna_r++;

				//coluna branco
				$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
				$coluna_r++;

				//for venda - difdias+1
				for($d=0;$d<($qtd_dias+1);$d++){
					$valor_c = '';
					if(isset($lista_geral2[$cod_prod][$dia_ini+$d])){
						$valor_c = $lista_geral2[$cod_prod][$dia_ini+$d]['vendas'];
						if($valor_c<=0){
							$valor_c = '';
						}
						$total_vendas+= $lista_geral2[$cod_prod][$dia_ini+$d]['vendas'];
						$total_vendas_valor+= $lista_geral2[$cod_prod][$dia_ini+$d]['vendas_valor'];
					}
					$romaneio_dia = $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio'];
					$perc_dia = 0;

					if($valor_c!=''){
						$worksheetT->write_number($linha_r,$coluna_r,$valor_c,$fmt_vendas_qtd);
						$coluna_r++;

						//percentagem
						if($romaneio_dia>0.0001){
							$perc_dia = ($valor_c/$romaneio_dia);
						}
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,$valor_c,$fmt_vendas_txt);
						$coluna_r++;
					}

					if($perc_dia>0){
						$worksheetT->write_number($linha_r,$coluna_r,$perc_dia,$fmt_vendas_total);
						$coluna_r++;
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_vendas_txt);
						$coluna_r++;
					}
				}
				//total venda
				if($total_vendas>0){
					$worksheetT->write_number($linha_r,$coluna_r,$total_vendas,$fmt_vendas_qtd);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_vendas_txt);
					$coluna_r++;
				}

				if($total_romaneio>0){
					$perc_vendas_total = ($total_vendas/$total_romaneio);
				}else{
					$perc_vendas_total=0;
				}
				if($perc_vendas_total>0){
					$worksheetT->write_number($linha_r,$coluna_r,$perc_vendas_total,$fmt_vendas_total);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_vendas_txt);
					$coluna_r++;
				}

				//coluna branco
				$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
				$coluna_r++;

				//for troca - difdias+1
				for($d=0;$d<($qtd_dias+1);$d++){
					$valor_c = '';
					if(isset($lista_geral2[$cod_prod][$dia_ini+$d])){
						$valor_c = $lista_geral2[$cod_prod][$dia_ini+$d]['trocas'];
						if($valor_c<=0){
							$valor_c = '';
						}
						$total_trocas+= $lista_geral2[$cod_prod][$dia_ini+$d]['trocas'];
						$total_trocas_valor+= $lista_geral2[$cod_prod][$dia_ini+$d]['trocas_valor'];
					}
					$romaneio_dia = $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio'];
					$perc_dia = 0;

					if($valor_c!=''){
						$worksheetT->write_number($linha_r,$coluna_r,$valor_c,$fmt_trocas_qtd);
						$coluna_r++;

						//percentagem
						if($romaneio_dia>0.0001){
							$perc_dia = ($valor_c/$romaneio_dia);
						}
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,$valor_c,$fmt_trocas_txt);
						$coluna_r++;
					}

					if($perc_dia>0){
						$worksheetT->write_number($linha_r,$coluna_r,$perc_dia,$fmt_trocas_total);
						$coluna_r++;
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_trocas_txt);
						$coluna_r++;
					}
				}
				//total troca
				if($total_trocas>0){
					$worksheetT->write_number($linha_r,$coluna_r,$total_trocas,$fmt_trocas_qtd);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_trocas_txt);
					$coluna_r++;
				}

				if($total_romaneio>0){
					$perc_trocas_total = ($total_trocas/$total_romaneio);
				}else{
					$perc_trocas_total=0;
				}
				if($perc_trocas_total>0){
					$worksheetT->write_number($linha_r,$coluna_r,$perc_trocas_total,$fmt_trocas_total);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_trocas_txt);
					$coluna_r++;
				}

				//coluna branco
				$worksheetT->write_blank($linha_r,$coluna_r, $fmt_branco);
				$coluna_r++;

				//for retorno - difdias+1
				for($d=0;$d<($qtd_dias+1);$d++){
					$valor_c = '';
					if(isset($lista_geral2[$cod_prod][$dia_ini+$d])){
						$valor_c = ($lista_geral2[$cod_prod][$dia_ini+$d]['romaneio']-$lista_geral2[$cod_prod][$dia_ini+$d]['vendas']-$lista_geral2[$cod_prod][$dia_ini+$d]['trocas']);
						if(($valor_c<=0.001)&&($valor_c> (-0.001))){
							$valor_c = 0;
						}
						$total_retorno+= ($valor_c);
						if($valor_c==0){
							$valor_c = '';
						}
						$retorno_valor = ($lista_geral2[$cod_prod][$dia_ini+$d]['romaneio_valor']-$lista_geral2[$cod_prod][$dia_ini+$d]['vendas_valor']-$lista_geral2[$cod_prod][$dia_ini+$d]['trocas_valor']);
						if(($retorno_valor<=0.001)&&($retorno_valor> (-0.001))){
							$retorno_valor = 0;
						}
						$total_retorno_valor+= ($retorno_valor);
					}
					$romaneio_dia = $lista_geral2[$cod_prod][$dia_ini+$d]['romaneio'];
					$perc_dia = 0;

					if($valor_c!=''){
						$worksheetT->write_number($linha_r,$coluna_r,$valor_c,$fmt_retorno_qtd);
						$coluna_r++;

						//percentagem
						if($romaneio_dia>0.0001){
							$perc_dia = ($valor_c/$romaneio_dia);
						}
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,$valor_c,$fmt_retorno_txt);
						$coluna_r++;
					}

					if($perc_dia>0.001){
						$worksheetT->write_number($linha_r,$coluna_r,$perc_dia,$fmt_retorno_total);
						$coluna_r++;
					}else{
						$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_retorno_txt);
						$coluna_r++;
					}
				}
				//total retorno
				if($total_retorno>0){
					$worksheetT->write_number($linha_r,$coluna_r,$total_retorno,$fmt_retorno_qtd);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_retorno_txt);
					$coluna_r++;
				}

				if($total_romaneio>0){
					$perc_retorno_total = ($total_retorno/$total_romaneio);
				}else{
					$perc_retorno_total=0;
				}
				if($perc_retorno_total>0){
					$worksheetT->write_number($linha_r,$coluna_r,$perc_retorno_total,$fmt_retorno_total);
					$coluna_r++;
				}else{
					$worksheetT->write_string($linha_r,$coluna_r,'',$fmt_retorno_txt);
					$coluna_r++;
				}

				$linha_r++;
			}

			//total romaneio
			$linha_r++;
			$coluna_r=0;
			$worksheetT->write_string($linha_r,$coluna_r,'TOTAL DE CARGA:',$fmt_romaneio_txt);
			//$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			//for($rb=0;$rb<1;$rb++){
			//$coluna_r++;
			//$worksheetT->write_blank($linha_r,$coluna_r,$fmt_romaneio_txt); //acertar bordas
			//}
			$coluna_r++;

			$worksheetT->write_number($linha_r,$coluna_r,$total_romaneio_valor,$fmt_romaneio_valor);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+5));
			for($rb=0;$rb<5;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_romaneio_txt); //acertar bordas
			}
			$coluna_r++;

			//total vendas
			$linha_r++;
			$coluna_r=0;
			$worksheetT->write_string($linha_r,$coluna_r,'TOTAL DE VENDAS:',$fmt_vendas_txt);
			//$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			//for($rb=0;$rb<1;$rb++){
			//$coluna_r++;
			//$worksheetT->write_blank($linha_r,$coluna_r,$fmt_vendas_txt); //acertar bordas
			//}
			$coluna_r++;

			$worksheetT->write_number($linha_r,$coluna_r,$total_vendas_valor,$fmt_vendas_valor);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+3));
			for($rb=0;$rb<3;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_vendas_txt); //acertar bordas
			}
			$coluna_r++;

			if($total_romaneio_valor>0){
				$total_vendas_perc = ($total_vendas_valor/$total_romaneio_valor);
			}else{
				$total_vendas_perc=0;
			}
			$worksheetT->write_number($linha_r,$coluna_r,$total_vendas_perc,$fmt_vendas_total);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_vendas_txt); //acertar bordas
			}
			$coluna_r++;

			//total trocas
			$linha_r++;
			$coluna_r=0;
			$worksheetT->write_string($linha_r,$coluna_r,'TOTAL DE TROCAS:',$fmt_trocas_txt);
			//$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			//for($rb=0;$rb<1;$rb++){
			//$coluna_r++;
			//$worksheetT->write_blank($linha_r,$coluna_r,$fmt_trocas_txt); //acertar bordas
			//}
			$coluna_r++;

			$worksheetT->write_number($linha_r,$coluna_r,$total_trocas_valor,$fmt_trocas_valor);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+3));
			for($rb=0;$rb<3;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_trocas_txt); //acertar bordas
			}
			$coluna_r++;

			if($total_romaneio_valor>0){
				$total_trocas_perc = ($total_trocas_valor/$total_romaneio_valor);
			}else{
				$total_trocas_perc=0;
			}
			$worksheetT->write_number($linha_r,$coluna_r,$total_trocas_perc,$fmt_trocas_total);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_trocas_txt); //acertar bordas
			}
			$coluna_r++;

			//total retorno
			$linha_r++;
			$coluna_r=0;
			$worksheetT->write_string($linha_r,$coluna_r,'TOTAL DE RETORNO:',$fmt_retorno_txt);
			//$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			//for($rb=0;$rb<1;$rb++){
			//$coluna_r++;
			//$worksheetT->write_blank($linha_r,$coluna_r,$fmt_retorno_txt); //acertar bordas
			//}
			$coluna_r++;

			$worksheetT->write_number($linha_r,$coluna_r,$total_retorno_valor,$fmt_retorno_valor);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+3));
			for($rb=0;$rb<3;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_retorno_txt); //acertar bordas
			}
			$coluna_r++;

			if($total_romaneio_valor>0){
				$total_retorno_perc = ($total_retorno_valor/$total_romaneio_valor);
			}else{
				$total_retorno_perc=0;
			}
			$worksheetT->write_number($linha_r,$coluna_r,$total_retorno_perc,$fmt_retorno_total);
			$worksheetT->merge_cells($linha_r, $coluna_r, $linha_r, ($coluna_r+1));
			for($rb=0;$rb<1;$rb++){
				$coluna_r++;
				$worksheetT->write_blank($linha_r,$coluna_r,$fmt_retorno_txt); //acertar bordas
			}
			$coluna_r++;

		}//fim foreach vendedor
		//foreach registros
	}else{
		$titulo_sheet = 'GERAL';
		$worksheetT =& $workbook->add_worksheet($titulo_sheet);
		$worksheetT->set_landscape();
		$worksheetT->write_string(0,0,'RELATRIO DE DEMONSTRATIVO POR DIA',$formatot);
		$worksheetT->write(2,0,config_pad('sistema_licenca'));
		$worksheetT->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
		$worksheetT->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
		$worksheetT->write(7,0,"Filtro: ".$filtro);
		$worksheetT->write(10,0,"No existem registros para este filtro!");
	}

	consulta_limpa($res_ped);

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();

?>