<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$empresa = ($_REQUEST['empresa'] != '') ? $_REQUEST['empresa'] : $_SESSION['Empresa_Codigo'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$tipo = $_REQUEST['tipo'];
	$situacao = $_REQUEST['situacao'];

	$filtro = '';
	$lista_geral = array();

	$label = label_vendedor_ou_rep_comercial('S');

	$consulta = 'SELECT Empresa, Numero_Pedido, Pessoa, DH_Emissao, Vendedor, Status, '.
				  ' Valor_Total_Liquido, Valor_Desconto, Usuario_Desconto, Forma_Pagto, Fatura_Tipo'.
				  ' FROM pedido '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
				  ' AND Empresa = "'.$empresa.'" '.
				  ' AND Status <> "E"';

	if(($dt_ini != '') && ($dt_fim != '')){
		$consulta.= 'AND ((DH_Emissao >= "'.datad($dt_ini).' 00:00:00") '.
					'AND (DH_Emissao <= "'.datad($dt_fim).' 23:59:59")) ';

		$filtro.= 'Perodo: De "'.$dt_ini.'"'.
					' At "'.$dt_fim.'"';
	}

	if($situacao == 'T'){
		$consulta .= ' AND Status <> "E" AND Status <> "C" ';
		$filtro .= ' Situao: "Todos" ';
	}else if($situacao == 'A'){
		$consulta .= ' AND (( Status = "A" ) OR '.
					'      ( Status = "L" ) OR '.
					'      ( Status = "P" ))';
		$filtro .= ' Situao: "Em Aberto" ';
	}else if($situacao == 'F'){
		$consulta .= ' AND Status = "F" ';
		$filtro .= ' Situao: "Fechados" ';
	}

	if($cliente != ''){
		$consulta.= ' AND Pessoa = "'.$cliente.'" ';

		$cons_cli = 'SELECT Nome_Listas FROM pessoa '.
				 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				 ' AND Pessoa = "'.$cliente.'"';
		$res_cli = consulta_sql($cons_cli);
		$reg_cli = consulta_ler_linha($res_cli);
		consulta_limpa($res_cli);
		$filtro.= ' Cliente: "'.$reg_cli[0].'"';
	}

	if($vendedor != ''){
		$consulta.= ' AND Vendedor = "'.$vendedor.'" ';

		$cons_vend = 'SELECT Nome_Listas FROM pessoa '.
				  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				  ' AND Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);

		$label_emp = empresa_representante($vendedor, 'S');

		$filtro.= ' '.$label.': "'.$label_emp.'"';
	}

	$consulta.= ' ORDER BY Numero_Pedido';
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	$vl_total = 0;
	$vl_total_descto = 0;

	for($t=0; $t<$nrows; $t++){
		$registro = consulta_ler_objeto($resultado);

		$nr_pedido = $registro->Numero_Pedido;
		$vl_juros = 0;
		$vl_desc = 0;
		$vl_principal = 0;
		$vl_recebidos = 0;
		$vl_receber = 0;
		$codigo = $registro->Empresa;

		$lista_geral[$nr_pedido]['Numero_Pedido'] = $nr_pedido;
		$lista_geral[$nr_pedido]['Valor_Total_Liquido'] = $registro->Valor_Total_Liquido;
		$lista_geral[$nr_pedido]['Valor_Desconto'] = $registro->Valor_Desconto;
		$lista_geral[$nr_pedido]['Usuario_Desconto'] = $registro->Usuario_Desconto;
		$lista_geral[$nr_pedido]['DH_Emissao'] = $registro->DH_Emissao;
		$lista_geral[$nr_pedido]['Cliente'] = $registro->Pessoa;
		$lista_geral[$nr_pedido]['Forma_Pagto'] = $registro->Forma_Pagto;
		$lista_geral[$nr_pedido]['Fatura_Tipo'] = $registro->Fatura_Tipo;
	}//fim for
	consulta_limpa($resultado);

	//var_dump2($lista_geral);

	$pdf=new FPDF();
	$pdf->Open();
	$pdf->Cabecalho = 'Relatrio '.busca_nome_pedido_orc().' de Descontos';
	//$pdf->Cabecalho =  'Relatrio Oramento Descontos';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	set_time_limit(60);

	if(!empty($lista_geral)){
		$lns = 0;
		$k=0;
		$pdf->CabecalhoGrid_Texto = '';

		$pdf->CabecalhoGrid_Texto[$k] = 'Nr. Pedido';
		$pdf->CabecalhoGrid_Tamanho[$k] = '8';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
		$pdf->CabecalhoGrid_Tamanho[$k] = '36';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Data Emisso';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Forma Pagto.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '12';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Valor Total';
		$pdf->CabecalhoGrid_Tamanho[$k] = '12';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Valor Desc.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '12';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Usurio Desc.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos = 7;
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$lns = 5;
		$larg = 190;
		$lista_empresas = lista_empresas();
		$total_receber = 0;
		$total_recebido = 0;
		$total_inadimplencia = 0;

		foreach($lista_geral as $key => $value){
			$registro = $value;

			$lns = 0;
			$k = 0;

			$pdf->SetFont('Arial','',7);
			$pdf->Cell(1,      $lns, '', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',7);

			$rowarr[$k]  = $registro['Numero_Pedido'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$cons_cli = 'SELECT Pessoa, Nome_Fantasia FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$registro['Cliente'].'"';
			$res_cli = consulta_sql($cons_cli);
			$reg_cli = consulta_ler_linha($res_cli);
			consulta_limpa($res_cli);
			$desc_cli = $reg_cli[0].' - '.$reg_cli[1];

			$rowarr[$k] = $desc_cli;
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++; 

			$rowarr[$k] = dataf($registro['DH_Emissao']);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$con_pagto = 'SELECT Descricao FROM forma_pagto '.
						 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						 ' AND Codigo_Pagto = "'.$registro['Forma_Pagto'].'"';
			$res_pagto = consulta_sql($con_pagto);
			$reg_pagto = consulta_ler_linha($res_pagto);
			consulta_limpa($res_pagto);

			$rowarr[$k] = $reg_pagto[0];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$vl_total += $registro['Valor_Total_Liquido'];
			$rowarr[$k] = to_money($registro['Valor_Total_Liquido'], false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$vl_total_descto += $registro['Valor_Desconto'];
			$rowarr[$k] = to_money($registro['Valor_Desconto'], false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			//$perc = '';
			$rowarr[$k] = $registro['Usuario_Desconto'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$lns = $lns * 5;

			for($k=0; $k<$ncampos; $k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
			}

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
		}

		$lns = 5;

		$pdf->Cell(1,      $lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$pdf->SetFont('Arial','B',8);
		$y=$pdf->y;
		$pdf->MultiCell((66/100)*190, $lns, 'TOTAL', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		//$pdf->MultiCell((22/100)*190, $lns, str_replace('"','',to_money($total_receber)), 'T', 'R');
		$pdf->MultiCell((12/100)*190, $lns, to_money($vl_total, false), 'T', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*190, $lns, to_money($vl_total_descto, false), 'T', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((10/100)*190, $lns, '', 'T', 'R');
		$pdf->y=$y;
		

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30); 

	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>