<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){      
	$dominios = array();
	$dominios['11'] = '11';

	$empresa = $_REQUEST['empresa'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$produto = $_REQUEST['produto'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];
	$uf = $_REQUEST['uf'];
	$cidade = $_REQUEST['cidade'];
	$situacao = $_REQUEST['situacao'];
	$trader = $_REQUEST['trader'];
	$tipo_ped = $_REQUEST['tipo_ped'];
	$fornecedor = $_REQUEST['fornec'];
	$departamento = $_REQUEST['depart'];

	$filtro = '';
	$lista_geral = array();
	$label = label_vendedor_ou_rep_comercial('S');

	$consulta = 'SELECT Numero_Pedido, Pessoa, Cupom_COO, Cupom_Caixa, DH_Emissao, Vendedor, '.
				  ' Valor_Total_Liquido, Empresa, Status, Local_Fatura, Bloqueio_Adm '.
				  ' FROM pedido '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				  ' AND Status <> "E"';

	if($empresa != ''){
		$consulta.= ' AND Empresa = "'.$empresa.'" ';
		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' AND Pessoa = "'.$empresa.'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}

	if(($data_ini != '') || ($data_fim != '')){
		$filtro.= ' Data:';
		if($data_ini!=''){
			$consulta.= ' AND DH_Emissao >= "'.datad($data_ini).'" ';
			$filtro.= ' De: "'.$data_ini.'"';
		}
		if($data_fim!=''){
			$consulta.= ' AND DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
			$filtro.= ' At: "'.$data_fim.'"';
		}
	}

	if($vendedor != ''){
		$consulta.= ' AND Vendedor = "'.$vendedor.'"';
		$cons_vend = 'select Nome_Listas, Pessoa from pessoa '.
					 ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' and Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);
		$label_emp = empresa_representante($vendedor);
		$filtro.= ' '.$label.': "'.$label_emp.'"';
	}

	if($cliente != ''){
		$consulta.= ' AND Pessoa = "'.$cliente.'"';
		$cons_cliente = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
					 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' AND Pessoa = "'.$cliente.'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);
		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';
	}

	if($trader != ''){
		$consulta.= ' AND Trader = "'.$trader.'"';
		$cons_trader = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$trader.'"';
		$res_trader = consulta_sql($cons_trader);
		$reg_trader = consulta_ler_linha($res_trader);
		consulta_limpa($res_trader);
		$filtro.= ' Trader: "'.$reg_trader[0].'"';
	}

	if($tipo_ped != ''){
		$consulta.= ' AND Tipo_Pedido = "'.$tipo_ped.'"';
		$cons_tipo = 'SELECT Descricao FROM tipo_pedido '.
				  ' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				  ' AND Codigo_Tipo="'.$tipo_ped.'"';
		$res_tipo = consulta_sql($cons_tipo);
		$reg_tipo = consulta_ler_linha($res_tipo);
		consulta_limpa($res_tipo);
		$filtro.= ' Tipo: "'.$reg_tipo[0].'"';
	}

	if($situacao!=''){
		$filtro.= ' Situao:';
		if($situacao == 'A'){
			$consulta.= ' AND ((Status = "A") or (Status = "L") or (Status = "P"))';
			$filtro.= ' "Em Aberto"';
		}else if($situacao == 'S'){
			$consulta.= ' AND Status = "A"';
			$filtro.= ' "Somente Abertos"';
		}else if($situacao == 'F'){
			$consulta.= ' AND Status = "F"';
			$filtro.= ' "Fechado"';
		}else if($situacao == 'P'){
			//faz validacao no item
			$filtro.= ' "Pendente de Liberao"';
		}else if($situacao == 'L'){
			//faz validacao no item
			$filtro.= ' "Somente Liberados"';
		}else if($situacao == 'C'){
			//faz validacao no item
			//$consulta.= ' AND Status = "C"';
			$filtro.= ' "Cancelados"';
		}else if($situacao=='B'){
			/**Modificacao para Zathura 19/04/2021 */		
			$consulta.= ' AND (Status = "L" AND Bloqueio_Adm="S") ';
			$filtro.= ' "Bloqueio Administrativo"';
		}
	}else{
		$filtro.= ' Situao: "Todos"';
	}

	if($uf != ''){
		/*$con_est = 'select Nome from uf '.
				 ' where Dominio="'.$_SESSION['Dominio'].'"'.
				 ' and UF = "'.$uf.'"';
		$res_est = consulta_sql($con_est);
		$reg_est = consulta_ler_linha($res_est);
		consulta_limpa($res_est);*/
		$filtro.= ' Estado: "'.$uf.'"';
	}

	if($cidade != ''){
		$con_cid = 'SELECT Nome FROM cidade '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Codigo_Cidade = "'.$cidade.'"';
		$res_cid = consulta_sql($con_cid);
		$reg_cid = consulta_ler_linha($res_cid);
		consulta_limpa($res_cid);

		$filtro.= ' Cidade: "'.$reg_cid[0].'"';
	}

	/* if($fornecedor != ''){
	 $cons_fornec = 'SELECT Nome_Listas, Pessoa FROM pessoa '.
					' WHERE Pessoa = "'.$fornecedor.'"'.
					' AND Dominio = "'.$_SESSION["Dominio"].'"';
	 $res_fornec = consulta_sql($cons_fornec);
	 $reg_fornec = consulta_ler_linha($res_fornec);
	 consulta_limpa($res_fornec);

	 $filtro.= ' Fornecedor: "'.$reg_fornec[0].'"';
	}

	$depart = '';
	if($departamento != ''){
	 $filtro_depart = '';

	 $lista_depart = explode(';',$_REQUEST['depart']);
	 foreach($lista_depart as $key => $valor){
		if($valor!=''){
		   $depart[$valor] = 1;

		   if($filtro_depart == ''){
			  $filtro_depart = ' Departamentos:';
		   }else{
			  $filtro_depart.= ',';
		   }

		   $cons_filt_depart = 'SELECT Codigo_Depart, Descricao '.
							   ' FROM produto_departamento '.
							   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							   ' AND Situacao <> "E" '.
							   ' AND Codigo_Depart <> 0 '.
							   ' AND Codigo_Depart = "'.$valor.'" '.
							   ' ORDER BY Descricao ';
		   $res_filt_depart = consulta_sql($cons_filt_depart);
		   $reg_filt_depart = consulta_ler_linha($res_filt_depart);
		   $filtro_depart.= ' "'.$reg_filt_depart[1].'"';
		}
	 }

	 if($filtro_depart !=''){
		$filtro.= $filtro_depart;
	 }
	} */

	$consulta.= ' ORDER BY Numero_Pedido ';

	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	for($t=0; $t<$nrows; $t++){
		$registro = consulta_ler_objeto($resultado);
		$ok = true;
		if(($uf != '') || ($cidade != '')){
			$con_cidade = 'SELECT UF, Codigo_Cidade FROM pessoa_endereco '.
						  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						  ' AND Pessoa = "'.$registro->Pessoa.'" '.
						  ' AND Seq_Endereco = "'.$registro->Local_Fatura.'"';
			$res_cidade = consulta_sql($con_cidade);
			$reg_cidade = consulta_ler_linha($res_cidade);
			consulta_limpa($res_cidade);
		}
		if($ok){
			if($uf != ''){
				$ok = ($uf == $reg_cidade[0]);
			}
		}
		if($ok){
			if($cidade != ''){
				$ok = ($cidade == $reg_cidade[1]);
			}
		}

		/* if($ok){
			if(($depart != '') || ($fornecedor != '')){
			   $cons_depart = 'SELECT Codigo_Depart, Codigo_Fornecedor FROM produto '.
							  ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.  
							  ' AND Id_Produto = "'.$reg_item->ID_Produto.'"';
			   $res_depart = consulta_sql($cons_depart);
			   $reg_depart = consulta_ler_linha($res_depart);
			   consulta_limpa($res_depart);

			   if($fornecedor != '') {
				  $ok = ($fornecedor == $reg_depart[1]);
			   }

			   if(($ok) && ($depart != '')){
				  $ok = (isset($depart[$reg_depart[0]]));
			   }
			}
		} */

		$nr_pedido = $registro->Numero_Pedido;
		$codigo = $registro->Empresa;

		if($ok){
			$cons_cli = 'SELECT Pessoa, Nome_Fantasia FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$registro->Pessoa.'"';
			$res_cli = consulta_sql($cons_cli);
			$reg_cli = consulta_ler_linha($res_cli);
			consulta_limpa($res_cli);
			$desc_cli = $reg_cli[0].' - '.$reg_cli[1];

			$cons_vend = 'SELECT Pessoa, Nome_Fantasia FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$registro->Vendedor.'"';
			$res_vend = consulta_sql($cons_vend);
			$reg_vend = consulta_ler_linha($res_vend);
			consulta_limpa($res_vend);
			$desc_vend = $reg_vend[0].' - '.$reg_vend[1];            

			$nr_doc = '';
			if($_SESSION['Dominio'] == $dominios['11']){
				$nr_doc = 'FPA';
			}
			if($registro->Cupom_COO > 0){
				$nr_doc = $registro->Cupom_COO.'/'.$registro->Cupom_Caixa.'-2D';
			}else{
				$con_nf = 'SELECT NrDoc, Serie, Modelo FROM nota_fiscal '.
							' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
							' AND Pedido_Empresa = "'.$registro->Empresa.'"'.
							' AND Pedido_Nr = "'.$registro->Numero_Pedido.'"'.
							' AND Situacao = "F"';
				$res_nf = consulta_sql($con_nf);
				$reg_nf = consulta_ler_linha($res_nf);
				consulta_limpa($res_nf);

				if($reg_nf[0] > 0){
					$nr_doc = $reg_nf[0].'/'.$reg_nf[1].'-'.$reg_nf[2];
				}
			}
			$lista_geral[$nr_pedido]['Numero_Pedido'] = $nr_pedido;
			$lista_geral[$nr_pedido]['Valor_Total_Liquido'] = $registro->Valor_Total_Liquido;
			$lista_geral[$nr_pedido]['DH_Emissao'] = $registro->DH_Emissao;
			$lista_geral[$nr_pedido]['Cliente'] = $registro->Pessoa;
			$lista_geral[$nr_pedido]['Cliente_Descricao'] = $desc_cli;
			$lista_geral[$nr_pedido]['Vendedor'] = $registro->Vendedor;
			$lista_geral[$nr_pedido]['Vendedor_Descricao'] = $desc_vend;
			$lista_geral[$nr_pedido]['Nr_Doc'] = $nr_doc;
		}
	}//fim for
	consulta_limpa($resultado);

	//var_dump2($lista_geral);

	$pdf=new FPDF();
	$pdf->Open();
	$pdf->Cabecalho = 'Relatrio de '.busca_nome_pedido_orc().'s';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	set_time_limit(60);

	if(!empty($lista_geral)){
		$lns = 0;
		$k=0;
		$pdf->CabecalhoGrid_Texto = '';

		$pdf->CabecalhoGrid_Texto[$k] = 'Nr '.busca_nome_pedido_orc('R');
		$pdf->CabecalhoGrid_Tamanho[$k] = '8';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
		$pdf->CabecalhoGrid_Tamanho[$k] = '36';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Nr Doc';
		$pdf->CabecalhoGrid_Tamanho[$k] = '9';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Dt '.busca_nome_pedido_orc('R');
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = $label;
		$pdf->CabecalhoGrid_Tamanho[$k] = '25';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Valor '.busca_nome_pedido_orc('R');
		$pdf->CabecalhoGrid_Tamanho[$k] = '12';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos = 6;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$lns = 5;
		$larg = 190;
		$lista_empresas = lista_empresas();
		$vl_total = 0;

		foreach($lista_geral as $registro){
			$lns = 0;
			$k = 0;

			$pdf->SetFont('Arial','',7);
			$pdf->Cell(1,      $lns, '', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',7);

			$rowarr[$k]  = $registro['Numero_Pedido'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = $registro['Cliente_Descricao'];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			while($lns_linha[$k] > 1){
				$rowarr[$k] = substr($rowarr[$k],0,strlen($rowarr[$k])-1);
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			}
			$vl_linha[$k] = $rowarr[$k];
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = $registro['Nr_Doc'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = dataf($registro['DH_Emissao']);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = $registro['Vendedor_Descricao'];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			while($lns_linha[$k] > 1){
				$rowarr[$k] = substr($rowarr[$k],0,strlen($rowarr[$k])-1);
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			}
			$vl_linha[$k] = $rowarr[$k];
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$vl_total += $registro['Valor_Total_Liquido'];
			$rowarr[$k] = to_money($registro['Valor_Total_Liquido'], false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
			if($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;
			
			$lns = $lns * 5;

			for($k=0; $k<$ncampos; $k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
			}

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
		}

		$lns = 5;

		$pdf->Cell(1,      $lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$pdf->SetFont('Arial','B',7);
		$y=$pdf->y;
		$pdf->MultiCell((88/100)*190, $lns, 'TOTAL', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*190, $lns, to_money($vl_total, false), 'T', 'R');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);
	}else{
		$pdf->CabecalhoGrid_Texto = '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>