<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	function sort_multi_array($multiArray, $secondIndex, $sort=SORT_ASC){
		while(list($firstIndex) = each($multiArray)){
			$indexMap[$firstIndex] = $multiArray[$firstIndex][$secondIndex];
		}
		if($sort === SORT_ASC){
			asort($indexMap);
		}else{
			arsort($indexMap);
		}
		while(list($firstIndex) = each($indexMap)){
			$sortedArray[$firstIndex] = $multiArray[$firstIndex];
		}
		return $sortedArray;
	}

	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){
	//---------------------------------------------------
	//require('relatorio_pedido_curva_abc_funcao.php');
	//---------------------------------------------------
	$tela = $_REQUEST['tela'];
	$empresa = $_REQUEST['empresa'];
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$departam = $_REQUEST['depart'];
	$produto = $_REQUEST['produto'];
	$fornecedor = $_REQUEST['fornecedor'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$situacao = $_REQUEST['situacao'];

	$consulta = 'SELECT nf.Pessoa, nf.DH_Emissao as DH_Emissao, '.
				  ' nfi.ID_Produto, nfi.Qtd, nfi.Valor_Unitario, nfi.Valor_Total '.
				  ' FROM pedido nf '.
				  ' INNER JOIN pedido_item nfi on'.
				  ' nf.Dominio=nfi.Dominio AND'.
				  ' nf.Empresa=nfi.Empresa AND '.
				  ' nf.Numero_Pedido=nfi.Numero_Pedido '.
				  ' WHERE nf.Dominio = "'.$_SESSION['Dominio'].'"';
	if($situacao=='T'){
		$consulta .= ' AND nf.Status <> "E" AND nf.Status <> "C" ';
	}else if($situacao=='A'){
		$consulta .= ' AND ( ( nf.Status = "A" ) OR '.
					'       ( nf.Status = "L" ) OR '.
					'       ( nf.Status = "P" ) )';

	}else if($situacao=='F'){
		$consulta .= ' AND nf.Status = "F" ';
	}
	$consulta .= ' AND nf.DH_Emissao>="'.datad($dt_ini).' 00:00:00"'.
			   ' AND nf.DH_Emissao<="'.datad($dt_fim).' 23:59:59"'.
			   ' AND nfi.ID_Produto>0 ';
	$filtro = 'Perodo: De "'.$dt_ini.'"'.
		' At "'.$dt_fim.'"';

	if($situacao == 'A'){
		$filtro .= ' Situao: "Em Aberto" ';
	}else if($situacao == 'F'){
		$filtro .= ' Situao: "Fechados" ';
	}else {
		$filtro .= ' Situao: "Ambos" ';
	}

	if($empresa != ''){
		$consulta.= ' AND nf.Empresa = "'.$empresa.'"';
		$con_pessoa = 'SELECT Nome_Listas FROM pessoa '.
				   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' AND Pessoa = "'.$empresa.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$filtro.=' Empresa: '.$reg_pessoa[0];
	}

	if($cliente!=''){
		$consulta.= ' AND nf.Pessoa = "'.$cliente.'"';
		$cons_cliente = 'SELECT Nome_Razao FROM pessoa '.
					 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' AND Pessoa = "'.$cliente.'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);
		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';
	}

	if($vendedor != ''){
		$consulta.= ' AND nf.Vendedor = "'.$vendedor.'"';
		$cons_vend = 'SELECT Nome_Razao FROM pessoa '.
				  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				  ' AND Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);
		$filtro.= ' Vendedor: "'.$reg_vend[0].'"';
	}

	if($produto != ''){
		$consulta.= ' AND nfi.ID_Produto = "'.$produto.'"';
		$cons_prod = 'SELECT Descricao_Completa FROM produto '.
				  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				  ' AND Id_Produto = "'.$produto.'"';
		$res_prod = consulta_sql($cons_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);
		$filtro.= ' Produto: "'.$reg_prod[0].'"';
	}

	if($fornecedor != ''){
		$cons_forn = 'SELECT Nome_Razao FROM pessoa '.
				  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				  ' AND Pessoa = "'.$fornecedor.'"';
		$res_forn = consulta_sql($cons_forn);
		$reg_forn = consulta_ler_linha($res_forn);
		consulta_limpa($res_forn);
		$filtro.= ' Fornecedor: "'.$reg_forn[0].'"';
	}

	$filtro_depart = '';
	$depart = '';
	$con_filtro = '';
	$filtro_dep = '';

	$lista_depart = explode(';',$departam);
	foreach($lista_depart as $key => $valor){
		if($valor!=''){
			$depart[$valor] = '1';
			if($filtro_depart == ''){
				$filtro_depart = ' Por Departamentos';
			}else{
				$filtro_depart.= ',';
			}
			$filtro_depart.= ' "'.$valor.'"';
		}
	}

	$filtro.= ' /'.$filtro_depart;
	//$counter = 0;
	//set_time_limit(60);

	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	for ($i=0;$i<$nrows;$i++){
		$registro = consulta_ler_objeto($resultado);
		//set_time_limit(60);

		//$ok_linha = true;($registro->Quantidade_Estoque>$registro->Qtd_Devolvida);//true;
		$ok_linha = true;
		if($ok_linha){
			$con_desc = 'SELECT Codigo_Depart,Codigo_Fornecedor,Codigo_Grupo,Codigo_Linha FROM produto '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto="'.$registro->ID_Produto.'"';
			$res_desc = consulta_sql($con_desc);
			$reg_desc = consulta_ler_linha($res_desc);
			consulta_limpa($res_desc);
			if(!empty($depart)){
				$ok_linha = (isset($depart[$reg_desc[0]]));  //($depart==$reg_desc[0]);
			}
		}
		if($ok_linha){
			if($fornecedor!=''){
				$ok_linha = ($fornecedor==$reg_desc[1]);
			}
		}

		$valor_dev = 0;
		$unit = 0;
		$medida = $registro->Qtd;
		$codigo = $registro->ID_Produto;

		if($ok_linha){
			if(!isset($lista_rel[$registro->Pessoa])){
				$con_pessoa = 'SELECT Nome_Listas FROM pessoa '.
							 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							 ' AND Pessoa = "'.$registro->Pessoa.'"';
				$res_pessoa = consulta_sql($con_pessoa);
				$reg_pessoa = consulta_ler_linha($res_pessoa);
				consulta_limpa($res_pessoa);

				$lista_rel[$registro->Pessoa]['Pessoa'] = $registro->Pessoa;
				$lista_rel[$registro->Pessoa]['Nome_Listas'] = $reg_pessoa[0];
				$lista_rel[$registro->Pessoa]['Total'] = 0;
			}

			if(!isset($lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto])){
				$cons_prod_cli = 'SELECT Codigo_Produto, Descricao_Completa, Unidade_Venda FROM produto '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Id_Produto = "'.$codigo.'"';
				$res_prod_cli = consulta_sql($cons_prod_cli);
				$reg_prod_cli = consulta_ler_linha($res_prod_cli);
				consulta_limpa($res_prod_cli);

				$descricao_arr = explode(" ", $reg_prod_cli[1]);
				$ordenar = "";
				foreach($descricao_arr as $descricao){
					if(strpos(strtoupper($descricao), "MM/") !== false){
						$ordenar = trim($descricao);
						break;
					}
				}
				$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['codigo'] = $reg_prod_cli[0];
				$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['ordenar'] = $ordenar;
				$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['descricao'] = $reg_prod_cli[1];
				$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['unidade'] = $reg_prod_cli[2];
				$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['qtd'] = 0;
			}

			$lista_rel[$registro->Pessoa]['Itens'][$registro->ID_Produto]['qtd']+= $registro->Qtd;
			$lista_rel[$registro->Pessoa]['Total']+= $registro->Qtd;
			/* $descricao_arr=explode(" ", $reg_prod_cli[1]);
			$codigo_desc="";
			foreach($descricao_arr as $descricao){
			   if(strpos(strtoupper($descricao), "MM/") !== false){
				  $codigo_desc=trim($descricao);
				  break;
			   }
			}

			if(empty($lista_rel[$codigo_desc][$codigo])){
			   $lista_rel[$codigo_desc][$codigo]['codigo'] = "";
			   $lista_rel[$codigo_desc][$codigo]['descricao']="";
			   $lista_rel[$codigo_desc][$codigo]['unidade']="";
			   $lista_rel[$codigo_desc][$codigo]['qtd']=0;
			}

			$lista_rel[$codigo_desc][$codigo]['codigo']=$reg_prod_cli[0];
			$lista_rel[$codigo_desc][$codigo]['descricao']=$reg_prod_cli[1];
			$lista_rel[$codigo_desc][$codigo]['unidade']=$reg_prod_cli[2];
			$lista_rel[$codigo_desc][$codigo]['qtd']+=$registro->Qtd; */
		}
	}

	consulta_limpa($resultado);

	//var_dump2($lista_rel);      
	//$lista_rel = array_orderby($lista_rel, 'ordenar', SORT_ASC);
	//-----------------------------------------------------------------------------------------
	$pdf=new FPDF();
	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio Oramento de Produo';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;
	$pdf->CabecalhoGrid_Texto = '';

	set_time_limit(60);

	if(!empty($lista_rel)){
		$k=0;

		$pdf->CabecalhoGrid_Texto[$k] = 'Prod.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '8';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Descrio';
		$pdf->CabecalhoGrid_Tamanho[$k] = '68';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Unid. Medida';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Qtdade';
		$pdf->CabecalhoGrid_Tamanho[$k] = '14';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$ncampos = 4;
		$valor = 0;
		$seq = 0;

		$vl_acumulado = 0;
		$valor_acum = 0;
		$qtd_acumulado = 0;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);
		$pdf->SetAutoPageBreak(true,30);

		foreach($lista_rel as $chave => $registro){
			set_time_limit(60);

			$lns=5;
			$larg = 190;
			$pdf->SetFillColor(175,175,175);

			$pdf->SetFont('Arial','B',8);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','B',8);

			$y=$pdf->y;
			$pdf->MultiCell((100/100)*$larg, $lns, $registro['Pessoa'].' - '.$registro['Nome_Listas'], 'T', 'L', 1);
			$pdf->y=$y;

			$pdf->SetFont('Arial','',8);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',8);

			$pdf->SetFillColor(225,225,225);

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);

			$itens = array_orderby($registro['Itens'], 'ordenar', SORT_ASC);
			foreach($itens as $item){
				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				$lns = 0;
				$larg = 190;
				$k=0;

				//codigo produto
				$rowarr[$k] = $item['codigo'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				//desc produto
				$rowarr[$k] = $item['descricao'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				//unidade medida
				$rowarr[$k] = $item['unidade'];
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				//quantidade
				$rowarr[$k] = formata_qtd($item['qtd'],3,false);
				$qtd_acumulado+= $item['qtd'];

				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$lns = $lns * 5;

				for($k=0;$k<$ncampos;$k++){
					$valor = $vl_linha[$k];
					$y=$pdf->y;
					$pdf->SetFillColor(225,225,225);
					$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$k],0);
					$pdf->y=$y;
				}
				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);
			}

			$lns=5;
			$larg = 190;
			$pdf->SetFillColor(220,220,220);

			$pdf->SetFont('Arial','B',8);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','B',8);

			$y=$pdf->y;
			$pdf->MultiCell((100/100)*$larg, $lns, 'TOTAL CLIENTE: '.formata_qtd($registro['Total'],3,false), 'T', 'R', 0);
			$pdf->y=$y;

			$pdf->SetFont('Arial','',8);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',8);

			$pdf->SetFillColor(225,225,225);

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
		}

		$lns=5;
		$larg=190;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(false,30);

		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$pdf->MultiCell((86/100)*$larg, $lns, 'TOTAL GERAL:', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((14/100)*$larg, $lns, formata_qtd($qtd_acumulado,3,false), 'T', 'R');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',8);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','',8);

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);
		//echo $qtd_acumulado;
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);
		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1, 5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_orcamento_producao.pdf','I');
}
?>