<?php
	error_reporting(E_ALL);
	ini_set('display_errors', true);
	ini_set('display_startup_errors', true);
	set_time_limit(60);
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){
	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$empresa = $_REQUEST['empresa'];
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$tipo = $_REQUEST['tipo'];

	$filtro = '';
	$counter = 0;
	$lista_rel = array();

	$consulta = 'SELECT DH_EntSai, Total_PIS, Total_COFINS, Total_NF FROM nota_fiscal'.
				' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
	if($empresa != ''){
		$consulta.= ' AND Empresa = "'.$empresa.'"';
		$con_pessoa='SELECT Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Pessoa = "'.$empresa.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$filtro.=' Empresa: '.$reg_pessoa[0];
	}

	$consulta.= ' AND TipoES = "1" '.
				' AND ((Modelo = "55") OR (Modelo = "01")) '.
				' AND ((Nat_Op_CFOP <> "5.929") AND (Nat_Op_CFOP <> "6.929")) '.
				' AND Situacao = "F" ';
	if($tipo == 'T'){
		$consulta.= ' AND (Total_PIS + Total_COFINS) > 0';
	}else{
		$consulta.= ' AND (Total_PIS + Total_COFINS) = 0';
	}
	$consulta.= ' AND DH_EntSai >= "'.datad($dt_ini).' 00:00:00"'.
				' AND DH_EntSai <= "'.datad($dt_fim).' 23:59:59"';
	$filtro =	'Perodo: De "'.$dt_ini.'"'.
				' At "'.$dt_fim.'"';
	//$consulta.= ' ORDER BY DH_EntSai';

	$filtro.= ' Tipo:';
	if($tipo == 'T'){
		$filtro.= ' "Tributados"';
	}else{
		$filtro.= ' "Isentos"';
	}

	//echo $consulta;
	//exit;
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$lista_geral = array();
	$counter = 0;

	for($i=0;$i<$nrows;$i++){
		$registro = consulta_ler_objeto($resultado);
		$dt_emissao = substr($registro->DH_EntSai, 0, 10);

		if(!isset($lista_rel[$dt_emissao])){
			$lista_rel[$dt_emissao]['DT_Emissao'] = $dt_emissao;
			$lista_rel[$dt_emissao]['ecf'] = array();

			$lista_rel[$dt_emissao]['nf']['Valor_Total'] = 0;
			$lista_rel[$dt_emissao]['nf']['PIS'] = 0;
			$lista_rel[$dt_emissao]['nf']['COFINS'] = 0;

			$lista_rel[$dt_emissao]['Valor_Total_Dia'] = 0;
			$lista_rel[$dt_emissao]['Valor_Total_Dia_PIS'] = 0;
			$lista_rel[$dt_emissao]['Valor_Total_Dia_COFINS'] = 0;
		}

		$lista_rel[$dt_emissao]['nf']['Valor_Total']+= $registro->Total_NF;
		$lista_rel[$dt_emissao]['nf']['PIS']+= $registro->Total_PIS;
		$lista_rel[$dt_emissao]['Valor_Total_Dia_PIS']+= $registro->Total_PIS;
		$lista_rel[$dt_emissao]['nf']['COFINS']+= $registro->Total_COFINS;
		$lista_rel[$dt_emissao]['Valor_Total_Dia_COFINS']+= $registro->Total_COFINS;
		$lista_rel[$dt_emissao]['Valor_Total_Dia']+= $registro->Total_NF;

		$counter++;
	}
	consulta_limpa($resultado);

	//inicio ECF
	$consulta_ecf = 'SELECT Empresa, NrFab, LetraMF, DT_Emissao, COO, SubTotal, Desconto, Acrescimo '.
					' FROM ecf_cupom '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
	if($empresa != ''){
		$consulta_ecf.= ' AND Empresa = "'.$empresa.'"';
	}
	$consulta_ecf.= ' AND DT_Emissao >= "'.datad($dt_ini).'"'.
					' AND DT_Emissao <= "'.datad($dt_fim).'"'.
					' AND Cancelado = "N"';
	//$consulta_ecf.= ' ORDER BY DT_Emissao';

	$resultado_ecf = consulta_sql($consulta_ecf);
	$nrows_ecf = consulta_num_registros($resultado_ecf);

	$empresa_ant = 0;

	for($c=0;$c<$nrows_ecf;$c++){
		$reg = consulta_ler_objeto($resultado_ecf);
		set_time_limit(60);
		$ok_line = false;

		if($empresa_ant != $reg->Empresa){
			//fazer para cada empresa
			$impostos = impostos_produto($reg->Empresa);
		}
		$empresa_ant = $reg->Empresa;

		//consulta funcao desconto
		$vl_seq = cupom_fiscal_calcula_desc_acre_proporcional($reg->Empresa, $reg->NrFab, $reg->DT_Emissao, $reg->COO, 0, 0);

		//consultar o item
		$cons_ecfit =	'SELECT ValorTotal, Id_Produto, Seq_Item, TributoCod '.
						' FROM ecf_cupom_item '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$reg->Empresa.'"'.
						' AND NrFab = "'.$reg->NrFab.'"'.
						' AND LetraMF = "'.$reg->LetraMF.'"'.
						' AND DT_Emissao = "'.$reg->DT_Emissao.'"'.
						' AND COO = "'.$reg->COO.'"'.
						' AND Cancelado = "N"';
		$res_ecfit = consulta_sql($cons_ecfit);
		$nrw_ecfit = consulta_num_registros($res_ecfit);

		for($n=0;$n<$nrw_ecfit;$n++){
			$reg_ecfit = consulta_ler_objeto($res_ecfit);

			$con_pro =	'SELECT Codigo_Classe_Tributo FROM produto '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$reg_ecfit->Id_Produto.'"';
			$res_pro = consulta_sql($con_pro);
			$nrw_prod = consulta_num_registros($res_pro);
			if($nrw_prod > 0){
				$reg_pro = consulta_ler_objeto($res_pro);

				$aliq_pis = 0;
				if(isset($impostos['pis'][$reg_pro->Codigo_Classe_Tributo])){
					$aliq_pis = $impostos['pis'][$reg_pro->Codigo_Classe_Tributo];
				}
				$aliq_cofins = 0;
				if(isset($impostos['cofins'][$reg_pro->Codigo_Classe_Tributo])){
					$aliq_cofins = $impostos['cofins'][$reg_pro->Codigo_Classe_Tributo];
				}

				$ok_imposto = false;

				if($tipo == 'I'){
					if(($aliq_pis == 0) || ($aliq_cofins == 0)){
						$ok_imposto = true;
					}
				}else{
					if(($aliq_pis > 0) || ($aliq_cofins > 0)){
						$ok_imposto = true;
					}
				}

				if($ok_imposto){
					$aliq_icms = $reg_ecfit->TributoCod.'0000000';
					if ($aliq_icms!=''){
						if ($aliq_icms[0]=='T'){
							$aliq_icms = (substr($aliq_icms,1,4)/100);
						}else if ($aliq_icms[2]=='T'){
							$aliq_icms = (substr($aliq_icms,3,4)/100);
						}else{
							$aliq_icms = 0;
						}
					}else{
						$aliq_icms = 0;
					}

					$vl_calculo = round($reg_ecfit->ValorTotal - $vl_seq[$reg_ecfit->Seq_Item]['d'], 2);
					$valor_icms = round($vl_calculo * $aliq_icms/100,2);
					$vl_calculo = calcula_base_pisconfis($vl_calculo,$reg->DT_Emissao,$valor_icms,$reg->Empresa,'P');

					if(!isset($lista_rel[$reg->DT_Emissao])){
						$lista_rel[$reg->DT_Emissao]['DT_Emissao'] = $reg->DT_Emissao;
						$lista_rel[$reg->DT_Emissao]['ecf'] = array();

						$lista_rel[$reg->DT_Emissao]['nf']['Valor_Total'] = 0;
						$lista_rel[$reg->DT_Emissao]['nf']['PIS'] = 0;
						$lista_rel[$reg->DT_Emissao]['nf']['COFINS'] = 0;

						$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia'] = 0;
						$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia_PIS'] = 0;
						$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia_COFINS'] = 0;
					}

					if(!isset($lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab])){
						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['NrFab'] = $reg->NrFab;
						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['Valor_Total'] = 0;
						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['PIS'] = 0;
						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['COFINS'] = 0;
					}

					$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['Valor_Total']+= $vl_calculo;
					$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia']+= $vl_calculo;

					if($tipo == 'T'){
						if($aliq_pis > 0){
							$vl_pis = arredonda_numero_menos($aliq_pis * $vl_calculo) / 100;
						}
						if($aliq_cofins > 0){
							$vl_cofins = arredonda_numero_menos($aliq_cofins * $vl_calculo) / 100;
						}

						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['PIS']+= $vl_pis;
						$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia_PIS']+= $vl_pis;

						$lista_rel[$reg->DT_Emissao]['ecf'][$reg->NrFab]['COFINS']+= $vl_cofins;
						$lista_rel[$reg->DT_Emissao]['Valor_Total_Dia_COFINS']+= $vl_cofins;
					}
					$counter++;
				}
			}
			consulta_limpa($res_pro);
		}
	}

	//var_dump2($lista_rel);
	//exit;

	$pdf = new FPDF();
	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio de PIS/COFINS por Dia';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	set_time_limit(60);

	if($counter > 0){
		$k = 0;

		$pdf->CabecalhoGrid_Texto[$k] = '';
		$pdf->CabecalhoGrid_Tamanho[$k] = '55';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Base';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'PIS';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'COFINS';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);
		$pdf->SetAutoPageBreak(true,30);

		$ncampos = 4;
		ksort($lista_rel);

		$total_geral = 0;
		$total_geral_pis = 0;
		$total_geral_cofins = 0;

		foreach($lista_rel as $registro){
			$lns = 5;
			$larg = 190;
			$k = 0;

			$pdf->SetFont('Arial','B',10);
			$pdf->Cell(1, $lns, '', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','B',10);

			$pdf->SetFillColor(175,175,175);

			$y=$pdf->y;
			$pdf->MultiCell((55/100)*$larg, $lns, 'Total do Dia: '.dataf($registro['DT_Emissao']), '', 'L', 1);
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro['Valor_Total_Dia'], false), '', 'R', 1);
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro['Valor_Total_Dia_PIS'], false), '', 'R', 1);
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro['Valor_Total_Dia_COFINS'], false), '', 'R', 1);
			$pdf->y=$y;

			$total_geral+= $registro['Valor_Total_Dia'];
			$total_geral_pis+= $registro['Valor_Total_Dia_PIS'];
			$total_geral_cofins+= $registro['Valor_Total_Dia_COFINS'];

			$pdf->Cell(1, $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
			$pdf->SetFont('Arial','',8);
			$pdf->SetFillColor(255,255,255);

			foreach($registro['ecf'] as $registro_ecf){
				$lns = 5;
				$larg = 190;
				$k = 0;

				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1, $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				$y=$pdf->y;
				$pdf->MultiCell((55/100)*$larg, $lns, '    '.$registro_ecf['NrFab'], '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_ecf['Valor_Total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_ecf['PIS'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_ecf['COFINS'], false), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1, $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$pdf->SetFont('Arial','',8);
			}

			if(!empty($registro['nf'])){
				$registro_nf = $registro['nf'];

				$lns = 5;
				$larg = 190;
				$k = 0;

				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1, $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				$y=$pdf->y;
				$pdf->MultiCell((55/100)*$larg, $lns, '    NOTA FISCAL', '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_nf['Valor_Total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_nf['PIS'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((15/100)*$larg, $lns, to_money($registro_nf['COFINS'], false), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1, $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$pdf->SetFont('Arial','',8);
			}
			//Pula Linha
			$pdf->Ln();
		}
		$lns = 5;
		$larg = 190;
		$k = 0;

		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1, $lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$pdf->MultiCell((55/100)*$larg, $lns, 'TOTAL GERAL', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*$larg, $lns, to_money($total_geral, false), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*$larg, $lns, to_money($total_geral_pis, false), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*$larg, $lns, to_money($total_geral_cofins, false), '', 'R');
		$pdf->y=$y;

		$pdf->Cell(1, $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->SetFont('Arial','',8);
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1, 5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1, 5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>