<?php
    require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
    session::usr_conectado($_REQUEST['USER_ID']);
    require_once('../../includes/write_excel/Worksheet.php');
    require_once('../../includes/write_excel/Workbook.php');
    require_once('relatorio_produto_fornec_funcao.php');

    function HeaderingExcel($filename) {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=$filename" );
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
        header("Pragma: public");
    }

    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');

    // HTTP headers
    HeaderingExcel('Produto_Fornecedor_Vendido.xls');

    // Creating a workbook
    $workbook = new Workbook("-");
    // Creating the first worksheet
    $titulo_sheet = 'Produto_Fornecedor_Vendido';
    $worksheet1 =& $workbook->add_worksheet($titulo_sheet);

    // Format for the headings
    $formatot =& $workbook->add_format();
    $formatot->set_size(18);

    $formatost =& $workbook->add_format();
    $formatost->set_size(14);

    $worksheet1->write_string(0,0,'Relatrios de Produto por Fornecedor Vendido nos ltimos 12 Meses',$formatot);
    $worksheet1->write(2,0,config_pad('sistema_licenca'));
    $worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
    $worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

    $worksheet1->write(6,0,"Filtro: ".$filtro);
    //$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

    // Formato cabecalho Centralizado
    $formatott =& $workbook->add_format();
    $formatott->set_align('center');
    $formatott->set_pattern();
    $formatott->set_fg_color(40);
    $formatott->set_bold(1);
    $formatott->set_border(1);

    // Formato cabecalho Esquerda
    $formatoTLeft =& $workbook->add_format();
    $formatoTLeft->set_align('left');
    $formatoTLeft->set_pattern();
    $formatoTLeft->set_fg_color(40);
    $formatoTLeft->set_bold(1);
    $formatoTLeft->set_border(1);

    // Formato texto
    $formatotc =& $workbook->add_format();
    $formatotc->set_border(1);
    $formatotc->set_align('center');

    $formatotl =& $workbook->add_format();
    $formatotl->set_border(1);
    $formatotl->set_align('left');

    $formatotr =& $workbook->add_format();
    $formatotr->set_border(1);
    $formatotr->set_align('right');

    $formatotlb =& $workbook->add_format();
    $formatotlb->set_border(1);
    $formatotlb->set_size(10);
    //$formatotlb->set_align('left');
    $formatotlb->set_bold(1);

    $formatotrb =& $workbook->add_format();
    $formatotrb->set_border(1);
    $formatotrb->set_size(10);
    $formatotrb->set_align('right');
    $formatotrb->set_bold(1);

    // Formato quantidade
    $formatotqtd =& $workbook->add_format();
    $formatotqtd->set_border(1);
    $formatotqtd->set_align('right');
    $formatotqtd->set_num_format('@');

    $formatotqtdb =& $workbook->add_format();
    $formatotqtdb->set_border(1);
    $formatotqtdb->set_align('right');
    $formatotqtdb->set_size(10);
    $formatotqtdb->set_bold(1);
    $formatotqtdb->set_num_format('@');

    // 3 casas
    $formatotqtd3 =& $workbook->add_format();
    $formatotqtd3->set_border(1);
    $formatotqtd3->set_align('right');
    $formatotqtd3->set_num_format('#,##0.000_);(#,##0.000)');

    $formatotbqtd3 =& $workbook->add_format();
    $formatotbqtd3->set_border(1);
    $formatotbqtd3->set_bold(1);
    $formatotbqtd3->set_align('right');
    $formatotbqtd3->set_num_format('#,##0.000_);(#,##0.000)');

    // Formato preco/valor
    $formatotpreco =& $workbook->add_format();
    $formatotpreco->set_border(1);
    $formatotpreco->set_align('right');
    $formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

    $formatotbpreco =& $workbook->add_format();
    $formatotbpreco->set_border(1);
    $formatotbpreco->set_align('right');
    $formatotbpreco->set_bold(1);
    $formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)'); 

    $linha_ini =8 ;
    set_time_limit(60);
    
    if(!empty($lista_rel)){
        //Apresentao dos titulo da pgina
        $celula=0;		
        $worksheet1->set_column($celula,$celula,10);
        $worksheet1->write_string($linha_ini,$celula,'Cdigo', $formatoTLeft);
        $celula++;

        $worksheet1->set_column($celula,$celula,45);
        $worksheet1->write_string($linha_ini,$celula,'Produto', $formatoTLeft);
        $celula++;
        //aqui comea os meses
        for($m=0;$m<12;$m++){
            $worksheet1->set_column($celula,$celula,15);
            $worksheet1->write_string($linha_ini,$celula,  substr(MesExtenso($coluna[$m]),0,3).'/'.$colunab[$m] ,$formatott);
            $celula++;
		}
        
        $worksheet1->set_column($celula,$celula,15);
        $worksheet1->write_string($linha_ini,$celula,' Estoque',$formatott);
        $celula++;

        ($ana_modas) ?  $campo= 'Vendido' :  $campo = 'Custo';
        $worksheet1->set_column($celula,$celula,15);
        $worksheet1->write_string($linha_ini,$celula, $campo ,$formatott);
        $celula++;

        $worksheet1->set_column($celula,$celula,20);
        $worksheet1->write_string($linha_ini,$celula,'Custo Total ',$formatott);
        $celula++; 

        $worksheet1->set_column($celula,$celula,25);
        $worksheet1->write_string($linha_ini,$celula,'Preo Venda ',$formatott);
        $celula++;
        $linha_ini++;
        $ncampos = $celula ;
        $lista_empresas = lista_empresas();

        //Copia do PDF
        //total parcial do mes  (de acordo com a qtdade de registros solicitada)
        //Zerar o total por Ms
        for( $m1=0; $m1<12; $m1++){
            $total_parc_mes[$coluna[$m1]] = 0;
        }
        $cont = 0; 
        foreach($lista_rel as $codigo2 => $valor){
            set_time_limit(60);
            /*
                $linha_ini++;
                $id_fornec = $valor['Fornecedor'];
                $cons_forn = 'SELECT Nome_Razao, Pessoa FROM pessoa '.
                                    ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                                    ' AND Pessoa = "'.$id_fornec.'"';
                $res_forn = consulta_sql($cons_forn);
                $reg_forn = consulta_ler_linha($res_forn);
                consulta_limpa($res_forn);
                            
                $celula=0;
                $worksheet1->write_string($linha_ini,$celula,'Fornecedor: '. $id_fornec  .' - '.$reg_forn[0],$formatotlb);
            
                $cel_merge= 17;
                $worksheet1->merge_cells($linha_ini, $celula, $linha_ini, $celula+$cel_merge);
                for($ca=0;$ca<$cel_merge;$ca++){
                            $celula++;
                            $worksheet1->write_blank($linha_ini,$celula,$formatotc); //acertar bordas
                }
            */
            
            $codigo = $valor['Id_Produto'];
            for( $m2=0; $m2<12; $m2++){
                //soma para calcular o total de outros produtos depois
                $total_parc_mes[$coluna[$m2]]+= $lista_mes[$coluna[$m2]][$codigo];
                $qtd_total[$codigo] += $lista_mes[$coluna[$m2]][$codigo];
            } 
            $celula = 0;
            $worksheet1->write_string($linha_ini,$celula,  $valor['Codigo'] , $formatotl );
            $celula++;
                        
            $worksheet1->write_string($linha_ini,$celula, $valor['Descricao'] , $formatotl );
            $celula++;
            
            for( $m3=0; $m3<12; $m3++){
                if($lista_mes[$coluna[$m3]][$codigo]>0){
                    $worksheet1->write_number($linha_ini,$celula,$lista_mes[$coluna[$m3]][$codigo], $formatotqtd );
                }else{
                    $worksheet1->write_string($linha_ini,$celula, '', $formatotl );
                }
                $celula++;
            }
            $worksheet1->write_number($linha_ini,$celula,  $valor['Estoque'], $formatotqtd );
            $celula++;

            if( $ana_modas ){
                $worksheet1->write_number($linha_ini,$celula, $valor['Qtd'], $formatotpreco  );
            }else{
                $worksheet1->write_number($linha_ini,$celula, $valor['PrecoCusto'], $formatotpreco  );
            }
            $celula++;
            if( ( $valor['PrecoCusto']*$valor['Estoque'] ) > 0){
                $worksheet1->write_number($linha_ini,$celula,  ( $valor['PrecoCusto']*$valor['Estoque'] ), $formatotpreco  );
            }else{
                $worksheet1->write_string($linha_ini,$celula, '', $formatotl );
            }
            $celula++;
                        
            $worksheet1->write_number($linha_ini,$celula, $valor['PrecoVenda'], $formatotpreco );
            $celula++;
            $linha_ini++;
        }//fecha forech
        $cont++; 
        //Apresentao do Final do Relatrio
        $celula=0;
        $worksheet1->write_string($linha_ini,$celula, 'Total Vendido por Ms ' ,$formatotlb);

        $cel_merge= 1;
        $worksheet1->merge_cells($linha_ini, $celula, $linha_ini, $celula+$cel_merge);
        for($ca=0;$ca<$cel_merge;$ca++){
            $celula++;
            $worksheet1->write_blank($linha_ini,$celula,$formatotc); //acertar bordas
        }
        $celula++;
                
        foreach(  $total_parc_mes as $key2 => $ttlmes ){
            $worksheet1->write_string($linha_ini,$celula,  $ttlmes , $formatotrb );
            $celula++;
        }
        for( $i= 0; $i<4; $i++){
            $worksheet1->write_string($linha_ini,$celula,' ', $formatotrb );
            $celula++;
        }
        $linha_ini++;
    }else{
        $worksheet1->write(10,0,"No existem registros para este filtro!");
    }
    
    //ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
    $insert = 'insert into relatorio_tmp ( '.
              ' Dominio, '.
              ' Usuario, '.
              ' Descricao ) values ('.
              '"'.$_SESSION['Dominio'].'", '.
              '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
              '"")';
    consulta_sql($insert);
    $workbook->close();
?>