<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	session::usr_conectado($_REQUEST['USER_ID']);

	$dominios = array();
	$empresa = $_SESSION['Empresa_Codigo'];

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$data_ini = $_REQUEST['DT_INI'];
	$data_fim = $_REQUEST['DT_FIM'];
	$fornecedor = $_REQUEST['fornec'];
	$saldo = $_REQUEST['saldo'];
	$filtro = '';

	if(($data_ini != '') || ($data_fim != '')){
		$filtro.= ' Data:';
		if($data_ini != ''){
			$filtro.= ' De: "'.$data_ini.'"';
		}
		if($data_fim != ''){
			$filtro.= ' At: "'.$data_fim.'"';
		}
	}

	if($fornecedor != ''){
		$filtro .= ' Fornecedor: '.$fornecedor;
	}
	$listaDepart = array();
	if($_REQUEST['depart'] != ''){
		$listaDepart = explode(";", $_REQUEST['depart']);
	}

	if(!empty($listaDepart)){
		$filtro_depart = '';
		foreach($listaDepart as $codigoDepart){
			if($codigoDepart > 0){
				if($filtro_depart == ''){
					$filtro_depart.= ' Departamento(s):';
				}else{
					$filtro_depart.= ',';
				}

				$conDepartamento =	'SELECT Descricao FROM produto_departamento '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Codigo_Depart = "'.$codigoDepart.'"';
				$resDepartamento = consulta_sql($conDepartamento);
				$regDepartamento = consulta_ler_linha($resDepartamento);
				consulta_limpa($resDepartamento);

				$filtro_depart.= ' "'.$regDepartamento[0].'"';
			}
		}
		$filtro.= $filtro_depart;
	}

	$listaDadosDepart = array();
	$listaProdutosDesconsiderar = array();
	$listaGeral = array();

	$consulta = 'SELECT COO, '.
				' NrFab, '.
				' DT_Emissao, '.
				' Empresa, '.
				' LetraMF '.
				' FROM ecf_cupom '.
				' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
				' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
				' AND Cancelado = "N" ';
	if(($data_ini != '') || ($data_fim != '')){
		if($data_ini != ''){
			$consulta.= ' AND DH_Movto >="'.datad($data_ini).' 00:00:00" ';
		}
		if($data_fim != ''){
			$consulta.= ' AND DH_Movto <= "'.datad($data_fim).' 23:59:59" ';
		}
	}
	$consulta.= ' ORDER BY DH_Movto, Empresa, COO ';
	$res_nf = consulta_sql($consulta);
	while($reg_nf = consulta_ler_objeto($res_nf)){
		$cons_item ='SELECT Id_Produto '.
					' FROM ecf_cupom_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$reg_nf->Empresa.'"'.
					' AND NrFab = "'.$reg_nf->NrFab.'"'.
					' AND LetraMF = "'.$reg_nf->LetraMF.'"'.
					' AND DT_Emissao = "'.$reg_nf->DT_Emissao.'"'.
					' AND COO = "'.$reg_nf->COO.'"'.
					' AND Cancelado = "N" ';
		$res_item = consulta_sql($cons_item);
		while($reg_item = consulta_ler_objeto($res_item)){
			$ok = true;

			if($ok){
				$ok = ($reg_item->Id_Produto > 0);
			}

			if($ok){
				$listaProdutosDesconsiderar[$reg_item->Id_Produto] = $reg_item->Id_Produto;
			}
		}
		consulta_limpa($res_item);
	}
	consulta_limpa($res_nf);

	$conNota =	'SELECT Empresa, Nr_Nota FROM nota_fiscal '.
				' WHERE Dominio = "'.$_SESSION['Dominio'].'"  '.
				' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
				' AND Situacao = "F" '.
				' AND TipoES = "1" ';
	if(($data_ini != '') || ($data_fim != '')){
		if($data_ini != ''){
			$conNota.= ' AND DH_Emissao >= "'.datad($data_ini).' 00:00:00" ';
		}
		if($data_fim != ''){
			$conNota.= ' AND DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
		}
	}
	$resNota = consulta_sql($conNota);
	while($regNota = consulta_ler_objeto($resNota)){
		$conItem =	'SELECT Id_Produto FROM nota_fiscal_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"  '.
					' AND Empresa = "'.$regNota->Empresa.'" '.
					' AND Nr_Nota = "'.$regNota->Nr_Nota.'" '.
					' AND Id_Produto > 0 '.
					' AND CFOP_Gera_Contas = "R"';
		$resItem = consulta_sql($conItem);
		while($regItem = consulta_ler_objeto($resItem)){
			$listaProdutosDesconsiderar[$regItem->Id_Produto] = $regItem->Id_Produto;
		}
		consulta_limpa($resItem);
	}
	consulta_limpa($resNota);

	$ana_modas = 355;
	$listaE = array();
	if ($_SESSION['Dominio']==$ana_modas){
		$con_ent =	'SELECT Id_Produto, '.
					' max(DH_EntSai) DH_EntSai '.
					' FROM movimento_vendas '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"  '.
					' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' AND Id_Produto NOT IN ('.implode(', ', $listaProdutosDesconsiderar).')'.
					' AND TipoES = 0 '.
					' AND Situacao = "F"'.
					' group by Id_Produto';
		$res_ent = consulta_sql($con_ent);
		$nrw_ent = consulta_num_registros($res_ent);
		for($e=0;$e<$nrw_ent;$e++){
			$reg_ent = consulta_ler_objeto($res_ent);
			$chave = $reg_ent->Id_Produto;
			$listaE[$chave]['DataE'] = $reg_ent->DH_EntSai;
			if ($listaE[$chave]['DataE']!=''){
				$listaE[$chave]['DataE'] = dataf($listaE[$chave]['DataE']);
			}
		}
		consulta_limpa($res_ent);
	}
	//print_r($listaE);

	$conProduto='SELECT Id_Produto, '.
				' Codigo_Produto, '.
				' Descricao_Curta, '.
				' Descricao_Completa, '.
				' Descricao_Detalhada, '.
				' Codigo_Depart, '.
				' Preco_Venda1, '.
				' Estoque_Atual, '.
				' Situacao '.
				' FROM produto '.
				' WHERE Dominio = "'.$_SESSION['Dominio'].'" ';
	if( Zathura() || $_SESSION['Dominio'] == 'xx'){
		$conProduto.= ' AND Situacao <> "E" ';
	}else{
		$conProduto.=' AND Situacao = "A" ';

	}
	if(!empty($listaProdutosDesconsiderar)){
		$conProduto.= 'AND Id_Produto NOT IN ('.implode(', ', $listaProdutosDesconsiderar).')';
	}

	if($fornecedor != ''){
		$conProduto.= ' AND Codigo_Fornecedor = "'.$fornecedor.'" ';
	}
	if(!empty($listaDepart)){
		$conProduto.= ' AND Codigo_Depart IN ('.implode(', ', $listaDepart).') ';
	}
	if ($saldo=='P'){
		$conProduto.= ' AND Estoque_Atual>0 ';
	}else if ($saldo=='Z'){
		$conProduto.= ' AND Estoque_Atual<=0 ';
	}
	$conProduto.= ' ORDER BY Id_Produto';
	$resProduto = consulta_sql($conProduto);
	while($regProduto = consulta_ler_objeto($resProduto)){
		$chave = $regProduto->Id_Produto;
		$listaGeral[$chave]['Id_Produto'] = $regProduto->Id_Produto;
		$listaGeral[$chave]['Codigo_Produto'] = $regProduto->Codigo_Produto;
		$listaGeral[$chave]['Descricao_Curta'] = $regProduto->Descricao_Curta;
		$listaGeral[$chave]['Descricao_Completa'] = $regProduto->Descricao_Completa;
		$listaGeral[$chave]['Descricao_Detalhada'] = $regProduto->Descricao_Detalhada;
		$listaGeral[$chave]['Codigo_Depart'] = $regProduto->Codigo_Depart;
		$listaGeral[$chave]['Preco_Venda1'] = $regProduto->Preco_Venda1;
		$listaGeral[$chave]['Estoque_Atual'] = $regProduto->Estoque_Atual;
		$listaGeral[$chave]['Situacao'] = $regProduto->Situacao;
		if (isset($listaE[$chave]['DataE'])){
			$listaGeral[$chave]['DataE'] = $listaE[$chave]['DataE'];
		}else{
			$listaGeral[$chave]['DataE'] = '';
		}
	}
	consulta_limpa($resProduto);

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('PRODUTOS_NAO_VENDIDOS.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'PRODUTOS NO VENDIDOS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE PRODUTOS NO VENDIDOS',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$worksheet1->write(8,0,"Filtro: ".$filtro);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	// Format for the headings
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco_b =& $workbook->add_format();
	$formatotpreco_b->set_border(1);
	$formatotpreco_b->set_align('right');
	$formatotpreco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$formatotpreco_b->set_bold(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	// Format for the headings
	$formatot_blank =& $workbook->add_format();
	$formatot_blank->set_border(0);
	$formatot_blank->set_align('left');

	if(!empty($listaGeral)){
		$coluna = 0;
		$linha_ini = 10;

		$worksheet1->set_column($coluna,$coluna, 15);
		$worksheet1->write_string($linha_ini,$coluna,'Cdigo',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 40);
		$worksheet1->write_string($linha_ini,$coluna,'Descrio',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 15);
		$worksheet1->write_string($linha_ini,$coluna,'Departamento',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 15);
		$worksheet1->write_string($linha_ini,$coluna,'Preo',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna, 15);
		$worksheet1->write_string($linha_ini,$coluna,'Estoque',$formatott);
		$coluna++;
		if( Zathura() ){
			$worksheet1->set_column($coluna,$coluna, 15);
			$worksheet1->write_string($linha_ini,$coluna,'Situao ',$formatott);
			$coluna++;
		}		
		if ($_SESSION['Dominio']==$ana_modas){
			$worksheet1->set_column($coluna,$coluna, 15);
			$worksheet1->write_string($linha_ini,$coluna,'ltima Entrada',$formatott);
			$coluna++;
		}

		$linha_ini++;
		foreach($listaGeral as $chave => $registro){
			$coluna = 0;

			$codigoDepartamento = $registro['Codigo_Depart'];
			$descricaoDepartamento = '';

			if(!isset($listaDadosDepart[$codigoDepartamento])){
				$conDepartamento =	'SELECT Descricao FROM produto_departamento '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Codigo_Depart = "'.$registro['Codigo_Depart'].'"';
				$resDepartamento = consulta_sql($conDepartamento);
				$regDepartamento = consulta_ler_linha($resDepartamento);
				consulta_limpa($resDepartamento);

				if(isset($regDepartamento)){
					$descricaoDepartamento = $regDepartamento[0];
				}

				$listaDadosDepart[$codigoDepartamento]['Descricao'] = $descricaoDepartamento;
			}else{
				$descricaoDepartamento = $listaDadosDepart[$codigoDepartamento]['Descricao'];
			}

			$worksheet1->write_string($linha_ini,$coluna,$registro['Codigo_Produto'],$formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Descricao_Completa'],$formatotl);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$descricaoDepartamento,$formatotl);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$registro['Preco_Venda1'],$formatotpreco);
			$coluna++;
			$worksheet1->write_number($linha_ini,$coluna,$registro['Estoque_Atual'],$formatotqtd);
			$coluna++;
			if( Zathura()  ){
				if( $registro['Situacao'] == 'A'){
					$situacao = 'Ativo';
				}else{
					$situacao = 'Inativo';
				}
				$worksheet1->write_string($linha_ini,$coluna,$situacao ,$formatotc);
				$coluna++;
			}
			if ($_SESSION['Dominio']==$ana_modas){
				$worksheet1->write_string($linha_ini,$coluna,$registro['DataE'],$formatotc);
				$coluna++;
			}

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert='insert into relatorio_tmp ( '.
			' Dominio, '.
			' Usuario, '.
			' Descricao '.
			' ) values ('.
			' "'.$_SESSION['Dominio'].'", '.
			' "'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			' "")';
	consulta_sql($insert);

	$workbook->close();
?>