<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$filtro="";

	if(session::usr_conectado($_REQUEST['USER_ID'])){
		$id_produto = $_REQUEST['produto'];
		$dt_ini = $_REQUEST['dt_ini'];
		$dt_fim = $_REQUEST['dt_fim'];
		//$depart = $_REQUEST['depart'];

		$consulta = 'SELECT id, Id_Produto, Valor, DT_Inicio, DT_Final FROM produto_promocao '.
				  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"';
		if($id_produto != ''){
			$consulta.= ' AND Id_Produto = "'.$id_produto.'"';

			$con_prod = 'SELECT Codigo_Produto, Descricao_Completa FROM produto '.
					 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Id_Produto = "'.$id_produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			$filtro.= ' Produto: "'.$reg_prod[0].'-'.$reg_prod[1].'"';
		}

		if($dt_ini == ''){
			$dt_ini = data_atual('data');
		}
		$filtro .= 'De: "'.$dt_ini.'"';
		if($dt_fim == ''){
			$dt_fim = data_atual('data');
		}
		$filtro .= ' At: "'.$dt_fim.'"';

		$consulta.= ' AND ( '.
					'  ( '.
					'   DT_Inicio <= "'.datad($dt_ini).'" AND '.
					'   (DT_Final >= "'.datad($dt_ini).'" OR DT_Final = "0000-00-00") '.
					'  ) OR '.
					'  ( '.
					'   DT_Inicio >= "'.datad($dt_ini).'" AND '.
					'   DT_Inicio <= "'.datad($dt_fim).'"'.
					'  ) '.
					' ) ';
		$filtro_depart = '';
		$depart = array();

		$filtro_dep = '';
		$lista_depart = explode(';',$_REQUEST['depart']);
		foreach($lista_depart as $key => $valor){
			if ($valor!=''){
				$depart[$valor] = '1';
				if ($filtro_depart == ''){
					$filtro_depart = ' Departamentos:';
				}else{
					$filtro_depart.= ',';
				}

				$cons_filt_depart = 'select Codigo_Depart, Descricao '.
								 ' from produto_departamento '.
								 ' where Dominio = "'.$_SESSION['Dominio'].'" '.
								 ' and Codigo_Depart <> 0 '.
								 ' and Codigo_Depart = "'.$valor.'" '.
								 ' and Situacao <> "E" '.
								 ' order by Descricao ';
				$res_filt_depart = consulta_sql($cons_filt_depart);
				$reg_filt_depart = consulta_ler_linha($res_filt_depart);
				$filtro_depart.= ' "'.$reg_filt_depart[1].'"';
			}
		}

		if($filtro_depart != ''){
			$filtro.= ' /'.$filtro_depart;
		}

		$consulta.= ' AND Situacao <> "E" '.
				  ' ORDER BY Id_Produto, DT_Inicio';

		$lista = array();
		$resultado = consulta_sql($consulta);
		$rows = consulta_num_registros($resultado);

		for($i=0;$i<$rows;$i++){
			$registro = consulta_ler_objeto($resultado);
			$ok_linha = true;

			$con_pro = 'SELECT Descricao_Completa, Codigo_Depart FROM produto'.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Id_Produto = "'.$registro->Id_Produto.'"';
			$res_pro = consulta_sql($con_pro);
			$reg_pro = consulta_ler_objeto($res_pro);
			consulta_limpa($res_pro);

			if($ok_linha){
				if(!empty($depart)){
					$ok_linha = (isset($depart[$reg_pro->Codigo_Depart]));
				}
			}

			if($ok_linha){
				$chave = $i;
				$dt_final = '';

				if($registro->DT_Final != '0000-00-00'){
					$dt_final = dataf($registro->DT_Final);
				}

				$lista[$chave]['id'] = $registro->id;
				$lista[$chave]['Id_Produto'] = $registro->Id_Produto;
				$lista[$chave]['Descricao_Completa'] = $reg_pro->Descricao_Completa;
				$lista[$chave]['Valor'] = $registro->Valor;
				$lista[$chave]['DT_Inicio'] = $registro->DT_Inicio;
				$lista[$chave]['DT_Final'] = $registro->DT_Final;
			}
		}

		consulta_limpa($resultado);
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('REL_PRODUTO_PROMOCAO.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'Rel. Promoo de Produto';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,$titulo_sheet,$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$worksheet1->write(8,0,"Filtro: ".$filtro);

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotnum =& $workbook->add_format();
	$formatotnum->set_border(1);
	$formatotnum->set_align('right');
	//    $formatotnum->set_num_format('#,##0_);(#,##0)');
	$formatotnum->set_num_format('#,##0.000_);(#,##0.000)');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	// Format for the headings
	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//negritos
	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//negritos e italico
	$formatotbipreco =& $workbook->add_format();
	$formatotbipreco->set_border(1);
	$formatotbipreco->set_align('right');
	$formatotbipreco->set_bold(1);
	$formatotbipreco->set_italic(1);
	$formatotbipreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotbqtd =& $workbook->add_format();
	$formatotbqtd->set_border(1);
	$formatotbqtd->set_align('right');
	$formatotbqtd->set_bold(1);
	$formatotbqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	$formatotbnum =& $workbook->add_format();
	$formatotbnum->set_border(1);
	$formatotbnum->set_align('right');
	$formatotbnum->set_bold(1);
	//    $formatotbnum->set_num_format('#,##0_);(#,##0)');
	$formatotbnum->set_num_format('#,##0.000_);(#,##0.000)');

	$formatotbl =& $workbook->add_format();
	$formatotbl->set_border(1);
	$formatotbl->set_bold(1);

	$formatotbc =& $workbook->add_format();
	$formatotbc->set_border(1);
	$formatotbc->set_align('center');
	$formatotbc->set_bold(1);

	//formato para peneira
	$formatotlP =& $workbook->add_format();
	$formatotlP->set_border(1);
	$formatotlP->set_italic(1);
	$formatotlP->set_bold(1);

	// Format for the headings
	$formatotnumP =& $workbook->add_format();
	$formatotnumP->set_border(1);
	$formatotnumP->set_align('right');
	$formatotnumP->set_num_format('#,##0.000_);(#,##0.000)');
	$formatotnumP->set_italic(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	$linha_ini = 11;

	if(!empty($lista)){
		$lista = array_orderby($lista, 'Descricao_Completa', SORT_ASC);

		$coluna = 0;

		$worksheet1->set_column($coluna,$coluna,15);
		$worksheet1->write_string($linha_ini,$coluna,'Cd. Produto',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,50);
		$worksheet1->write_string($linha_ini,$coluna,'Descrio Produto',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Valor',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna, 'Inicio', $formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna, 'Fim', $formatott);
		$coluna++;

		$linha_ini++;

		set_time_limit(30);
		foreach($lista as $registro){
			$coluna = 0;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Id_Produto'],$formatotc);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,$registro['Descricao_Completa'],$formatotl);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna, $registro['Valor'] ,$formatotpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,data2nr(dataf($registro['DT_Inicio'])),$formato_data);
			$coluna++;

			if($registro['DT_Final'] != '0000-00-00'){
				$worksheet1->write_number($linha_ini,$coluna,data2nr(dataf($registro['DT_Final'])),$formato_data);
			}else{
				$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
			}
			$coluna++;

			$linha_ini++;
		}
	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}

	$workbook->close();
	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);

?>