<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID'])){
	require_once('relatorio_vendas_cliente_func.php');

	$pdf = new FPDF();
	$pdf->Open();
	$pdf->Cabecalho = 'Relatrio de Vendas por Cliente';
	$pdf->Cabecalho_Filtro = $filtro;
	$pdf->Sub_Cabecalho_Style = 'B';
	$pdf->Sub_Cabecalho_Align = 'L';
	$pdf->Sub_Cabecalho_Border = 0;
	$pdf->CabecalhoGrid_Texto = '';

	if($counter > 0){
		$k=0;

		$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
		$pdf->CabecalhoGrid_Tamanho[$k] = '30';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'B';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Nascimento';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'B';
		$k++;


		$pdf->CabecalhoGrid_Texto[$k] = 'E-mail';
		$pdf->CabecalhoGrid_Tamanho[$k] = '30';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'B';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Telefone';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'B';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Vl. Total';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'B';
		$k++;

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);
		$pdf->SetAutoPageBreak(true,30);
		$ncampos = 5;//4

		$total_NF = 0;
		$rowarr = array();
		$vl_linha = array();
		$lns_linha = array();

		foreach($lista_ordem as $idcli => $valor){
			$lista_geral_cliente = $lista_geral[$idcli];
			$lns = 0;
			$larg = 190;
			$k = 0;

			$pdf->SetFont('Arial','',8);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',8);

			$rowarr[$k] = trim($lista_geral_cliente['descCli'].' ('.$lista_geral_cliente['CPF_CNPJ']).')';
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, 5, $rowarr[$k], 0);
			if($lns_linha[$k] > $lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$nascimento = $lista_geral_cliente['Nascimento']; 
			if( $nascimento == '0000-00-00'){
				$nascimento = '';

			}else{
				$nascimento = dataf($nascimento);
			}


			$rowarr[$k] = $nascimento;
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, 5, $rowarr[$k], 0);
			if($lns_linha[$k] > $lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$pdf->SetFont('Arial','',6);
			$rowarr[$k] = $lista_geral_cliente['Email'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, 5, $rowarr[$k], 0);
			if($lns_linha[$k] > $lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$pdf->SetFont('Arial','',8);
			$rowarr[$k] = $lista_geral_cliente['Telefone'];
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, 5, $rowarr[$k], 0);
			if($lns_linha[$k] > $lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$rowarr[$k] = to_money($lista_geral_cliente['totalNF'], false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, 5, $rowarr[$k], 0);
			if($lns_linha[$k] > $lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$lns = $lns * 5;

			for($k=0;$k<$ncampos;$k++){
				$valor = $vl_linha[$k];
				$y = $pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k] / 100) * $larg, ($lns / ($lns_linha[$k] * 3)) * 3, $valor, 0, $pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
			}

			$total_NF+= $lista_geral_cliente['totalNF'];

			$pdf->Cell(1, $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
		}

		$lns = 5;
		$larg = 190;

		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$y=$pdf->y;
		$pdf->MultiCell((85 / 100) * $larg, $lns, 'Total Geral: ', 'T', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15 / 100) * $larg, $lns, str_replace('R$ ', '', to_money($total_NF, false)), 'T', 'R');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>