<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('VENDAS.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'VENDAS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(12);

	$worksheet1->write_string(0,0,'RELATRIO DE VENDAS',$formatot);
	$worksheet1->set_row(1,6);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora." - Usurio: ".base64_decode_si($_REQUEST['USER_ID']));
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Format for the headings
	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_align('vcenter');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_bold(1);
	$fmt_cabec->set_border(1);

	$fmt_cabec_sub =& $workbook->add_format();
	$fmt_cabec_sub->set_align('center');
	$fmt_cabec_sub->set_align('vcenter');
	$fmt_cabec_sub->set_pattern();
	$fmt_cabec_sub->set_fg_color('silver');
	$fmt_cabec_sub->set_bold(1);
	$fmt_cabec_sub->set_italic(1);
	$fmt_cabec_sub->set_border(1);
	$fmt_cabec_sub->set_size(8);

	$fmt_cabec_sub2 =& $workbook->add_format();
	$fmt_cabec_sub2->set_align('center');
	$fmt_cabec_sub2->set_align('vcenter');
	$fmt_cabec_sub2->set_pattern();
	$fmt_cabec_sub2->set_italic(1);
	$fmt_cabec_sub2->set_border(1);
	$fmt_cabec_sub2->set_size(8);

	// Format for the headings
	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_border(1);
	$fmt_txt_l->set_align('left');

	$fmt_txt_l_sub =& $workbook->add_format();
	$fmt_txt_l_sub->set_border(1);
	$fmt_txt_l_sub->set_align('left');
	$fmt_txt_l_sub->set_size(8);
	$fmt_txt_l_sub->set_italic(1);

	$fmt_txt_lb =& $workbook->add_format();
	$fmt_txt_lb->set_border(1);
	$fmt_txt_lb->set_align('left');
	$fmt_txt_lb->set_bold(1);

	$fmt_txt_r =& $workbook->add_format();
	$fmt_txt_r->set_border(1);
	$fmt_txt_r->set_align('right');
	$fmt_txt_r->set_size(8);

	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_border(1);
	$fmt_txt_c->set_align('center');

	$fmt_txt_sub_c =& $workbook->add_format();
	$fmt_txt_sub_c->set_border(1);
	$fmt_txt_sub_c->set_align('center');
	$fmt_txt_sub_c->set_size(8);
	$fmt_txt_sub_c->set_italic(1);

	$fmt_aviso =& $workbook->add_format();
	$fmt_aviso->set_size(10);
	$fmt_aviso->set_bold(1);

	$fmt_qtd =& $workbook->add_format();
	$fmt_qtd->set_border(1);
	$fmt_qtd->set_align('right');
	$fmt_qtd->set_num_format('#,##0.000_);-#,##0.000_)');
	//$fmt_qtd->set_num_format('#,##0.0##_);-#,##0.0##_)');

	$fmt_qtd_b =& $workbook->add_format();
	$fmt_qtd_b->set_border(1);
	$fmt_qtd_b->set_align('right');
	$fmt_qtd_b->set_size(10);
	$fmt_qtd_b->set_bold(1);
	//$$fmt_qtd_b->set_num_format('#,##0_);-#,##0_)');
	$fmt_qtd_b->set_num_format('#,##0.0##_);-#,##0.0##_)');

	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	$fmt_valor->set_size(10);
	$fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_valor_sub =& $workbook->add_format();
	$fmt_valor_sub->set_border(1);
	$fmt_valor_sub->set_align('right');
	$fmt_valor_sub->set_italic(1);
	$fmt_valor_sub->set_size(8);
	$fmt_valor_sub->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_valor_b =& $workbook->add_format();
	$fmt_valor_b->set_border(1);
	$fmt_valor_b->set_align('right');
	$fmt_valor_b->set_size(10);
	$fmt_valor_b->set_bold(1);
	$fmt_valor_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$empresa = $_REQUEST['empresa'];
	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['cliente'];
	$data_ini = $_REQUEST['dt_ini'];
	$data_fim = $_REQUEST['dt_fim'];
	$GeraCR = $_REQUEST['GeraCR'];
	$tipo_rel = $_REQUEST['Tipo'];
	$uf = $_REQUEST['uf'];
	$cidade = $_REQUEST['cidade'];
	$filtro = '';

	$consulta = 'select NrDoc, Modelo, Serie, Destinatario, Dest_Razao, '.
				' DH_EntSai as DH_Emissao, DH_EntSai as DT_Emissao, Empresa, Nr_Nota, '.
				' Nat_Op_CFOP, Nat_Op_Descricao, Vendedor, Vendedor_Nome, '.
				' Peso_Bruto, Peso_Liquido, '.
				' Total_ICMS_Valor, Total_IPI, '.
				' Total_Desconto, Total_Produtos, Total_Servicos, Total_NF, '.
				' "" as LetraMF, 0 as COO, Primeira_NF_Dest, Total_Outros '.
				' from nota_fiscal '.
				' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				' and Situacao="F" '.
				' and TipoES="1"';
	if($empresa!=''){
		$consulta.= ' and Empresa = "'.$empresa.'" ';
		$cons_empresa = 'select Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					   ' and Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
	}
	if(($data_ini!='')||($data_fim!='')){
		$filtro.= ' Data:';
		if($data_ini!=''){
			$consulta.= ' and DH_Emissao >= "'.datad($data_ini).'" ';
			$filtro.= ' De: "'.$data_ini.'"';
		}
		if($data_fim!=''){
			$consulta.= ' and DH_Emissao <= "'.datad($data_fim).' 23:59:59" ';
			$filtro.= ' At: "'.$data_fim.'"';
		}
	}
	$sub_cabec = '';
	if($vendedor!=''){
		$consulta.= ' and Vendedor = "'.$vendedor.'" ';
		$cons_vend = 'select Nome_Razao, Pessoa from pessoa '.
					' where Dominio = "'.$_SESSION["Dominio"].'"'.
					' and Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);
		$label_emp = empresa_representante($vendedor);
		//$label_emp2 = empresa_representante($vendedor,'S');
		$filtro.= ' '.$label.': "'.$label_emp.'"';
	}

	if($cliente!=''){
		$consulta.= ' and Destinatario = "'.$cliente.'" ';
		$cons_cliente = 'select Nome_Razao, Pessoa from pessoa '.
					   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					   ' and Pessoa = "'.$cliente.'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);
		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';
	}

	if ($GeraCR=='R'){
		$consulta.= ' and Nat_Op_Gera_Contas = "R" ';
		$filtro.= ' Somente as CFOPs que Geram Contas a Receber';
	}else if ($GeraCR=='N'){
		$consulta.= ' and Nat_Op_Gera_Contas <> "R" ';
		$filtro.= ' Somente as CFOPs que No Geram Contas a Receber';
	}

	if($uf!=''){
		$consulta.= ' and Dest_UF = "'.$uf.'" ';
		$filtro.= ' Estado: "'.$uf.'"';
	}

	if($cidade!=''){
		$consulta.= ' and Dest_Codigo_Cidade = "'.$cidade.'" ';
		$con_cid = 'select Nome from cidade '.
				  ' where Dominio="'.$_SESSION['Dominio'].'"'.
				  ' and Codigo_Cidade = "'.$cidade.'"';
		$res_cid = consulta_sql($con_cid);
		$reg_cid = consulta_ler_linha($res_cid);
		consulta_limpa($res_cid);
		$filtro.= ' Cidade: "'.$reg_cid[0].'"';
	}
	$consulta.= ' order by Destinatario, DH_Emissao, Empresa, Nr_Nota ';

	//echo $consulta;

	$res_nf = consulta_sql($consulta);
	$nrows_nf = consulta_num_registros($res_nf);
	$lista_geral = array();

	$counter = 0;
	for($n=0;$n<$nrows_nf;$n++){
		$reg_nf = consulta_ler_objeto($res_nf);

		$var_pessoa = $reg_nf->Destinatario;
		//$desc_cabec = 'Cliente';

		$campos_nf['empresa']= $reg_nf->Empresa;

		$cons_empresa2 = 'select Nome_Listas from pessoa '.
						 ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						 ' and Pessoa = "'.$campos_nf['empresa'].'"';
		$res_empresa2 = consulta_sql($cons_empresa2);
		$reg_empresa2 = consulta_ler_linha($res_empresa2);
		consulta_limpa($res_empresa2);

		$campos_nf['empresa_desc']= $reg_empresa2[0];
		$campos_nf['nr_nota']= $reg_nf->NrDoc.'/'.$reg_nf->Serie.'-'.$reg_nf->Modelo;
		$campos_nf['cfop']= $reg_nf->Nat_Op_CFOP;
		$campos_nf['cfop_desc']= $reg_nf->Nat_Op_Descricao;
		if ($reg_nf->Vendedor==0){
			$campos_nf['vendedor']= '';
		}else{
			$cons_vend_2 = 'select Nome_Razao, Pessoa from pessoa '.
						  ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' and Pessoa = "'.$reg_nf->Vendedor.'"';
			$res_vend_2 = consulta_sql($cons_vend_2);
			$reg_vend_2 = consulta_ler_linha($res_vend_2);
			consulta_limpa($res_vend_2);

			$campos_nf['vendedor']= $reg_nf->Vendedor.'-'.$reg_vend_2[0];
		}
		$campos_nf['dt_emissao']= dataf($reg_nf->DH_Emissao);
		$campos_nf['hora_emissao']= substr($reg_nf->DH_Emissao, 11, 8);
		$campos_nf['pesoB']= $reg_nf->Peso_Bruto;
		$campos_nf['pesoL']= $reg_nf->Peso_Liquido;

		$campos_nf['ICMS']= $reg_nf->Total_ICMS_Valor;
		$campos_nf['IPI']= $reg_nf->Total_IPI;
		$campos_nf['totalDesc']= $reg_nf->Total_Desconto;
		$campos_nf['totalAcresc']= $reg_nf->Total_Outros; //acrescimo
		$campos_nf['totalProd']= $reg_nf->Total_Produtos+$reg_nf->Total_Desconto;
		$campos_nf['totalServ']= $reg_nf->Total_Servicos;
		$campos_nf['totalNF']= $reg_nf->Total_NF;
		$campos_nf['Primeira_NF_Dest']= $reg_nf->Primeira_NF_Dest;
		$campos_nf['itens'] = array();

		$lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->Nr_Nota] = $campos_nf;

		if($tipo_rel == 'A'){
			$cons_item = 'select Seq_Item, Id_Produto, Codigo_Produto, Prod_Descricao, '.
						' Quantidade_Estoque, Unidade_Estoque, '.
						' Valor_Unitario, Valor_Total, Valor_Desconto, Qtd_Devolvida, Valor_Outros '.
						' from nota_fiscal_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$reg_nf->Empresa.'" '.
						' and Nr_Nota = "'.$reg_nf->Nr_Nota.'" ';

			$res_item = consulta_sql($cons_item);
			$nrows_item = consulta_num_registros($res_item);
			for($e=0;$e<$nrows_item;$e++){
				$reg_item = consulta_ler_objeto($res_item);
				$ok = true;
				if($ok){
					$con_desc = 'select Descricao_Completa, Codigo_Produto, Unidade_Venda, NCM from produto '.
							  ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							  ' and Id_Produto="'.$reg_item->Id_Produto.'"';
					$res_desc = consulta_sql($con_desc);
					$reg_desc = consulta_ler_linha($res_desc);
					consulta_limpa($res_desc);

					if($ok){
						$counter++;

						//if($agrupado=='C'){
						//}else{
						//	$var_pessoa = $reg_desc[4];
						//	$desc_cabec = 'Fornecedor';
						//}
						//$lista_campos['Id_Produto'] = $reg_item->Id_Produto;
						//$lista_campos['Destinatario'] = $reg_nf->Destinatario;
						//$lista_campos['Vendedor'] = $reg_nf->Vendedor;

						$lista_campos['Produto'] = $reg_desc[1];

						if (($_SESSION['Dominio']=='122')||($_SESSION['Dominio']=='191')){
							$con_barra = 'select Codigo_Barras from produto_cod_barras '.
									  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
									  ' and Id_Produto = "'.$reg_item->Id_Produto.'" '.
									  ' and Situacao = "A" '.
									  ' LIMIT 1';
							$res_barra = consulta_sql($con_barra);
							$reg_barra = consulta_ler_linha($res_barra);
							consulta_limpa($res_barra);

							$lista_campos['Produto'] = $reg_barra[0];
							if ($lista_campos['Produto']==''){
								$lista_campos['Produto'] = $reg_desc[1];
							}
						}
						$lista_campos['Desc_Produto'] = $reg_desc[0];
						$lista_campos['UnidadeMedida'] = $reg_desc[2];
						$lista_campos['NCM'] = $reg_desc[3]; //Ginza 260
						$lista_campos['Qtdade'] = $reg_item->Quantidade_Estoque;
						$lista_campos['QtdDev'] = $reg_item->Qtd_Devolvida;
						//$lista_campos['Valor']  = ($reg_item->Valor_Total + $reg_item->Valor_Outros);
						$lista_campos['Valor']  = $reg_item->Valor_Total;
						$lista_campos['ValorUnit'] = $reg_item->Valor_Unitario;
						$lista_campos['ValorDesc'] = $reg_item->Valor_Desconto;
						$lista_campos['ValorAcresc'] = $reg_item->Valor_Outros;
						$lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->Nr_Nota]['itens'][$reg_item->Seq_Item] = $lista_campos;
					}
				}
			}
			consulta_limpa($res_item);
		}
	}
	consulta_limpa($res_nf);

	$consulta= 'select COO as NrDoc, "2D" as Modelo, NrFab, Pessoa, Pessoa_CNPJ, Pessoa_Nome, '.
			   ' DH_Movto as DH_Emissao, DT_Emissao, Empresa, 0, '.
			   ' "5.102" as Nat_Op_CFOP, "VENDA CF" as Nat_Op_Descricao, Vendedor, "" as Vendedor_Nome, '.
			   ' 0, 0, 0, 0, '.
			   ' Desconto, SubTotal, 0, (SubTotal + Acrescimo-Desconto) as Total_NF, '.
			   ' LetraMF, COO, "N" as Primeira_NF_Dest '.
			   ' from ecf_cupom '.
			   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
			   ' and Cancelado="N" '.
			   ' and DH_Movto>="'.datad($_REQUEST['dt_ini']).' 00:00:00"'.
			   ' and DH_Movto<="'.datad($_REQUEST['dt_fim']).' 23:59:59"';
	if($empresa!=''){
		$consulta.= ' and Empresa = "'.$_REQUEST['empresa'].'"';
	}
	if($vendedor!=''){
		$consulta.=' and Vendedor = "'.$vendedor.'" ';
	}

	if($cliente!=''){
		$consulta .= ' and Pessoa = "'.$cliente.'" ';
	}
	$consulta.= ' order by DH_Emissao, Empresa, NrDoc ';

	//echo $consulta;

	$res_nf = consulta_sql($consulta);
	$nrows_nf = consulta_num_registros($res_nf);
	//$lista_geral = array();

	$tipo[0] = '';
	$con_tipo = 'select Empresa, NrFab, LetraMF, NrCaixa  '.
				' from ecf '.
				' where Dominio="'.$_SESSION["Dominio"].'"';
	$res_tipo = consulta_sql($con_tipo);
	$nrw_tipo = consulta_num_registros($res_tipo);
	for($t=0;$t<$nrw_tipo;$t++){
		$reg_tipo = consulta_ler_linha($res_tipo);
		$tipo[$reg_tipo[0].'_'.$reg_tipo[1].'_'.$reg_tipo[2]] = $reg_tipo[3];
	}
	consulta_limpa($res_tipo);

	$pessoa_nome = array();
	//$counter = 0;
	for($n=0;$n<$nrows_nf;$n++){
		$reg_nf = consulta_ler_objeto($res_nf);

		$div_cli = limpa_numero($reg_nf->Pessoa_CNPJ);
		if ($reg_nf->Pessoa>0){
			$div_cli = 'P'.$reg_nf->Pessoa;
		}else{
			if (($div_cli == '')||
				($div_cli == '00000000000')||
				($div_cli == '00000000000000')){
				$div_cli.= '_'.$reg_nf->Pessoa_Nome;
			}
		}

		$var_pessoa = 'CF_'.$div_cli;
		//$desc_cabec = 'Cliente';
		$pessoa_nome[$var_pessoa] = $reg_nf->Pessoa_Nome;
		//$nr_caixa = $reg_nf->NrFab;
		$nr_caixa = 1;

		if(isset($tipo[$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF])){
			$nr_caixa = $tipo[$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF];
		}

		$campos_nf['empresa']= $reg_nf->Empresa;
		$campos_nf['nr_nota']= $reg_nf->NrDoc.'/'.$nr_caixa.'-'.$reg_nf->Modelo;
		$campos_nf['cfop']= $reg_nf->Nat_Op_CFOP;
		$campos_nf['cfop_desc']= $reg_nf->Nat_Op_Descricao;
		$campos_nf['vendedor']= $reg_nf->Vendedor.'-'.$reg_nf->Vendedor_Nome;
		if ($reg_nf->Vendedor==0){
			$campos_nf['vendedor']= '';
		}else{
			$cons_vend_2 = 'select Nome_Razao, Pessoa from pessoa '.
						  ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' and Pessoa = "'.$reg_nf->Vendedor.'"';
			$res_vend_2 = consulta_sql($cons_vend_2);
			$reg_vend_2 = consulta_ler_linha($res_vend_2);
			consulta_limpa($res_vend_2);
			$campos_nf['vendedor']= $reg_nf->Vendedor.'-'.$reg_vend_2[0];
		}
		$campos_nf['dt_emissao']= dataf($reg_nf->DH_Emissao);
		$campos_nf['hora_emissao']= substr($reg_nf->DH_Emissao, 11, 8);
		$campos_nf['pesoB']= 0;//$reg_nf->Peso_Bruto;
		$campos_nf['pesoL']= 0;//$reg_nf->Peso_Liquido;

		$campos_nf['ICMS']= 0;//$reg_nf->Total_ICMS_Valor;
		$campos_nf['IPI']= 0;//$reg_nf->Total_IPI;
		$campos_nf['totalDesc']= $reg_nf->Desconto;
		$campos_nf['totalAcresc']= $reg_nf->Total_Outros;//Acrescimo
		$campos_nf['totalProd']= $reg_nf->SubTotal;
		$campos_nf['totalServ']= 0;//$reg_nf->Total_Servicos;
		$campos_nf['totalNF']= $reg_nf->Total_NF;
		$campos_nf['Primeira_NF_Dest']= $reg_nf->Primeira_NF_Dest;
		$campos_nf['itens'] = array();

		$lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF.'_'.$reg_nf->COO.'_'.limpa_numero($reg_nf->DT_Emissao)] = $campos_nf;

		if($tipo_rel == 'A'){
			$cons_item= 'select Seq_Item, Id_Produto, Codigo_Produto, Descricao_Produto, '.
						' Quantidade, Unidade_Medida, '.
						' Preco, ValorTotal, Desconto '.
						' from ecf_cupom_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$reg_nf->Empresa.'"'.
						' and NrFab = "'.$reg_nf->NrFab.'"'.
						' and LetraMF = "'.$reg_nf->LetraMF.'"'.
						' and DT_Emissao = "'.$reg_nf->DT_Emissao.'"'.
						' and COO = "'.$reg_nf->COO.'"'.
						' and Cancelado = "N" ';
			$res_item = consulta_sql($cons_item);
			$nrows_item = consulta_num_registros($res_item);
			for($e=0;$e<$nrows_item;$e++){
				$reg_item = consulta_ler_objeto($res_item);
				$ok = true;

				if($ok){
					$con_desc = 'select Descricao_Completa, Codigo_Produto, Unidade_Venda, NCM from produto '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto="'.$reg_item->Id_Produto.'"';
					$res_desc = consulta_sql($con_desc);
					$reg_desc = consulta_ler_linha($res_desc);
					consulta_limpa($res_desc);
					if($ok){
						$counter++;

						//if($agrupado=='C'){
						//}else{
						//	$var_pessoa = $reg_desc[4];
						//	$desc_cabec = 'Fornecedor';
						//}
						//$lista_campos['Id_Produto'] = $reg_item->Id_Produto;
						//$lista_campos['Destinatario'] = $reg_nf->Destinatario;
						//$lista_campos['Vendedor'] = $reg_nf->Vendedor;

						//if(isset($lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF.'_'.$reg_nf->COO.'_'.limpa_numero($reg_nf->DT_Emissao)]['itens'][$reg_item->Seq_Item])){
						//	$lista_campos = $lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF.'_'.$reg_nf->COO.'_'.limpa_numero($reg_nf->DT_Emissao)]['itens'][$reg_item->Seq_Item];
						//}else{

						$lista_campos['Produto'] = $reg_desc[1];

						if (($_SESSION['Dominio']=='122')||($_SESSION['Dominio']=='191')){
							$con_barra = 'select Codigo_Barras from produto_cod_barras '.
									  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
									  ' and Id_Produto = "'.$reg_item->Id_Produto.'" '.
									  ' and Situacao = "A" '.
									  ' LIMIT 1';
							$res_barra = consulta_sql($con_barra);
							$reg_barra = consulta_ler_linha($res_barra);
							consulta_limpa($res_barra);

							$lista_campos['Produto'] = $reg_barra[0];
							if ($lista_campos['Produto']==''){
								$lista_campos['Produto'] = $reg_desc[1];
							}
						}

						$lista_campos['Desc_Produto'] = $reg_desc[0];
						$lista_campos['UnidadeMedida'] = $reg_desc[2];
						$lista_campos['NCM'] = $reg_desc[3];
						$lista_campos['Qtdade'] = $reg_item->Quantidade;
						$lista_campos['QtdDev'] = 0;
						$lista_campos['Valor']  = $reg_item->ValorTotal;
						$lista_campos['ValorUnit'] = $reg_item->Preco;
						$lista_campos['ValorDesc'] = $reg_item->Desconto;
						//$lista_campos['ValorAcresc'] = $reg_item->Valor_Outros; 
						//}

						$lista_geral[$var_pessoa][$reg_nf->Empresa.'_'.$reg_nf->NrFab.'_'.$reg_nf->LetraMF.'_'.$reg_nf->COO.'_'.limpa_numero($reg_nf->DT_Emissao)]['itens'][$reg_item->Seq_Item] = $lista_campos;
					}
				}
			}
			consulta_limpa($res_item);
		}
	}
	consulta_limpa($res_nf);

	//var_dump($lista_geral);
	$worksheet1->set_row(4,6);
	$worksheet1->write(5,0,"Filtro: ".$filtro);

	$linha_ini = 6;

	$qtd_total_vendas = 0;
	$qtd_pecas=0;

	if($vendedor!=''){
		$cons_vend = 'select Pessoa, Nome_Razao from pessoa '.
					' where Dominio = "'.$_SESSION["Dominio"].'"'.
					' and Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);

		$label_emp = empresa_representante($vendedor,'S');

		$worksheet1->write_string($linha_ini,0,$label.': '.$label_emp,$formatost);
		$linha_ini++;
	}
	if($produto!=''){
		$con_prod = 'select Codigo_Produto, Descricao_Completa from produto '.
				   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Id_Produto="'.$produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_linha($res_prod);
		consulta_limpa($res_prod);

		$worksheet1->write_string($linha_ini,0,'Produto: '.$reg_prod[0].'-'.$reg_prod[1],$formatost);
		$linha_ini++;
	}

	//depois do filtro, quebra linha
	$linha_ini++;
	if(!empty($lista_geral)){
		$coluna=0;

		$worksheet1->set_column($coluna,$coluna,2);
		$worksheet1->write_string($linha_ini,$coluna,'',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Nr NF',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Dt Emisso',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Hr Emisso',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,8);
		$worksheet1->write_string($linha_ini,$coluna,'Nat. Op.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Desc. Nat.Op.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Cliente',$fmt_cabec);
		$coluna++;

		$label = label_vendedor_ou_rep_comercial('S');
		$worksheet1->set_column($coluna,$coluna,24);
		$worksheet1->write_string($linha_ini,$coluna,$label,$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,20);
		$worksheet1->write_string($linha_ini,$coluna,'Empresa',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Peso Bruto',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Peso Lq.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Vl ICMS',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Vl IPI',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Vl Desc.',$fmt_cabec);
		$coluna++;

		/**Adicionar os acrescimos */
		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Vl Acrsc.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Vl Prod.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Vl Serv.',$fmt_cabec);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,16);
		$worksheet1->write_string($linha_ini,$coluna,'Total NF',$fmt_cabec);

		$ultima_coluna = $coluna;
		//$coluna++;

		//$linha_ini++;

		$valor = 0;
		$total_pesoL = 0;
		$total_pesoB = 0;
		$total_ICMS = 0;
		$total_IPI = 0;
		$total_Desc = 0;
		$total_Acresc = 0;/**Correo para a Adri Doce */
		$total_Prod = 0;
		$total_Serv = 0;
		$total_NF = 0;

		$qtd_total_primeira_venda = 0;

		foreach($lista_geral as $idcli => $valor){
			$lista_geral_cliente = $lista_geral[$idcli];

			$coluna = 0;
			$linha_ini++;
			$linha_ini++;

			$cli_pesoL = 0;
			$cli_pesoB = 0;
			$cli_ICMS = 0;
			$cli_IPI = 0;
			$cli_Desc = 0;
			$cli_Acresc = 0; //acrescimo
			$cli_Prod = 0;
			$cli_Serv = 0;
			$cli_NF = 0;

			$desc_cli = '';
			if($idcli[0]=='C'){
				$desc_cli = $pessoa_nome[$idcli];
				if($desc_cli==''){
					$desc_cli = 'CONSUMIDOR FINAL';
				}
			}else{
				$cons_vend = 'select Pessoa, Nome_Razao from pessoa '.
						   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' and Pessoa = "'.$idcli.'"';
				$res_vend = consulta_sql($cons_vend);
				$reg_vend = consulta_ler_linha($res_vend);
				consulta_limpa($res_vend);

				$desc_cli = $idcli.' - '.$reg_vend[1];
			}

			$worksheet1->write_string($linha_ini,$coluna,'Cliente: '.$desc_cli,$fmt_txt_l);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+$ultima_coluna);
			$coluna++;
			for($ca=0;$ca<$ultima_coluna;$ca++){
				$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
				$coluna++;
			}

			foreach($lista_geral_cliente as $nota => $valor2){
				$lista_geral_nota = $lista_geral_cliente[$nota];

				$coluna = 0;
				$linha_ini++;

				$texto_primeira_nf = '';
				if($lista_geral_nota['Primeira_NF_Dest'] == 'S'){
					$texto_primeira_nf = '*';
					$qtd_total_primeira_venda++;
				}

				$worksheet1->write_string($linha_ini,$coluna,$texto_primeira_nf,$fmt_txt_c);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['nr_nota'],$fmt_txt_c);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['dt_emissao'],$fmt_txt_c);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['hora_emissao'],$fmt_txt_c);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['cfop'],$fmt_txt_c);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['cfop_desc'],$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$desc_cli,$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['vendedor'],$fmt_txt_l);
				$coluna++;

				$worksheet1->write_string($linha_ini,$coluna,$lista_geral_nota['empresa_desc'],$fmt_txt_c);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['pesoB'],$fmt_qtd);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['pesoL'],$fmt_qtd);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['ICMS'],$fmt_valor);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['IPI'],$fmt_valor);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['totalDesc'],$fmt_valor);
				$coluna++;
				//acrescimo
				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['totalAcresc'],$fmt_valor);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['totalProd'],$fmt_valor);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['totalServ'],$fmt_valor);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$lista_geral_nota['totalNF'],$fmt_valor);
				$coluna++;

				$qtd_total_vendas++;

				$cli_pesoL+= $lista_geral_nota['pesoL'];
				$cli_pesoB+= $lista_geral_nota['pesoB'];
				$cli_ICMS+=  $lista_geral_nota['ICMS'];
				$cli_IPI+=   $lista_geral_nota['IPI'];
				$cli_Desc+=  $lista_geral_nota['totalDesc'];
				$cli_Acresc+=  $lista_geral_nota['totalAcresc'];
				$cli_Prod+=  $lista_geral_nota['totalProd'];
				$cli_Serv+=  $lista_geral_nota['totalServ'];
				$cli_NF+=    $lista_geral_nota['totalNF'];

				$total_pesoL+= $lista_geral_nota['pesoL'];
				$total_pesoB+= $lista_geral_nota['pesoB'];
				$total_ICMS+=  $lista_geral_nota['ICMS'];
				$total_IPI+=   $lista_geral_nota['IPI'];
				$total_Desc+=  $lista_geral_nota['totalDesc'];
				$total_Acresc+=  $lista_geral_nota['totalAcresc'];//acrescimo
				$total_Prod+=  $lista_geral_nota['totalProd'];
				$total_Serv+=  $lista_geral_nota['totalServ'];
				$total_NF+=    $lista_geral_nota['totalNF'];

				if($tipo_rel=='A'){
					$coluna=0;
					$linha_ini++;

					$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_l_sub);
					$coluna++;
					//$worksheet1->set_column($coluna,$coluna,8);
					$worksheet1->write_string($linha_ini,$coluna,'Produto',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,30);
					$worksheet1->write_string($linha_ini,$coluna,'Descrio',$fmt_cabec_sub);
					$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+2);
					$coluna++;
					for($ca=0;$ca<2;$ca++){
						$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
						$coluna++;
					}
					//$coluna++;

					$worksheet1->write_string($linha_ini,$coluna,'NCM',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,5);
					$worksheet1->write_string($linha_ini,$coluna,'UM',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,8);
					$worksheet1->write_string($linha_ini,$coluna,'Custo Prod.',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,8);
					$worksheet1->write_string($linha_ini,$coluna,'Qtd.',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,12);
					$worksheet1->write_string($linha_ini,$coluna,'Vl. Unit.',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,12);
					$worksheet1->write_string($linha_ini,$coluna,'Vl. Desc. Item',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,12); //acrescimo
					$worksheet1->write_string($linha_ini,$coluna,'Vl. Acresc. Item',$fmt_cabec_sub);
					$coluna++;

					//$worksheet1->set_column($coluna,$coluna,14);
					$worksheet1->write_string($linha_ini,$coluna,'Vl. Total',$fmt_cabec_sub);
					$coluna++;

					foreach($lista_geral_nota['itens'] as $idprod => $valor3){
						$lista_campos = $lista_geral_nota['itens'][$idprod];

						$coluna = 0;
						$linha_ini++;

						$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_l_sub);
						$coluna++;
						$worksheet1->write_string($linha_ini,$coluna,$lista_campos['Produto'],$fmt_txt_l_sub);
						$coluna++;

						$worksheet1->write_string($linha_ini,$coluna,$lista_campos['Desc_Produto'],$fmt_txt_l_sub);
						$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+2);
						$coluna++;
						for($ca=0;$ca<2;$ca++){
							$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_sub_c); //acertar bordas
							$coluna++;
						}
						//$coluna++;

						$worksheet1->write_string($linha_ini,$coluna,$lista_campos['NCM'],$fmt_txt_sub_c);
						$coluna++;

						$worksheet1->write_string($linha_ini,$coluna,$lista_campos['UnidadeMedida'],$fmt_txt_sub_c);
						$coluna++;

						$cons_preco = 'Select Preco_Custo from produto_hist_custo'.
									  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
									  ' and Empresa = "'.$lista_geral_nota['empresa'].'"'.
									  ' and Id_Produto = "'.$lista_campos['Produto'].'"'.
									  ' and DH_Custo <= "'.datad($lista_geral_nota['dt_emissao']).' 23:59:59"'.
									  ' ORDER BY DH_Custo DESC LIMIT 0,1';
						$res_preco = consulta_sql($cons_preco);
						$reg_preco = consulta_ler_linha($res_preco);
						consulta_limpa($res_preco);

						$worksheet1->write_number($linha_ini,$coluna,$reg_preco[0],$fmt_valor_sub);
						$coluna++;

						$qtd_pecas+= $lista_campos['Qtdade'];
						$qtd_txt = formata_qtd($lista_campos['Qtdade'],3,false);
						if($lista_campos['QtdDev']>0){
							$qtd_txt.= ' (Dev '.formata_qtd($lista_campos['QtdDev'],3,false).')';
						}
						$worksheet1->write_string($linha_ini,$coluna,$qtd_txt,$fmt_txt_r);
						$coluna++;

						$worksheet1->write_number($linha_ini,$coluna,$lista_campos['ValorUnit'],$fmt_valor_sub);
						$coluna++;

						$worksheet1->write_number($linha_ini,$coluna,$lista_campos['ValorDesc'],$fmt_valor_sub);
						$coluna++;

						/**Acrescimo */
						$worksheet1->write_number($linha_ini,$coluna,$lista_campos['ValorAcresc'],$fmt_valor_sub);
						$coluna++;

						$worksheet1->write_number($linha_ini,$coluna,$lista_campos['Valor'],$fmt_valor_sub);
						$coluna++;
					}
				}
			}

			$coluna = 0;
			//$linha_ini++;
			/*
			$worksheet1->write_string($linha_ini,$coluna,'Total do Cliente:',$fmt_txt_lb);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
			$coluna++;
			for($ca=0;$ca<=3;$ca++){
			$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
			$coluna++;
			}
			//$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_lb);
			$coluna++;

			$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_lb);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_pesoB,$fmt_qtd_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_pesoL,$fmt_qtd_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_ICMS,$fmt_valor_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_IPI,$fmt_valor_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_Desc,$fmt_valor_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_Prod,$fmt_valor_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_Serv,$fmt_valor_b);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$cli_NF,$fmt_valor_b);
			$coluna++;
			*/
		}

		$coluna = 0;
		$linha_ini++;
		$linha_ini++;

		$txt_comp = '      Mdia: '.str_replace('"','',to_money($total_NF/$qtd_total_vendas));
		if($qtd_pecas>0){
			$txt_comp.= '      Peas: '.formata_qtd($qtd_pecas,3,false);
		}
		$worksheet1->write_string($linha_ini,$coluna,'Total Geral: '.$qtd_total_vendas.' vendas'.$txt_comp,$fmt_txt_lb);
		$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+12);//$coluna+4 //6 //8 //10 //12
		$coluna += 3 ;
		for($ca=0;$ca<=3;$ca++){
			$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
			$coluna++;
		}
		//$coluna++;

		$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_lb);
		$coluna++;

		$worksheet1->write_string($linha_ini,$coluna,'',$fmt_txt_lb);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_pesoB,$fmt_qtd_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_pesoL,$fmt_qtd_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_ICMS,$fmt_valor_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_IPI,$fmt_valor_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_Desc,$fmt_valor_b);
		$coluna++;

		//total do acrescimo
		$worksheet1->write_number($linha_ini,$coluna,$total_Acresc,$fmt_valor_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_Prod,$fmt_valor_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_Serv,$fmt_valor_b);
		$coluna++;

		$worksheet1->write_number($linha_ini,$coluna,$total_NF,$fmt_valor_b);
		$coluna++;

		$linha_ini++;
		$coluna = 0;

		$worksheet1->write_string($linha_ini,$coluna,'Total Primeira Venda: '.$qtd_total_primeira_venda,$fmt_txt_lb);
		$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+4);
		$coluna++;
		for($ca=0;$ca<=3;$ca++){
			$worksheet1->write_blank($linha_ini,$coluna,$fmt_txt_c); //acertar bordas
			$coluna++;
		}
	}else{
		$worksheet1->write(7,0,"No existem registros para este filtro!",$fmt_aviso);
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE A DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			  ' Dominio, '.
			  ' Usuario, '.
			  ' Descricao ) values ('.
			  '"'.$_SESSION['Dominio'].'", '.
			  '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			  '"")';
	consulta_sql($insert);

	$workbook->close();
?>