<?
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');

	class PDF extends FPDF{
		var $Empresa;
		var $Total;
		var $Qtd;

		var $CodCliente;
		var $NomeCliente;
		var $NmFantasiaCliente;
		var $EnderecoCliente;
		var $CidadeCliente;
		var $BairroCliente;
		var $CEPCliente;
		var $UFCliente;
		var $FoneCliente;
		var $FaxCliente;
		var $CelCliente;
		var $CPFCNPJCliente;
		var $RGCliente;
		var $Entrega;

		/**Teste para endereo de Entrega - Dominio 359 */
		var $EntregaEnd ;
		//se a entrega for no endereo
		var $EntregaRuaC ;
		var $EntregaNumC ;
		var $EntregaComC ;
		var $EntregaBarC ;
		var $EntregaCidC ;
		var $EntregaUFC  ;
		//se a entrega for em outro endereco
		var $EntregaRua ;
		var $EntregaNum ;
		var $EntregaCom ;
		var $EntregaBar ;
		var $EntregaCid ;
		var $EntregaUF  ;

		var $TtlProdutos ;
		var $TtlFrete    ;
		var $TtlSeguro   ;
		var $TtlDesconto ;
		var $TtlOutros   ;
		var $Romaneio    ;
		var $Vendedor	 ;

		//Nova Apresentao da Finalizao do Romaneio
		var $FormaPagtoDesc;
		var $DataPagto;

		var $PesoBruto;
		var $PesoLiquido;

		var $DHEmissao;

		function Header($tipo_cab='tudo'){
			if ($this->DefOrientation=='P'){
				$tamanho_total_linha = 190;
			}else{
				$tamanho_total_linha = 275;
			}
			$this->SetFillColor(255,255,255);
			$date=getdate();
			$hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
			$hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);

			$consulta_usuario = 'select Nome from usuario '.
						   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"';
			$res = consulta_sql($consulta_usuario);
			$row = consulta_ler_linha($res);
			$nome_usuario = $row[0];
			consulta_limpa($res);

			$this->SetFont('Arial','B',14);
			//Imprime Cabealho

			$this->Cell(1,  20, ' ', 0,0,'C');
			if($tipo_cab=='tudo'){
				//$this->Cell(30, 15, dataf($hoje).' '.($hora), 0,0,'L');
				$this->Cell(30, 15, '', 0,0,'L');  //para ficar certo o posicionamento do cabecalho central
				$base_y = 0;
				//$this->Cell(1,  15, ' ', 1,0,'C');
				//$this->Image(busca_imagem_empresa('blogo_menu.jpg', '../../'), (($tamanho_total_linha/2)-5), (15+$base_y), 30,15);  //50,20
				$h=60;
				$w=0;
				$x=28;
				$y=5;
				if ($_SESSION["Dominio"]!=205){
					$logo=busca_imagem_empresa('logo_menu.jpg', '../../');
					if(file_exists($logo)){
						$logoInfo=getimagesize($logo);
						//largura da imagem em mm
						$logoWmm = ($logoInfo[0]/72)*25.4;
						//altura da imagem em mm
						$logoHmm = ($logoInfo[1]/72)*25.4;
						$nImgH = round($h/3, 0);
						$nImgW = round($logoWmm * ($nImgH/$logoHmm), 0);
						$xImg = round(($w-$nImgW)/2+$x, 0);
						$yImg = $y;
						$this->Image($logo, $xImg, $yImg, $nImgW, $nImgH);
					}
				}
				//$this->Image(busca_imagem_empresa('logo_menu.jpg', '../../'), 12, (8+$base_y), 45, 16);
				//$this->Cell(1,  15, ' ', 1,1,'C');
			}else{
				$this->Cell(30, 20, " ", 0,0,'L');
			}

			$lns_cabecalho = $this->Lines_MultiCell(($tamanho_total_linha-60),5,$this->Cabecalho,1);
			$y=$this->y;
			$this->MultiCell(($tamanho_total_linha-60), (20/($lns_cabecalho*5)) * 5, $this->Cabecalho, 0,'C');
			$this->y=$y;

			$this->SetFont('Arial','B',10);
			$this->AliasNbPages();
			if($tipo_cab=='tudo'){
				//$this->Cell(30, 15, "Hora: ".($hora), 1,0,'R');
				$this->Cell(35, 20, 'Pg.: '.$this->PageNo().' / {nb}',0,0,'R');
			}

			$this->Cell(1,  15, ' ', 0,1,'C');

			if ($tipo_cab=='tudo'){
				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->Cell(190, 5, 'Emisso: '.$this->DHEmissao, 0,0,'R');
				$this->Cell(1,  5, ' ', 0,1,'C');
			}

			$this->SetFont('Arial','B',10);

			if($tipo_cab=='tudo'){

				$this->SetFont('Arial','B',9); //10

				$lns = 5;
				$larg = 190;

				$this->SetFont('Arial','',9); //10
				if ($_SESSION["Dominio"]!=205){
					$this->Cell(1,  $lns, ' ', 0,0,'C');
					$pos_y=$this->y;
					$this->MultiCell(19, $lns, 'Empresa...: ', 'T', 'L'); //22
					$this->y=$pos_y;

					$this->SetFont('Arial','B',9);

					$lns_lin1 = $this->Lines_MultiCell(171, $lns, $this->Empresa, 'T', 'L'); //78

					$pos_y=$this->y;
					$this->MultiCell(171, $lns, $this->Empresa, 'T', 'L'); //78
					$this->y=$pos_y;

					$this->SetFont('Arial','',9);

					$pos_y=$this->y;
					$this->MultiCell(27, 5, '', '', 'L'); //27
					$this->y=$pos_y;
					$this->Cell(1,  5, ' ', 0,1,'C');
				}

				$this->Cell(1,  $lsn, ' ', 0,0,'C');
				$pos_y=$this->y;
				$this->MultiCell(21, $lns, 'Cliente........: ', 'T', 'L'); //22
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$lns_lin1 = $this->Lines_MultiCell(79, $lns, $this->CodCliente.' - '.$this->NomeCliente, 'T', 'L'); //78

				$pos_y=$this->y;
				$this->MultiCell(79, $lns, $this->CodCliente.' - '.$this->NomeCliente, 'T', 'L'); //78
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(25, $lns, 'Nome Fantasia: ', 'T', 'L'); //28
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$lns_lin = $this->Lines_MultiCell(65, $lns, $this->NmFantasiaCliente, 'T', 'L'); //62
				if($lns_lin1>$lns_lin){
					$lns_lin = $lns_lin1;
				}

				$pos_y=$this->y;
				$this->MultiCell(65, $lns, $this->NmFantasiaCliente, 'T', 'L');
				$this->y=$pos_y;

				$this->Cell(1,  $lns, ' ', 0,1,'C');

				$this->y=$pos_y + ($lns_lin*5);

				$this->SetFont('Arial','',9);

				$this->Cell(1,  $lns, ' ', 0,0,'C');
				$pos_y=$this->y;
				$this->MultiCell(21, $lns, 'Endereo....: ', '', 'L'); //23
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(169, $lns, $this->EnderecoCliente, '', 'L'); //167
				$this->y=$pos_y;
				$this->Cell(1,  $lns, ' ', 0,1,'C');

				$this->SetFont('Arial','',9);

				$this->Cell(1,  5, ' ', 0,0,'C');
				$pos_y=$this->y;
				$this->MultiCell(21, 5, 'Cidade........: ', '', 'L'); //23
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(79, 5, $this->CidadeCliente, '', 'L'); //77
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(12, 5, 'Bairro: ', '', 'L'); //14
				$this->y=$pos_y;

				$this->SetFont('Arial','B',10);

				$pos_y=$this->y;
				$bairro_tmp = $this->Lines_MultiCell(39, 5, $this->BairroCliente, '', 'L');
				while ($bairro_tmp>1){
					$this->BairroCliente = substr($this->BairroCliente,0,strlen($this->BairroCliente)-1);
					$bairro_tmp = $this->Lines_MultiCell(39, 5, $this->BairroCliente, '');
				}
				$this->MultiCell(39, 5, $this->BairroCliente, '', 'L'); //76
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(12, 5, 'Fone: ', '', 'L'); //14
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(27, 5, $this->FoneCliente, '', 'L'); //76
				$this->y=$pos_y;
				$this->Cell(1,  5, ' ', 0,1,'C');

				$this->SetFont('Arial','',9);

				$this->Cell(1,  5, ' ', 0,0,'C');
				$pos_y=$this->y;
				$this->MultiCell(21, 5, 'CEP............: ', '', 'L'); //24
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(79, 5, $this->CEPCliente, '', 'L'); //76
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(8, 5, 'UF: ', '', 'L'); //9
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(43, 5, $this->UFCliente, '', 'L'); //41
				$this->y=$pos_y;

				

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(12, 5, 'Fax: ', '', 'L'); //13
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(27, 5, $this->FaxCliente, '', 'L'); //27
				$this->y=$pos_y;
				$this->Cell(1,  5, ' ', 0,1,'C');

				$this->SetFont('Arial','',9);

				$this->Cell(1,  5, ' ', 0,0,'C');
				$pos_y=$this->y;
				$this->MultiCell(21, 5, 'CPF/CNPJ..: ', '', 'L'); //24
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(79, 5, $this->CPFCNPJCliente, '', 'L'); //76
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(7, 5, 'IE: ', '', 'L'); //8
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);

				$pos_y=$this->y;
				$this->MultiCell(44, 5, $this->RGCliente, '', 'L'); //83
				$this->y=$pos_y;

				$this->SetFont('Arial','',9);

				$pos_y=$this->y;
				$this->MultiCell(12, 5, 'Cel: ', '', 'L'); //13
				$this->y=$pos_y;

				$this->SetFont('Arial','B',9);
				$pos_y=$this->y;
				$this->MultiCell(44, 5, $this->CelCliente, '', 'L'); //83
				$this->y=$pos_y;

				$lns = 10;//espao
				$y=$this->y;
				//$this->MultiCell(190, $lns, '', 'B', 'L');
				$this->y=$y;

				$this->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+$lns;
				$this->SetAutoPageBreak(true,30);
			}

			if($this->Sub_Cabecalho_Texto != ''){
				$this->SetFont('Arial',$this->Sub_Cabecalho_Style,10);
				$lns_cabecalho = $this->Lines_MultiCell($tamanho_total_linha,5,$this->Sub_Cabecalho_Texto,$this->Sub_Cabecalho_Border);
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,0,'C');
				$y=$this->y;
				$this->MultiCell($tamanho_total_linha, 5 , $this->Sub_Cabecalho_Texto, $this->Sub_Cabecalho_Border,$this->Sub_Cabecalho_Align);
				$this->y=$y;
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,1,'C');
				$this->x=$this->lMargin;
				$this->y=$y+($lns_cabecalho*5);
				$this->SetAutoPageBreak(true,30);
				$this->SetFont('Arial','',10);
			}

			if($this->CabecalhoGrid_Texto!=''){
				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->SetFont('Arial','B',10);

				foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');
			}
			$this->SetFont('Arial','',10);
		}

		function Footer(){
			$this->SetFillColor(255,255,255);
			$tamanho_total_linha = 190;

			$this->Cell(1,      5, ' ', 0,1,'C');
			//Prxima Linha
			$this->x=$this->lMargin;
			$this->y=$y+5;
			$this->SetAutoPageBreak(false,30);

			$novo_y = 260;  //266
			$this->AliasNbPages();
			$this->SetFont("Arial","B",9);
			$this->y=$novo_y+5;
			$borda = '';//'TRLB';

			if( $_SESSION['Dominio']==359){


				/** Teste para Adri Doce adiciona nome do cliente */
				if( $this->EntregaEnd == 1){
					$endEntrega =  $this->EntregaRuaC.', '.$this->EntregaNumC;
					if( $this->EntregaComC != ''){
						$endEntrega .= ', '. $this->EntregaComC;
					}
					$endEntrega .= ' - '.$this->EntregaBarC.' - '.$this->EntregaCidC.'/'.$this->EntregaUFC;
				}else{
					$endEntrega =  $this->EntregaRua.', '.$this->EntregaNum;
					if( $this->EntregaCom != ''){
						$endEntrega .= ', '. $this->EntregaCom;
					}
					$endEntrega .= ' - '.$this->EntregaBar.' - '.$this->EntregaCid.'/'.$this->EntregaUF;
				}			
				
				
				$outros   = $this->TtlFrete  + $this->TtlSeguro  + $this->TtlOutros   ;
				$desconto = $this->TtlDesconto ;
				$subTotal = $this->TtlProdutos + $this->TtlDesconto - $this->TtlOutros - $this->TtlSeguro ;
				$cliente  = $this->NomeCliente. ' ('. $this->NmFantasiaCliente .')';


				$y=$this->y;
				$this->MultiCell(140, 5, $cliente , $borda ,'L');
				$this->y=$y;
				//$this->Cell(1,2, ' ', 0,1,'C');

				$y=$this->y;
				$this->MultiCell(25, 5, 'Sub-Total........:', $borda,'L');
				$this->y=$y;

				$this->SetFont("Arial","",9);
				$y=$this->y;
				$this->MultiCell(25, 5,  to_money($subTotal, false) , $borda ,'R');
				$this->y=$y;
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);
				$this->SetFont("Arial","",9);

				$end_tmp = $this->Lines_MultiCell(140, 5,  $endEntrega, $borda, 'L');
				while ($end_tmp>2){
					$endEntrega = substr( $endEntrega ,0,strlen( $endEntrega)-1);
					$end_tmp = $this->Lines_MultiCell(39, 5,  $endEntrega, '');
				}
				
				
				$y=$this->y;
				$this->MultiCell(140, 5, 'Endereo de Entrega: '.  $endEntrega , $borda,'L');
				$this->y=$y;

				$this->SetFont("Arial","B",9);
				$y=$this->y;
				$this->MultiCell(25, 5, 'Desconto........:', $borda,'L');
				$this->y=$y;

				$this->SetFont("Arial","",9);
				$y=$this->y;
				$this->MultiCell(25, 5,  to_money($desconto, false)  , $borda ,'R');
				$this->y=$y;

				$this->Cell(1,2, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);
				/**At aqui identificacao do cliente */

				//Consulta o vendedor
				$con_vend = 'SELECT  Nome_Razao FROM pessoa '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Pessoa = "'.$this->Vendedor.'"';
				$res_vend = consulta_sql($con_vend );
				$reg_vend = consulta_ler_linha( $res_vend );
				consulta_limpa($res_vend );

				// Para a segunda linha do endereo
				$y=$this->y;
				$this->MultiCell(140, 5, '' , $borda ,'L');
				$this->y=$y;

				$this->SetFont("Arial","B",9);
				$y=$this->y;
				$this->MultiCell(25, 5, 'Acrscimo......:', $borda,'L');
				$this->y=$y;

				$this->SetFont("Arial","",9);
				$y=$this->y;
				$this->MultiCell(25, 5,   to_money($outros, false)  , $borda ,'R');
				$this->y=$y;

				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);
				/*$y=$this->y;
				$this->MultiCell(140, 5, '', $borda ,'C');
				$this->y=$y;*/

				$linhaExtra  = 'linha extra 1 Subtotal'. $subTotal .' Acrescimo: '. $outros. 'Desconto '. $desconto. to_money($this->Total, false) ;
				$linhaExtra1 = 'ROMANEIO: '. $this->Romaneio .' (Vendedor: '. $this->Vendedor .' - ' . $reg_vend[0]. ')';
				$y=$this->y;
				$this->MultiCell(140, 5,  $linhaExtra1 , $borda ,'L');
				$this->y=$y;

				$this->SetFont("Arial","B",9);
				$y=$this->y;
				$this->MultiCell(25, 5, 'Valor Total......:', $borda ,'L');
				$this->y=$y;

				$this->SetFont('Arial','',9);
				$y=$this->y;
				$this->MultiCell(25, 5, to_money($this->Total, false), $borda ,'R');
				$this->y=$y;

				/**Final da pagina e/ou linha  */
				$this->Cell(1,1, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);

				$y=$this->y;
				$this->MultiCell(190, 5, '', $borda ,'C');
				$this->y=$y;

			}else{
				$placa = '';				
				if( ($this->Placa=='')&&($this->Entrega=='')){
					$placa.= ' Forma de Pagto: '. $this->FormaPagtoDesc;
				}
				if ($this->Placa!=''){
					$placa = 'Placa: '.$this->Placa;
				}
				if ($this->Entrega!=''){
					$placa.= ' Dt Entrega: '.$this->Entrega;
				}
				$placa = trim($placa);
				$y=$this->y;
				$this->MultiCell(90, 5, $placa , $borda,'L');
				$this->y=$y;

				//peso Bruto
				$y=$this->y;
				$this->MultiCell(25, 5, 'Peso Bruto:', $borda,'L');
				$this->y=$y;
				//peso Bruto
				$y=$this->y;
				$this->MultiCell(24, 5,    $this->PesoBruto  , $borda,'R');
				$this->y=$y;


				$y=$this->y;
				$this->MultiCell(25, 5, 'Qtd. Total...:', $borda,'L');
				$this->y=$y;

				$y=$this->y;
				$this->MultiCell(25, 5, $this->Qtd, $borda ,'R');
				$this->y=$y;

				$this->Cell(1,2, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);
				
				$this->SetFont('Arial','B',9);


				$y=$this->y;
				$this->MultiCell(25, 5, 'Data Pagto: ',  $borda ,'L');
				$this->y=$y;

				$y=$this->y;
				$this->MultiCell(65, 5, $this->DataPagto,  $borda ,'L');
				$this->y=$y;


				//Descricao peso Liquido
				$y=$this->y;
				$this->MultiCell(25, 5, 'Peso Liquido:', $borda,'L');
				$this->y=$y;
				//peso liquido
				$y=$this->y;
				$this->MultiCell(24, 5, $this->PesoLiquido , $borda,'R');
				$this->y=$y;



				//Total
				$this->SetFont('Arial','B',9);
				$y=$this->y;
				$this->MultiCell(25, 5, 'Valor Total..:', $borda ,'L');
				$this->y=$y;

				$y=$this->y;
				$this->MultiCell(25, 5, to_money($this->Total, false), $borda ,'R');
				$this->y=$y;

				$this->Cell(1,1, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);


				//Nova linha 
				// Observacao
				/**Solicitacao Hardt (359 teste) */
				if( $this->Observacao != ''){
					$infObs = 'Obs......:  '. $this->Observacao ;
				}
			
				$y=$this->y;
				$this->MultiCell(190, 5,  $infObs , $borda ,'L');
				$this->y=$y;

				$this->Cell(1,2, ' ', 0,1,'C');
				//Prxima Linha
				$this->x=$this->lMargin;
				$this->y=$y+5;
				$this->SetAutoPageBreak(true,45);

				

				// $y=$this->y;
				// $this->MultiCell(190, 5, '', $borda ,'C');
				// $this->y=$y;
			}	
		}
	}

	function print_pdf($idreg,$filt_empresa,$visualiza=true){

		$con_nota = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$filt_empresa.'"'.
					' AND Nr_Nota = "'.$idreg.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);


		$con_nfparcela = 'SELECT Parcela, DT_Vencimento FROM nota_fiscal_parcela '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$filt_empresa.'"'.
					' AND Nr_Nota = "'.$idreg.'"';
		$res_nfparcela = consulta_sql( $con_nfparcela );
		$reg_nfparcela = consulta_ler_objeto( $res_nfparcela);
		$qtd_parcelas = consulta_num_registros( $res_nfparcela );

		$datas = '';
		for( $ttl=0; $ttl<$qtd_parcelas; $ttl++){
			$datas.= dataf($reg_nfparcela->DT_Vencimento ).' ';
		}

		$pdf=new PDF();
		$pdf->Open();

		//$pdf->Cabecalho = strtoupper(busca_nome_pedido_orc()).' NR '.base64_decode_si($_REQUEST['idreg']);
		$filtro = '';
		$pdf->Cabecalho = 'ROMANEIO '.$reg_nota->NrDoc;
		$pdf->Cabecalho_Filtro =  $filtro;
		$pdf->Sub_Cabecalho_Texto =  '';
		$pdf->Sub_Cabecalho_Style =  'B';
		$pdf->Sub_Cabecalho_Align =  'L';
		$pdf->Sub_Cabecalho_Border =  0;

		set_time_limit(60);

		//Consulta o Cliente
		$con_cli = 'select Pessoa, Nome_Razao, Nome_Fantasia, CPF_CNPJ, RG from pessoa '.
				' where Dominio = "'.$_SESSION["Dominio"].'"'.
				' and Pessoa = "'.$reg_nota->Destinatario.'"';
		$res_cli = consulta_sql($con_cli);
		$reg_cli = consulta_ler_linha($res_cli);
		consulta_limpa($res_cli);
		
		$entrega = '';
		if($reg_nota->Pedido_Nr > 0){
			$con_pedo = 'SELECT DH_Entrega FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$reg_nota->Pedido_Empresa.'"'.
						' AND Numero_Pedido = "'.$reg_nota->Pedido_Nr.'"';
			$res_pedo = consulta_sql($con_pedo);
			$reg_pedo = consulta_ler_linha($res_pedo);
			consulta_limpa($res_pedo);
			if ($reg_pedo[0]!=''){
				$entrega = dataf($reg_pedo[0]);
				if ($entrega=='00/00/0000'){
					$entrega = '';
				}
			}
		}

		//Consulta o Telefone do Cliente
		$con_cli_tel = 'select Numero_Telefone from pessoa_telefone '.
					' where Dominio = "'.$_SESSION["Dominio"].'" '.
					' and Pessoa = "'.$reg_nota->Destinatario.'"'.
					' and Situacao="A"';
		if($_SESSION['Dominio'] != '205'){
			$con_cli_tel .=	' and ((Tipo_Telefone=1) OR (Tipo_Telefone=2))';
		}
		$con_cli_tel .=	' order by Seq_Telefone '.
						' limit 1';
		$res_cli_tel = consulta_sql($con_cli_tel);
		$reg_cli_tel = consulta_ler_linha($res_cli_tel);
		consulta_limpa($res_cli_tel);

		//Consulta o Telefone do Cliente
		$con_cli_cel = 'select Numero_Telefone from pessoa_telefone '.
						' where Dominio = "'.$_SESSION["Dominio"].'" '.
						' and Pessoa = "'.$reg_nota->Destinatario.'"'.
						' and Situacao="A"'.
						' and ((Tipo_Telefone=3) OR (Tipo_Telefone=4))'.
						' order by Seq_Telefone '.
						' limit 1';
		$res_cli_cel = consulta_sql($con_cli_cel);
		$reg_cli_cel = consulta_ler_linha($res_cli_cel);
		consulta_limpa($res_cli_cel);

		//Consulta o Telefone FAX do Cliente
		$con_cli_fax = 'select Numero_Telefone from pessoa_telefone '.
					' where Dominio = "'.$_SESSION["Dominio"].'" '.
					' and Pessoa = "'.$reg_nota->Destinatario.'"'.
					' and Situacao="A"'.
					' and Tipo_Telefone=5'.
					' order by Seq_Telefone '.
					' limit 1';
		$res_cli_fax = consulta_sql($con_cli_fax);
		$reg_cli_fax = consulta_ler_linha($res_cli_fax);
		consulta_limpa($res_cli_fax);


		$dominio_teste = ($_SESSION['Dominio'] == 119);
		if($dominio_teste){
			//Consulta o Telefone FAX do Cliente
			$con_telcli_geral= 'select Numero_Telefone from pessoa_telefone '.
							' where Dominio = "'.$_SESSION["Dominio"].'" '.
							' and Pessoa = "'.$reg_nota->Destinatario.'"'.
							' and Situacao="A"'.
							' ';
			$res_telcli_geral = consulta_sql( $con_telcli_geral );
			$qtd_telcli_geral = consulta_num_registros( $res_telcli_geral  );
			if( $qtd_telcli_geral >1 ){
				//echo ' Quantida de de telefones: '. $qtd_telcli_geral ; 
				for( $t=0; $t< $qtd_telcli_geral ; $t++){
					$reg_telcli_geral = consulta_ler_linha( $res_telcli_geral );
					if( $reg_cli_tel[0] == ''){
						$reg_cli_tel[0] .= $reg_telcli_geral[0];						
					}
					else if( $reg_cli_cel[0] == ''){
						$reg_cli_cel[0] .= $reg_telcli_geral[0];						
					}
					else if( $reg_cli_fax[0] == ''){
						$reg_cli_fax[0] .= $reg_telcli_geral[0];						
					}
				}
			}
			consulta_limpa( $res_telcli_geral );
		}

		$con_end_cli = 'select Logradouro, Numero, Nome_Cidade, Bairro, UF, CEP, Insc_Estadual, Codigo_Cidade from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and Pessoa = "'.$reg_nota->Destinatario.'"'.
						' and Seq_Endereco = "'.$reg_nota->Dest_Endereco.'"';
						//' and Situacao <> "E"'.
						//' order by Seq_Endereco limit 1';
		$res_end_cli = consulta_sql($con_end_cli);
		$nrow_end_cli = consulta_num_registros($res_end_cli);
		if($nrow_end_cli==0){
			consulta_limpa($res_end_cli);
			$con_end_cli = 'select Logradouro, Numero, Nome_Cidade, Bairro, UF, CEP, Insc_Estadual, Codigo_Cidade from pessoa_endereco '.
						   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
						   ' and Pessoa = "'.$reg_nota->Destinatario.'"'.
						   ' and Situacao <> "E"'.
						   ' order by Seq_Endereco limit 1';
			$res_end_cli = consulta_sql($con_end_cli);
		}
		$reg_end_cli = consulta_ler_linha($res_end_cli);
		consulta_limpa($res_end_cli);
		$endereco_log = $reg_end_cli[0].', ';
		if($reg_end_cli[1]!=''){
			$endereco_log.=$reg_end_cli[1];
		}else{
			$endereco_log.='S/N';
		}

		if(($reg_end_cli[2]=='')&&($reg_end_cli[7]>0)){
			$con_cid = 'select Nome from cidade '.
					   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					   ' and Codigo_Cidade = "'.$reg_end_cli[7].'"';
			$res_cid = consulta_sql($con_cid);
			$reg_cid = consulta_ler_linha($res_cid);
			consulta_limpa($res_cid);
			$cidade_cli = $reg_cid[0];
		}else{
			$cidade_cli = $reg_end_cli[2];
		}

		$rg_ie_cli = '';
		if($reg_end_cli[6]!=''){
			$rg_ie_cli = $reg_end_cli[6];
		}

		//Consulta a Empresa
		$con_empresa = 'SELECT Pessoa, Nome_Razao, Nome_Fantasia, CPF_CNPJ FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$reg_nota->Empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		
		/**Teste para Hardt (359 teste) */
		//Consulta Observacao
		//echo ' linha 572 '.
		$con_obs  = 'SELECT Complemento FROM nota_fiscal_obs '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa= "'.$reg_nota->Empresa.'" '.
					' AND Nr_Nota = "'.$reg_nota->Nr_Nota.'"'. 
					' AND Seq_Item = "0" '.
					' AND Seq_Obs>100 ';
		$res_obs = consulta_sql($con_obs);
		$num_obs = consulta_num_registros($res_obs);
		$observacao = '';
		for($o=0; $o<=$num_obs; $o++){
			$reg_obs = consulta_ler_linha($res_obs);
			if($reg_obs[0] != ""){
				$observacao .= $reg_obs[0].'; ';					
			}
		}
		consulta_limpa($res_obs);

		$pdf->Empresa = $reg_empresa[1];
		$pdf->Total = $reg_nota->Total_NF;

		$pdf->CodCliente = $reg_cli[0];
		$pdf->NomeCliente = $reg_cli[1];
		$pdf->NmFantasiaCliente = $reg_cli[2];
		$pdf->EnderecoCliente = $endereco_log;
		$pdf->CidadeCliente = $cidade_cli; //$reg_end_cli[2];
		$pdf->BairroCliente = $reg_end_cli[3];
		$pdf->CEPCliente = $reg_end_cli[5];
		$pdf->UFCliente = $reg_end_cli[4];
		$pdf->FoneCliente = $reg_cli_tel[0];
		$pdf->FaxCliente = $reg_cli_fax[0];
		$pdf->CelCliente = $reg_cli_cel[0];
		$pdf->CPFCNPJCliente = $reg_cli[3];
		$pdf->RGCliente = $rg_ie_cli;
		$pdf->Placa = $reg_nota->Veiculo_Placa;
		$pdf->Entrega = $entrega;
		$pdf->DHEmissao = dataf($reg_nota->DH_EntSai);
		/** Teste para o Dominio 205 */
		$pdf->Observacao = $observacao;	
		
		/**Teste para endereo de Entrega - Dominio 359 */
		$pdf->EntregaEnd = $reg_nota->BuscaEntrega_Endereco;
		//se a entrega  no endereo 
		$pdf->EntregaRuaC = $reg_nota->Dest_Logradouro;
		$pdf->EntregaNumC = $reg_nota->Dest_Numero;
		$pdf->EntregaComC = $reg_nota->Dest_Complemento;
		$pdf->EntregaBarC = $reg_nota->Dest_Bairro;
		$pdf->EntregaCidC = $reg_nota->Dest_Nome_Cidade;
		$pdf->EntregaUFC  = $reg_nota->Dest_UF; 
		// se a entrega for em outro lugar
		
		$pdf->EntregaRua = $reg_nota->BuscaEntrega_Logradouro;
		$pdf->EntregaNum = $reg_nota->BuscaEntrega_Numero;
		$pdf->EntregaCom = $reg_nota->BuscaEntrega_Complemento;
		$pdf->EntregaBar = $reg_nota->BuscaEntrega_Bairro;
		$pdf->EntregaCid = $reg_nota->BuscaEntrega_Nome_Cidade;
		$pdf->EntregaUF  = $reg_nota->BuscaEntrega_UF;

		$pdf->TtlProdutos = $reg_nota->Total_Produtos;
		$pdf->TtlFrete    = $reg_nota->Total_Frete;
		$pdf->TtlSeguro   = $reg_nota->Total_Seguro;
		$pdf->TtlDesconto = $reg_nota->Total_Desconto;
		$pdf->TtlOutros   = $reg_nota->Total_Outros;
		$pdf->Romaneio    = $reg_nota->NrDoc;
		$pdf->Vendedor    = $reg_nota->Vendedor;

		//Forma de pagamento para a finalizacao da impressao
		$pdf->FormaPagtoDesc = $reg_nota->Forma_Pagto_Desc;
		$pdf->DataPagto = $datas;
		// $pdf->PesoLiquido = $reg_produto[3];
		// $pdf->PesoBruto = $reg_produto[4];



		$k=0;
		$pdf->CabecalhoGrid_Texto = '';

		$ncampos = 6; // 5

		$pdf->AddPage();
		$pdf->SetFont('Arial','',9);

		$pdf->CabecalhoGrid_Texto[$k] = 'Cdigo';
		$pdf->CabecalhoGrid_Tamanho[$k] = '16';
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Descrio do Produto';
		$pdf->CabecalhoGrid_Tamanho[$k] = '46';//46 //51
		$pdf->CabecalhoGrid_Align[$k] = 'L';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;
		/**Modificao realizada para o cliente 392 solcitacao Cesar em 31/05/2021 
		if( ($_SESSION['Dominio']==359)||($_SESSION['Dominio']==392) ){
			$pdf->CabecalhoGrid_Texto[$k] = 'Marca';
			$pdf->CabecalhoGrid_Tamanho[$k] = '8';
			$pdf->CabecalhoGrid_Align[$k] = 'C';
			$pdf->CabecalhoGrid_Border[$k] = 'TB';
			$k++;
		}*/

		$pdf->CabecalhoGrid_Texto[$k] = 'Qtde';
		$pdf->CabecalhoGrid_Tamanho[$k] = '8';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'U.M.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '6';
		$pdf->CabecalhoGrid_Align[$k] = 'C';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Vl. Unit.';
		$pdf->CabecalhoGrid_Tamanho[$k] = '10';//15
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;

		$pdf->CabecalhoGrid_Texto[$k] = 'Vl. Total';
		$pdf->CabecalhoGrid_Tamanho[$k] = '15';
		$pdf->CabecalhoGrid_Align[$k] = 'R';
		$pdf->CabecalhoGrid_Border[$k] = 'TB';
		$k++;
		//if( ($_SESSION['Dominio']==359)||($_SESSION['Dominio']==392) ){ $lns = 6; }else{ $lns = 5; }

		$lns = 5;
		//imprime cabecalho
		$pdf->SetFont('Arial','B',9);
		$pdf->SetAutoPageBreak(true,45);
		$pdf->Cell(1,$lns, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$peso_bruto = 0;
		$peso_liquido = 0;

		for ($k=0;$k<$ncampos;$k++){
			$y=$pdf->y;
			$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190, 5, $pdf->CabecalhoGrid_Texto[$k], $pdf->CabecalhoGrid_Border[$k],$pdf->CabecalhoGrid_Align[$k]);
			$pdf->y=$y;

			//if($k==($ncampos-1)){
			//    $pdf->Cell(1,      $lns, ' ', 0,1,'C');
			 //    //Prxima Linha
			 //    $pdf->x=$pdf->lMargin;
			 //    $pdf->y=$y+$lns;
			 //    $pdf->SetAutoPageBreak(true,30);
			 //
			 //    $y=$pdf->y;
			 //    $pdf->MultiCell(190, 0, '', 'T', 'L');
			 //    $pdf->y=$y;
			 //}
		}

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,50);

		//$cons_nota_item = 'SELECT Id_Produto, Quantidade_NF, Quantidade_Estoque, Valor_Unitario, Valor_Total FROM nota_fiscal_item '.
		$cons_nota_item = 'SELECT Id_Produto, ';
		if( $_SESSION['Dominio'] != '359'){
			$cons_nota_item .= 
				' SUM(Quantidade_NF) as Quantidade_NF, '.
				' SUM(Quantidade_Estoque) as Quantidade_Estoque, ';
		}else{
			$cons_nota_item .= 
				' Quantidade_NF, '.
				' Quantidade_Estoque, ';
		}
		$cons_nota_item .= 						  
						   ' Valor_Unitario, Unidade_NF, '.
						   ' Valor_Frete, Valor_Seguro, Valor_Desconto, Valor_Outros,'.
						   ' Barra_Produto FROM nota_fiscal_item '.
						   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
						   ' AND Nr_Nota = "'.$idreg.'"';
		if( $_SESSION['Dominio'] != '359'){
			$cons_nota_item .= 
			' GROUP BY Id_Produto ';
		}
		$cons_nota_item .= ' ORDER BY Seq_Item ASC ';
		$res_nota_item = consulta_sql($cons_nota_item);
		$nro_nota_item = consulta_num_registros($res_nota_item);

		$quant = 0;
		$valorTotalProdutoNota = 0;
		for($i=0;$i<$nro_nota_item;$i++){
			$reg_nota_item = consulta_ler_objeto($res_nota_item);
			$lns = 0;

			//set_time_limit(60);
			$k = 0;
			$pdf->SetFont('Arial','',9);
			$pdf->Cell(1,$lns, '', 0,0,'C');
			$pdf->SetFont('Arial','',9);
			$pdf->SetAutoPageBreak(false,30);

			$quant+= $reg_nota_item->Quantidade_Estoque;
			$pdf->Qtd = formata_qtd($quant,3,true);

			//Consulta a descricao do produto
			$con_produto = 'SELECT Descricao_Completa, Codigo_Produto, Marca, Peso_Bruto, Peso_Liquido FROM produto '.
						   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' AND Id_Produto = "'.$reg_nota_item->Id_Produto.'"';
			$res_produto = consulta_sql($con_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);

			$peso_bruto += $reg_produto[3];
			$peso_liquido += $reg_produto[4]; 

			//Consulta a descricao da Marca do produto
			$con_marca = 'SELECT Descricao FROM produto_marca '.
						   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						   ' AND Codigo_Marca = "'.$reg_produto[2].'"';
			$res_marca = consulta_sql($con_marca );
			$reg_marca = consulta_ler_linha($res_marca );
			consulta_limpa($res_marca );


			$codigo_produto = $reg_produto[1];
			if ($_SESSION["Dominio"]!=205){
				if ($reg_nota_item->Barra_Produto!=''){
					$codigo_produto = $reg_nota_item->Barra_Produto;
				}
			}

		
			$rowarr[$k]  =  $codigo_produto; // ($i + 1) .' '.  . ' ' . $reg_nota_item->Id_Produto. ' '.$reg_nota_item->Barra_Produto  ;
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;
			/**Modificado em 31/05/2021 a pedido Cesar para cliente 392 ( 359 teste) */
			$descricao =  $reg_produto[0];
			if ( ($_SESSION["Dominio"]=='359xx') || ($_SESSION["Dominio"]=='392') ){
				if( $reg_marca[0] ){
					$descricao =  $reg_produto[0].' ('.$reg_marca[0].')';
				}						
			}else{
				$descricao =  $reg_produto[0];

			}		

			$rowarr[$k]  = $descricao;
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			//Quantidade
			$rowarr[$k]  =  formata_qtd($reg_nota_item->Quantidade_Estoque,3,false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;


			//Unidade de Medida 
			$rowarr[$k]  = $reg_nota_item->Unidade_NF;
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			//Valor Unitario
			$rowarr[$k]  = to_money($reg_nota_item->Valor_Unitario, false);
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			//Valor Total
			$valorTotalProduto =  ($reg_nota_item->Quantidade_Estoque * $reg_nota_item->Valor_Unitario );
			$valorTotalProdutoNota +=  $valorTotalProduto;
			$rowarr[$k]  = to_money(($reg_nota_item->Quantidade_Estoque * $reg_nota_item->Valor_Unitario), false); //Custo Rep
			$vl_linha[$k] = $rowarr[$k];
			$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
			if ($lns_linha[$k]>$lns){
				$lns = $lns_linha[$k];
			}
			$k++;

			$lns = $lns * 5;
			//$pdf->SetFont('Arial','',7);

			for ($k=0;$k<$ncampos;$k++){
				$valor = $vl_linha[$k];
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190, ($lns/($lns_linha[$k]* 4)) * 4, $valor, str_replace('TB','',$pdf->CabecalhoGrid_Border[$k]),$pdf->CabecalhoGrid_Align[$k]);
				$pdf->y=$y;
			}

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,50);

			$lns = 4;

			$obs = $reg_nota_item->Obs;
			if($obs!=''){

				$pdf->SetFont('Arial','',9);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','B',9);

				$lns_linha_obs = $pdf->Lines_MultiCell((47/100)*190, $lns, $obs, 0);

				$y=$pdf->y;
				$pdf->MultiCell((9.5/100)*190, $lns*$lns_linha_obs, ' ', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((47/100)*190, $lns, $obs, '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((35.5/100)*190, $lns*$lns_linha_obs, ' ', '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+($lns*$lns_linha_obs);
				$pdf->SetAutoPageBreak(true,30);
			}
		}
		consulta_limpa($res_nota_item);

		$pdf->PesoBruto = $peso_bruto;
		$pdf->PesoLiquido = $peso_liquido; 

		//salva pdf do pedido para mandar por email
		$diretorio = '';

		$arquivo = MD5($_REQUEST['USER_ID']).'.tmp';
		$diretorio = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/upload/email';

		if(file_exists($diretorio.'/'.$arquivo)){
			unlink($diretorio.'/'.$arquivo);
		}
		rmkdir($diretorio.'/');
		$pdf->Output($diretorio.'/'.$arquivo,'F');

		$arquivo2 = $_SESSION['Empresa_Codigo'].'_'.$idreg.'.pdf';
		$diretorio2 = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/pdf';
		if(file_exists($diretorio2.'/'.$arquivo2)){
			unlink($diretorio2.'/'.$arquivo2);
		}
		rmkdir($diretorio2.'/');
		$pdf->Output($diretorio2.'/'.$arquivo2, 'F');
		if ($visualiza){
			echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
		}
	}

?>